/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.action.ContainerActionBase;
import com.intellij.docker.action.DockerActionUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.ApplicationActionUtils;
import org.jetbrains.annotations.NotNull;

public class AttachToContainerAction
extends ContainerActionBase {
    @Override
    protected boolean isEnabled(DeploymentNode node) {
        Deployment deployment = ApplicationActionUtils.getDeployment((DeploymentNode)node);
        if (deployment == null || deployment.getStatus() != DeploymentStatus.DEPLOYED) {
            return false;
        }
        RemoteServer server = (RemoteServer)node.getServerNode().getValue();
        ServerConnection connection = ServerConnectionManager.getInstance().getConnection(server);
        if (connection == null) {
            return false;
        }
        Project project = node.getServerNode().getProject();
        if (project == null) {
            return false;
        }
        DeploymentLogManagerImpl logManager = (DeploymentLogManagerImpl)connection.getLogManager(project, deployment);
        if (logManager == null) {
            return true;
        }
        for (LoggingHandlerBase loggingHandler : logManager.getAdditionalLoggingHandlers()) {
            if (!StringUtil.equals((CharSequence)"Attached Console", (CharSequence)loggingHandler.getPresentableName()) || loggingHandler.isClosed()) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DockerActionUtils.LoggingActionHelper helper;
        if (e == null) {
            AttachToContainerAction.$$$reportNull$$$0(0);
        }
        if ((helper = DockerActionUtils.getLoggingActionHelper(e)) == null) {
            return;
        }
        helper.applicationRuntime.attach(helper.project, helper.createLogSelector("Attached Console"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/action/AttachToContainerAction", "actionPerformed"));
    }
}

