/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.dockerFile.DockerFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DockerFileSearchUtil {
    @Deprecated
    @NonNls
    private static final String[] COMPOSE_FILES = new String[]{"docker-compose.yml", "docker-compose.yaml"};

    public static Collection<VirtualFile> getDockerFiles(@NotNull Project project, boolean includeLibraries) {
        if (project == null) {
            DockerFileSearchUtil.$$$reportNull$$$0(0);
        }
        return (Collection)ApplicationManager.getApplication().runReadAction(DockerFileSearchUtil.findFilesByType(project, (FileType)DockerFileType.DOCKER_FILE_TYPE, includeLibraries));
    }

    public static Collection<VirtualFile> getComposeFiles(@NotNull Project project, boolean includeLibraries) {
        if (project == null) {
            DockerFileSearchUtil.$$$reportNull$$$0(1);
        }
        return (Collection)ApplicationManager.getApplication().runReadAction(() -> {
            LinkedList result = new LinkedList();
            for (String variant : COMPOSE_FILES) {
                result.addAll((Collection)DockerFileSearchUtil.findFilesByName(project, variant, includeLibraries).compute());
            }
            return result;
        });
    }

    protected static Computable<Collection<VirtualFile>> findFilesByName(@NotNull Project project, @NotNull String fileName, boolean includeLibraries) {
        if (project == null) {
            DockerFileSearchUtil.$$$reportNull$$$0(2);
        }
        if (fileName == null) {
            DockerFileSearchUtil.$$$reportNull$$$0(3);
        }
        return () -> {
            if (project.isDisposed()) {
                return Collections.emptyList();
            }
            GlobalSearchScope scope = DockerFileSearchUtil.getSearchScope(project, includeLibraries);
            return FilenameIndex.getVirtualFilesByName((Project)project, (String)fileName, (GlobalSearchScope)scope);
        };
    }

    protected static Computable<Collection<VirtualFile>> findFilesByType(@NotNull Project project, @NotNull FileType fileType, boolean includeLibraries) {
        if (project == null) {
            DockerFileSearchUtil.$$$reportNull$$$0(4);
        }
        if (fileType == null) {
            DockerFileSearchUtil.$$$reportNull$$$0(5);
        }
        return () -> {
            if (project.isDisposed()) {
                return Collections.emptyList();
            }
            return FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)DockerFileSearchUtil.getSearchScope(project, includeLibraries));
        };
    }

    private static GlobalSearchScope getSearchScope(@NotNull Project project, boolean includeLibraries) {
        if (project == null) {
            DockerFileSearchUtil.$$$reportNull$$$0(6);
        }
        return includeLibraries ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/DockerFileSearchUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDockerFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getComposeFiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findFilesByName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findFilesByType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getSearchScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

