/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.jps;

import com.intellij.workspace.api.LibraryEntity;
import com.intellij.workspace.api.LibraryTableId;
import com.intellij.workspace.api.ModuleEntity;
import com.intellij.workspace.api.TypedEntityStorageBuilder;
import com.intellij.workspace.api.VirtualFileUrl;
import com.intellij.workspace.api.VirtualFileUrlKt;
import com.intellij.workspace.ide.JpsFileEntitySource;
import com.intellij.workspace.ide.JpsProjectStoragePlace;
import com.intellij.workspace.jps.CachingJpsFileContentReader;
import com.intellij.workspace.jps.JpsArtifactsDirectorySerializerFactory;
import com.intellij.workspace.jps.JpsArtifactsFileSerializer;
import com.intellij.workspace.jps.JpsDirectoryEntitiesSerializerFactory;
import com.intellij.workspace.jps.JpsEntitiesSerializationData;
import com.intellij.workspace.jps.JpsEntitiesSerializerFactories;
import com.intellij.workspace.jps.JpsFileContentReader;
import com.intellij.workspace.jps.JpsFileEntitiesSerializer;
import com.intellij.workspace.jps.JpsFileEntityTypeSerializer;
import com.intellij.workspace.jps.JpsLibrariesDirectorySerializerFactory;
import com.intellij.workspace.jps.JpsLibrariesFileSerializer;
import com.intellij.workspace.jps.ModuleSerializersFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ-\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001c"}, d2={"Lcom/intellij/workspace/jps/JpsProjectEntitiesLoader;", "", "()V", "createDirectoryProjectSerializers", "Lcom/intellij/workspace/jps/JpsEntitiesSerializerFactories;", "storagePlace", "Lcom/intellij/workspace/ide/JpsProjectStoragePlace$DirectoryBased;", "serializeArtifacts", "", "serializeFacets", "createIprProjectSerializers", "Lcom/intellij/workspace/ide/JpsProjectStoragePlace$FileBased;", "createProjectEntitiesSerializers", "Lcom/intellij/workspace/ide/JpsProjectStoragePlace;", "createProjectSerializers", "Lcom/intellij/workspace/jps/JpsEntitiesSerializationData;", "reader", "Lcom/intellij/workspace/jps/JpsFileContentReader;", "loadModule", "", "moduleFile", "Ljava/io/File;", "source", "Lcom/intellij/workspace/ide/JpsFileEntitySource$FileInDirectory;", "builder", "Lcom/intellij/workspace/api/TypedEntityStorageBuilder;", "loadModule$intellij_platform_workspaceModel_ide", "loadProject", "intellij.platform.workspaceModel.ide"})
public final class JpsProjectEntitiesLoader {
    public static final JpsProjectEntitiesLoader INSTANCE;

    @NotNull
    public final JpsEntitiesSerializationData createProjectSerializers(@NotNull JpsProjectStoragePlace storagePlace, @NotNull JpsFileContentReader reader, boolean serializeArtifacts, boolean serializeFacets) {
        Intrinsics.checkParameterIsNotNull((Object)storagePlace, (String)"storagePlace");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        return this.createProjectEntitiesSerializers(storagePlace, serializeArtifacts, serializeFacets).createSerializers(reader);
    }

    @NotNull
    public final JpsEntitiesSerializationData loadProject(@NotNull JpsProjectStoragePlace storagePlace, @NotNull TypedEntityStorageBuilder builder2) {
        Intrinsics.checkParameterIsNotNull((Object)storagePlace, (String)"storagePlace");
        Intrinsics.checkParameterIsNotNull((Object)builder2, (String)"builder");
        JpsEntitiesSerializerFactories mainFactories = this.createProjectEntitiesSerializers(storagePlace, true, true);
        CachingJpsFileContentReader reader = new CachingJpsFileContentReader(storagePlace.getBaseDirectoryUrl());
        JpsEntitiesSerializationData data2 = mainFactories.createSerializers(reader);
        data2.loadAll(reader, builder2);
        return data2;
    }

    public final void loadModule(@NotNull File moduleFile, @NotNull JpsProjectStoragePlace storagePlace, @NotNull TypedEntityStorageBuilder builder2) {
        Intrinsics.checkParameterIsNotNull((Object)moduleFile, (String)"moduleFile");
        Intrinsics.checkParameterIsNotNull((Object)storagePlace, (String)"storagePlace");
        Intrinsics.checkParameterIsNotNull((Object)builder2, (String)"builder");
        File file2 = moduleFile.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"moduleFile.parentFile");
        JpsFileEntitySource.FileInDirectory source = new JpsFileEntitySource.FileInDirectory(VirtualFileUrlKt.toVirtualFileUrl(file2), storagePlace);
        this.loadModule$intellij_platform_workspaceModel_ide(moduleFile, source, storagePlace, builder2);
    }

    /*
     * WARNING - void declaration
     */
    public final void loadModule$intellij_platform_workspaceModel_ide(@NotNull File moduleFile, @NotNull JpsFileEntitySource.FileInDirectory source, @NotNull JpsProjectStoragePlace storagePlace, @NotNull TypedEntityStorageBuilder builder2) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)moduleFile, (String)"moduleFile");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)storagePlace, (String)"storagePlace");
        Intrinsics.checkParameterIsNotNull((Object)builder2, (String)"builder");
        JpsEntitiesSerializerFactories mainFactories = this.createProjectEntitiesSerializers(storagePlace, false, true);
        CachingJpsFileContentReader reader = new CachingJpsFileContentReader(storagePlace.getBaseDirectoryUrl());
        Iterable $this$filterIsInstance$iv = mainFactories.getFileSerializerFactories();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ModuleSerializersFactory)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ModuleSerializersFactory moduleSerializerFactory = (ModuleSerializersFactory)CollectionsKt.single((List)((List)destination$iv$iv));
        JpsFileEntitiesSerializer<ModuleEntity> serializer = moduleSerializerFactory.createSerializer(source, VirtualFileUrlKt.toVirtualFileUrl(moduleFile));
        serializer.loadEntities(builder2, reader);
    }

    private final JpsEntitiesSerializerFactories createProjectEntitiesSerializers(JpsProjectStoragePlace storagePlace, boolean serializeArtifacts, boolean serializeFacets) {
        JpsEntitiesSerializerFactories jpsEntitiesSerializerFactories;
        JpsProjectStoragePlace jpsProjectStoragePlace = storagePlace;
        if (jpsProjectStoragePlace instanceof JpsProjectStoragePlace.FileBased) {
            jpsEntitiesSerializerFactories = this.createIprProjectSerializers((JpsProjectStoragePlace.FileBased)storagePlace, serializeArtifacts, serializeFacets);
        } else if (jpsProjectStoragePlace instanceof JpsProjectStoragePlace.DirectoryBased) {
            jpsEntitiesSerializerFactories = this.createDirectoryProjectSerializers((JpsProjectStoragePlace.DirectoryBased)storagePlace, serializeArtifacts, serializeFacets);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jpsEntitiesSerializerFactories;
    }

    private final JpsEntitiesSerializerFactories createDirectoryProjectSerializers(JpsProjectStoragePlace.DirectoryBased storagePlace, boolean serializeArtifacts, boolean serializeFacets) {
        String projectDirUrl = storagePlace.getProjectDir().getUrl();
        ArrayList directorySerializersFactories = new ArrayList();
        Collection collection = directorySerializersFactories;
        JpsDirectoryEntitiesSerializerFactory<LibraryEntity> jpsDirectoryEntitiesSerializerFactory = new JpsLibrariesDirectorySerializerFactory(projectDirUrl + "/.idea/libraries");
        boolean bl = false;
        collection.add(jpsDirectoryEntitiesSerializerFactory);
        if (serializeArtifacts) {
            collection = directorySerializersFactories;
            jpsDirectoryEntitiesSerializerFactory = new JpsArtifactsDirectorySerializerFactory(projectDirUrl + "/.idea/artifacts");
            bl = false;
            collection.add(jpsDirectoryEntitiesSerializerFactory);
        }
        return new JpsEntitiesSerializerFactories(CollectionsKt.emptyList(), directorySerializersFactories, CollectionsKt.listOf((Object)new ModuleSerializersFactory(projectDirUrl + "/.idea/modules.xml", serializeFacets)), storagePlace);
    }

    private final JpsEntitiesSerializerFactories createIprProjectSerializers(JpsProjectStoragePlace.FileBased storagePlace, boolean serializeArtifacts, boolean serializeFacets) {
        JpsFileEntitySource.ExactFile projectFileSource = new JpsFileEntitySource.ExactFile(storagePlace.getIprFile(), storagePlace);
        VirtualFileUrl projectFileUrl = projectFileSource.getFile();
        ArrayList entityTypeSerializers = new ArrayList();
        Collection collection = entityTypeSerializers;
        JpsFileEntityTypeSerializer<LibraryEntity> jpsFileEntityTypeSerializer = new JpsLibrariesFileSerializer(projectFileUrl, projectFileSource, LibraryTableId.ProjectLibraryTableId.INSTANCE);
        boolean bl = false;
        collection.add(jpsFileEntityTypeSerializer);
        if (serializeArtifacts) {
            collection = entityTypeSerializers;
            jpsFileEntityTypeSerializer = new JpsArtifactsFileSerializer(projectFileUrl, projectFileSource);
            bl = false;
            collection.add(jpsFileEntityTypeSerializer);
        }
        return new JpsEntitiesSerializerFactories(entityTypeSerializers, CollectionsKt.emptyList(), CollectionsKt.listOf((Object)new ModuleSerializersFactory(projectFileUrl.getUrl(), serializeFacets)), storagePlace);
    }

    private JpsProjectEntitiesLoader() {
    }

    static {
        JpsProjectEntitiesLoader jpsProjectEntitiesLoader;
        INSTANCE = jpsProjectEntitiesLoader = new JpsProjectEntitiesLoader();
    }
}

