/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ProjectRefreshFloatingProvider;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000bJ\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectNotificationAware;", "Lcom/intellij/openapi/Disposable;", "()V", "isHidden", "", "projectsWithNotification", "Lgnu/trove/THashSet;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "dispose", "", "getProjectsWithNotification", "", "getSystemIds", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "hideNotification", "isNotificationVisible", "notificationExpire", "projectId", "notificationNotify", "projectAware", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "revealNotification", "setHideStatus", "Companion", "intellij.platform.externalSystem.impl"})
public final class ProjectNotificationAware
implements Disposable {
    private boolean isHidden;
    private final THashSet<ExternalSystemProjectId> projectsWithNotification = new THashSet();
    private static final Logger LOG;
    public static final Companion Companion;

    public final void notificationNotify(@NotNull ExternalSystemProjectAware projectAware) {
        Application app$iv;
        Intrinsics.checkParameterIsNotNull((Object)projectAware, (String)"projectAware");
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application application = app$iv = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
        if (application.isDispatchThread()) {
            boolean bl = false;
            ExternalSystemProjectId projectId = projectAware.getProjectId();
            ProjectNotificationAware.LOG.debug(projectId.getReadableName() + ": Notify notification");
            this.projectsWithNotification.add((Object)projectId);
            this.revealNotification();
        } else {
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(this, projectAware){
                final /* synthetic */ ProjectNotificationAware this$0;
                final /* synthetic */ ExternalSystemProjectAware $projectAware$inlined;
                {
                    this.this$0 = projectNotificationAware;
                    this.$projectAware$inlined = externalSystemProjectAware;
                }

                public final void run() {
                    boolean bl = false;
                    ExternalSystemProjectId projectId = this.$projectAware$inlined.getProjectId();
                    ProjectNotificationAware.access$getLOG$cp().debug(projectId.getReadableName() + ": Notify notification");
                    ProjectNotificationAware.access$getProjectsWithNotification$p(this.this$0).add((Object)projectId);
                    ProjectNotificationAware.access$revealNotification(this.this$0);
                }
            }, ModalityState.defaultModalityState());
        }
    }

    public final void notificationExpire(@NotNull ExternalSystemProjectId projectId) {
        Application app$iv;
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application application = app$iv = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
        if (application.isDispatchThread()) {
            boolean bl = false;
            ProjectNotificationAware.LOG.debug(projectId.getReadableName() + ": Expire notification");
            this.projectsWithNotification.remove((Object)projectId);
            this.revealNotification();
        } else {
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(this, projectId){
                final /* synthetic */ ProjectNotificationAware this$0;
                final /* synthetic */ ExternalSystemProjectId $projectId$inlined;
                {
                    this.this$0 = projectNotificationAware;
                    this.$projectId$inlined = externalSystemProjectId;
                }

                public final void run() {
                    boolean bl = false;
                    ProjectNotificationAware.access$getLOG$cp().debug(this.$projectId$inlined.getReadableName() + ": Expire notification");
                    ProjectNotificationAware.access$getProjectsWithNotification$p(this.this$0).remove((Object)this.$projectId$inlined);
                    ProjectNotificationAware.access$revealNotification(this.this$0);
                }
            }, ModalityState.defaultModalityState());
        }
    }

    public final void notificationExpire() {
        Application app$iv;
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application application = app$iv = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
        if (application.isDispatchThread()) {
            boolean bl = false;
            ProjectNotificationAware.LOG.debug("Expire notification");
            this.projectsWithNotification.clear();
            this.revealNotification();
        } else {
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(this){
                final /* synthetic */ ProjectNotificationAware this$0;
                {
                    this.this$0 = projectNotificationAware;
                }

                public final void run() {
                    boolean bl = false;
                    ProjectNotificationAware.access$getLOG$cp().debug("Expire notification");
                    ProjectNotificationAware.access$getProjectsWithNotification$p(this.this$0).clear();
                    ProjectNotificationAware.access$revealNotification(this.this$0);
                }
            }, ModalityState.defaultModalityState());
        }
    }

    public void dispose() {
        this.notificationExpire();
    }

    private final void setHideStatus(boolean isHidden) {
        Application app$iv;
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application application = app$iv = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
        if (application.isDispatchThread()) {
            boolean bl = false;
            this.isHidden = isHidden;
            ApplicationManager.getApplication().assertIsDispatchThread();
            ProjectRefreshFloatingProvider toolbarProvider = ProjectRefreshFloatingProvider.Companion.getExtension();
            toolbarProvider.updateAllToolbarComponents();
        } else {
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(this, isHidden){
                final /* synthetic */ ProjectNotificationAware this$0;
                final /* synthetic */ boolean $isHidden$inlined;
                {
                    this.this$0 = projectNotificationAware;
                    this.$isHidden$inlined = bl;
                }

                public final void run() {
                    boolean bl = false;
                    ProjectNotificationAware.access$setHidden$p(this.this$0, this.$isHidden$inlined);
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    ProjectRefreshFloatingProvider toolbarProvider = ProjectRefreshFloatingProvider.Companion.getExtension();
                    toolbarProvider.updateAllToolbarComponents();
                }
            }, ModalityState.defaultModalityState());
        }
    }

    private final void revealNotification() {
        this.setHideStatus(false);
    }

    public final void hideNotification() {
        this.setHideStatus(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isNotificationVisible() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isHidden) return false;
        Collection collection = (Collection)this.projectsWithNotification;
        boolean bl = false;
        if (collection.isEmpty()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<ProjectSystemId> getSystemIds() {
        void $this$mapTo$iv$iv;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Iterable $this$map$iv = (Iterable)this.projectsWithNotification;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExternalSystemProjectId externalSystemProjectId = (ExternalSystemProjectId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProjectSystemId projectSystemId = it.getSystemId();
            collection.add(projectSystemId);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Set<ExternalSystemProjectId> getProjectsWithNotification() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return CollectionsKt.toSet((Iterable)((Iterable)this.projectsWithNotification));
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"#com.intellij.openapi.externalSystem.autoimport");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026ternalSystem.autoimport\")");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$isHidden$p(ProjectNotificationAware $this) {
        return $this.isHidden;
    }

    @JvmStatic
    @NotNull
    public static final ProjectNotificationAware getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectNotificationAware$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectNotificationAware;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ProjectNotificationAware getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, ProjectNotificationAware.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026icationAware::class.java)");
            return (ProjectNotificationAware)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

