/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.file;

import com.google.common.collect.EvictingQueue;
import com.intellij.largeFilesEditor.editor.Page;
import com.intellij.largeFilesEditor.file.FileAdapter;
import com.intellij.largeFilesEditor.file.FileChangeListener;
import com.intellij.largeFilesEditor.file.LargeFileManager;
import com.intellij.largeFilesEditor.file.ReadingPageResultHandler;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;

public class LargeFileManagerImpl
implements LargeFileManager {
    private static final Logger logger = Logger.getInstance(LargeFileManagerImpl.class);
    private static final int MAX_SIZE_OF_PAGE_CASH = 3;
    private final List<FileChangeListener> myFileChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private FileAdapter fileAdapter;
    private final Queue<Page> notUpdatedPagesCash;
    private final ReentrantLock myLock = new ReentrantLock();
    private final ExecutorService readingPageExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Large File Editor Reading File Executor");

    public LargeFileManagerImpl(VirtualFile vFile, int pageSize, int maxPageBorderShift) throws FileNotFoundException {
        this.fileAdapter = new FileAdapter(pageSize, maxPageBorderShift, vFile);
        this.notUpdatedPagesCash = EvictingQueue.create((int)3);
        this.startFileCheckingThread();
    }

    @Override
    public void reset(Charset charset) {
        this.myLock.lock();
        try {
            this.notUpdatedPagesCash.clear();
            this.fileAdapter.setCharset(charset);
        }
        finally {
            this.myLock.unlock();
        }
    }

    public void dispose() {
        try {
            this.fileAdapter.closeFile();
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
        }
    }

    @Override
    public String getCharsetName() {
        return this.fileAdapter.getCharsetName();
    }

    @Override
    public long getPagesAmount() throws IOException {
        return this.fileAdapter.getPagesAmount();
    }

    @Override
    public int getPageSize() {
        return this.fileAdapter.getPageSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getPage_wait(long pageNumber) throws IOException {
        this.myLock.lock();
        try {
            String notUpdatedPageText;
            long pagesAmount = this.fileAdapter.getPagesAmount();
            boolean neededPageShouldBeLastInFile = pageNumber == pagesAmount - 1L;
            Page notUpdatedPage = null;
            Iterator iterator2 = this.notUpdatedPagesCash.iterator();
            while (iterator2.hasNext()) {
                boolean isOutdated;
                Page pageFromCash = (Page)iterator2.next();
                if (pageFromCash.getPageNumber() != pageNumber) continue;
                boolean bl = isOutdated = pageFromCash.isLastInFile() != neededPageShouldBeLastInFile;
                if (isOutdated) {
                    iterator2.remove();
                    continue;
                }
                notUpdatedPage = pageFromCash;
                break;
            }
            if (notUpdatedPage != null) {
                notUpdatedPageText = notUpdatedPage.getText();
            } else {
                notUpdatedPageText = this.fileAdapter.getPageText(pageNumber);
                if (notUpdatedPageText == null) {
                    iterator2 = null;
                    return iterator2;
                }
                notUpdatedPage = new Page(notUpdatedPageText, pageNumber, neededPageShouldBeLastInFile);
                this.notUpdatedPagesCash.add(notUpdatedPage);
            }
            String notUpdatedPageTextWithoutSlashR = LargeFileManagerImpl.destroySlashRSeparators(notUpdatedPageText);
            Page page = new Page(notUpdatedPageTextWithoutSlashR, pageNumber, neededPageShouldBeLastInFile);
            return page;
        }
        finally {
            this.myLock.unlock();
        }
    }

    private static String destroySlashRSeparators(String str) {
        return str.replace("\r\n", "\n").replace("\r", "\n");
    }

    @Override
    public boolean hasBOM() {
        VirtualFile vFile = this.fileAdapter.getVirtualFile();
        return vFile.getBOM() != null && vFile.getBOM().length > 0;
    }

    @Override
    public String getFileName() {
        return this.fileAdapter.getFileName();
    }

    @Override
    public FileDataProviderForSearch getFileDataProviderForSearch() {
        return new FileDataProviderForSearch(){

            @Override
            public long getPagesAmount() throws IOException {
                return LargeFileManagerImpl.this.getPagesAmount();
            }

            @Override
            public Page getPage_wait(long pageNumber) throws IOException {
                return LargeFileManagerImpl.this.getPage_wait(pageNumber);
            }

            @Override
            public String getName() {
                return LargeFileManagerImpl.this.getFileName();
            }
        };
    }

    @Override
    public void requestReadPage(long pageNumber, ReadingPageResultHandler readingPageResultHandler) {
        this.readingPageExecutor.execute(() -> {
            try {
                Page page = this.getPage_wait(pageNumber);
                readingPageResultHandler.run(page);
            }
            catch (IOException e) {
                logger.warn((Throwable)e);
                readingPageResultHandler.run(null);
            }
        });
    }

    @Override
    public void addFileChangeListener(FileChangeListener listener2) {
        this.myFileChangeListeners.add(listener2);
    }

    private void onFileChanged() {
        try {
            long pagesAmount = this.getPagesAmount();
            Page lastPage = this.getPage_wait(pagesAmount - 1L);
            for (FileChangeListener listener2 : this.myFileChangeListeners) {
                listener2.onFileChanged(lastPage);
            }
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
        }
    }

    private void startFileCheckingThread() {
        Alarm alarm2 = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        FileChangesChecker task2 = new FileChangesChecker(alarm2);
        alarm2.addRequest((Runnable)task2, 10);
    }

    private class FileChangesChecker
    implements Runnable {
        private final Alarm alarm;
        private long prevFileSize;

        private FileChangesChecker(Alarm alarm2) {
            this.alarm = alarm2;
        }

        @Override
        public void run() {
            try {
                this.doCheck();
            }
            catch (IOException e) {
                logger.info((Throwable)e);
                return;
            }
            if (this.alarm.isDisposed()) {
                return;
            }
            this.alarm.addRequest((Runnable)this, 5000);
        }

        protected void doCheck() throws IOException {
            if (LargeFileManagerImpl.this.fileAdapter == null) {
                return;
            }
            boolean isFileLengthChanged = this.refreshFileLength();
            if (isFileLengthChanged) {
                this.removeOutdatedPagesFromCash();
                LargeFileManagerImpl.this.onFileChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeOutdatedPagesFromCash() throws IOException {
            LargeFileManagerImpl.this.myLock.lock();
            try {
                Iterator iterator2 = LargeFileManagerImpl.this.notUpdatedPagesCash.iterator();
                while (iterator2.hasNext()) {
                    Page cashedPage = (Page)iterator2.next();
                    String physicalPageText = LargeFileManagerImpl.this.fileAdapter.getPageText(cashedPage.getPageNumber());
                    if (cashedPage.getText().equals(physicalPageText)) continue;
                    iterator2.remove();
                }
            }
            finally {
                LargeFileManagerImpl.this.myLock.unlock();
            }
        }

        private boolean refreshFileLength() throws IOException {
            long size = LargeFileManagerImpl.this.fileAdapter.getFileSize();
            if (size != this.prevFileSize) {
                this.prevFileSize = size;
                return true;
            }
            return false;
        }
    }
}

