/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindModelListener;
import com.intellij.find.FindResult;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.impl.FindResultImpl;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.find.impl.RegExReplacementBuilder;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.navigation.NavigationItem;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ReplacePromptDialog;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.impl.SyntaxHighlighterOverEditorHighlighter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.Predicate;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashSet;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FindManagerImpl
extends FindManager {
    private static final Logger LOG = Logger.getInstance(FindManagerImpl.class);
    private final FindUsagesManager myFindUsagesManager;
    private boolean isFindWasPerformed;
    private boolean isSelectNextOccurrenceWasPerformed;
    private Point myReplaceInFilePromptPos;
    private Point myReplaceInProjectPromptPos;
    private final FindModel myFindInProjectModel;
    private final FindModel myFindInFileModel;
    private FindModel myFindNextModel;
    private FindModel myPreviousFindModel;
    private static final FindResultImpl NOT_FOUND_RESULT = new FindResultImpl();
    private final Project myProject;
    private static final Key<Boolean> HIGHLIGHTER_WAS_NOT_FOUND_KEY = Key.create((String)"com.intellij.find.impl.FindManagerImpl.HighlighterNotFoundKey");
    private FindUIHelper myHelper;
    private static final NotificationGroup GROUP = new NotificationGroup("Find Problems", NotificationDisplayType.STICKY_BALLOON, false);
    private static final Key<ThreadLocal<FindExceptCommentsOrLiteralsData>> ourExceptCommentsOrLiteralsDataKey = KeyWithDefaultValue.create((String)"except.comments.literals.search.data", () -> new ThreadLocal());
    private static final Key<ThreadLocal<CommentsLiteralsSearchData>> ourCommentsLiteralsSearchDataKey = KeyWithDefaultValue.create((String)"comments.literals.search.data", () -> new ThreadLocal());
    private static final IntObjectMap<Boolean> ourReportedPatterns = ContainerUtil.createConcurrentIntObjectMap();

    public FindManagerImpl(@NotNull Project project) {
        if (project == null) {
            FindManagerImpl.$$$reportNull$$$0(0);
        }
        this.myReplaceInFilePromptPos = new Point(-1, -1);
        this.myReplaceInProjectPromptPos = new Point(-1, -1);
        this.myFindInProjectModel = new FindModel();
        this.myFindInFileModel = new FindModel();
        this.myProject = project;
        FindSettings findSettings = FindSettings.getInstance();
        findSettings.initModelBySetings(this.myFindInProjectModel);
        this.myFindInFileModel.setCaseSensitive(findSettings.isLocalCaseSensitive());
        this.myFindInFileModel.setWholeWordsOnly(findSettings.isLocalWholeWordsOnly());
        this.myFindInFileModel.setRegularExpressions(findSettings.isLocalRegularExpressions());
        this.myFindUsagesManager = new FindUsagesManager(this.myProject);
        this.myFindInProjectModel.setMultipleFiles(true);
        NotificationsConfigurationImpl.remove("FindInPath");
        Disposer.register((Disposable)project, () -> {
            if (this.myHelper != null) {
                Disposer.dispose((Disposable)this.myHelper);
            }
        });
    }

    public FindModel createReplaceInFileModel() {
        FindModel model = new FindModel();
        model.copyFrom(this.getFindInFileModel());
        model.setReplaceState(true);
        model.setPromptOnReplace(false);
        return model;
    }

    public int showPromptDialog(@NotNull FindModel model, String title) {
        if (model == null) {
            FindManagerImpl.$$$reportNull$$$0(1);
        }
        return this.showPromptDialogImpl(model, title, null);
    }

    @FindManager.PromptResultValue
    private int showPromptDialogImpl(final @NotNull FindModel model, String title, @Nullable FindManager.MalformedReplacementStringException exception) {
        if (model == null) {
            FindManagerImpl.$$$reportNull$$$0(2);
        }
        ReplacePromptDialog replacePromptDialog = new ReplacePromptDialog(model.isMultipleFiles(), title, this.myProject, exception){

            @Nullable
            public Point getInitialLocation() {
                if (model.isMultipleFiles() && ((FindManagerImpl)FindManagerImpl.this).myReplaceInProjectPromptPos.x >= 0 && ((FindManagerImpl)FindManagerImpl.this).myReplaceInProjectPromptPos.y >= 0) {
                    return FindManagerImpl.this.myReplaceInProjectPromptPos;
                }
                if (!model.isMultipleFiles() && ((FindManagerImpl)FindManagerImpl.this).myReplaceInFilePromptPos.x >= 0 && ((FindManagerImpl)FindManagerImpl.this).myReplaceInFilePromptPos.y >= 0) {
                    return FindManagerImpl.this.myReplaceInFilePromptPos;
                }
                return null;
            }
        };
        replacePromptDialog.show();
        if (model.isMultipleFiles()) {
            this.myReplaceInProjectPromptPos = replacePromptDialog.getLocation();
        } else {
            this.myReplaceInFilePromptPos = replacePromptDialog.getLocation();
        }
        return replacePromptDialog.getExitCode();
    }

    void changeGlobalSettings(FindModel findModel) {
        String stringToFind = findModel.getStringToFind();
        FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance((Project)this.myProject);
        if (!StringUtil.isEmpty((String)stringToFind)) {
            findInProjectSettings.addStringToFind(stringToFind);
        }
        if (!findModel.isMultipleFiles()) {
            this.setFindWasPerformed();
        }
        if (findModel.isReplaceState()) {
            findInProjectSettings.addStringToReplace(findModel.getStringToReplace());
        }
        if (findModel.isMultipleFiles() && !findModel.isProjectScope() && findModel.getDirectoryName() != null) {
            findInProjectSettings.addDirectory(findModel.getDirectoryName());
            this.myFindInProjectModel.setWithSubdirectories(findModel.isWithSubdirectories());
        }
    }

    public void showFindDialog(@NotNull FindModel model, @NotNull Runnable okHandler) {
        if (model == null) {
            FindManagerImpl.$$$reportNull$$$0(3);
        }
        if (okHandler == null) {
            FindManagerImpl.$$$reportNull$$$0(4);
        }
        if (this.myHelper == null || Disposer.isDisposed((Disposable)this.myHelper)) {
            this.myHelper = new FindUIHelper(this.myProject, model, okHandler);
            Disposer.register((Disposable)this.myHelper, () -> {
                this.myHelper = null;
            });
        } else {
            this.myHelper.setModel(model);
            this.myHelper.setOkHandler(okHandler);
        }
        this.myHelper.showUI();
    }

    @NotNull
    public FindModel getFindInFileModel() {
        FindModel findModel = this.myFindInFileModel;
        if (findModel == null) {
            FindManagerImpl.$$$reportNull$$$0(5);
        }
        return findModel;
    }

    @NotNull
    public FindModel getFindInProjectModel() {
        this.myFindInProjectModel.setFromCursor(false);
        this.myFindInProjectModel.setForward(true);
        this.myFindInProjectModel.setGlobal(true);
        this.myFindInProjectModel.setMultiline(Registry.is((String)"ide.find.as.popup.allow.multiline"));
        this.myFindInProjectModel.setSearchInProjectFiles(false);
        FindModel findModel = this.myFindInProjectModel;
        if (findModel == null) {
            FindManagerImpl.$$$reportNull$$$0(6);
        }
        return findModel;
    }

    public boolean findWasPerformed() {
        return this.isFindWasPerformed;
    }

    public void setFindWasPerformed() {
        this.isFindWasPerformed = true;
        this.isSelectNextOccurrenceWasPerformed = false;
    }

    public boolean selectNextOccurrenceWasPerformed() {
        return this.isSelectNextOccurrenceWasPerformed;
    }

    public void setSelectNextOccurrenceWasPerformed() {
        this.isSelectNextOccurrenceWasPerformed = true;
        this.isFindWasPerformed = false;
    }

    public FindModel getFindNextModel() {
        return this.myFindNextModel;
    }

    public FindModel getFindNextModel(@NotNull Editor editor) {
        String textInField;
        if (editor == null) {
            FindManagerImpl.$$$reportNull$$$0(7);
        }
        if (this.myFindNextModel == null) {
            return null;
        }
        EditorSearchSession search2 = EditorSearchSession.get(editor);
        if (!(search2 == null || this.isSelectNextOccurrenceWasPerformed || Comparing.equal((String)(textInField = search2.getTextInField()), (String)this.myFindInFileModel.getStringToFind()) || textInField.isEmpty())) {
            FindModel patched = new FindModel();
            patched.copyFrom(this.myFindNextModel);
            patched.setStringToFind(textInField);
            return patched;
        }
        return this.myFindNextModel;
    }

    public void setFindNextModel(FindModel findNextModel) {
        this.myFindNextModel = findNextModel;
        ((FindModelListener)this.myProject.getMessageBus().syncPublisher(FIND_MODEL_TOPIC)).findNextModelChanged();
    }

    @NotNull
    public FindResult findString(@NotNull CharSequence text2, int offset, @NotNull FindModel model) {
        if (text2 == null) {
            FindManagerImpl.$$$reportNull$$$0(8);
        }
        if (model == null) {
            FindManagerImpl.$$$reportNull$$$0(9);
        }
        FindResult findResult = this.findString(text2, offset, model, null);
        if (findResult == null) {
            FindManagerImpl.$$$reportNull$$$0(10);
        }
        return findResult;
    }

    @NotNull
    public FindResult findString(@NotNull CharSequence text2, int offset, @NotNull FindModel model, @Nullable VirtualFile file2) {
        if (text2 == null) {
            FindManagerImpl.$$$reportNull$$$0(11);
        }
        if (model == null) {
            FindManagerImpl.$$$reportNull$$$0(12);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("offset=" + offset);
            LOG.debug("textlength=" + text2.length());
            LOG.debug(model.toString());
        }
        FindResult findResult = this.findStringLoop(text2, offset, model, file2, this.getFindContextPredicate(model, file2, text2));
        if (findResult == null) {
            FindManagerImpl.$$$reportNull$$$0(13);
        }
        return findResult;
    }

    private FindResult findStringLoop(CharSequence text2, int offset, FindModel model, VirtualFile file2, @Nullable Predicate<? super FindResult> filter2) {
        char[] textArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)text2);
        do {
            FindResult result2 = this.doFindString(text2, textArray, offset, model, file2);
            if (filter2 == null || filter2.apply((Object)result2)) {
                if (!model.isWholeWordsOnly()) {
                    return result2;
                }
                if (!result2.isStringFound()) {
                    return result2;
                }
                if (FindManagerImpl.isWholeWord(text2, result2.getStartOffset(), result2.getEndOffset())) {
                    return result2;
                }
            }
            int n = offset = model.isForward() ? result2.getStartOffset() + 1 : result2.getEndOffset() - 1;
        } while (offset <= text2.length() && offset >= 0);
        return NOT_FOUND_RESULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Predicate<FindResult> getFindContextPredicate(@NotNull FindModel model, VirtualFile file2, CharSequence text2) {
        ThreadLocal data2;
        if (model == null) {
            FindManagerImpl.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            return null;
        }
        FindModel.SearchContext context = model.getSearchContext();
        if (context == FindModel.SearchContext.ANY || context == FindModel.SearchContext.IN_COMMENTS || context == FindModel.SearchContext.IN_STRING_LITERALS) {
            return null;
        }
        FindModel findModel = model;
        synchronized (findModel) {
            data2 = (ThreadLocal)model.getUserData(ourExceptCommentsOrLiteralsDataKey);
            assert (data2 != null);
        }
        FindExceptCommentsOrLiteralsData currentThreadData = (FindExceptCommentsOrLiteralsData)data2.get();
        if (currentThreadData == null || !currentThreadData.isAcceptableFor(model, file2, text2)) {
            currentThreadData = new FindExceptCommentsOrLiteralsData(file2, model, text2);
            data2.set(currentThreadData);
        }
        return currentThreadData;
    }

    public int showMalformedReplacementPrompt(@NotNull FindModel model, String title, FindManager.MalformedReplacementStringException exception) {
        if (model == null) {
            FindManagerImpl.$$$reportNull$$$0(15);
        }
        return this.showPromptDialogImpl(model, title, exception);
    }

    public FindModel getPreviousFindModel() {
        return this.myPreviousFindModel;
    }

    public void setPreviousFindModel(FindModel previousFindModel) {
        this.myPreviousFindModel = previousFindModel;
    }

    private static boolean isWholeWord(CharSequence text2, int startOffset, int endOffset) {
        boolean isWordEnd;
        boolean isWordStart;
        if (startOffset != 0) {
            boolean previousCharacterIsIdentifier = Character.isJavaIdentifierPart(text2.charAt(startOffset - 1)) && (startOffset <= 1 || text2.charAt(startOffset - 2) != '\\');
            boolean previousCharacterIsSameAsNext = text2.charAt(startOffset - 1) == text2.charAt(startOffset);
            boolean firstCharacterIsIdentifier = Character.isJavaIdentifierPart(text2.charAt(startOffset));
            isWordStart = firstCharacterIsIdentifier ? !previousCharacterIsIdentifier : !previousCharacterIsSameAsNext;
        } else {
            isWordStart = true;
        }
        if (endOffset != text2.length()) {
            boolean lastSearchedCharacterIsIdentifier;
            boolean nextCharacterIsIdentifier = Character.isJavaIdentifierPart(text2.charAt(endOffset));
            boolean nextCharacterIsSameAsPrevious = endOffset > 0 && text2.charAt(endOffset) == text2.charAt(endOffset - 1);
            boolean bl = lastSearchedCharacterIsIdentifier = endOffset > 0 && Character.isJavaIdentifierPart(text2.charAt(endOffset - 1));
            isWordEnd = lastSearchedCharacterIsIdentifier ? !nextCharacterIsIdentifier : !nextCharacterIsSameAsPrevious;
        } else {
            isWordEnd = true;
        }
        return isWordStart && isWordEnd;
    }

    @NotNull
    private static FindModel normalizeIfMultilined(@NotNull FindModel findmodel) {
        if (findmodel == null) {
            FindManagerImpl.$$$reportNull$$$0(16);
        }
        if (findmodel.isMultiline()) {
            String newStringToFind;
            FindModel model = new FindModel();
            model.copyFrom(findmodel);
            String s = model.getStringToFind();
            if (findmodel.isRegularExpressions()) {
                newStringToFind = StringUtil.replace((String)s, (String)"\\n", (String)"\n");
                newStringToFind = newStringToFind.replaceAll("\n", "\\\\n\\\\s*");
            } else {
                newStringToFind = StringUtil.escapeToRegexp((String)s);
                newStringToFind = newStringToFind.replaceAll("\\\\n\\s*", "\\\\n\\\\s*");
                model.setRegularExpressions(true);
            }
            model.setStringToFind(newStringToFind);
            FindModel findModel = model;
            if (findModel == null) {
                FindManagerImpl.$$$reportNull$$$0(17);
            }
            return findModel;
        }
        FindModel findModel = findmodel;
        if (findModel == null) {
            FindManagerImpl.$$$reportNull$$$0(18);
        }
        return findModel;
    }

    @NotNull
    private FindResult doFindString(@NotNull CharSequence text2, char @Nullable [] textArray, int offset, @NotNull FindModel findmodel, @Nullable VirtualFile file2) {
        int index;
        FindModel model;
        String toFind;
        if (text2 == null) {
            FindManagerImpl.$$$reportNull$$$0(19);
        }
        if (findmodel == null) {
            FindManagerImpl.$$$reportNull$$$0(20);
        }
        if ((toFind = (model = FindManagerImpl.normalizeIfMultilined(findmodel)).getStringToFind()).isEmpty()) {
            FindResultImpl findResultImpl = NOT_FOUND_RESULT;
            if (findResultImpl == null) {
                FindManagerImpl.$$$reportNull$$$0(21);
            }
            return findResultImpl;
        }
        if (model.isInCommentsOnly() || model.isInStringLiteralsOnly()) {
            if (file2 == null) {
                FindResultImpl findResultImpl = NOT_FOUND_RESULT;
                if (findResultImpl == null) {
                    FindManagerImpl.$$$reportNull$$$0(22);
                }
                return findResultImpl;
            }
            return this.findInCommentsAndLiterals(text2, textArray, offset, model, file2);
        }
        if (model.isRegularExpressions()) {
            FindResult findResult = this.findStringByRegularExpression(text2, offset, model, file2);
            if (findResult == null) {
                FindManagerImpl.$$$reportNull$$$0(23);
            }
            return findResult;
        }
        StringSearcher searcher = FindManagerImpl.createStringSearcher(model);
        if (model.isForward()) {
            int res2 = searcher.scan(text2, textArray, offset, text2.length());
            index = res2 < 0 ? -1 : res2;
        } else {
            int n = index = offset == 0 ? -1 : searcher.scan(text2, textArray, 0, offset - 1);
        }
        if (index < 0) {
            FindResultImpl findResultImpl = NOT_FOUND_RESULT;
            if (findResultImpl == null) {
                FindManagerImpl.$$$reportNull$$$0(24);
            }
            return findResultImpl;
        }
        return new FindResultImpl(index, index + toFind.length());
    }

    @NotNull
    private static StringSearcher createStringSearcher(@NotNull FindModel model) {
        if (model == null) {
            FindManagerImpl.$$$reportNull$$$0(25);
        }
        return new StringSearcher(model.getStringToFind(), model.isCaseSensitive(), model.isForward());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearPreviousFindData(FindModel model) {
        FindModel findModel = model;
        synchronized (findModel) {
            model.putUserData(ourCommentsLiteralsSearchDataKey, null);
            model.putUserData(ourExceptCommentsOrLiteralsDataKey, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private FindResult findInCommentsAndLiterals(@NotNull CharSequence text2, char[] textArray, int offset, @NotNull FindModel model, @NotNull VirtualFile file2) {
        ThreadLocal data2;
        if (text2 == null) {
            FindManagerImpl.$$$reportNull$$$0(26);
        }
        if (model == null) {
            FindManagerImpl.$$$reportNull$$$0(27);
        }
        if (file2 == null) {
            FindManagerImpl.$$$reportNull$$$0(28);
        }
        FindModel findModel = model;
        synchronized (findModel) {
            data2 = (ThreadLocal)model.getUserData(ourCommentsLiteralsSearchDataKey);
            assert (data2 != null);
        }
        FileType ftype = file2.getFileType();
        Language lang = LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)file2);
        CommentsLiteralsSearchData currentThreadData = (CommentsLiteralsSearchData)data2.get();
        if (currentThreadData == null || !Comparing.equal((Object)currentThreadData.lastFile, (Object)file2) || !currentThreadData.model.equals((Object)model)) {
            Set<Language> relevantLanguages;
            SyntaxHighlighter highlighter = FindManagerImpl.getHighlighter(file2, lang);
            if (highlighter == null) {
                FindResultImpl findResultImpl = NOT_FOUND_RESULT;
                if (findResultImpl == null) {
                    FindManagerImpl.$$$reportNull$$$0(29);
                }
                return findResultImpl;
            }
            TokenSet tokensOfInterest = TokenSet.EMPTY;
            if (lang != null) {
                Language finalLang = lang;
                relevantLanguages = (Set)ReadAction.compute(() -> {
                    THashSet result2 = new THashSet();
                    FileViewProvider viewProvider = PsiManager.getInstance((Project)this.myProject).findViewProvider(file2);
                    if (viewProvider != null) {
                        result2.addAll((Collection)viewProvider.getLanguages());
                    }
                    if (result2.isEmpty()) {
                        result2.add((Object)finalLang);
                    }
                    return result2;
                });
                for (Language relevantLanguage : relevantLanguages) {
                    tokensOfInterest = FindManagerImpl.addTokenTypesForLanguage(model, relevantLanguage, tokensOfInterest);
                }
            } else {
                relevantLanguages = new HashSet();
                if (ftype instanceof AbstractFileType) {
                    if (model.isInCommentsOnly()) {
                        tokensOfInterest = TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT});
                    }
                    if (model.isInStringLiteralsOnly()) {
                        tokensOfInterest = TokenSet.orSet((TokenSet[])new TokenSet[]{tokensOfInterest, TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.STRING, CustomHighlighterTokenType.SINGLE_QUOTED_STRING})});
                    }
                }
            }
            Matcher matcher = model.isRegularExpressions() ? FindManagerImpl.compileRegExp(model, "") : null;
            StringSearcher searcher = matcher != null ? null : new StringSearcher(model.getStringToFind(), model.isCaseSensitive(), true);
            LayeredLexer.ourDisableLayersFlag.set(Boolean.TRUE);
            try {
                SyntaxHighlighterOverEditorHighlighter highlighterAdapter = new SyntaxHighlighterOverEditorHighlighter(highlighter, file2, this.myProject);
                currentThreadData = new CommentsLiteralsSearchData(file2, relevantLanguages, highlighterAdapter, tokensOfInterest, searcher, matcher, model.clone());
                currentThreadData.highlighter.restart(text2);
            }
            finally {
                LayeredLexer.ourDisableLayersFlag.set(null);
            }
            data2.set(currentThreadData);
        }
        int initialStartOffset = model.isForward() && currentThreadData.startOffset < offset ? currentThreadData.startOffset : 0;
        currentThreadData.highlighter.resetPosition(initialStartOffset);
        Lexer lexer = currentThreadData.highlighter.getHighlightingLexer();
        TokenSet tokens = currentThreadData.tokensOfInterest;
        int lastGoodOffset = 0;
        boolean scanningForward = model.isForward();
        FindResultImpl prevFindResult = NOT_FOUND_RESULT;
        while (true) {
            block44: {
                int end;
                int start2;
                block43: {
                    block41: {
                        IElementType tokenType;
                        block42: {
                            char c;
                            if ((tokenType = lexer.getTokenType()) == null) break block41;
                            if (lexer.getState() == 0) {
                                lastGoodOffset = lexer.getTokenStart();
                            }
                            TextAttributesKey[] keys2 = currentThreadData.highlighter.getTokenHighlights(tokenType);
                            if (!tokens.contains(tokenType) && (!model.isInStringLiteralsOnly() || !ChunkExtractor.isHighlightedAsString((TextAttributesKey[])keys2)) && (!model.isInCommentsOnly() || !ChunkExtractor.isHighlightedAsComment((TextAttributesKey[])keys2))) break block42;
                            start2 = lexer.getTokenStart();
                            end = lexer.getTokenEnd();
                            if (model.isInStringLiteralsOnly() && ((c = text2.charAt(start2)) == '\"' || c == '\'')) {
                                while (start2 < end && c == text2.charAt(start2)) {
                                    if (c != text2.charAt(end - 1) || ++start2 >= end) continue;
                                    --end;
                                }
                            }
                            break block43;
                        }
                        Language tokenLang = tokenType.getLanguage();
                        if (tokenLang != lang && tokenLang != Language.ANY && !currentThreadData.relevantLanguages.contains(tokenLang)) {
                            currentThreadData.tokensOfInterest = tokens = FindManagerImpl.addTokenTypesForLanguage(model, tokenLang, tokens);
                            currentThreadData.relevantLanguages.add(tokenLang);
                        }
                        break block44;
                    }
                    FindResultImpl findResultImpl = prevFindResult;
                    if (findResultImpl == null) {
                        FindManagerImpl.$$$reportNull$$$0(32);
                    }
                    return findResultImpl;
                }
                int tokenContentStart = start2;
                while (true) {
                    FindResultImpl findResult = null;
                    if (currentThreadData.searcher != null) {
                        int matchStart = currentThreadData.searcher.scan(text2, textArray, start2, end);
                        if (matchStart != -1 && matchStart >= start2) {
                            int matchEnd = matchStart + model.getStringToFind().length();
                            if (matchStart >= offset || !scanningForward) {
                                findResult = new FindResultImpl(matchStart, matchEnd);
                            } else {
                                start2 = matchEnd;
                                continue;
                            }
                        }
                    } else if (start2 <= end) {
                        currentThreadData.matcher.reset(StringPattern.newBombedCharSequence((CharSequence)text2.subSequence(tokenContentStart, end)));
                        currentThreadData.matcher.region(start2 - tokenContentStart, end - tokenContentStart);
                        currentThreadData.matcher.useTransparentBounds(true);
                        if (currentThreadData.matcher.find()) {
                            int matchEnd = tokenContentStart + currentThreadData.matcher.end();
                            int matchStart = tokenContentStart + currentThreadData.matcher.start();
                            if (matchStart >= offset || !scanningForward) {
                                findResult = new FindResultImpl(matchStart, matchEnd);
                            } else {
                                int diff = 0;
                                if (start2 == end || start2 == matchEnd) {
                                    diff = 1;
                                }
                                start2 = matchEnd + diff;
                                continue;
                            }
                        }
                    }
                    if (findResult == null) break;
                    if (scanningForward) {
                        currentThreadData.startOffset = lastGoodOffset;
                        FindResultImpl findResultImpl = findResult;
                        if (findResultImpl == null) {
                            FindManagerImpl.$$$reportNull$$$0(30);
                        }
                        return findResultImpl;
                    }
                    if (findResult.getEndOffset() >= offset) {
                        FindResultImpl findResultImpl = prevFindResult;
                        if (findResultImpl == null) {
                            FindManagerImpl.$$$reportNull$$$0(31);
                        }
                        return findResultImpl;
                    }
                    prevFindResult = findResult;
                    start2 = findResult.getEndOffset();
                }
            }
            lexer.advance();
        }
    }

    private static TokenSet addTokenTypesForLanguage(FindModel model, Language lang, TokenSet tokensOfInterest) {
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (definition != null) {
            tokensOfInterest = TokenSet.orSet((TokenSet[])new TokenSet[]{tokensOfInterest, model.isInCommentsOnly() ? definition.getCommentTokens() : TokenSet.EMPTY});
            tokensOfInterest = TokenSet.orSet((TokenSet[])new TokenSet[]{tokensOfInterest, model.isInStringLiteralsOnly() ? definition.getStringLiteralElements() : TokenSet.EMPTY});
        }
        return tokensOfInterest;
    }

    private static SyntaxHighlighter getHighlighter(VirtualFile file2, @Nullable Language lang) {
        SyntaxHighlighter syntaxHighlighter;
        SyntaxHighlighter syntaxHighlighter2 = syntaxHighlighter = lang != null ? SyntaxHighlighterFactory.getSyntaxHighlighter((Language)lang, null, (VirtualFile)file2) : null;
        if (lang == null || syntaxHighlighter instanceof PlainSyntaxHighlighter) {
            syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)file2.getFileType(), null, (VirtualFile)file2);
        }
        return syntaxHighlighter;
    }

    private FindResult findStringByRegularExpression(CharSequence text2, int startOffset, FindModel model, VirtualFile file2) {
        Matcher matcher = FindManagerImpl.compileRegExp(model, text2);
        if (matcher == null) {
            return NOT_FOUND_RESULT;
        }
        try {
            if (model.isForward()) {
                if (matcher.find(startOffset) && matcher.end() <= text2.length()) {
                    return new FindResultImpl(matcher.start(), matcher.end());
                }
                return NOT_FOUND_RESULT;
            }
            int start2 = -1;
            int end = -1;
            while (matcher.find() && matcher.end() < startOffset) {
                start2 = matcher.start();
                end = matcher.end();
            }
            if (start2 < 0) {
                return NOT_FOUND_RESULT;
            }
            return new FindResultImpl(start2, end);
        }
        catch (StackOverflowError soe) {
            String stringToFind = model.getStringToFind();
            if (!ApplicationManager.getApplication().isHeadlessEnvironment() && ourReportedPatterns.put(stringToFind.hashCode(), (Object)Boolean.TRUE) == null) {
                String content2 = stringToFind + " produced stack overflow when matching content of the file";
                LOG.info(content2);
                GROUP.createNotification(FindBundle.message((String)"notification.title.regular.expression.failed.to.match", (Object[])new Object[0]), content2 + " " + file2.getPath(), NotificationType.ERROR, null).notify(this.myProject);
            }
            return NOT_FOUND_RESULT;
        }
    }

    private static Matcher compileRegExp(FindModel model, CharSequence text2) {
        Pattern pattern = model.compileRegExp();
        return pattern == null ? null : pattern.matcher(StringPattern.newBombedCharSequence((CharSequence)text2));
    }

    public String getStringToReplace(@NotNull String foundString, @NotNull FindModel model, int startOffset, @NotNull CharSequence documentText) throws FindManager.MalformedReplacementStringException {
        if (foundString == null) {
            FindManagerImpl.$$$reportNull$$$0(33);
        }
        if (model == null) {
            FindManagerImpl.$$$reportNull$$$0(34);
        }
        if (documentText == null) {
            FindManagerImpl.$$$reportNull$$$0(35);
        }
        String toReplace = model.getStringToReplace();
        if (model.isRegularExpressions()) {
            return FindManagerImpl.getStringToReplaceByRegexp(model, documentText, startOffset);
        }
        if (model.isPreserveCase()) {
            return FindManagerImpl.replaceWithCaseRespect(toReplace, foundString);
        }
        return toReplace;
    }

    private static String getStringToReplaceByRegexp(@NotNull FindModel model, @NotNull CharSequence text2, int startOffset) throws FindManager.MalformedReplacementStringException {
        if (model == null) {
            FindManagerImpl.$$$reportNull$$$0(36);
        }
        if (text2 == null) {
            FindManagerImpl.$$$reportNull$$$0(37);
        }
        Matcher matcher = FindManagerImpl.compileRegexAndFindFirst(model, text2, startOffset);
        return FindManagerImpl.getStringToReplaceByRegexp(model, matcher);
    }

    private static String getStringToReplaceByRegexp(@NotNull FindModel model, Matcher matcher) throws FindManager.MalformedReplacementStringException {
        if (model == null) {
            FindManagerImpl.$$$reportNull$$$0(38);
        }
        if (matcher == null) {
            return null;
        }
        try {
            String toReplace = model.getStringToReplace();
            return new RegExReplacementBuilder(matcher).createReplacement(toReplace);
        }
        catch (Exception e) {
            throw FindManagerImpl.createMalformedReplacementException(model, e);
        }
    }

    private static Matcher compileRegexAndFindFirst(FindModel model, CharSequence text2, int startOffset) {
        model = FindManagerImpl.normalizeIfMultilined(model);
        Matcher matcher = FindManagerImpl.compileRegExp(model, text2);
        if (model.isForward()) {
            if (!matcher.find(startOffset)) {
                return null;
            }
            if (matcher.end() > text2.length()) {
                return null;
            }
        } else {
            int start2 = -1;
            while (matcher.find() && matcher.end() < startOffset) {
                start2 = matcher.start();
            }
            if (start2 < 0) {
                return null;
            }
        }
        return matcher;
    }

    private static FindManager.MalformedReplacementStringException createMalformedReplacementException(FindModel model, Exception e) {
        return new FindManager.MalformedReplacementStringException(FindBundle.message((String)"find.replace.invalid.replacement.string", (Object[])new Object[]{model.getStringToReplace()}), (Throwable)e);
    }

    private static String replaceWithCaseRespect(String toReplace, String foundString) {
        char foundChar;
        char replacementChar;
        if (foundString.isEmpty() || toReplace.isEmpty()) {
            return toReplace;
        }
        StringBuilder buffer = new StringBuilder();
        if (Character.isUpperCase(foundString.charAt(0))) {
            buffer.append(Character.toUpperCase(toReplace.charAt(0)));
        } else {
            buffer.append(Character.toLowerCase(toReplace.charAt(0)));
        }
        if (toReplace.length() == 1) {
            return buffer.toString();
        }
        if (foundString.length() == 1) {
            buffer.append(toReplace.substring(1));
            return buffer.toString();
        }
        boolean isReplacementLowercase = true;
        boolean isReplacementUppercase = true;
        for (int i = 1; i < toReplace.length() && (!Character.isLetter(replacementChar = toReplace.charAt(i)) || (isReplacementLowercase &= Character.isLowerCase(replacementChar)) || (isReplacementUppercase &= Character.isUpperCase(replacementChar))); ++i) {
        }
        boolean isTailUpper = true;
        boolean isTailLower = true;
        for (int i = 1; i < foundString.length() && (!Character.isLetter(foundChar = foundString.charAt(i)) || (isTailUpper &= Character.isUpperCase(foundChar)) || (isTailLower &= Character.isLowerCase(foundChar))); ++i) {
        }
        if (isTailUpper && (isReplacementLowercase || isReplacementUppercase)) {
            buffer.append(StringUtil.toUpperCase((String)toReplace.substring(1)));
        } else if (isTailLower && (isReplacementLowercase || isReplacementUppercase)) {
            buffer.append(StringUtil.toLowerCase((String)toReplace.substring(1)));
        } else {
            buffer.append(toReplace.substring(1));
        }
        return buffer.toString();
    }

    public boolean canFindUsages(@NotNull PsiElement element2) {
        if (element2 == null) {
            FindManagerImpl.$$$reportNull$$$0(39);
        }
        return element2.isValid() && this.myFindUsagesManager.canFindUsages(element2);
    }

    public void findUsages(@NotNull PsiElement element2) {
        if (element2 == null) {
            FindManagerImpl.$$$reportNull$$$0(40);
        }
        this.findUsages(element2, false);
    }

    public void findUsagesInScope(@NotNull PsiElement element2, @NotNull SearchScope searchScope) {
        if (element2 == null) {
            FindManagerImpl.$$$reportNull$$$0(41);
        }
        if (searchScope == null) {
            FindManagerImpl.$$$reportNull$$$0(42);
        }
        this.myFindUsagesManager.findUsages(element2, null, null, false, searchScope);
    }

    public void findUsages(@NotNull PsiElement element2, boolean showDialog) {
        if (element2 == null) {
            FindManagerImpl.$$$reportNull$$$0(43);
        }
        this.myFindUsagesManager.findUsages(element2, null, null, showDialog, null);
    }

    public void showSettingsAndFindUsages(NavigationItem @NotNull [] targets2) {
        if (targets2 == null) {
            FindManagerImpl.$$$reportNull$$$0(44);
        }
        FindUsagesManager.showSettingsAndFindUsages(targets2);
    }

    public void clearFindingNextUsageInFile() {
        this.myFindUsagesManager.clearFindingNextUsageInFile();
    }

    public void findUsagesInEditor(@NotNull PsiElement element2, @NotNull FileEditor fileEditor) {
        if (element2 == null) {
            FindManagerImpl.$$$reportNull$$$0(45);
        }
        if (fileEditor == null) {
            FindManagerImpl.$$$reportNull$$$0(46);
        }
        if (fileEditor instanceof TextEditor) {
            TextEditor textEditor = (TextEditor)fileEditor;
            Editor editor = textEditor.getEditor();
            Document document = editor.getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            this.myFindUsagesManager.findUsages(element2, psiFile, fileEditor, false, null);
        }
    }

    private static boolean tryToFindNextUsageViaEditorSearchComponent(Editor editor, SearchResults.Direction forwardOrBackward) {
        EditorSearchSession search2 = EditorSearchSession.get(editor);
        if (search2 != null && search2.hasMatches()) {
            if (!search2.isSearchInProgress()) {
                if (forwardOrBackward == SearchResults.Direction.UP) {
                    search2.searchBackward();
                } else {
                    search2.searchForward();
                }
            }
            return true;
        }
        return false;
    }

    public boolean findNextUsageInEditor(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            FindManagerImpl.$$$reportNull$$$0(47);
        }
        if (!(fileEditor instanceof TextEditor)) {
            return false;
        }
        return this.findNextUsageInFile(((TextEditor)fileEditor).getEditor(), SearchResults.Direction.DOWN);
    }

    public boolean findNextUsageInEditor(@NotNull Editor editor) {
        if (editor == null) {
            FindManagerImpl.$$$reportNull$$$0(48);
        }
        return this.findNextUsageInFile(editor, SearchResults.Direction.DOWN);
    }

    public boolean findPreviousUsageInEditor(@NotNull Editor editor) {
        if (editor == null) {
            FindManagerImpl.$$$reportNull$$$0(49);
        }
        return this.findNextUsageInFile(editor, SearchResults.Direction.UP);
    }

    private boolean findNextUsageInFile(@NotNull Editor editor, @NotNull SearchResults.Direction direction) {
        if (editor == null) {
            FindManagerImpl.$$$reportNull$$$0(50);
        }
        if (direction == null) {
            FindManagerImpl.$$$reportNull$$$0(51);
        }
        editor.getCaretModel().removeSecondaryCarets();
        if (FindManagerImpl.tryToFindNextUsageViaEditorSearchComponent(editor, direction)) {
            return true;
        }
        RangeHighlighter[] highlighters = ((HighlightManagerImpl)HighlightManager.getInstance((Project)this.myProject)).getHighlighters(editor);
        if (highlighters.length > 0) {
            return FindManagerImpl.highlightNextHighlighter(highlighters, editor, editor.getCaretModel().getOffset(), direction == SearchResults.Direction.DOWN, false);
        }
        if (direction == SearchResults.Direction.DOWN) {
            return this.myFindUsagesManager.findNextUsageInFile(editor);
        }
        return this.myFindUsagesManager.findPreviousUsageInFile(editor);
    }

    public boolean findPreviousUsageInEditor(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            FindManagerImpl.$$$reportNull$$$0(52);
        }
        if (!(fileEditor instanceof TextEditor)) {
            return false;
        }
        return this.findNextUsageInFile(((TextEditor)fileEditor).getEditor(), SearchResults.Direction.UP);
    }

    private static boolean highlightNextHighlighter(RangeHighlighter[] highlighters, Editor editor, int offset, boolean isForward, boolean secondPass) {
        RangeHighlighter highlighterToSelect = null;
        Object wasNotFound = editor.getUserData(HIGHLIGHTER_WAS_NOT_FOUND_KEY);
        for (RangeHighlighter highlighter : highlighters) {
            int start2 = highlighter.getStartOffset();
            int end = highlighter.getEndOffset();
            if (!highlighter.isValid() || start2 >= end) continue;
            if (isForward && (start2 > offset || start2 == offset && secondPass) && (highlighterToSelect == null || highlighterToSelect.getStartOffset() > start2)) {
                highlighterToSelect = highlighter;
            }
            if (isForward || end >= offset && (end != offset || !secondPass) || highlighterToSelect != null && highlighterToSelect.getEndOffset() >= end) continue;
            highlighterToSelect = highlighter;
        }
        if (highlighterToSelect != null) {
            FindManagerImpl.expandFoldRegionsIfNecessary(editor, highlighterToSelect.getStartOffset(), highlighterToSelect.getEndOffset());
            editor.getSelectionModel().setSelection(highlighterToSelect.getStartOffset(), highlighterToSelect.getEndOffset());
            editor.getCaretModel().moveToOffset(highlighterToSelect.getStartOffset());
            ScrollType scrollType = secondPass ? (isForward ? ScrollType.CENTER_UP : ScrollType.CENTER_DOWN) : (isForward ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP);
            editor.getScrollingModel().scrollToCaret(scrollType);
            editor.putUserData(HIGHLIGHTER_WAS_NOT_FOUND_KEY, null);
            return true;
        }
        if (wasNotFound == null) {
            AnAction action2;
            String shortcutsText;
            editor.putUserData(HIGHLIGHTER_WAS_NOT_FOUND_KEY, (Object)Boolean.TRUE);
            String message = FindBundle.message((String)"find.highlight.no.more.highlights.found", (Object[])new Object[0]);
            message = isForward ? ((shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)(action2 = ActionManager.getInstance().getAction("FindNext")))).isEmpty() ? FindBundle.message((String)"find.search.again.from.top.action.message", (Object[])new Object[]{message}) : FindBundle.message((String)"find.search.again.from.top.hotkey.message", (Object[])new Object[]{message, shortcutsText})) : ((shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)(action2 = ActionManager.getInstance().getAction("FindPrevious")))).isEmpty() ? FindBundle.message((String)"find.search.again.from.bottom.action.message", (Object[])new Object[]{message}) : FindBundle.message((String)"find.search.again.from.bottom.hotkey.message", (Object[])new Object[]{message, shortcutsText}));
            JComponent component2 = HintUtil.createInformationLabel(message);
            LightweightHint hint = new LightweightHint(component2);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
            return true;
        }
        if (!secondPass) {
            offset = isForward ? 0 : editor.getDocument().getTextLength();
            return FindManagerImpl.highlightNextHighlighter(highlighters, editor, offset, isForward, true);
        }
        return false;
    }

    private static void expandFoldRegionsIfNecessary(@NotNull Editor editor, int startOffset, int endOffset) {
        FoldRegion region;
        FoldingModel foldingModel;
        FoldRegion[] regions;
        if (editor == null) {
            FindManagerImpl.$$$reportNull$$$0(53);
        }
        if ((regions = (foldingModel = editor.getFoldingModel()) instanceof FoldingModelEx ? ((FoldingModelEx)foldingModel).fetchTopLevel() : foldingModel.getAllFoldRegions()) == null) {
            return;
        }
        int i = Arrays.binarySearch(regions, null, (o1, o2) -> {
            if (o1 == null) {
                return startOffset - o2.getEndOffset();
            }
            return o1.getEndOffset() - startOffset;
        });
        i = i < 0 ? -i - 1 : ++i;
        if (i >= regions.length) {
            return;
        }
        ArrayList<FoldRegion> toExpand = new ArrayList<FoldRegion>();
        while (i < regions.length && (region = regions[i]).getStartOffset() < endOffset) {
            if (!region.isExpanded()) {
                toExpand.add(region);
            }
            ++i;
        }
        if (toExpand.isEmpty()) {
            return;
        }
        foldingModel.runBatchFoldingOperation(() -> {
            for (FoldRegion region : toExpand) {
                region.setExpanded(true);
            }
        });
    }

    @NotNull
    public FindUsagesManager getFindUsagesManager() {
        FindUsagesManager findUsagesManager = this.myFindUsagesManager;
        if (findUsagesManager == null) {
            FindManagerImpl.$$$reportNull$$$0(54);
        }
        return findUsagesManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 25: 
            case 27: 
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okHandler";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindManagerImpl";
                break;
            }
            case 7: 
            case 48: 
            case 49: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 11: 
            case 19: 
            case 26: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findmodel";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundString";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentText";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 46: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindInFileModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindInProjectModel";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findString";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeIfMultilined";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindString";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "findInCommentsAndLiterals";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showPromptDialog";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showPromptDialogImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showFindDialog";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 54: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFindNextModel";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFindContextPredicate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showMalformedReplacementPrompt";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "normalizeIfMultilined";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doFindString";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createStringSearcher";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findInCommentsAndLiterals";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getStringToReplace";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getStringToReplaceByRegexp";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsages";
                break;
            }
            case 40: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findUsagesInScope";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "showSettingsAndFindUsages";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findUsagesInEditor";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findNextUsageInEditor";
                break;
            }
            case 49: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findPreviousUsageInEditor";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findNextUsageInFile";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "expandFoldRegionsIfNecessary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CommentsLiteralsSearchData {
        final VirtualFile lastFile;
        int startOffset;
        final SyntaxHighlighterOverEditorHighlighter highlighter;
        TokenSet tokensOfInterest;
        final StringSearcher searcher;
        final Matcher matcher;
        final Set<Language> relevantLanguages;
        final FindModel model;

        CommentsLiteralsSearchData(VirtualFile lastFile, Set<Language> relevantLanguages, SyntaxHighlighterOverEditorHighlighter highlighter, TokenSet tokensOfInterest, StringSearcher searcher, Matcher matcher, FindModel model) {
            this.lastFile = lastFile;
            this.highlighter = highlighter;
            this.tokensOfInterest = tokensOfInterest;
            this.searcher = searcher;
            this.matcher = matcher;
            this.relevantLanguages = relevantLanguages;
            this.model = model;
        }
    }

    private class FindExceptCommentsOrLiteralsData
    implements Predicate<FindResult> {
        private final VirtualFile myFile;
        private final FindModel myFindModel;
        private final TreeMap<Integer, Integer> mySkipRangesSet;
        private final CharSequence myText;

        private FindExceptCommentsOrLiteralsData(VirtualFile file2, FindModel model, CharSequence text2) {
            this.myFile = file2;
            this.myFindModel = model.clone();
            this.myText = ImmutableCharSequence.asImmutable((CharSequence)text2);
            TreeMap<Integer, Integer> result2 = new TreeMap<Integer, Integer>();
            if (model.isExceptComments() || model.isExceptCommentsAndStringLiterals()) {
                this.addRanges(file2, model, text2, result2, FindModel.SearchContext.IN_COMMENTS);
            }
            if (model.isExceptStringLiterals() || model.isExceptCommentsAndStringLiterals()) {
                this.addRanges(file2, model, text2, result2, FindModel.SearchContext.IN_STRING_LITERALS);
            }
            this.mySkipRangesSet = result2;
        }

        private void addRanges(VirtualFile file2, FindModel model, CharSequence text2, TreeMap<Integer, Integer> result2, FindModel.SearchContext searchContext) {
            FindResult customResult;
            FindModel clonedModel = model.clone();
            clonedModel.setSearchContext(searchContext);
            clonedModel.setForward(true);
            int offset = 0;
            while ((customResult = FindManagerImpl.this.findStringLoop(text2, offset, clonedModel, file2, (Predicate<? super FindResult>)null)).isStringFound()) {
                result2.put(customResult.getStartOffset(), customResult.getEndOffset());
                offset = Math.max(customResult.getEndOffset(), offset + 1);
                if (offset < text2.length()) continue;
                break;
            }
        }

        boolean isAcceptableFor(FindModel model, VirtualFile file2, CharSequence text2) {
            return Comparing.equal((Object)this.myFile, (Object)file2) && this.myFindModel.equals((Object)model) && this.myText.length() == text2.length();
        }

        public boolean apply(@Nullable FindResult input) {
            if (input == null || !input.isStringFound()) {
                return true;
            }
            NavigableMap<Integer, Integer> map2 = this.mySkipRangesSet.headMap(input.getStartOffset(), true);
            for (Map.Entry e : map2.descendingMap().entrySet()) {
                if ((Integer)e.getKey() <= input.getStartOffset() && (input.getStartOffset() <= (Integer)e.getValue() || (Integer)e.getValue() >= input.getEndOffset())) {
                    return false;
                }
                if ((Integer)e.getValue() > input.getStartOffset()) continue;
                break;
            }
            return true;
        }
    }
}

