/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.Gray;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffLineSeparatorRenderer
implements LineMarkerRendererEx,
LineSeparatorRenderer {
    private static Object[] ourCachedImageKey = null;
    private static BufferedImage outCachedImage = null;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final BooleanGetter myCondition;
    @Nullable
    private final Computable<String> myDescription;
    public static final ColorKey BACKGROUND = ColorKey.createColorKey((String)"DIFF_SEPARATORS_BACKGROUND");

    public DiffLineSeparatorRenderer(@NotNull Editor editor, @NotNull BooleanGetter condition, @Nullable Computable<String> description) {
        if (editor == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(0);
        }
        if (condition == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(1);
        }
        this.myEditor = editor;
        this.myCondition = condition;
        this.myDescription = description;
    }

    public static void drawConnectorLine(@NotNull Graphics2D g, int x1, int x2, int y1, int y2, int lineHeight, @Nullable EditorColorsScheme scheme) {
        if (g == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(2);
        }
        int step = DiffLineSeparatorRenderer.getStepSize(lineHeight);
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        int verticalOffset = DiffLineSeparatorRenderer.getVerticalOffset(lineHeight, step, height);
        int start1 = y1 + verticalOffset + step / 2;
        int start2 = y2 + verticalOffset + step / 2;
        int end1 = start1 + height - 1;
        int end2 = start2 + height - 1;
        Color color = DiffLineSeparatorRenderer.getBackgroundColor(scheme);
        DiffDrawUtil.drawCurveTrapezium(g, x1, x2, start1, end1, start2, end2, color, null);
    }

    public void paint(Editor editor, Graphics g, Rectangle r) {
        if (!this.myCondition.get()) {
            return;
        }
        int y = r.y;
        int lineHeight = this.myEditor.getLineHeight();
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        int annotationsOffset = gutter.getAnnotationsAreaOffset();
        int annotationsWidth = gutter.getAnnotationsAreaWidth();
        if (annotationsWidth != 0) {
            g.setColor(editor.getColorsScheme().getColor(EditorColors.GUTTER_BACKGROUND));
            g.fillRect(annotationsOffset, y, annotationsWidth, lineHeight);
        }
        DiffLineSeparatorRenderer.draw(g, 0, y, lineHeight, this.myEditor.getColorsScheme());
    }

    public void drawLine(Graphics g, int x1, int x2, int y) {
        String description;
        if (!this.myCondition.get()) {
            return;
        }
        ++y;
        int gutterWidth = ((EditorEx)this.myEditor).getGutterComponentEx().getWidth();
        int lineHeight = this.myEditor.getLineHeight();
        int interval = DiffLineSeparatorRenderer.getStepSize(lineHeight) * 2;
        int shiftX = -interval;
        if (DiffUtil.isMirrored(this.myEditor)) {
            int contentWidth = ((EditorEx)this.myEditor).getScrollPane().getViewport().getWidth();
            shiftX += contentWidth % interval - interval;
            shiftX += gutterWidth % interval - interval;
        } else {
            shiftX += -gutterWidth % interval - interval;
        }
        String string = description = this.myDescription != null && this.myEditor instanceof EditorImpl ? (String)this.myDescription.compute() : null;
        if (description != null) {
            DiffLineSeparatorRenderer.drawWithDescription((Graphics2D)g, x1, y, shiftX, lineHeight, (EditorImpl)this.myEditor, description);
        } else {
            DiffLineSeparatorRenderer.draw(g, shiftX, y, lineHeight, this.myEditor.getColorsScheme());
        }
    }

    private static void drawWithDescription(Graphics2D g, int x, int y, int shiftX, int lineHeight, @NotNull EditorImpl editor, @NotNull String description) {
        if (editor == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(3);
        }
        if (description == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(4);
        }
        EditorColorsScheme scheme = editor.getColorsScheme();
        int rectX = x + JBUIScale.scale((int)5);
        int rectWidth = HintRenderer.calcWidthInPixels(editor, description, null);
        Shape oldClip = g.getClip();
        g.clip(new Rectangle(0, 0, rectX, Integer.MAX_VALUE));
        DiffLineSeparatorRenderer.draw(g, shiftX, y, lineHeight, editor.getColorsScheme());
        g.setClip(oldClip);
        g.clip(new Rectangle(rectX + rectWidth, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
        DiffLineSeparatorRenderer.draw(g, shiftX, y, lineHeight, editor.getColorsScheme());
        g.setClip(oldClip);
        HintRenderer.paintHint(g, editor, new Rectangle(rectX, y, rectWidth, lineHeight), description, scheme.getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT), scheme.getAttributes(HighlighterColors.TEXT), null);
    }

    @Override
    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.CUSTOM;
        if (position == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(5);
        }
        return position;
    }

    private static void draw(@NotNull Graphics g, int shiftX, int shiftY, int lineHeight, @NotNull EditorColorsScheme scheme) {
        if (g == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(6);
        }
        if (scheme == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(7);
        }
        int step = DiffLineSeparatorRenderer.getStepSize(lineHeight);
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        Color color = DiffLineSeparatorRenderer.getBackgroundColor(scheme);
        Rectangle clip = g.getClipBounds();
        if (clip.width <= 0) {
            return;
        }
        int startX = clip.x - shiftX;
        int endX = startX + clip.width;
        int startIndex = startX / step;
        int endIndex = endX / step + 1;
        Graphics2D gg = (Graphics2D)g.create();
        gg.translate(shiftX, shiftY + DiffLineSeparatorRenderer.getVerticalOffset(lineHeight, step, height));
        if (startIndex == 0) {
            gg.setColor(color);
            LinePainter2D.fillPolygon((Graphics2D)gg, (double[])new double[]{0.0, step, step, 0.0}, (double[])new double[]{step / 2, step, step + height, step / 2 + height}, (int)4, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED_CAPS_SQUARE, (double)1.0, (Object)RenderingHints.VALUE_ANTIALIAS_OFF);
        } else if (startIndex % 2 == 0) {
            --startIndex;
        }
        BufferedImage image = DiffLineSeparatorRenderer.createImage(gg, color, step, height);
        gg.setComposite(AlphaComposite.SrcOver);
        for (int index = startIndex; index < endIndex; ++index) {
            if (index % 2 == 0) continue;
            UIUtil.drawImage((Graphics)gg, (Image)image, (int)(index * step), (int)0, null);
        }
        gg.dispose();
    }

    @NotNull
    private static BufferedImage createImage(@NotNull Graphics2D g, @NotNull Color color, int step, int height) {
        Object[] key;
        if (g == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(8);
        }
        if (color == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(9);
        }
        if (Arrays.equals(ourCachedImageKey, key = new Object[]{color.getRGB(), Float.valueOf(JBUIScale.sysScale((Graphics2D)g)), step, height}) && outCachedImage != null) {
            BufferedImage bufferedImage = outCachedImage;
            if (bufferedImage == null) {
                DiffLineSeparatorRenderer.$$$reportNull$$$0(10);
            }
            return bufferedImage;
        }
        int imageWidth = step * 2;
        int imageHeight = step + height;
        BufferedImage image = ImageUtil.createImage((Graphics)g, (int)imageWidth, (int)imageHeight, (int)2);
        Graphics2D gg = image.createGraphics();
        gg.setColor(color);
        LinePainter2D.fillPolygon((Graphics2D)gg, (double[])new double[]{0.0, step, step * 2, step * 2, step, 0.0}, (double[])new double[]{step, 0.0, step, step + height, height, step + height}, (int)6, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED_CAPS_SQUARE, (double)1.0, (Object)RenderingHints.VALUE_ANTIALIAS_OFF);
        outCachedImage = image;
        ourCachedImageKey = key;
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(11);
        }
        return bufferedImage;
    }

    private static int getStepSize(int lineHeight) {
        return Math.max(lineHeight / 3, 1);
    }

    private static int getHeight(int lineHeight) {
        return Math.max(lineHeight / 2, 1);
    }

    private static int getVerticalOffset(int lineHeight, int step, int height) {
        return (lineHeight - height - step) / 2;
    }

    @NotNull
    private static Color getBackgroundColor(@Nullable EditorColorsScheme scheme) {
        Color color;
        if (scheme == null) {
            scheme = EditorColorsManager.getInstance().getGlobalScheme();
        }
        Color color2 = (color = scheme.getColor(BACKGROUND)) != null ? color : Gray._128;
        if (color2 == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(12);
        }
        return color2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffLineSeparatorRenderer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffLineSeparatorRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "drawConnectorLine";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "drawWithDescription";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "draw";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

