/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorComposer;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.GlobalReportedProblemFilter;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.ReportedProblemFilter;
import com.intellij.codeInspection.ui.actions.ExportHTMLAction;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultInspectionToolPresentation
implements InspectionToolPresentation {
    protected static final Logger LOG = Logger.getInstance(DefaultInspectionToolPresentation.class);
    public static final String INSPECTION_RESULTS_PROBLEM_CLASS_ELEMENT = "problem_class";
    public static final String INSPECTION_RESULTS_SEVERITY_ATTRIBUTE = "severity";
    public static final String INSPECTION_RESULTS_ATTRIBUTE_KEY_ATTRIBUTE = "attribute_key";
    public static final String INSPECTION_RESULTS_ID_ATTRIBUTE = "id";
    public static final String INSPECTION_RESULTS_DESCRIPTION_ELEMENT = "description";
    public static final String INSPECTION_RESULTS_HINTS_ELEMENT = "hints";
    public static final String INSPECTION_RESULTS_HINT_ELEMENT = "hint";
    public static final String INSPECTION_RESULTS_VALUE_ATTRIBUTE = "value";
    @NotNull
    private final InspectionToolWrapper myToolWrapper;
    @NotNull
    protected final GlobalInspectionContextImpl myContext;
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myProblemElements;
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> mySuppressedElements;
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myResolvedElements;
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myExcludedElements;
    protected final Map<String, Set<RefEntity>> myContents;
    private DescriptorComposer myComposer;
    private volatile boolean isDisposed;

    public DefaultInspectionToolPresentation(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        if (toolWrapper == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(1);
        }
        this.myProblemElements = DefaultInspectionToolPresentation.createBidiMap();
        this.mySuppressedElements = DefaultInspectionToolPresentation.createBidiMap();
        this.myResolvedElements = DefaultInspectionToolPresentation.createBidiMap();
        this.myExcludedElements = DefaultInspectionToolPresentation.createBidiMap();
        this.myContents = Collections.synchronizedMap(new HashMap(1));
        this.myToolWrapper = toolWrapper;
        this.myContext = context;
    }

    public void resolveProblem(@NotNull CommonProblemDescriptor descriptor2) {
        RefEntity entity;
        if (descriptor2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(2);
        }
        if ((entity = this.myProblemElements.removeValue(descriptor2)) != null) {
            this.myResolvedElements.put(entity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor2});
        }
    }

    @Override
    public boolean isProblemResolved(@Nullable CommonProblemDescriptor descriptor2) {
        return this.myResolvedElements.containsValue(descriptor2);
    }

    @Override
    public boolean isProblemResolved(@Nullable RefEntity entity) {
        return this.myResolvedElements.containsKey(entity) && !this.myProblemElements.containsKey(entity);
    }

    @Override
    @NotNull
    public Collection<RefEntity> getResolvedElements() {
        Collection<RefEntity> collection = this.myResolvedElements.keys();
        if (collection == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    public CommonProblemDescriptor @NotNull [] getResolvedProblems(@NotNull RefEntity entity) {
        if (entity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(4);
        }
        CommonProblemDescriptor[] commonProblemDescriptorArray = this.myResolvedElements.getOrDefault(entity, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY);
        if (commonProblemDescriptorArray == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(5);
        }
        return commonProblemDescriptorArray;
    }

    @Override
    public void suppressProblem(@NotNull CommonProblemDescriptor descriptor2) {
        if (descriptor2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(6);
        }
        this.mySuppressedElements.put(this.myProblemElements.removeValue(descriptor2), (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor2});
    }

    @Override
    public void suppressProblem(@NotNull RefEntity entity) {
        CommonProblemDescriptor[] removed;
        if (entity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(7);
        }
        if ((removed = this.myProblemElements.remove(entity)) != null) {
            this.mySuppressedElements.put(entity, (CommonProblemDescriptor[])removed);
        }
    }

    @Override
    public boolean isSuppressed(RefEntity element2) {
        return this.mySuppressedElements.containsKey(element2);
    }

    @Override
    public boolean isSuppressed(CommonProblemDescriptor descriptor2) {
        return this.mySuppressedElements.containsValue(descriptor2);
    }

    @Override
    public CommonProblemDescriptor @NotNull [] getSuppressedProblems(@NotNull RefEntity entity) {
        if (entity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(8);
        }
        CommonProblemDescriptor[] commonProblemDescriptorArray = this.mySuppressedElements.getOrDefault(entity, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY);
        if (commonProblemDescriptorArray == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(9);
        }
        return commonProblemDescriptorArray;
    }

    @Override
    @Nullable
    public HighlightSeverity getSeverity(@NotNull RefElement element2) {
        if (element2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(10);
        }
        return (HighlightSeverity)ReadAction.nonBlocking(() -> {
            PsiFile psiElement = ((RefElement)element2.getRefManager().getRefinedElement((RefEntity)element2)).getPointer().getContainingFile();
            if (psiElement != null) {
                GlobalInspectionContextImpl context = this.getContext();
                String shortName = this.getSeverityDelegateName();
                Tools tools = context.getTools().get(shortName);
                if (tools != null) {
                    for (ScopeToolState state : tools.getTools()) {
                        InspectionToolWrapper toolWrapper = state.getTool();
                        if (toolWrapper != this.getToolWrapper()) continue;
                        return context.getCurrentProfile().getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement).getSeverity();
                    }
                }
                InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(context.getProject()).getCurrentProfile();
                HighlightDisplayLevel level = profile.getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement);
                return level.getSeverity();
            }
            return null;
        }).executeSynchronously();
    }

    @Override
    public boolean isExcluded(@NotNull CommonProblemDescriptor descriptor2) {
        if (descriptor2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(11);
        }
        return this.myExcludedElements.containsValue(descriptor2);
    }

    @Override
    public boolean isExcluded(@NotNull RefEntity entity) {
        if (entity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(12);
        }
        Object[] excluded = this.myExcludedElements.get(entity);
        Object[] problems = this.myProblemElements.get(entity);
        return excluded != null && problems != null && Comparing.equal((Object)ContainerUtil.set((Object[])excluded), (Object)ContainerUtil.set((Object[])problems));
    }

    @Override
    public void amnesty(@NotNull RefEntity element2) {
        if (element2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(13);
        }
        this.myExcludedElements.remove(element2);
    }

    @Override
    public void exclude(@NotNull RefEntity element2) {
        if (element2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(14);
        }
        this.myExcludedElements.put(element2, (CommonProblemDescriptor[])this.myProblemElements.getOrDefault(element2, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY));
    }

    @Override
    public void amnesty(@NotNull CommonProblemDescriptor descriptor2) {
        if (descriptor2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(15);
        }
        this.myExcludedElements.removeValue(descriptor2);
    }

    @Override
    public void exclude(@NotNull CommonProblemDescriptor descriptor2) {
        RefEntity entity;
        if (descriptor2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(16);
        }
        if ((entity = (RefEntity)ObjectUtils.chooseNotNull((Object)this.myProblemElements.getKeyFor(descriptor2), (Object)this.myResolvedElements.getKeyFor(descriptor2))) != null) {
            this.myExcludedElements.put(entity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor2});
        }
    }

    protected String getSeverityDelegateName() {
        return this.getToolWrapper().getShortName();
    }

    @Override
    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        InspectionToolWrapper inspectionToolWrapper = this.myToolWrapper;
        if (inspectionToolWrapper == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(17);
        }
        return inspectionToolWrapper;
    }

    @NotNull
    public RefManager getRefManager() {
        RefManager refManager = this.getContext().getRefManager();
        if (refManager == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(18);
        }
        return refManager;
    }

    @Override
    @NotNull
    public GlobalInspectionContextImpl getContext() {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.myContext;
        if (globalInspectionContextImpl == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(19);
        }
        return globalInspectionContextImpl;
    }

    @Override
    public void exportResults(final @NotNull Consumer<? super Element> resultConsumer, final @NotNull Predicate<? super RefEntity> excludedEntities, final @NotNull Predicate<? super CommonProblemDescriptor> excludedDescriptors) {
        if (resultConsumer == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(20);
        }
        if (excludedEntities == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(21);
        }
        if (excludedDescriptors == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(22);
        }
        this.getRefManager().iterate(new RefVisitor(){

            public void visitElement(@NotNull RefEntity elem) {
                if (elem == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!excludedEntities.test(elem)) {
                    DefaultInspectionToolPresentation.this.exportResults((Consumer<? super Element>)resultConsumer, elem, (Predicate<? super CommonProblemDescriptor>)excludedDescriptors);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation$1", "visitElement"));
            }
        });
    }

    public void addProblemElement(@Nullable RefEntity refElement, CommonProblemDescriptor ... descriptions) {
        if (descriptions == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(23);
        }
        this.addProblemElement(refElement, true, descriptions);
    }

    @Override
    public void addProblemElement(@Nullable RefEntity refElement, boolean filterSuppressed, CommonProblemDescriptor ... descriptors) {
        if (descriptors == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(24);
        }
        if (refElement == null || descriptors.length == 0) {
            return;
        }
        ReportedProblemFilter filter2 = this.myContext.getReportedProblemFilter();
        if (filter2 != null && !filter2.shouldReportProblem(refElement, descriptors)) {
            return;
        }
        DefaultInspectionToolPresentation.checkFromSameFile(refElement, descriptors);
        if (filterSuppressed) {
            if (this.myContext.getOutputPath() == null || !(this.myToolWrapper instanceof LocalInspectionToolWrapper)) {
                this.myProblemElements.put(refElement, (CommonProblemDescriptor[])descriptors);
            } else {
                try {
                    this.writeOutput(descriptors, refElement);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        } else {
            this.myProblemElements.put(refElement, (CommonProblemDescriptor[])descriptors);
        }
        GlobalInspectionContextImpl context = this.getContext();
        if (context.isViewClosed() || !(refElement instanceof RefElement)) {
            return;
        }
        if (this.myToolWrapper instanceof LocalInspectionToolWrapper && (!ApplicationManager.getApplication().isUnitTestMode() || GlobalInspectionContextImpl.TESTING_VIEW)) {
            context.initializeViewIfNeeded().doWhenDone(() -> context.getView().addProblemDescriptors(this.myToolWrapper, refElement, descriptors));
        }
    }

    protected boolean isDisposed() {
        return this.isDisposed;
    }

    private synchronized void writeOutput(CommonProblemDescriptor @NotNull [] descriptions, @NotNull RefEntity refElement) throws IOException {
        if (refElement == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(25);
        }
        if (descriptions == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(26);
        }
        Path file2 = ExportHTMLAction.getInspectionResultFile(this.myContext.getOutputPath(), this.myToolWrapper.getShortName());
        boolean exists = Files.exists(file2, new LinkOption[0]);
        Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file2, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
            if (!exists) {
                ((Writer)writer).write(60);
                writer.write("problems");
                ((Writer)writer).write(32);
                writer.write("is_local_tool");
                ((Writer)writer).write(61);
                ((Writer)writer).write(34);
                writer.write(Boolean.toString(this.myToolWrapper instanceof LocalInspectionToolWrapper));
                ((Writer)writer).write(34);
                ((Writer)writer).write(62);
                ((Writer)writer).write(10);
            }
            this.exportResults(descriptions, refElement, p -> {
                try {
                    JbXmlOutputter.collapseMacrosAndWrite(p, (ComponentManager)this.getContext().getProject(), writer);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }, d -> false);
            ((Writer)writer).write(10);
        }
    }

    @Override
    @NotNull
    public Collection<CommonProblemDescriptor> getProblemDescriptors() {
        Collection<CommonProblemDescriptor> collection = this.myProblemElements.getValues();
        if (collection == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(27);
        }
        return collection;
    }

    public void ignoreElement(@NotNull RefEntity refEntity) {
        if (refEntity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(28);
        }
        this.myProblemElements.remove(refEntity);
    }

    @Override
    public void cleanup() {
        this.isDisposed = true;
    }

    public CommonProblemDescriptor @Nullable [] getDescriptions(@NotNull RefEntity refEntity) {
        CommonProblemDescriptor[] problems;
        if (refEntity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(29);
        }
        if ((problems = this.getProblemElements().getOrDefault(refEntity, null)) == null) {
            return null;
        }
        if (!refEntity.isValid()) {
            this.ignoreElement(refEntity);
            return null;
        }
        return problems;
    }

    @Override
    @NotNull
    public HTMLComposerImpl getComposer() {
        if (this.myComposer == null) {
            this.myComposer = new DescriptorComposer(this);
        }
        DescriptorComposer descriptorComposer = this.myComposer;
        if (descriptorComposer == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(30);
        }
        return descriptorComposer;
    }

    @Override
    public void exportResults(@NotNull Consumer<? super Element> resultConsumer, @NotNull RefEntity refEntity, @NotNull Predicate<? super CommonProblemDescriptor> isDescriptorExcluded) {
        CommonProblemDescriptor[] descriptions;
        if (resultConsumer == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(31);
        }
        if (refEntity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(32);
        }
        if (isDescriptorExcluded == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(33);
        }
        if ((descriptions = this.getProblemElements().get(refEntity)) != null) {
            this.exportResults(descriptions, refEntity, resultConsumer, isDescriptorExcluded);
        }
    }

    protected void exportResults(CommonProblemDescriptor @NotNull [] descriptors, @NotNull RefEntity refEntity, @NotNull Consumer<? super Element> problemSink, @NotNull Predicate<? super CommonProblemDescriptor> isDescriptorExcluded) {
        if (refEntity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(34);
        }
        if (problemSink == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(35);
        }
        if (isDescriptorExcluded == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(36);
        }
        if (descriptors == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(37);
        }
        for (CommonProblemDescriptor descriptor2 : descriptors) {
            if (isDescriptorExcluded.test((CommonProblemDescriptor)descriptor2)) continue;
            int line = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getLineNumber() : -1;
            Element element2 = null;
            try {
                element2 = refEntity.getRefManager().export(refEntity, line);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            if (element2 == null) {
                return;
            }
            this.exportResult(refEntity, descriptor2, element2);
            problemSink.accept((Element)element2);
        }
    }

    private void exportResult(@NotNull RefEntity refEntity, @NotNull CommonProblemDescriptor descriptor2, @NotNull Element element2) {
        if (refEntity == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(38);
        }
        if (descriptor2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(39);
        }
        if (element2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(40);
        }
        try {
            TextRange textRange;
            PsiElement psiElement = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getPsiElement() : null;
            Element problemClassElement = new Element(INSPECTION_RESULTS_PROBLEM_CLASS_ELEMENT);
            problemClassElement.setAttribute(INSPECTION_RESULTS_ID_ATTRIBUTE, this.myToolWrapper.getShortName());
            problemClassElement.addContent(this.myToolWrapper.getDisplayName());
            HighlightSeverity severity = InspectionToolPresentation.getSeverity(refEntity, psiElement, this);
            SeverityRegistrar severityRegistrar = this.myContext.getCurrentProfile().getProfileManager().getSeverityRegistrar();
            HighlightInfoType type = descriptor2 instanceof ProblemDescriptor ? ProblemDescriptorUtil.highlightTypeFromDescriptor((ProblemDescriptor)descriptor2, severity, severityRegistrar) : ProblemDescriptorUtil.getHighlightInfoType(ProblemHighlightType.GENERIC_ERROR_OR_WARNING, severity, severityRegistrar);
            problemClassElement.setAttribute(INSPECTION_RESULTS_SEVERITY_ATTRIBUTE, type.getSeverity(psiElement).getName());
            problemClassElement.setAttribute(INSPECTION_RESULTS_ATTRIBUTE_KEY_ATTRIBUTE, type.getAttributesKey().getExternalName());
            element2.addContent(problemClassElement);
            if (this.myToolWrapper instanceof GlobalInspectionToolWrapper) {
                GlobalInspectionTool globalInspectionTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)this.myToolWrapper).getTool();
                QuickFix[] fixes = descriptor2.getFixes();
                if (fixes != null) {
                    Element hintsElement = new Element(INSPECTION_RESULTS_HINTS_ELEMENT);
                    for (QuickFix fix : fixes) {
                        String hint = globalInspectionTool.getHint(fix);
                        if (hint == null) continue;
                        Element hintElement = new Element(INSPECTION_RESULTS_HINT_ELEMENT);
                        hintElement.setAttribute(INSPECTION_RESULTS_VALUE_ATTRIBUTE, hint);
                        hintsElement.addContent(hintElement);
                    }
                    element2.addContent(hintsElement);
                }
            }
            String template = descriptor2.getDescriptionTemplate();
            String highlightedText = ProblemDescriptorUtil.extractHighlightedText(descriptor2, psiElement);
            String problemText = StringUtil.replace((String)StringUtil.replace((String)template, (String)"#ref", (String)(psiElement != null ? highlightedText : "")), (String)" #loc ", (String)" ");
            Element descriptionElement = new Element(INSPECTION_RESULTS_DESCRIPTION_ELEMENT);
            descriptionElement.addContent(problemText);
            element2.addContent(descriptionElement);
            Element highLightedElement = new Element("highlighted_element");
            highLightedElement.addContent(highlightedText);
            element2.addContent(highLightedElement);
            if (descriptor2 instanceof ProblemDescriptorBase && (textRange = ((ProblemDescriptorBase)descriptor2).getTextRangeForNavigation()) != null) {
                int offset = textRange.getStartOffset() - ((ProblemDescriptorBase)descriptor2).getLineStartOffset();
                int length = textRange.getLength();
                element2.addContent(new Element("offset").addContent(String.valueOf(offset)));
                element2.addContent(new Element("length").addContent(String.valueOf(length)));
            }
        }
        catch (RuntimeException e) {
            LOG.info("Cannot save results for " + refEntity.getName() + ", inspection which caused problem: " + this.myToolWrapper.getShortName() + ", problem descriptor " + descriptor2);
        }
    }

    @Override
    public synchronized boolean hasReportedProblems() {
        return !this.myContents.isEmpty();
    }

    @Override
    public synchronized void updateContent() {
        this.myContents.clear();
        this.updateProblemElements();
    }

    protected void updateProblemElements() {
        Object elements2;
        if (this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS) {
            elements2 = this.getProblemElements().keys().stream().filter(entity -> !this.isExcluded((RefEntity)entity)).collect(Collectors.toSet());
        } else {
            elements2 = new THashSet(this.getProblemElements().keys());
            elements2.addAll(this.getResolvedElements());
            elements2.addAll(this.mySuppressedElements.keys());
        }
        Iterator iterator2 = elements2.iterator();
        while (iterator2.hasNext()) {
            RefEntity element2 = (RefEntity)iterator2.next();
            String groupName = element2 instanceof RefElement ? element2.getRefManager().getGroupName((RefElement)element2) : element2.getQualifiedName();
            this.registerContentEntry(element2, groupName);
        }
    }

    protected void registerContentEntry(RefEntity element2, String packageName) {
        GlobalReportedProblemFilter globalReportedProblemFilter = this.myContext.getGlobalReportedProblemFilter();
        if (globalReportedProblemFilter == null || globalReportedProblemFilter.shouldReportProblem(element2, this.getToolWrapper().getShortName())) {
            Set content2 = this.myContents.computeIfAbsent(packageName, k -> new HashSet());
            content2.add(element2);
        }
    }

    @Override
    @NotNull
    public Map<String, Set<RefEntity>> getContent() {
        Map<String, Set<RefEntity>> map2 = this.myContents;
        if (map2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(41);
        }
        return map2;
    }

    @Override
    public QuickFixAction @NotNull [] getQuickFixes(RefEntity ... refElements) {
        if (refElements == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(42);
        }
        if (QuickFixAction.EMPTY == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(43);
        }
        return QuickFixAction.EMPTY;
    }

    public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor2) {
        if (descriptor2 == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(44);
        }
        return this.myProblemElements.getKeyFor(descriptor2);
    }

    @Override
    @NotNull
    public SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> getProblemElements() {
        SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> synchronizedBidiMultiMap = this.myProblemElements;
        if (synchronizedBidiMultiMap == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(45);
        }
        return synchronizedBidiMultiMap;
    }

    @Override
    @Nullable
    public QuickFix findQuickFixes(@NotNull CommonProblemDescriptor problemDescriptor, RefEntity entity, String hint) {
        InspectionProfileEntry tool;
        if (problemDescriptor == null) {
            DefaultInspectionToolPresentation.$$$reportNull$$$0(46);
        }
        return !((tool = this.getToolWrapper().getTool()) instanceof GlobalInspectionTool) ? null : ((GlobalInspectionTool)tool).getQuickFix(hint);
    }

    private static SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> createBidiMap() {
        return new SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor>(){

            @Override
            @NotNull
            protected ArrayFactory<CommonProblemDescriptor> arrayFactory() {
                ArrayFactory arrayFactory = CommonProblemDescriptor.ARRAY_FACTORY;
                if (arrayFactory == null) {
                    2.$$$reportNull$$$0(0);
                }
                return arrayFactory;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation$2", "arrayFactory"));
            }
        };
    }

    private static void checkFromSameFile(RefEntity element2, CommonProblemDescriptor[] descriptors) {
        if (!(element2 instanceof RefElement)) {
            return;
        }
        SmartPsiElementPointer pointer = ((RefElement)element2).getPointer();
        if (pointer == null) {
            return;
        }
        VirtualFile entityFile = DefaultInspectionToolPresentation.ensureNotInjectedFile(pointer.getVirtualFile());
        if (entityFile == null) {
            return;
        }
        StreamEx.of((Object[])descriptors).select(ProblemDescriptorBase.class).forEach(d -> {
            VirtualFile file2 = d.getContainingFile();
            if (file2 != null) {
                LOG.assertTrue(DefaultInspectionToolPresentation.ensureNotInjectedFile(file2).equals(entityFile), (Object)("descriptor and containing entity files should be the same; descriptor: " + d.getDescriptionTemplate()));
            }
        });
    }

    @Contract(value="null -> null")
    private static VirtualFile ensureNotInjectedFile(VirtualFile file2) {
        return file2 instanceof VirtualFileWindow ? ((VirtualFileWindow)file2).getDelegate() : file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 27: 
            case 30: 
            case 41: 
            case 43: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 27: 
            case 30: 
            case 41: 
            case 43: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 15: 
            case 16: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 27: 
            case 30: 
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultConsumer";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedEntities";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedDescriptors";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isDescriptorExcluded";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemSink";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElements";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/DefaultInspectionToolPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedProblems";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressedProblems";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWrapper";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefManager";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemDescriptors";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposer";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveProblem";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 27: 
            case 30: 
            case 41: 
            case 43: 
            case 45: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedProblems";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suppressProblem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedProblems";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSeverity";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "amnesty";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "exportResults";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addProblemElement";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "writeOutput";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "ignoreElement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptions";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "exportResult";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findQuickFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 27: 
            case 30: 
            case 41: 
            case 43: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

