/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.timing;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Timeout;
import org.fest.swing.util.TimeoutWatch;
import org.fest.util.Arrays;
import org.fest.util.Preconditions;

public final class Pause {
    private static final int DEFAULT_DELAY = 30000;
    private static final int SLEEP_INTERVAL = 10;

    public static void pause(@Nonnull Condition condition) {
        Pause.pause(condition, 30000L);
    }

    public static void pause(@Nonnull Condition condition, @Nonnull Timeout timeout) {
        Preconditions.checkNotNull((Object)timeout);
        Pause.pause(condition, timeout.duration());
    }

    public static void pause(@Nonnull Condition condition, long timeout) {
        Preconditions.checkNotNull((Object)condition);
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!condition.test()) {
            if (watch.isTimeOut() && !condition.test()) {
                condition.done();
                throw new WaitTimedOutError(String.format("Timed out waiting for %s", condition.toString()));
            }
            Pause.pause(10L);
        }
        condition.done();
    }

    public static void pause(@Nonnull Condition[] conditions) {
        Pause.pause(conditions, 30000L);
    }

    public static void pause(@Nonnull Condition[] conditions, @Nonnull Timeout timeout) {
        Pause.pause(conditions, timeout.duration());
    }

    public static void pause(@Nonnull Condition[] conditions, long timeout) {
        Preconditions.checkNotNullOrEmpty((Object[])conditions);
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!Pause.areSatisfied(conditions)) {
            if (watch.isTimeOut()) {
                for (Condition condition : conditions) {
                    condition.done();
                }
                throw new WaitTimedOutError(String.format("Timed out waiting for %s", Arrays.format((Object)conditions)));
            }
            Pause.pause(10L);
        }
        for (Condition condition : conditions) {
            condition.done();
        }
    }

    private static boolean areSatisfied(@Nonnull Condition[] conditions) {
        for (Condition condition : conditions) {
            Preconditions.checkNotNull((Object)condition);
            if (condition.test()) continue;
            return false;
        }
        return true;
    }

    public static void pause(long timeout, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull((Object)((Object)unit));
        Pause.pause(unit.toMillis(timeout));
    }

    public static void pause(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void pause() {
        Pause.pause(10L);
    }

    private Pause() {
    }
}

