/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountCombobox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "accounts", "", "defaultAccount", "onChange", "Lkotlin/Function1;", "", "(Ljava/util/Set;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Lkotlin/jvm/functions/Function1;)V", "intellij.vcs.github"})
public final class GithubAccountCombobox
extends ComboBox<GithubAccount> {
    public GithubAccountCombobox(@NotNull Set<? extends GithubAccount> accounts, @Nullable GithubAccount defaultAccount, final @Nullable Function1<? super GithubAccount, Unit> onChange) {
        Intrinsics.checkParameterIsNotNull(accounts, (String)"accounts");
        List accountList = CollectionsKt.toList((Iterable)accounts);
        this.setModel((ComboBoxModel)new CollectionComboBoxModel(accountList));
        if (defaultAccount != null) {
            this.setSelectedItem(defaultAccount);
        } else {
            this.setSelectedIndex(0);
        }
        if (onChange != null) {
            this.addItemListener(new ItemListener(){

                @Override
                public final void itemStateChanged(ItemEvent it) {
                    ItemEvent itemEvent = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemEvent, (String)"it");
                    if (itemEvent.getStateChange() == 1) {
                        ComboBoxModel comboBoxModel = this.getModel();
                        Intrinsics.checkExpressionValueIsNotNull((Object)comboBoxModel, (String)"model");
                        Object object = comboBoxModel.getSelectedItem();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.github.authentication.accounts.GithubAccount");
                        }
                        onChange.invoke((Object)((GithubAccount)object));
                    }
                }
            });
        }
        this.setEnabled(accounts.size() > 1);
    }

    public /* synthetic */ GithubAccountCombobox(Set set, GithubAccount githubAccount, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        this(set, githubAccount, (Function1<? super GithubAccount, Unit>)function1);
    }
}

