/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\b2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\bJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\bJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001f\u001a\u00020 J\u001a\u0010!\u001a\u00020\u00102\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060#J\u0010\u0010$\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "", "()V", "generatedFileToSourceMap", "Lgnu/trove/THashMap;", "Ljava/nio/file/Path;", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "scriptUrlToRelativePath", "Lcom/intellij/util/Url;", "", "getScriptUrlToRelativePath", "()Lgnu/trove/THashMap;", "scriptUrlToSourceMap", "sourceMapUrlToSourceMap", "Lcom/intellij/util/containers/BidirectionalMap;", "add", "", "mapUrl", "map", "scriptUrl", "relativePath", "generatedFile", "containsMap", "", "containsScript", "get", "url", "getAllMaps", "", "getByScript", "getBySourceFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "process", "procedure", "Lgnu/trove/TObjectObjectProcedure;", "removeHash", "intellij.javascript.debugger"})
public final class PreloadedSourceMapList {
    private final THashMap<Url, SourceMap> scriptUrlToSourceMap = new THashMap();
    private final THashMap<Path, SourceMap> generatedFileToSourceMap = new THashMap();
    private final BidirectionalMap<Url, SourceMap> sourceMapUrlToSourceMap = new BidirectionalMap();
    @NotNull
    private final THashMap<Url, String> scriptUrlToRelativePath = new THashMap();

    @NotNull
    public final THashMap<Url, String> getScriptUrlToRelativePath() {
        return this.scriptUrlToRelativePath;
    }

    public final synchronized void add(@NotNull Url mapUrl, @NotNull SourceMap map, @NotNull Url scriptUrl, @Nullable String relativePath, @Nullable Path generatedFile) {
        Intrinsics.checkParameterIsNotNull((Object)mapUrl, (String)"mapUrl");
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        Url mapUrlWithoutHash = this.removeHash(mapUrl);
        Url scriptUrlWithoutHash = this.removeHash(scriptUrl);
        ((Map)this.sourceMapUrlToSourceMap).put(mapUrlWithoutHash, map);
        ((Map)this.scriptUrlToSourceMap).put(scriptUrlWithoutHash, map);
        if (relativePath != null) {
            ((Map)this.scriptUrlToRelativePath).put(scriptUrlWithoutHash, relativePath);
        }
        if (generatedFile != null) {
            ((Map)this.generatedFileToSourceMap).put(generatedFile, map);
        }
    }

    public static /* synthetic */ void add$default(PreloadedSourceMapList preloadedSourceMapList, Url url, SourceMap sourceMap, Url url2, String string, Path path, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            path = null;
        }
        preloadedSourceMapList.add(url, sourceMap, url2, string, path);
    }

    @Nullable
    public final synchronized SourceMap get(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return (SourceMap)this.sourceMapUrlToSourceMap.get((Object)this.removeHash(url));
    }

    @Nullable
    public final synchronized SourceMap getByScript(@NotNull Url scriptUrl) {
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        return (SourceMap)this.scriptUrlToSourceMap.get((Object)this.removeHash(scriptUrl));
    }

    @Nullable
    public final synchronized SourceMap getBySourceFile(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return (SourceMap)this.generatedFileToSourceMap.get((Object)VfsUtilCore.virtualToIoFile((VirtualFile)file2).toPath());
    }

    public final synchronized boolean containsMap(@NotNull SourceMap map) {
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        return this.sourceMapUrlToSourceMap.containsValue((Object)map);
    }

    public final synchronized boolean containsScript(@NotNull Url scriptUrl) {
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        return this.scriptUrlToSourceMap.containsKey((Object)this.removeHash(scriptUrl));
    }

    public final synchronized void process(@NotNull TObjectObjectProcedure<Url, SourceMap> procedure) {
        Intrinsics.checkParameterIsNotNull(procedure, (String)"procedure");
        this.scriptUrlToSourceMap.forEachEntry(procedure);
    }

    @NotNull
    public final synchronized Collection<SourceMap> getAllMaps() {
        Collection collection = this.scriptUrlToSourceMap.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"scriptUrlToSourceMap.values");
        return collection;
    }

    private final Url removeHash(Url url) {
        String parameters = url.getParameters();
        if (parameters != null && parameters.length() > 8 && parameters.charAt(0) == '?') {
            boolean bl;
            block3: {
                String string = parameters;
                int n = 1;
                boolean bl2 = false;
                String string2 = string.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                CharSequence $this$all$iv = string2;
                boolean $i$f$all = false;
                CharSequence charSequence = $this$all$iv;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char element$iv;
                    char p1 = element$iv = charSequence.charAt(i);
                    boolean bl3 = false;
                    if (StringUtil.isHexDigit((char)p1)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (bl) {
                Url url2 = url.trimParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"url.trimParameters()");
                return url2;
            }
        }
        return url;
    }
}

