/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.FileResolverByContentKt;
import com.intellij.javascript.debugger.JSCachingFileFinderKt;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.locationResolving.JSFileUrlMappings;
import com.intellij.javascript.debugger.locationResolving.SearchAccuracy;
import com.intellij.javascript.debugger.locationResolving.SearchResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.Url;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0019\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/debugger/JSCachingFileFinder;", "", "delegate", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "(Lcom/intellij/javascript/debugger/DebuggableFileFinder;)V", "getDelegate", "()Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "fileMappings", "Lcom/intellij/javascript/debugger/locationResolving/JSFileUrlMappings;", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "findByName", "", "sourceContent", "", "script", "Lorg/jetbrains/debugger/Script;", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "getRemoteUrls", "", "file", "setFileMappings", "", "map", "intellij.javascript.debugger"})
public final class JSCachingFileFinder {
    private volatile JSFileUrlMappings fileMappings;
    @NotNull
    private final DebuggableFileFinder delegate;

    @Nullable
    public final VirtualFile findFile(@NotNull Url url, @NotNull Project project, boolean findByName2, @Nullable String sourceContent, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.fileMappings.findFile(url, sourceContent, findByName2, script, (Function0<SearchResult>)((Function0)new Function0<SearchResult>(this, url, project, sourceContent, findByName2, script){
            final /* synthetic */ JSCachingFileFinder this$0;
            final /* synthetic */ Url $url;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $sourceContent;
            final /* synthetic */ boolean $findByName;
            final /* synthetic */ Script $script;

            @NotNull
            public final SearchResult invoke() {
                VirtualFile result2 = this.this$0.getDelegate().findFile(this.$url, this.$project);
                SearchAccuracy accuracy = SearchAccuracy.BY_CONTENT;
                if (result2 == null && this.$sourceContent != null) {
                    result2 = FileResolverByContentKt.resolveFileBySourceUrl(this.$project, this.$url, this.$sourceContent);
                }
                if (result2 == null) {
                    result2 = this.this$0.getDelegate().guessFile(this.$url, this.$project);
                    accuracy = SearchAccuracy.BY_URL;
                }
                if (result2 == null && this.$sourceContent == null) {
                    result2 = FileResolverByContentKt.resolveFileBySourceUrl(this.$project, this.$url, null);
                    accuracy = SearchAccuracy.BY_URL;
                }
                if (result2 == null && this.this$0.getDelegate().searchesByName() && this.$findByName) {
                    result2 = RemoteDebuggingFileFinderKt.findByName(this.$url, this.$project);
                    accuracy = SearchAccuracy.BY_NAME;
                }
                if (result2 != null && (this.$script != null && !JSCachingFileFinderKt.isFileMatchingScript(result2, this.$script) || this.$sourceContent != null && !JSCachingFileFinderKt.isFileMatchingContent(result2, this.$sourceContent, this.$project))) {
                    result2 = null;
                }
                return new SearchResult(result2, accuracy);
            }
            {
                this.this$0 = jSCachingFileFinder;
                this.$url = url;
                this.$project = project;
                this.$sourceContent = string;
                this.$findByName = bl;
                this.$script = script;
                super(0);
            }
        }));
    }

    public static /* synthetic */ VirtualFile findFile$default(JSCachingFileFinder jSCachingFileFinder, Url url, Project project, boolean bl, String string, Script script, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            script = null;
        }
        return jSCachingFileFinder.findFile(url, project, bl, string, script);
    }

    @NotNull
    public final List<Url> getRemoteUrls(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.fileMappings.findUrls(file2, (Function0<? extends List<? extends Url>>)((Function0)new Function0<List<? extends Url>>(this, file2){
            final /* synthetic */ JSCachingFileFinder this$0;
            final /* synthetic */ VirtualFile $file;

            @NotNull
            public final List<Url> invoke() {
                return this.this$0.getDelegate().getRemoteUrls(this.$file);
            }
            {
                this.this$0 = jSCachingFileFinder;
                this.$file = virtualFile;
                super(0);
            }
        }));
    }

    public final void setFileMappings(@NotNull JSFileUrlMappings map) {
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        this.fileMappings = map;
    }

    @Nullable
    public final Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Navigatable navigatable = this.delegate.findNavigatable(url, project);
        if (navigatable == null) {
            navigatable = (Navigatable)JsFileUtil.createNavigatable(project, JSCachingFileFinder.findFile$default(this, url, project, true, null, null, 24, null));
        }
        return navigatable;
    }

    @NotNull
    public final DebuggableFileFinder getDelegate() {
        return this.delegate;
    }

    public JSCachingFileFinder(@NotNull DebuggableFileFinder delegate) {
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.fileMappings = new JSFileUrlMappings();
    }
}

