/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelExternalData;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.sql.intentions.JoinUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0004H\u0016J#\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/intentions/SqlAddExternalRelationIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "getExternalDataPath", "", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "getFamilyName", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "startInWriteAction", "intellij.database.sql.impl"})
public final class SqlAddExternalRelationIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        return "Store table relation";
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        void t1;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Couple<Pair<DasTable, List<DasColumn>>> couple = JoinUtilsKt.getRelationInfo(element2);
        if (couple == null) {
            return false;
        }
        Couple<Pair<DasTable, List<DasColumn>>> couple2 = couple;
        Pair<DasTable, List<DasColumn>> pair = JoinUtilsKt.component1(couple2);
        Pair<DasTable, List<DasColumn>> t2 = JoinUtilsKt.component2(couple2);
        Object object = t1.getFirst();
        if (!(object instanceof DbTable)) {
            object = null;
        }
        DbTable dbTable = (DbTable)object;
        if (dbTable == null) {
            return false;
        }
        DbTable dbT1 = dbTable;
        Object object2 = t2.getFirst();
        if (!(object2 instanceof DbTable)) {
            object2 = null;
        }
        DbTable dbTable2 = (DbTable)object2;
        if (dbTable2 == null) {
            return false;
        }
        DbTable dbT2 = dbTable2;
        if (Intrinsics.areEqual((Object)dbT1.getDataSource(), (Object)dbT2.getDataSource()) ^ true || DbImplUtil.getMaybeLocalDataSource((DasDataSource)dbT1.getDataSource()) == null) {
            return false;
        }
        Set c1 = CollectionsKt.toSet((Iterable)((Iterable)t1.getSecond()));
        Set c2 = CollectionsKt.toSet((Iterable)((Iterable)t2.getSecond()));
        JBIterable jBIterable = ModelRelationManager.getForeignKeys(project, (DasTable)dbT1, (DasTable)t2.getFirst()).filter((Condition)new Condition<DasForeignKey>(c1, c2){
            final /* synthetic */ Set $c1;
            final /* synthetic */ Set $c2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean value(DasForeignKey fk) {
                DasForeignKey dasForeignKey = fk;
                Intrinsics.checkExpressionValueIsNotNull((Object)dasForeignKey, (String)"fk");
                Iterable iterable = dasForeignKey.getColumnsRef().resolveObjects();
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"fk.columnsRef.resolveObjects()");
                if (!Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)iterable), (Object)this.$c1)) return false;
                Iterable iterable2 = fk.getRefColumns().resolveObjects();
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"fk.refColumns.resolveObjects()");
                if (!Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)iterable2), (Object)this.$c2)) return false;
                return true;
            }
            {
                this.$c1 = set;
                this.$c2 = set2;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"ModelRelationManager.get\u2026s().toSet() == c2\n      }");
        return jBIterable.isEmpty();
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Couple<Pair<DasTable, List<DasColumn>>> couple = JoinUtilsKt.getRelationInfo(element2);
        if (couple == null) {
            return;
        }
        Couple<Pair<DasTable, List<DasColumn>>> info = couple;
        Object object = ((Pair)info.first).getFirst();
        if (!(object instanceof DbTable)) {
            object = null;
        }
        DbTable dbTable = (DbTable)object;
        LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)(dbTable != null ? dbTable.getDataSource() : null));
        if (localDataSource == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)localDataSource, (String)"DbImplUtil.getMaybeLocal\u2026e)?.dataSource) ?: return");
        LocalDataSource ds = localDataSource;
        String path = this.getExternalDataPath(project, ds);
        if (path == null) {
            return;
        }
        ModelExternalData.modify(path, (Consumer<? super ModelExternalData.Data>)((Consumer)new Consumer<ModelExternalData.Data>(info){
            final /* synthetic */ Couple $info;

            public final void consume(ModelExternalData.Data data) {
                Collection<String> collection;
                String string;
                DasColumn it2;
                Collection<String> collection2;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable = (Iterable)((Pair)this.$info.first).getSecond();
                ObjectPath objectPath = ObjectPaths.of((DasObject)((Pair)this.$info.first).getFirst());
                MultiMap<ObjectPath, ModelExternalData.FkDesc> multiMap = data.tableSet;
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    DasColumn dasColumn = (DasColumn)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    string = it2.getName();
                    collection2.add(string);
                }
                collection2 = (List)destination$iv$iv;
                $this$map$iv = (Iterable)((Pair)this.$info.second).getSecond();
                string = ObjectPaths.of((DasObject)((Pair)this.$info.second).getFirst());
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (DasColumn)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string2 = it2.getName();
                    collection.add(string2);
                }
                Collection<String> collection3 = collection = (List)destination$iv$iv;
                String string3 = string;
                Collection<String> collection4 = collection2;
                multiMap.putValue((Object)objectPath, (Object)new ModelExternalData.FkDesc((List<String>)collection4, (ObjectPath)string3, (List<String>)collection3));
            }
            {
                this.$info = couple;
            }
        }));
    }

    public boolean startInWriteAction() {
        return false;
    }

    private final String getExternalDataPath(Project project, LocalDataSource ds) {
        Object object = ds.getAdditionalJdbcProperties().get("EXTERNAL_DATA_PATH");
        if (object == null) {
            Object object2 = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save external data for " + ds.getName(), "", new String[]{"xml"}), project).save(ProjectUtil.guessProjectDir((Project)project), "external-data.xml");
            if (object2 != null && (object2 = object2.getFile()) != null && (object2 = ((File)object2).getCanonicalPath()) != null) {
                Object object3 = object2;
                boolean bl = false;
                boolean bl2 = false;
                Object it2 = object3;
                boolean bl3 = false;
                Map<String, String> map2 = ds.getAdditionalJdbcProperties();
                Intrinsics.checkExpressionValueIsNotNull(map2, (String)"ds.additionalJdbcProperties");
                map2.put("EXTERNAL_DATA_PATH", (String)it2);
                object = object3;
            } else {
                object = null;
            }
        }
        return object;
    }
}

