/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.inspections.SqlCaseVsCoalesceInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCaseExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElseClause;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlThenClause;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhenThenClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsCoalesceInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "preferCase", "", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "problems", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "createOptionsPanel", "Lcom/intellij/codeInspection/ui/SingleCheckboxOptionsPanel;", "Companion", "ConvertToCaseFix", "ConvertToCoalesceFix", "intellij.database.sql.impl"})
public final class SqlCaseVsCoalesceInspection
extends SqlInspectionBase {
    @JvmField
    public boolean preferCase;
    private static final List<SqlTokenType> IS_NOT_TOKENS;
    private static final List<SqlTokenType> IS_NOT_NULL_TOKENS;
    public static final Companion Companion;

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> problems, boolean onTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull(problems, (String)"problems");
        String string = Companion.getCoalesceName(dialect);
        if (string == null) {
            return null;
        }
        String coalesceName = string;
        return new SqlInspectionBase.SqlAnnotationVisitor(this, coalesceName, onTheFly, manager, dialect, problems, manager, dialect, problems){
            final /* synthetic */ SqlCaseVsCoalesceInspection this$0;
            final /* synthetic */ String $coalesceName;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $problems;

            public void visitSqlCaseExpression(@NotNull SqlCaseExpression o) {
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                if (com.intellij.sql.inspections.SqlCaseVsCoalesceInspection$Companion.access$getExpressions(SqlCaseVsCoalesceInspection.Companion, o) != null) {
                    PsiElement psiElement = PsiTreeUtil.findSiblingForward((PsiElement)o.getFirstChild(), (IElementType)((IElementType)SqlCommonKeywords.SQL_CASE), (boolean)false, null);
                    if (psiElement == null) {
                        psiElement = (PsiElement)o;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"PsiTreeUtil.findSiblingF\u2026L_CASE, false, null) ?: o");
                    PsiElement anchor = psiElement;
                    this.report(anchor, "CASE can be replaced with '" + this.$coalesceName + "' call", !this.this$0.preferCase, (LocalQuickFix)new ConvertToCoalesceFix(this.$coalesceName, o));
                }
                super.visitSqlCaseExpression(o);
            }

            public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o) {
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                if (com.intellij.sql.inspections.SqlCaseVsCoalesceInspection$Companion.access$getExpressions(SqlCaseVsCoalesceInspection.Companion, o, this.$coalesceName) != null) {
                    SqlReferenceExpression sqlReferenceExpression = o.getNameElement();
                    SqlExpression anchor = sqlReferenceExpression != null ? (SqlExpression)sqlReferenceExpression : (SqlExpression)o;
                    this.report((PsiElement)anchor, anchor.getName() + " call can be replaced with CASE expression", this.this$0.preferCase, (LocalQuickFix)new ConvertToCaseFix(this.$coalesceName, o));
                }
                super.visitSqlFunctionCallExpression(o);
            }

            private final void report(PsiElement elementToHighlight, String message2, boolean isWarning, LocalQuickFix fix) {
                if (!isWarning && !this.$onTheFly) {
                    return;
                }
                PsiElement psiElement = elementToHighlight;
                if (psiElement == null) {
                    return;
                }
                ProblemDescriptor problemDescriptor = this.myManager.createProblemDescriptor(psiElement, message2, true, isWarning ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION, false, new LocalQuickFix[]{fix});
                Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"myManager.createProblemD\u2026,\n          fix\n        )");
                ProblemDescriptor problem = problemDescriptor;
                this.addDescriptor(problem);
            }
            {
                this.this$0 = $outer;
                this.$coalesceName = $captured_local_variable$1;
                this.$onTheFly = $captured_local_variable$2;
                this.$manager = $captured_local_variable$3;
                this.$dialect = $captured_local_variable$4;
                this.$problems = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        };
    }

    @NotNull
    public SingleCheckboxOptionsPanel createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Prefer CASE expressions over COALESCE function", (InspectionProfileEntry)this, "preferCase");
    }

    static {
        Companion = new Companion(null);
        IS_NOT_TOKENS = CollectionsKt.listOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_IS, SqlCommonKeywords.SQL_NOT});
        IS_NOT_NULL_TOKENS = CollectionsKt.listOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_IS, SqlCommonKeywords.SQL_NOT, SqlCommonKeywords.SQL_NULL});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J)\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsCoalesceInspection$ConvertToCoalesceFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "coalesceName", "", "caseExpression", "Lcom/intellij/sql/psi/SqlCaseExpression;", "(Ljava/lang/String;Lcom/intellij/sql/psi/SqlCaseExpression;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.database.sql.impl"})
    private static final class ConvertToCoalesceFix
    extends LocalQuickFixOnPsiElement {
        private final String coalesceName;

        @NotNull
        public String getFamilyName() {
            return "Replace with '" + this.coalesceName + "' call";
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
            Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
            PsiElement psiElement = startElement;
            if (!(psiElement instanceof SqlCaseExpression)) {
                psiElement = null;
            }
            SqlCaseExpression sqlCaseExpression = (SqlCaseExpression)psiElement;
            if (sqlCaseExpression == null) {
                return;
            }
            SqlCaseExpression caseExpression = sqlCaseExpression;
            List list = Companion.getExpressions(caseExpression);
            if (list == null) {
                return;
            }
            List expressions2 = list;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(file)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            SqlFunctionDefinition sqlFunctionDefinition = dialect.getSupportedFunctions().get(this.coalesceName);
            if (sqlFunctionDefinition == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlFunctionDefinition), (String)"dialect.supportedFunctions[coalesceName] ?: return");
            SqlFunctionDefinition coalesceFunction = sqlFunctionDefinition;
            DdlBuilder ddlBuilder = new DdlBuilder();
            boolean bl = false;
            boolean bl2 = false;
            DdlBuilder $this$with = ddlBuilder;
            boolean bl3 = false;
            $this$with.applyCodeStyle(project, dialect);
            $this$with.withDialect(dialect.getDatabaseDialect());
            $this$with.quoteIdentifiers(false);
            $this$with.ref((DasObject)coalesceFunction, this.coalesceName);
            $this$with.plain(CollectionsKt.joinToString$default((Iterable)expressions2, null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)invoke.callText.1.1.INSTANCE, (int)25, null));
            String string = $this$with.getStatement();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"with(DdlBuilder()) {\n   \u2026        statement\n      }");
            String callText2 = string;
            SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(callText2, dialect, (PsiElement)caseExpression);
            if (!(sqlExpression instanceof SqlFunctionCallExpression)) {
                sqlExpression = null;
            }
            SqlFunctionCallExpression sqlFunctionCallExpression = (SqlFunctionCallExpression)sqlExpression;
            if (sqlFunctionCallExpression == null) {
                return;
            }
            SqlFunctionCallExpression callExpression = sqlFunctionCallExpression;
            PsiElement newElement = caseExpression.replace((PsiElement)callExpression);
            CodeStyleManager.getInstance((Project)project).reformat(newElement);
        }

        public ConvertToCoalesceFix(@NotNull String coalesceName, @NotNull SqlCaseExpression caseExpression) {
            Intrinsics.checkParameterIsNotNull((Object)coalesceName, (String)"coalesceName");
            Intrinsics.checkParameterIsNotNull((Object)caseExpression, (String)"caseExpression");
            super((PsiElement)caseExpression);
            this.coalesceName = coalesceName;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J)\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsCoalesceInspection$ConvertToCaseFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "coalesceName", "", "callExpression", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "(Ljava/lang/String;Lcom/intellij/sql/psi/SqlFunctionCallExpression;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.database.sql.impl"})
    private static final class ConvertToCaseFix
    extends LocalQuickFixOnPsiElement {
        private final String coalesceName;

        @NotNull
        public String getFamilyName() {
            return "Replace with CASE expression";
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
            Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
            PsiElement psiElement = startElement;
            if (!(psiElement instanceof SqlFunctionCallExpression)) {
                psiElement = null;
            }
            SqlFunctionCallExpression sqlFunctionCallExpression = (SqlFunctionCallExpression)psiElement;
            if (sqlFunctionCallExpression == null) {
                return;
            }
            SqlFunctionCallExpression callExpression = sqlFunctionCallExpression;
            List list = Companion.getExpressions(callExpression, this.coalesceName);
            if (list == null) {
                return;
            }
            List expressions2 = list;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(file)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            DdlBuilder ddlBuilder = new DdlBuilder();
            boolean bl = false;
            boolean bl2 = false;
            DdlBuilder $this$with = ddlBuilder;
            boolean bl3 = false;
            $this$with.applyCodeStyle(project, dialect);
            $this$with.withDialect(dialect.getDatabaseDialect());
            $this$with.keyword("CASE");
            $this$with.newLine();
            for (SqlExpression expression : expressions2.subList(0, CollectionsKt.getLastIndex((List)expressions2))) {
                String expressionText = expression.getText();
                $this$with.keyword("WHEN ").plain(expressionText).space().keyword("IS NOT NULL THEN ").plain(expressionText);
                $this$with.newLine();
            }
            $this$with.keyword("ELSE ").plain(((SqlExpression)CollectionsKt.last((List)expressions2)).getText());
            $this$with.newLine();
            $this$with.keyword("END");
            String string = $this$with.getStatement();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"with(DdlBuilder()) {\n   \u2026        statement\n      }");
            String caseText = string;
            SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(caseText, dialect, (PsiElement)callExpression);
            if (sqlExpression == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlExpression, (String)"SqlPsiElementFactory.cre\u2026callExpression) ?: return");
            SqlExpression caseExpression = sqlExpression;
            PsiElement newElement = callExpression.replace((PsiElement)caseExpression);
            CodeStyleManager.getInstance((Project)project).reformat(newElement);
        }

        public ConvertToCaseFix(@NotNull String coalesceName, @NotNull SqlFunctionCallExpression callExpression) {
            Intrinsics.checkParameterIsNotNull((Object)coalesceName, (String)"coalesceName");
            Intrinsics.checkParameterIsNotNull((Object)callExpression, (String)"callExpression");
            super((PsiElement)callExpression);
            this.coalesceName = coalesceName;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002J\u0014\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0004*\u00020\u0013H\u0002J\u001c\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0004*\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0010*\u00020\u0010H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsCoalesceInspection$Companion;", "", "()V", "IS_NOT_NULL_TOKENS", "", "Lcom/intellij/sql/psi/SqlTokenType;", "kotlin.jvm.PlatformType", "IS_NOT_TOKENS", "coalesceName", "", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "getCoalesceName", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;)Ljava/lang/String;", "areEquivalent", "", "left", "Lcom/intellij/sql/psi/SqlExpression;", "right", "getExpressions", "Lcom/intellij/sql/psi/SqlCaseExpression;", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "getIsNotNullTarget", "intellij.database.sql.impl"})
    public static final class Companion {
        @Nullable
        public final String getCoalesceName(@NotNull SqlLanguageDialectEx $this$coalesceName) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)$this$coalesceName), (String)"$this$coalesceName");
            Dbms dbms = $this$coalesceName.getDbms();
            Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"dbms");
            Dbms dbms2 = dbms;
            return dbms2.isCassandra() ? null : (dbms2.isHive() || dbms2.isSpark() || dbms2.isSqlite() || dbms2.isSybase() || dbms2.isPostgres() || dbms2.isClickHouse() ? "coalesce" : "COALESCE");
        }

        private final SqlExpression getIsNotNullTarget(@NotNull SqlExpression $this$getIsNotNullTarget) {
            if (!($this$getIsNotNullTarget instanceof SqlBinaryExpression)) {
                return null;
            }
            PsiElement psiElement = ((SqlBinaryExpression)$this$getIsNotNullTarget).getOpSignElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"opSignElement");
            Sequence opTokens2 = SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)psiElement.getFirstChild(), (Function1)getIsNotNullTarget.opTokens.1.INSTANCE), (Function1)getIsNotNullTarget.opTokens.2.INSTANCE);
            List list = SequencesKt.toList((Sequence)opTokens2);
            if (Intrinsics.areEqual((Object)list, (Object)IS_NOT_TOKENS)) {
                SqlExpression sqlExpression = ((SqlBinaryExpression)$this$getIsNotNullTarget).getROperand();
                if (!(sqlExpression instanceof SqlLiteralExpression)) {
                    sqlExpression = null;
                }
                SqlLiteralExpression sqlLiteralExpression = (SqlLiteralExpression)sqlExpression;
                if (sqlLiteralExpression == null) {
                    return null;
                }
                SqlLiteralExpression rOperand = sqlLiteralExpression;
                Object[] objectArray = rOperand.getChildren();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"rOperand.children");
                if (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)((PsiElement)ArraysKt.singleOrNull((Object[])objectArray))), (Object)SqlCommonKeywords.SQL_NULL) ^ true) {
                    return null;
                }
            } else if (Intrinsics.areEqual((Object)list, (Object)IS_NOT_NULL_TOKENS)) {
                if (((SqlBinaryExpression)$this$getIsNotNullTarget).getROperand() != null) {
                    return null;
                }
            } else {
                return null;
            }
            return ((SqlBinaryExpression)$this$getIsNotNullTarget).getLOperand();
        }

        private final boolean areEquivalent(SqlExpression left, SqlExpression right) {
            if (left instanceof SqlLiteralExpression && right instanceof SqlLiteralExpression) {
                return Intrinsics.areEqual((Object)((SqlLiteralExpression)left).getText(), (Object)((SqlLiteralExpression)right).getText());
            }
            if (!(left instanceof SqlReferenceExpression) || !(right instanceof SqlReferenceExpression)) {
                return false;
            }
            List<Pair<PsiElement, PsiElement>> list = SqlImplUtil.resolveQualified((SqlReferenceExpression)left);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"SqlImplUtil.resolveQualified(left)");
            List<Pair<PsiElement, PsiElement>> leftResolve = list;
            List<Pair<PsiElement, PsiElement>> list2 = SqlImplUtil.resolveQualified((SqlReferenceExpression)right);
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"SqlImplUtil.resolveQualified(right)");
            List<Pair<PsiElement, PsiElement>> rightResolve = list2;
            if (leftResolve.isEmpty() && rightResolve.isEmpty()) {
                return Intrinsics.areEqual((Object)((SqlReferenceExpression)left).getText(), (Object)((SqlReferenceExpression)right).getText());
            }
            Pair pair = (Pair)CollectionsKt.singleOrNull(leftResolve);
            if (pair == null) {
                return false;
            }
            Pair leftResult = pair;
            Pair pair2 = (Pair)CollectionsKt.singleOrNull(rightResolve);
            if (pair2 == null) {
                return false;
            }
            Pair rightResult = pair2;
            return Intrinsics.areEqual((Object)leftResult, (Object)rightResult);
        }

        private final List<SqlExpression> getExpressions(@NotNull SqlCaseExpression $this$getExpressions) {
            if ($this$getExpressions.getExpression() != null) {
                return null;
            }
            List list = $this$getExpressions.getBranches();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"branches");
            List branches = list;
            ArrayList result = new ArrayList(branches.size());
            SqlExpression elseExpression = null;
            for (SqlClause branch : branches) {
                SqlClause sqlClause = branch;
                if (sqlClause instanceof SqlWhenThenClause) {
                    SqlExpression resultExpression;
                    SqlExpression checkedExpression;
                    SqlElement sqlElement;
                    SqlWhenClause sqlWhenClause = ((SqlWhenThenClause)branch).getWhenClause();
                    if (sqlWhenClause == null || (sqlWhenClause = sqlWhenClause.getExpression()) == null) {
                        return null;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlWhenClause, (String)"branch.whenClause?.expression ?: return null");
                    SqlWhenClause condition = sqlWhenClause;
                    if (this.getIsNotNullTarget((SqlExpression)condition) == null) {
                        return null;
                    }
                    SqlThenClause sqlThenClause = ((SqlWhenThenClause)branch).getThenClause();
                    if (!((sqlThenClause != null && (sqlThenClause = sqlThenClause.getBody()) != null ? (SqlElement)CollectionsKt.singleOrNull((Iterable)((Iterable)sqlThenClause)) : (sqlElement = null)) instanceof SqlExpression)) {
                        sqlElement = null;
                    }
                    if ((SqlExpression)sqlElement == null) {
                        return null;
                    }
                    if (!this.areEquivalent(checkedExpression, resultExpression)) {
                        return null;
                    }
                    Collection collection = result;
                    boolean bl = false;
                    collection.add(resultExpression);
                    continue;
                }
                if (!(sqlClause instanceof SqlElseClause)) continue;
                if (elseExpression != null) {
                    return null;
                }
                JBIterable jBIterable = ((SqlElseClause)branch).getBody();
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"branch.body");
                Object object = CollectionsKt.singleOrNull((Iterable)((Iterable)jBIterable));
                if (!(object instanceof SqlExpression)) {
                    object = null;
                }
                if ((SqlExpression)object == null) {
                    return null;
                }
                Collection collection = result;
                boolean bl = false;
                collection.add(elseExpression);
            }
            return result;
        }

        private final List<SqlExpression> getExpressions(@NotNull SqlFunctionCallExpression $this$getExpressions, String coalesceName) {
            boolean bl;
            Object arguments;
            block8: {
                Object object = $this$getExpressions.getFunctionDefinition();
                if (object == null || (object = object.getName()) == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"functionDefinition?.name ?: return null");
                Object functionName = object;
                if (Intrinsics.areEqual((Object)functionName, (Object)coalesceName) ^ true) {
                    return null;
                }
                Object object2 = $this$getExpressions.getParameterList();
                if (object2 == null || (object2 = object2.getExpressionList()) == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameterList?.expressionList ?: return null");
                arguments = object2;
                if (arguments.size() < 2) {
                    return null;
                }
                Iterable $this$any$iv = CollectionsKt.slice((List)arguments, (IntRange)RangesKt.until((int)0, (int)CollectionsKt.getLastIndex((List)arguments)));
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SqlExpression it2 = (SqlExpression)element$iv;
                        boolean bl2 = false;
                        if (!(!(it2 instanceof SqlLiteralExpression) && !(it2 instanceof SqlReferenceExpression))) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
            return arguments;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

