/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlAggregatesInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAnalyticClause;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlPivotColumnsClause;
import com.intellij.sql.psi.SqlQualifyClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.slicer.SqlPsiUtilKt;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlAggregatesInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlAggregatesInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        return new SqlInspectionBase.SqlAnnotationVisitor(dbms2, onTheFly, manager, dialect, result, manager, dialect, result){
            private final Lazy clausesWithAggregates$delegate;
            private final Lazy groupByPrimaryKeys$delegate;
            final /* synthetic */ Dbms $dbms;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            private final HashSet<SqlClause> getClausesWithAggregates() {
                Lazy lazy = this.clausesWithAggregates$delegate;
                createAnnotationVisitor.1 var2_2 = this;
                Object var3_3 = null;
                boolean bl = false;
                return (HashSet)lazy.getValue();
            }

            private final HashSet<SqlGroupByClause> getGroupByPrimaryKeys() {
                Lazy lazy = this.groupByPrimaryKeys$delegate;
                createAnnotationVisitor.1 var2_2 = this;
                Object var3_3 = null;
                boolean bl = false;
                return (HashSet)lazy.getValue();
            }

            private final boolean getHasAnalyticClause(@NotNull SqlFunctionCallExpression $this$hasAnalyticClause) {
                return PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)$this$hasAnalyticClause), SqlAnalyticClause.class) != null;
            }

            private final boolean maybeSameRefs(SqlReferenceExpression ref1, SqlReferenceExpression ref2) {
                PsiElement result1 = ref1.resolve();
                PsiElement result2 = ref2.resolve();
                return result1 == null || result2 == null || Intrinsics.areEqual((Object)result1, (Object)result2);
            }

            private final ObjectKind getEffectiveKind(@NotNull SqlReferenceExpression $this$getEffectiveKind) {
                ObjectKind objectKind;
                block3: {
                    PsiElement target;
                    while ((target = $this$getEffectiveKind.resolve()) instanceof SqlAsExpression) {
                        SqlExpression sqlExpression = ((SqlAsExpression)target).getExpression();
                        if (!(sqlExpression instanceof SqlReferenceExpression)) {
                            sqlExpression = null;
                        }
                        if ((SqlReferenceExpression)sqlExpression != null) {
                            continue;
                        }
                        objectKind = null;
                        break block3;
                    }
                    objectKind = target instanceof PsiObject ? ((PsiObject)target).getKind() : null;
                }
                return objectKind;
            }

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression o) {
                block11: {
                    SqlExpression[] sqlExpressionArray;
                    block14: {
                        Object object;
                        block13: {
                            block12: {
                                PsiElement targetElement;
                                Object object2;
                                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                                PsiElement immediateTarget = o.getReference().resolveImmediate();
                                if (immediateTarget instanceof SqlAsExpression) {
                                    object2 = (PsiElement)((SqlAsExpression)immediateTarget).getExpression();
                                } else if (immediateTarget instanceof PomTargetPsiElement) {
                                    PomTarget pomTarget = ((PomTargetPsiElement)immediateTarget).getTarget();
                                    if (!(pomTarget instanceof SqlColumnSymbol)) {
                                        pomTarget = null;
                                    }
                                    SqlColumnSymbol sqlColumnSymbol = (SqlColumnSymbol)pomTarget;
                                    object2 = sqlColumnSymbol != null ? sqlColumnSymbol.getContext() : null;
                                } else {
                                    object2 = targetElement = null;
                                }
                                if (!(targetElement instanceof SqlFunctionCallExpression) || !SqlPsiUtilKt.isAggregateCall((SqlFunctionCallExpression)targetElement)) break block12;
                                SqlQueryExpression currentQuery = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o), SqlQueryExpression.class);
                                SqlQueryExpression targetQuery = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)targetElement, SqlQueryExpression.class);
                                if (!Intrinsics.areEqual((Object)targetQuery, (Object)currentQuery)) break block11;
                                this.processAggregate((SqlExpression)o, (SqlFunctionCallExpression)targetElement);
                                break block11;
                            }
                            if (!Intrinsics.areEqual((Object)this.getEffectiveKind(o), (Object)ObjectKind.COLUMN)) break block11;
                            PsiElement psiElement = (PsiElement)SqlImplUtil.sqlParents((PsiElement)o).takeWhile((Condition)createAnnotationVisitor.visitSqlReferenceExpression.1.INSTANCE).filter((Condition)createAnnotationVisitor.visitSqlReferenceExpression.2.INSTANCE).first();
                            if (psiElement == null) break block11;
                            PsiElement psiElement2 = psiElement;
                            boolean bl = false;
                            boolean bl2 = false;
                            PsiElement clause = psiElement2;
                            boolean bl3 = false;
                            PsiElement psiElement3 = clause;
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"clause");
                            PsiElement parent2 = psiElement3.getParent();
                            object = (SqlGroupByClause)PsiTreeUtil.getChildOfType((PsiElement)parent2, SqlGroupByClause.class);
                            if (object == null) {
                                SqlQueryExpression sqlQueryExpression;
                                PsiElement psiElement4 = parent2;
                                if (!(psiElement4 instanceof SqlQueryExpression)) {
                                    psiElement4 = null;
                                }
                                object = (sqlQueryExpression = (SqlQueryExpression)psiElement4) != null && (sqlQueryExpression = sqlQueryExpression.getTableExpression()) != null ? sqlQueryExpression.getGroupByClause() : null;
                            }
                            if (object != null) break block13;
                            break block11;
                        }
                        SqlGroupByClause groupByClause = object;
                        if (this.getGroupByPrimaryKeys().contains(groupByClause)) break block11;
                        sqlExpressionArray = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)groupByClause), SqlExpression.class);
                        if (sqlExpressionArray != null) break block14;
                        break block11;
                    }
                    SqlExpression[] expressions2 = sqlExpressionArray;
                    boolean hasRef = false;
                    for (SqlExpression expression : expressions2) {
                        if (expression instanceof SqlReferenceExpression) {
                            if (hasRef || !this.maybeSameRefs((SqlReferenceExpression)expression, o)) continue;
                            hasRef = true;
                            continue;
                        }
                        break block11;
                    }
                    if (hasRef) break block11;
                    if (this.$dbms.isSqlite() || this.$dbms.isH2()) {
                        this.reportWarning((PsiElement)o, "Nondeterministic value: column " + o.getName() + " is neither aggregated, nor mentioned in GROUP BY clause");
                    } else {
                        this.reportError((PsiElement)o, "Column " + o.getName() + " must be either aggregated, or mentioned in GROUP BY clause");
                    }
                }
            }

            public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o) {
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                if (SqlPsiUtilKt.isAggregateCall(o)) {
                    this.processAggregate((SqlExpression)o, o);
                }
                super.visitSqlElement((SqlElement)o);
            }

            public void visitSqlQueryExpression(@NotNull SqlQueryExpression o) {
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                this.checkIfGroupedByPrimaryKey(o);
                super.visitSqlQueryExpression(o);
            }

            public void elementFinished(@NotNull PsiElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                if (element2 instanceof SqlHavingClause && !this.getClausesWithAggregates().contains(element2)) {
                    SqlGroupByClause groupBy = (SqlGroupByClause)PsiTreeUtil.getChildOfType((PsiElement)((SqlHavingClause)element2).getParent(), SqlGroupByClause.class);
                    if (groupBy != null && this.hasMultipleGroupingSets(groupBy)) {
                        return;
                    }
                    this.reportWarning(PsiTreeUtil.findSiblingForward((PsiElement)((SqlHavingClause)element2).getFirstChild(), (IElementType)((IElementType)SqlCommonKeywords.SQL_HAVING), (boolean)false, null), "Using aggregate-free condition(s) in HAVING clause might be inefficient. Consider moving them to WHERE");
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean hasMultipleGroupingSets(@NotNull SqlGroupByClause $this$hasMultipleGroupingSets) {
                boolean bl;
                JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren((PsiElement)$this$hasMultipleGroupingSets);
                Intrinsics.checkExpressionValueIsNotNull(jBIterable, (String)"SqlImplUtil.sqlChildren(this)");
                Iterable $this$any$iv = (Iterable)jBIterable;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    T element$iv = iterator.next();
                    PsiElement it2 = (PsiElement)element$iv;
                    boolean bl2 = false;
                    IElementType type = PsiUtilCore.getElementType((PsiElement)it2);
                    if (Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_CUBE)) return true;
                    if (Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_ROLLUP)) return true;
                    if (Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_GROUPING)) {
                        PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)$this$hasMultipleGroupingSets), SqlExpression.class);
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (psiElementArray != null) {
                            PsiElement[] psiElementArray2 = psiElementArray;
                            boolean bl5 = false;
                            if (psiElementArray2.length != 0) return true;
                            boolean bl6 = true;
                            if (!bl6) return true;
                        }
                        boolean bl7 = true;
                        if (!bl7) {
                            return true;
                        }
                    }
                    bl = false;
                } while (!bl);
                return true;
            }

            /*
             * WARNING - void declaration
             */
            private final void checkIfGroupedByPrimaryKey(SqlQueryExpression query) {
                Collection destination$iv;
                Object object;
                SqlTableExpression sqlTableExpression = query.getTableExpression();
                if (sqlTableExpression == null || (sqlTableExpression = sqlTableExpression.getFromClause()) == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlTableExpression, (String)"query.tableExpression?.fromClause ?: return");
                SqlTableExpression fromClause = sqlTableExpression;
                SqlGroupByClause sqlGroupByClause = (SqlGroupByClause)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)query), SqlGroupByClause.class, (boolean)true, SqlQueryExpression.class);
                if (sqlGroupByClause == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlGroupByClause, (String)"PsiTreeUtil.findChildOfT\u2026                ?: return");
                SqlGroupByClause groupByClause = sqlGroupByClause;
                SqlExpression[] sqlExpressionArray = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)groupByClause), SqlExpression.class);
                if (sqlExpressionArray != null) {
                    void $this$mapNotNullTo$iv;
                    object = sqlExpressionArray;
                    destination$iv = new HashSet<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                    boolean $i$f$forEach = false;
                    void var10_12 = $this$forEach$iv$iv;
                    int n = ((void)var10_12).length;
                    for (int j = 0; j < n; ++j) {
                        DasTypedObject dasTypedObject;
                        void element$iv$iv;
                        void element$iv = element$iv$iv = var10_12[j];
                        boolean bl = false;
                        void it2 = element$iv;
                        boolean bl2 = false;
                        Object v3 = it2;
                        if (!(v3 instanceof SqlReferenceExpression)) {
                            v3 = null;
                        }
                        SqlReferenceExpression sqlReferenceExpression = v3;
                        Object object2 = sqlReferenceExpression != null ? sqlReferenceExpression.resolve() : null;
                        if (!(object2 instanceof DasTypedObject)) {
                            object2 = null;
                        }
                        if ((DasTypedObject)object2 == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        DasTypedObject it$iv = dasTypedObject;
                        boolean bl5 = false;
                        destination$iv.add(it$iv);
                    }
                } else {
                    return;
                }
                HashSet groupByColumns = (HashSet)destination$iv;
                if (groupByColumns.isEmpty()) {
                    return;
                }
                Iterator<E> iterator = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)fromClause), SqlReferenceExpression.class).iterator();
                while (iterator.hasNext()) {
                    boolean bl;
                    block15: {
                        Object primaryKeyColumns;
                        DasTable table;
                        SqlReferenceExpression ref;
                        SqlReferenceExpression sqlReferenceExpression = ref = (SqlReferenceExpression)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceExpression, (String)"ref");
                        SqlReferenceElementType sqlReferenceElementType = sqlReferenceExpression.getReferenceElementType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"ref.referenceElementType");
                        if (Intrinsics.areEqual((Object)sqlReferenceElementType.getTargetKind(), (Object)ObjectKind.TABLE) ^ true) continue;
                        PsiElement psiElement = ref.resolve();
                        if (!(psiElement instanceof DasTable)) {
                            psiElement = null;
                        }
                        if ((DasTable)psiElement == null) {
                            continue;
                        }
                        Object object3 = DasUtil.getPrimaryKey((DasTable)table);
                        if (object3 == null || (object3 = object3.getColumnsRef()) == null || (object3 = object3.resolveObjects()) == null) {
                            return;
                        }
                        Object $this$any$iv = primaryKeyColumns = object3;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            Iterator<T> iterator2 = $this$any$iv.iterator();
                            while (iterator2.hasNext()) {
                                T element$iv = iterator2.next();
                                DasTypedObject it3 = (DasTypedObject)element$iv;
                                boolean bl6 = false;
                                if (!(!groupByColumns.contains(it3))) continue;
                                bl = true;
                                break block15;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    return;
                }
                object = this.getGroupByPrimaryKeys();
                boolean bl = false;
                object.add(groupByClause);
            }

            private final void processAggregate(SqlExpression e, SqlFunctionCallExpression aggregateCall) {
                block9: {
                    Object v2;
                    PsiElement psiElement;
                    block8: {
                        PsiElement permittedClause2;
                        JBIterable jBIterable = SqlImplUtil.sqlParents(e.getParent()).takeWhile((Condition)createAnnotationVisitor.processAggregate.parents.1.INSTANCE);
                        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"SqlImplUtil.sqlParents(e\u2026 !is SqlQueryExpression }");
                        JBIterable parents2 = jBIterable;
                        psiElement = permittedClause2 = (PsiElement)parents2.filter((Condition)new Condition<PsiElement>(this){
                            final /* synthetic */ createAnnotationVisitor.1 this$0;

                            public final boolean value(PsiElement it2) {
                                return it2 instanceof SqlSelectClause || it2 instanceof SqlHavingClause || it2 instanceof SqlQualifyClause && this.this$0.$dbms.isSnowflake() || it2 instanceof SqlOrderByClause || it2 instanceof SqlPivotColumnsClause || it2 instanceof SqlStatement;
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }).first();
                        if (psiElement == null) {
                            this.reportError((PsiElement)e, "Aggregate calls are not allowed here");
                        } else if (psiElement instanceof SqlHavingClause || psiElement instanceof SqlSelectClause) {
                            PsiElement psiElement2 = permittedClause2;
                            if (psiElement2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.psi.SqlClause");
                            }
                            this.getClausesWithAggregates().add((SqlClause)psiElement2);
                        }
                        if (this.getHasAnalyticClause(aggregateCall) || this.$dbms.isOracle()) break block9;
                        Iterable $this$firstOrNull$iv = (Iterable)parents2;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            PsiElement it2 = (PsiElement)element$iv;
                            boolean bl = false;
                            if (!(it2 instanceof SqlFunctionCallExpression && SqlPsiUtilKt.isAggregateCall((SqlFunctionCallExpression)it2))) continue;
                            v2 = element$iv;
                            break block8;
                        }
                        v2 = null;
                    }
                    PsiElement psiElement3 = v2;
                    if (psiElement3 != null) {
                        psiElement = psiElement3;
                        boolean bl = false;
                        boolean bl2 = false;
                        PsiElement it3 = psiElement;
                        boolean bl3 = false;
                        PsiElement psiElement4 = it3;
                        if (psiElement4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.psi.SqlFunctionCallExpression");
                        }
                        if (!this.getHasAnalyticClause((SqlFunctionCallExpression)psiElement4)) {
                            this.reportError((PsiElement)e, "Nested aggregate calls are not allowed");
                        }
                    }
                }
            }

            private final void reportError(PsiElement element2, String message2) {
                this.reportProblem(element2, message2, ProblemHighlightType.GENERIC_ERROR);
            }

            private final void reportWarning(PsiElement element2, String message2) {
                this.reportProblem(element2, message2, ProblemHighlightType.WARNING);
            }

            private final void reportProblem(PsiElement element2, String message2, ProblemHighlightType highlightType) {
                PsiElement psiElement = element2 instanceof SqlFunctionCallExpression ? (PsiElement)((SqlFunctionCallExpression)element2).getNameElement() : element2;
                if (psiElement == null) {
                    return;
                }
                PsiElement anchor = psiElement;
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor, anchor, message2, highlightType, this.$onTheFly, new LocalQuickFix[0]));
            }
            {
                this.$dbms = $captured_local_variable$0;
                this.$onTheFly = $captured_local_variable$1;
                this.$manager = $captured_local_variable$2;
                this.$dialect = $captured_local_variable$3;
                this.$result = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
                this.clausesWithAggregates$delegate = LazyKt.lazy((Function0)createAnnotationVisitor.clausesWithAggregates.2.INSTANCE);
                this.groupByPrimaryKeys$delegate = LazyKt.lazy((Function0)createAnnotationVisitor.groupByPrimaryKeys.2.INSTANCE);
            }
        };
    }
}

