/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtil;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.Change;
import com.intellij.sql.formatter.SqlPreFormatHelper;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTokenElement;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SqlPreFormatter {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiDocumentManager myDocumentManager;
    @NotNull
    private final Document myDocument;
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final DatabaseDialectEx myDatabaseDialect;
    @NotNull
    private final NamingService myNamingService;
    @NotNull
    private final SqlCodeStyleSettings mySettings;
    @Nullable
    private final List<TextRange> myReadOnlyFragments;
    private final List<TextRange> myKeywords;
    private final List<TextRange> myTypes;
    private final List<SqlIdentifier> myIdentifiers;
    private final List<PsiElement> mySelects;
    private final List<Change> myChanges;

    SqlPreFormatter(@NotNull Project project, @NotNull Document document, @NotNull PsiElement element2, @NotNull Dbms dbms, @NotNull SqlCodeStyleSettings settings) {
        if (project == null) {
            SqlPreFormatter.$$$reportNull$$$0(0);
        }
        if (document == null) {
            SqlPreFormatter.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            SqlPreFormatter.$$$reportNull$$$0(2);
        }
        if (dbms == null) {
            SqlPreFormatter.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            SqlPreFormatter.$$$reportNull$$$0(4);
        }
        this.myKeywords = new ArrayList<TextRange>();
        this.myTypes = new ArrayList<TextRange>();
        this.myIdentifiers = new ArrayList<SqlIdentifier>();
        this.mySelects = new ArrayList<PsiElement>();
        this.myChanges = new ArrayList<Change>();
        this.myProject = project;
        this.myDocumentManager = PsiDocumentManager.getInstance((Project)project);
        this.myDocument = document;
        this.myElement = element2;
        this.myDatabaseDialect = DbImplUtil.getDatabaseDialect(dbms);
        this.myNamingService = NamingServices.getNamingService(SqlImplUtil.getDbms(element2));
        this.mySettings = settings;
        this.myReadOnlyFragments = this.myDocument instanceof DocumentWindow ? InjectedLanguageManager.getInstance((Project)this.myProject).getNonEditableFragments((DocumentWindow)this.myDocument) : null;
    }

    @NotNull
    TextRange process(final @NotNull TextRange range) {
        if (range == null) {
            SqlPreFormatter.$$$reportNull$$$0(5);
        }
        if (PostprocessReformattingAspect.getInstance((Project)this.myProject).isDisabled()) {
            TextRange textRange = range;
            if (textRange == null) {
                SqlPreFormatter.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        this.myElement.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                SqlPreFormatter.this.gatherFragmentsToHandle(element2, range);
                if (element2 instanceof IsExternal) {
                    PsiElement child = element2.getFirstChild();
                    if (child != null) {
                        SqlPreFormatter.this.gatherFragmentsToHandle(child, range);
                    }
                    return;
                }
                super.visitElement(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/formatter/SqlPreFormatter$1", "visitElement"));
            }
        });
        TextRange fixedRange = this.fixRange(range);
        CharSequence text2 = this.myDocument.getCharsSequence();
        this.processSelects(this.mySelects, this.myChanges);
        this.processIdentifiers(this.myIdentifiers, this.myChanges);
        this.processKeywords(this.myKeywords, text2, this.myChanges);
        this.processTypes(this.myTypes, text2, this.myChanges);
        SqlPreFormatHelper.performModificationInBulk(this.myDocumentManager, this.myDocument, this.myChanges);
        int delta = this.calculateDelta();
        TextRange textRange = fixedRange.grown(delta);
        if (textRange == null) {
            SqlPreFormatter.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    private void gatherFragmentsToHandle(@NotNull PsiElement element2, @NotNull TextRange range) {
        ASTNode node;
        TextRange nodeRange;
        IElementType elementType;
        if (element2 == null) {
            SqlPreFormatter.$$$reportNull$$$0(8);
        }
        if (range == null) {
            SqlPreFormatter.$$$reportNull$$$0(9);
        }
        if ((elementType = PsiUtilCore.getElementType((PsiElement)element2)) == SqlCompositeElementTypes.SQL_SELECT_CLAUSE) {
            this.mySelects.add(element2);
        }
        if (range.intersects(nodeRange = (node = element2.getNode()).getTextRange()) && !SqlPreFormatHelper.intersects(nodeRange, this.myReadOnlyFragments)) {
            boolean parameter;
            boolean isKeyword = node.getElementType() instanceof SqlKeywordTokenType;
            PsiElement parent2 = element2.getParent();
            boolean isRemapped = parent2 instanceof SqlIdentifier;
            ASTNode parentNode = parent2 != null ? parent2.getNode() : null;
            IElementType parentType = parentNode != null ? parentNode.getElementType() : null;
            boolean referencePart = parent2 instanceof SqlReferenceExpression;
            PsiElement grandpa = referencePart ? parent2.getParent() : null;
            ASTNode grandpaNode = grandpa == null ? null : grandpa.getNode();
            IElementType grandpaType = grandpaNode != null ? grandpaNode.getElementType() : null;
            boolean insideSpecialLiteral = parentType == SqlCompositeElementTypes.SQL_SPECIAL_LITERAL && !"null".equalsIgnoreCase(element2.getText());
            boolean functionName = parentType == SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE || parentType == SqlCompositeElementTypes.SQL_FUNCTION_REFERENCE || grandpaType == SqlCompositeElementTypes.SQL_FUNCTION_CALL;
            boolean bl = parameter = parentType == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
            if (isKeyword && !isRemapped && !insideSpecialLiteral) {
                if (element2.getParent() instanceof SqlTypeElement) {
                    if (!SqlPreFormatHelper.isQuoted(node, this.myNamingService)) {
                        this.myTypes.add(node.getTextRange());
                    }
                } else {
                    this.myKeywords.add(nodeRange);
                }
            } else {
                boolean identifier = element2 instanceof SqlIdentifier;
                boolean asterisk = "*".equals(element2.getText());
                boolean isSecond = false;
                if (identifier && referencePart) {
                    Object left = SqlImplUtil.getSiblingToTheLeftOfType(element2, false, SqlTokenElement.class);
                    boolean bl2 = isSecond = left != null && left.getNode().getElementType() == SqlCommonTokens.SQL_PERIOD;
                }
                if (!(!identifier || !isSecond && (functionName || parameter) || range.getLength() <= 1 && asterisk)) {
                    if (SqlPreFormatter.isTypeRef(parentType)) {
                        if (!SqlPreFormatHelper.isQuoted(node, this.myNamingService)) {
                            this.myTypes.add(node.getTextRange());
                        }
                    } else {
                        this.myIdentifiers.add((SqlIdentifier)element2);
                    }
                }
            }
        }
    }

    private static boolean isTypeRef(IElementType parentType) {
        SqlReferenceElementType refType = (SqlReferenceElementType)ObjectUtils.tryCast((Object)parentType, SqlReferenceElementType.class);
        return refType != null && refType != SqlCompositeElementTypes.SQL_DOMAIN_REFERENCE && DbImplUtil.isTypeKind(refType.getTargetKind());
    }

    private void processSelects(@NotNull List<PsiElement> selects, @NotNull Collection<Change> changes) {
        String AS;
        int commaPosition;
        if (selects == null) {
            SqlPreFormatter.$$$reportNull$$$0(10);
        }
        if (changes == null) {
            SqlPreFormatter.$$$reportNull$$$0(11);
        }
        boolean comma1st = (commaPosition = SqlUtilFun.change(this.mySettings.SELECT_EL_COMMA, -1, this.mySettings.QUERY_EL_COMMA)) == 1;
        boolean commaLast = commaPosition == 2;
        boolean processCommas = comma1st || commaLast;
        int useAsWord = this.mySettings.SELECT_USE_AS_WORD;
        switch (this.mySettings.KEYWORD_CASE) {
            case 0: {
                AS = "AS";
                break;
            }
            case 1: {
                AS = "as";
                break;
            }
            case 5: {
                AS = "As";
                break;
            }
            default: {
                AS = null;
            }
        }
        for (PsiElement select : selects) {
            PsiElement[] s;
            if (useAsWord > 0) {
                for (PsiElement e = select.getFirstChild(); e != null; e = e.getNextSibling()) {
                    if (PsiUtilCore.getElementType((PsiElement)e) != SqlCompositeElementTypes.SQL_AS_EXPRESSION) continue;
                    if (useAsWord == 1) {
                        String word;
                        s = SqlPreFormatHelper.findSubSequence(e.getFirstChild(), x -> x instanceof SqlExpression, y -> PsiUtilCore.getElementType((PsiElement)y) == SqlCompositeElementTypes.SQL_IDENTIFIER);
                        if (s == null) continue;
                        String string = AS != null ? AS : (word = SqlPreFormatHelper.whetherKeywordsUpper(select) ? "AS" : "as");
                        assert (s.length == 2);
                        changes.add(Change.insert(s[1].getTextRange().getStartOffset(), word + ' '));
                        continue;
                    }
                    if (useAsWord != 2 || (s = SqlPreFormatHelper.findSubSequence(e.getFirstChild(), x -> x instanceof SqlExpression, z -> PsiUtilCore.getElementType((PsiElement)z) == SqlCommonKeywords.SQL_AS, y -> PsiUtilCore.getElementType((PsiElement)y) == SqlCompositeElementTypes.SQL_IDENTIFIER)) == null) continue;
                    assert (s.length == 3);
                    TextRange r = s[1].getTextRange();
                    changes.add(Change.delete(r.getStartOffset(), r.getEndOffset()));
                }
            }
            if (!processCommas) continue;
            PsiElement begin = select.getFirstChild();
            if (comma1st) {
                while (begin != null && (s = SqlPreFormatHelper.findSubSequence(begin, element2 -> element2 instanceof SqlExpression, element2 -> PsiUtilCore.getElementType((PsiElement)element2) == SqlCommonTokens.SQL_COMMA, element2 -> PsiUtilCore.getElementType((PsiElement)element2) == SqlTokens.SQL_LINE_COMMENT, element2 -> element2 instanceof SqlExpression)) != null) {
                    assert (s.length == 4);
                    changes.add(Change.delete(s[1].getTextRange()));
                    changes.add(Change.insertAfter(s[2].getTextRange(), "\n,"));
                    begin = s[3];
                }
            }
            if (!commaLast) continue;
            while (begin != null && (s = SqlPreFormatHelper.findSubSequence(begin, element2 -> element2 instanceof SqlExpression, element2 -> PsiUtilCore.getElementType((PsiElement)element2) == SqlTokens.SQL_LINE_COMMENT, element2 -> PsiUtilCore.getElementType((PsiElement)element2) == SqlCommonTokens.SQL_COMMA, element2 -> element2 instanceof SqlExpression)) != null) {
                assert (s.length == 4);
                changes.add(Change.insertBefore(s[1].getTextRange(), ", "));
                changes.add(Change.delete(s[2].getTextRange()));
                begin = s[3];
            }
        }
    }

    private void processKeywords(@NotNull List<TextRange> keywords, @NotNull CharSequence text2, @NotNull Collection<Change> changes) {
        if (keywords == null) {
            SqlPreFormatter.$$$reportNull$$$0(12);
        }
        if (text2 == null) {
            SqlPreFormatter.$$$reportNull$$$0(13);
        }
        if (changes == null) {
            SqlPreFormatter.$$$reportNull$$$0(14);
        }
        SqlPreFormatter.processRanges(keywords, text2, changes, SqlCodeStyleSettings.getCaseMode((int)this.mySettings.KEYWORD_CASE));
    }

    private void processTypes(@NotNull List<TextRange> types, @NotNull CharSequence text2, @NotNull Collection<Change> changes) {
        if (types == null) {
            SqlPreFormatter.$$$reportNull$$$0(15);
        }
        if (text2 == null) {
            SqlPreFormatter.$$$reportNull$$$0(16);
        }
        if (changes == null) {
            SqlPreFormatter.$$$reportNull$$$0(17);
        }
        Case casing = this.isExactCasedDialect() ? Case.EXACT : this.mySettings.getCaseModeExt(this.mySettings.TYPE_CASE);
        SqlPreFormatter.processRanges(types, text2, changes, casing);
    }

    private static void processRanges(@NotNull List<TextRange> ranges, @NotNull CharSequence text2, @NotNull Collection<Change> changes, @NotNull Case mode) {
        if (ranges == null) {
            SqlPreFormatter.$$$reportNull$$$0(18);
        }
        if (text2 == null) {
            SqlPreFormatter.$$$reportNull$$$0(19);
        }
        if (changes == null) {
            SqlPreFormatter.$$$reportNull$$$0(20);
        }
        if (mode == null) {
            SqlPreFormatter.$$$reportNull$$$0(21);
        }
        if (mode == Case.MIXED) {
            return;
        }
        for (TextRange range : ranges) {
            String oldName = text2.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
            String newName = mode.apply(oldName);
            changes.add(Change.replace(range, newName));
        }
    }

    private void processIdentifiers(@NotNull List<SqlIdentifier> identifiers, @NotNull Collection<Change> changes) {
        if (identifiers == null) {
            SqlPreFormatter.$$$reportNull$$$0(22);
        }
        if (changes == null) {
            SqlPreFormatter.$$$reportNull$$$0(23);
        }
        Case quotedMode = SqlCodeStyleSettings.getCaseMode((int)this.mySettings.QUOTED_IDENTIFIER_CASE);
        Case plainMode = SqlCodeStyleSettings.getCaseMode((int)this.mySettings.IDENTIFIER_CASE);
        if (this.isExactCasedDialect()) {
            plainMode = Case.EXACT;
        }
        if (quotedMode == Case.MIXED && plainMode == Case.MIXED && this.mySettings.QUOTE_IDENTIFIER == 2) {
            return;
        }
        for (SqlIdentifier identifier : identifiers) {
            String newText;
            boolean isQuoted = !identifier.isPlainIdentifier();
            String identifierName = identifier.getName();
            String prefix = identifier.getNamePrefix();
            String text2 = identifier.getText();
            if (this.mySettings.QUOTE_IDENTIFIER == 0 && !isQuoted) {
                newText = this.myNamingService.enquoteName(identifierName, this.mySettings.getQuotesPriority());
                newText = quotedMode.apply(newText);
            } else if (this.mySettings.QUOTE_IDENTIFIER == 1 && isQuoted) {
                boolean canUnquote;
                if (SqlImplUtil.getElementType(identifier.getParent()) == SqlCompositeElementTypes.SQL_AS_EXPRESSION) {
                    boolean afterAS;
                    LeafPsiElement followedToken = (LeafPsiElement)SqlImplUtil.getSiblingToTheLeftOfType((PsiElement)identifier, true, LeafPsiElement.class);
                    switch (this.mySettings.SELECT_USE_AS_WORD) {
                        case 1: {
                            afterAS = true;
                            break;
                        }
                        case 2: {
                            afterAS = false;
                            break;
                        }
                        default: {
                            afterAS = followedToken != null && SqlImplUtil.getElementType((PsiElement)followedToken) == SqlCommonKeywords.SQL_AS;
                        }
                    }
                    canUnquote = this.myDatabaseDialect.canUnquoteAlias(identifierName, afterAS);
                } else {
                    canUnquote = SqlImplUtil.canUnquote(identifierName, this.myNamingService);
                }
                newText = canUnquote ? plainMode.apply(identifierName) : quotedMode.apply(text2);
            } else {
                Case desiredMode = isQuoted ? quotedMode : plainMode;
                newText = desiredMode.apply(prefix == null ? text2 : text2.replaceFirst(prefix, ""));
            }
            if (newText == null) continue;
            if (prefix != null) {
                newText = prefix + newText;
            }
            TextRange range = identifier.getTextRange();
            Change change = Change.replace(range.getStartOffset(), range.getEndOffset(), newText);
            changes.add(change);
        }
    }

    private boolean isExactCasedDialect() {
        Casing casing = this.myDatabaseDialect.getCasing(ObjectKind.NONE, null);
        return casing.plain == Case.EXACT;
    }

    @NotNull
    private TextRange fixRange(@NotNull TextRange range) {
        if (range == null) {
            SqlPreFormatter.$$$reportNull$$$0(24);
        }
        int start2 = range.getStartOffset();
        int end2 = range.getEndOffset();
        if (!this.myKeywords.isEmpty()) {
            start2 = Math.min(start2, this.myKeywords.get(0).getStartOffset());
            end2 = Math.max(end2, this.myKeywords.get(this.myKeywords.size() - 1).getEndOffset());
        }
        if (!this.myIdentifiers.isEmpty()) {
            start2 = Math.min(start2, this.myIdentifiers.get(0).getTextRange().getStartOffset());
            end2 = Math.max(end2, this.myIdentifiers.get(this.myIdentifiers.size() - 1).getTextRange().getEndOffset());
        }
        return new TextRange(start2, end2);
    }

    private int calculateDelta() {
        int delta = 0;
        for (Change change : this.myChanges) {
            delta += change.delta();
        }
        return delta;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 9: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/SqlPreFormatter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selects";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywords";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/SqlPreFormatter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "gatherFragmentsToHandle";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processSelects";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processKeywords";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processTypes";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processRanges";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processIdentifiers";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fixRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

