/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.completion.SqlCompletionContributor;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.options.SqlCodeCompletionSettings;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.MultiMap;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlJoinSmartCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static final String ID_POSTFIX = "_id";

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(2);
        }
        SqlJoinSmartCompletionProvider.suggestJoinStuff(parameters, result);
    }

    public static boolean suggestJoinStuff(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PsiFile file;
        if (parameters == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(4);
        }
        if (!((file = parameters.getOriginalFile()) instanceof SqlFile)) {
            return true;
        }
        PsiElement position = parameters.getPosition();
        PsiElement parent2 = position.getParent();
        if (parent2.getNextSibling() != null) {
            return true;
        }
        PsiElement grandPa = parent2.getParent();
        if (grandPa instanceof SqlReferenceExpression && ((SqlReferenceExpression)grandPa).getQualifierExpression() != null) {
            return true;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        LinkedHashSet<TableInfo> tables = new LinkedHashSet<TableInfo>(SqlJoinSmartCompletionProvider.collectTablesForJoin(parent2, dialect));
        for (TableInfo table : tables) {
            SqlCompletionUtil.addLookupElement(dialect, table.table, (Consumer<? super LookupElement>)result, false, table.getPriority(), SqlImplUtil.getDbms((PsiElement)file));
        }
        SqlJoinSmartCompletionProvider.suggestJoinConditions(parent2, dialect, tables, (statement, priority) -> SqlJoinSmartCompletionProvider.addFkItem(result, statement, priority), null);
        SqlJoinSmartCompletionProvider.suggestJoinUsing(parent2, dialect, result);
        return false;
    }

    @NotNull
    private static Collection<TableInfo> collectTablesForJoin(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx dialect) {
        SqlJoinExpression join2;
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(5);
        }
        if (dialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(6);
        }
        if ((join2 = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlJoinExpression.class)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        PsiElement parent2 = position.getParent();
        if (parent2 == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        ASTNode joinNode = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)parent2.getNode());
        if (joinNode == null || joinNode.getElementType() != SqlCommonKeywords.SQL_JOIN && joinNode.getElementType() != SqlCommonTokens.SQL_COMMA) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (!(parent2 instanceof SqlReferenceExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        PsiReference reference = parent2.getReference();
        if (!(reference instanceof SqlReferenceImpl)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlJoinSmartCompletionProvider.$$$reportNull$$$0(11);
            }
            return list;
        }
        HashSet<DasTable> fromLeft = new HashSet<DasTable>();
        SqlJoinExpression topmost = (SqlJoinExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)join2, SqlJoinExpression.class);
        SqlJoinExpression mainJoin = topmost == null ? join2 : topmost;
        return SqlJoinSmartCompletionProvider.collectTablesForJoin(dialect, parent2, (SqlReferenceImpl)reference, fromLeft, (PsiElement)mainJoin);
    }

    @NotNull
    public static Collection<TableInfo> collectTablesForJoin(@NotNull SqlLanguageDialectEx dialect, final @NotNull PsiElement parent2, SqlReferenceImpl reference, final Collection<DasTable> fromLeft, final PsiElement mainJoin) {
        if (dialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(12);
        }
        if (parent2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(13);
        }
        mainJoin.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ContainerUtil.addAllNotNull((Collection)fromLeft, (Object[])new DasTable[]{SqlCompletionContributor.retrieveTable(element2)});
                super.visitElement(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$1", "visitElement"));
            }
        });
        final boolean findFuzzyKeys = SqlCodeCompletionSettings.getInstance().isSupportNonStrictForeignKeys();
        final HashSet fks = new HashSet();
        final MultiMap leftColumnsByName = new MultiMap();
        final ArrayList<DasColumn> leftIdColumns = new ArrayList<DasColumn>();
        for (DasTable table : fromLeft) {
            Iterables.addAll(fks, ModelRelationManager.getForeignKeys(parent2.getProject(), table));
            if (!findFuzzyKeys) continue;
            for (DasColumn column : DasUtil.getColumns((DasObject)table)) {
                String name = StringUtil.toLowerCase((String)column.getName());
                leftColumnsByName.putValue((Object)name, (Object)column);
                if (!name.endsWith(ID_POSTFIX)) continue;
                leftIdColumns.add(column);
            }
        }
        final ArrayList<TableInfo> result = new ArrayList<TableInfo>();
        reference.processResolveVariants(new SqlScopeProcessor(null, dialect, SqlImplUtil.getDataSources(parent2), parent2){

            @Override
            public boolean isResultEmpty() {
                return false;
            }

            @Override
            public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement element2, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element2 instanceof DasTable) {
                    this.addLookupElement((DasTable)element2);
                }
                return true;
            }

            private void addLookupElement(@NotNull DasTable table) {
                if (table == null) {
                    2.$$$reportNull$$$0(2);
                }
                for (DasForeignKey fk : fks) {
                    if (!SqlJoinSmartCompletionProvider.cheapEquals(table, fk) || !table.equals(fk.getRefTable())) continue;
                    result.add(new TableInfo(table, ObjectName.plain((String)this.suggestAlias(table, mainJoin)), null));
                    return;
                }
                for (DasTable info : fromLeft) {
                    if (!ModelRelationManager.getForeignKeys(parent2.getProject(), table, info).isNotEmpty()) continue;
                    result.add(new TableInfo(table, ObjectName.plain((String)this.suggestAlias(table, mainJoin)), null));
                    return;
                }
                if (fromLeft.contains(table)) {
                    return;
                }
                List<FuzzyKey> fuzzyKeys = this.addFuzzyKeys(table);
                if (!fuzzyKeys.isEmpty()) {
                    result.add(new TableInfo(table, ObjectName.plain((String)this.suggestAlias(table, mainJoin)), null, fuzzyKeys));
                }
            }

            @NotNull
            private List<FuzzyKey> addFuzzyKeys(@NotNull DasTable table) {
                if (table == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (!findFuzzyKeys) {
                    List<FuzzyKey> list = Collections.emptyList();
                    if (list == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    return list;
                }
                String tableNameKey = this.getNormalizedName(table);
                ArrayList<FuzzyKey> fuzzyKeys = new ArrayList<FuzzyKey>();
                for (DasColumn column : DasUtil.getColumns((DasObject)table)) {
                    String name = StringUtil.toLowerCase((String)column.getName());
                    if (name.equals("id")) {
                        for (DasColumn refColumn : leftIdColumns) {
                            String prefix = StringUtil.trimEnd((String)refColumn.getName(), (String)SqlJoinSmartCompletionProvider.ID_POSTFIX);
                            if (!tableNameKey.endsWith(prefix)) continue;
                            fuzzyKeys.add(new FuzzyKey(column, refColumn, 98));
                        }
                        continue;
                    }
                    for (DasColumn refColumn : leftColumnsByName.get((Object)name)) {
                        fuzzyKeys.add(new FuzzyKey(column, refColumn, 99));
                    }
                    if (!name.endsWith(SqlJoinSmartCompletionProvider.ID_POSTFIX)) continue;
                    String prefix = StringUtil.trimEnd((String)name, (String)SqlJoinSmartCompletionProvider.ID_POSTFIX);
                    for (DasColumn refColumn : leftColumnsByName.get((Object)"id")) {
                        DasTable refTable = refColumn.getTable();
                        String refTableName = refTable != null ? this.getNormalizedName(refTable) : null;
                        if (refTableName == null || !StringUtil.endsWith((CharSequence)refTableName, (CharSequence)prefix)) continue;
                        fuzzyKeys.add(new FuzzyKey(column, refColumn, 98));
                    }
                }
                ArrayList<FuzzyKey> arrayList = fuzzyKeys;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(5);
                }
                return arrayList;
            }

            @NotNull
            private String getNormalizedName(@NotNull DasTable table) {
                if (table == null) {
                    2.$$$reportNull$$$0(6);
                }
                String lowerCased = StringUtil.toLowerCase((String)table.getName());
                String string = (String)ObjectUtils.notNull((Object)StringUtil.unpluralize((String)lowerCased), (Object)lowerCased);
                if (string == null) {
                    2.$$$reportNull$$$0(7);
                }
                return string;
            }

            @Nullable
            private String suggestAlias(@NotNull DasTable table, @NotNull PsiElement element2) {
                if (table == null) {
                    2.$$$reportNull$$$0(8);
                }
                if (element2 == null) {
                    2.$$$reportNull$$$0(9);
                }
                if (!SqlCodeCompletionSettings.getInstance().isUseAliasInJoinCompletion()) {
                    return null;
                }
                String tableName = table.getName();
                Collection<String> existingNames = SqlNamesGenerator.collectExistingNamesForContainingStatement(element2);
                existingNames.add(tableName);
                return SqlNamesGenerator.suggestAliasName(element2, existingNames, tableName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$2";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "addFuzzyKeys";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNormalizedName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "executeTarget";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "addLookupElement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "addFuzzyKeys";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getNormalizedName";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "suggestAlias";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        ArrayList<TableInfo> arrayList = result;
        if (arrayList == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static boolean cheapEquals(@NotNull DasTable table, @NotNull DasForeignKey fk) {
        if (table == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(15);
        }
        if (fk == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(16);
        }
        return !(!Comparing.strEqual((String)table.getName(), (String)fk.getRefTableName(), (boolean)false) || !StringUtil.isEmpty((String)DasUtil.getSchema((DasObject)table)) && !StringUtil.isEmpty((String)fk.getRefTableSchema()) && !Comparing.strEqual((String)DasUtil.getSchema((DasObject)table), (String)fk.getRefTableSchema(), (boolean)false) || !StringUtil.isEmpty((String)DasUtil.getCatalog((DasObject)table)) && !StringUtil.isEmpty((String)fk.getRefTableCatalog()) && !Comparing.strEqual((String)DasUtil.getCatalog((DasObject)table), (String)fk.getRefTableCatalog(), (boolean)false));
    }

    private static void collectTables(@Nullable SqlExpression e, @NotNull Collection<TableInfo> tables) {
        if (tables == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(17);
        }
        if (e instanceof SqlJoinExpression) {
            SqlJoinSmartCompletionProvider.collectTables(((SqlJoinExpression)e).getLOperand(), tables);
            SqlJoinSmartCompletionProvider.collectTables(((SqlJoinExpression)e).getROperand(), tables);
            return;
        }
        ContainerUtil.addAllNotNull(tables, (Object[])new TableInfo[]{SqlJoinSmartCompletionProvider.retrieveTable(e)});
    }

    private static TableInfo retrieveTable(@Nullable SqlExpression o) {
        SqlAsExpression asExpr = (SqlAsExpression)ObjectUtils.tryCast((Object)o, SqlAsExpression.class);
        return asExpr != null ? SqlJoinSmartCompletionProvider.retrieveTable(asExpr.getExpression(), DbSqlUtil.getName((DasObject)asExpr)) : SqlJoinSmartCompletionProvider.retrieveTable(o, null);
    }

    @Nullable
    private static TableInfo retrieveTable(@Nullable SqlExpression place, @Nullable ObjectName alias) {
        DasTable table = SqlCompletionContributor.retrieveTable((PsiElement)place);
        return table == null ? null : new TableInfo(table, alias, place);
    }

    public static void suggestJoinConditions(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull Collection<TableInfo> right, @NotNull BiConsumer<String, Integer> result, @Nullable Collection<TableInfo> left) {
        boolean appendTable;
        PsiElement parent2;
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(18);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(19);
        }
        if (right == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(20);
        }
        if (result == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(21);
        }
        if ((parent2 = position.getParent()) == null) {
            return;
        }
        ASTNode sibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)parent2.getNode());
        IElementType type = sibling == null ? null : sibling.getElementType();
        boolean appendCondition = type == SqlCommonKeywords.SQL_ON;
        boolean bl = appendTable = left != null || type == SqlCommonKeywords.SQL_JOIN;
        if (!appendCondition && !appendTable) {
            return;
        }
        SqlJoinExpression join2 = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlJoinExpression.class);
        if (left == null && join2 == null) {
            return;
        }
        if (join2 != null) {
            left = new LinkedHashSet<TableInfo>();
            SqlJoinSmartCompletionProvider.collectTables(join2.getLOperand(), left);
        }
        if (!appendTable) {
            SqlJoinSmartCompletionProvider.collectTables(join2.getROperand(), right);
        }
        Project project = position.getProject();
        SqlJoinSmartCompletionProvider.processTables(project, left, right, sqlDialect, result, join2 == null ? null : join2.getLOperand());
    }

    @Nullable
    public static String collectUsingCandidatesAndGetStatement(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull Map<String, PsiElement> toColumn, @NotNull List<String> usingCandidates) {
        String name;
        int i2;
        SqlUsingClause using;
        SqlJoinExpression join2;
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(22);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(23);
        }
        if (toColumn == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(24);
        }
        if (usingCandidates == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(25);
        }
        SqlJoinExpression sqlJoinExpression = join2 = (using = (SqlUsingClause)PsiTreeUtil.getParentOfType((PsiElement)position, SqlUsingClause.class)) == null ? null : (SqlJoinExpression)ObjectUtils.tryCast((Object)using.getParent(), SqlJoinExpression.class);
        if (join2 == null) {
            return null;
        }
        SqlReferenceList refs = using.getReferenceList();
        if (refs == null || !PsiTreeUtil.isContextAncestor((PsiElement)refs, (PsiElement)position, (boolean)false)) {
            return null;
        }
        SqlExpression right = join2.getROperand();
        SqlTableType ltype = (SqlTableType)ObjectUtils.tryCast((Object)join2.getLOperand().getSqlType(), SqlTableType.class);
        SqlTableType rtype = (SqlTableType)ObjectUtils.tryCast((Object)(right == null ? null : right.getSqlType()), SqlTableType.class);
        if (ltype == null || rtype == null) {
            return null;
        }
        Set lnames = DasUtil.newCaseAwareSet((boolean)false);
        Set rnames = DasUtil.newCaseAwareSet((boolean)false);
        HashSet<String> excluded = new HashSet<String>();
        for (i2 = 0; i2 < ltype.getColumnCount(); ++i2) {
            name = ltype.getColumnName(i2);
            toColumn.put(name, ltype.getColumnElement(i2));
            if (lnames.add(name)) continue;
            excluded.add(name);
        }
        for (i2 = 0; i2 < rtype.getColumnCount(); ++i2) {
            name = rtype.getColumnName(i2);
            if (rnames.add(name)) continue;
            excluded.add(name);
        }
        for (i2 = 0; i2 < ltype.getColumnCount(); ++i2) {
            name = ltype.getColumnName(i2);
            if (!rnames.contains(name) || excluded.contains(name)) continue;
            usingCandidates.add(name);
        }
        if (usingCandidates.size() >= 2 || refs.getReferenceList().size() > 1) {
            DdlBuilder builder = new DdlBuilder().withDialect(sqlDialect.getDatabaseDialect()).applyCodeStyle(position.getProject(), sqlDialect);
            for (String candidate : usingCandidates) {
                if (!builder.isEmpty()) {
                    builder.symbol(", ");
                }
                builder.columnRef(candidate);
            }
            return builder.getStatement();
        }
        return null;
    }

    private static void suggestJoinUsing(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull CompletionResultSet result) {
        ArrayList<String> usingCandidates;
        HashMap<String, PsiElement> toColumn;
        String statement;
        if (position == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(26);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(27);
        }
        if (result == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(28);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(statement = SqlJoinSmartCompletionProvider.collectUsingCandidatesAndGetStatement(position, sqlDialect, toColumn = new HashMap<String, PsiElement>(), usingCandidates = new ArrayList<String>())))) {
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)statement).withIcon(DatabaseIcons.ColBlueKey), (double)90.0));
        }
        Dbms dbms = SqlImplUtil.getDbms(position);
        for (String candidate : usingCandidates) {
            SqlCompletionUtil.addLookupElement(sqlDialect, dbms, toColumn.get(candidate), null, (Consumer<? super LookupElement>)result, false, 90.0, PsiTreeUtil.getParentOfType((PsiElement)position, SqlReferenceExpression.class));
        }
    }

    private static void processForeignKeys(@NotNull Project project, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull TableInfo first2, @NotNull TableInfo second, @NotNull BiConsumer<String, Integer> result, @Nullable SqlExpression lOperand) {
        if (project == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(29);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(30);
        }
        if (first2 == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(31);
        }
        if (second == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(32);
        }
        if (result == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(33);
        }
        SqlJoinSmartCompletionProvider.foreignKeyStatements(project, sqlDialect, first2, second, lOperand, result);
    }

    private static void addFkItem(@NotNull CompletionResultSet result, String s, int priority) {
        if (result == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(34);
        }
        Icon icon = priority < 100 ? DatabaseIcons.ColGreyKey : DatabaseIcons.ColBlueKey;
        result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)s).withIcon(icon), (double)priority));
    }

    private static void foreignKeyStatements(@NotNull Project project, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull TableInfo firstTable, @NotNull TableInfo secondTable, @Nullable SqlExpression lOperand, @NotNull BiConsumer<String, Integer> result) {
        if (project == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(35);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(36);
        }
        if (firstTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(37);
        }
        if (secondTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(38);
        }
        if (result == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(39);
        }
        boolean ancestor = secondTable.place != null && PsiTreeUtil.isContextAncestor((PsiElement)lOperand, (PsiElement)secondTable.place, (boolean)false);
        boolean leftToRight = ancestor ^ SqlCodeCompletionSettings.getInstance().isInvertOrderInOnClause();
        for (DasForeignKey key : ModelRelationManager.getForeignKeys(project, secondTable.table, firstTable.table)) {
            SqlJoinSmartCompletionProvider.foreignKeyStatement(project, sqlDialect, firstTable, secondTable, leftToRight, key, 100, result);
        }
        for (DasForeignKey key : secondTable.fuzzyKeys) {
            SqlJoinSmartCompletionProvider.foreignKeyStatement(project, sqlDialect, firstTable, secondTable, leftToRight, key, key.priority, result);
        }
    }

    private static void foreignKeyStatement(@NotNull Project project, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull @NotNull @NotNull TableInfo firstTable, @NotNull @NotNull @NotNull TableInfo secondTable, boolean leftToRight, DasForeignKey key, int priority, @NotNull BiConsumer<String, Integer> result) {
        if (project == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(40);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(41);
        }
        if (firstTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(42);
        }
        if (secondTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(43);
        }
        if (result == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(44);
        }
        if (firstTable.table.equals(key.getRefTable())) {
            MultiRef cols = key.getColumnsRef();
            MultiRef refCols = key.getRefColumns();
            if (cols.size() == refCols.size()) {
                DdlBuilder builder = new DdlBuilder().withDialect(sqlDialect.getDatabaseDialect()).applyCodeStyle(project, sqlDialect);
                if (firstTable.place == null) {
                    SqlJoinSmartCompletionProvider.appendTableReference(builder, firstTable);
                } else if (secondTable.place == null) {
                    SqlJoinSmartCompletionProvider.appendTableReference(builder, secondTable);
                }
                boolean first2 = true;
                Iterator<ObjectName> refIt = SqlJoinSmartCompletionProvider.iterateNames((MultiRef<? extends DasObject>)refCols);
                for (ObjectName name : JBIterable.once(SqlJoinSmartCompletionProvider.iterateNames((MultiRef<? extends DasObject>)cols))) {
                    if (first2) {
                        first2 = false;
                    } else {
                        builder.space().keyword("and").space();
                    }
                    ObjectName refName = refIt.next();
                    Runnable leftPart = () -> SqlJoinSmartCompletionProvider.appendJoinPart(name, secondTable, firstTable, key.getTable(), builder);
                    Runnable rightPart = () -> SqlJoinSmartCompletionProvider.appendJoinPart(refName, firstTable, secondTable, key.getRefTable(), builder);
                    (leftToRight ? leftPart : rightPart).run();
                    builder.space().symbol("=").space();
                    (leftToRight ? rightPart : leftPart).run();
                }
                result.accept(builder.getStatement(), priority);
            }
        }
    }

    private static Iterator<ObjectName> iterateNames(MultiRef<? extends DasObject> ref) {
        final MultiRef.It it2 = ref.iterate();
        return new JBIterator<ObjectName>(){

            protected ObjectName nextImpl() {
                if (!it2.hasNext()) {
                    return (ObjectName)this.stop();
                }
                String name = (String)it2.next();
                DasObject obj = (DasObject)it2.resolve();
                return obj == null ? ObjectName.plain((String)name) : DbSqlUtil.getName(obj);
            }
        };
    }

    private static void appendTableReference(@NotNull DdlBuilder builder, @NotNull TableInfo info) {
        if (builder == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(45);
        }
        if (info == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(46);
        }
        builder.identifier((DasObject)info.table).space();
        if (info.alias != null) {
            builder.identifier(info.alias, ObjectKind.TABLE).space();
        }
        builder.keyword("on").space();
    }

    private static void appendJoinPart(@NotNull ObjectName columnName, @NotNull TableInfo info, @NotNull TableInfo pairedInfo, @NotNull DasTable relatedTable, @NotNull DdlBuilder builder) {
        DasColumn sameColumnInPairedTable;
        SqlEditorOptions.QualificationType qualification;
        boolean shouldQualify;
        if (columnName == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(47);
        }
        if (info == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(48);
        }
        if (pairedInfo == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(49);
        }
        if (relatedTable == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(50);
        }
        if (builder == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(51);
        }
        if (shouldQualify = (qualification = SqlEditorOptions.getInstance().getJoinConditionQualification()).shouldQualify((sameColumnInPairedTable = (DasColumn)DasUtil.getColumns((DasObject)pairedInfo.table).find(c2 -> columnName.equals((Object)DbSqlUtil.getName((DasObject)c2)))) != null ? 2 : 1)) {
            (info.alias == null ? builder.identifier((DasObject)relatedTable) : builder.identifier(info.alias, ObjectKind.TABLE)).symbol(".");
        }
        builder.identifier(columnName, ObjectKind.COLUMN);
    }

    private static void processTables(@NotNull Project project, @NotNull Collection<TableInfo> left, @NotNull Collection<TableInfo> right, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull BiConsumer<String, Integer> result, @Nullable SqlExpression lOperand) {
        if (project == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(52);
        }
        if (left == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(53);
        }
        if (right == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(54);
        }
        if (sqlDialect == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(55);
        }
        if (result == null) {
            SqlJoinSmartCompletionProvider.$$$reportNull$$$0(56);
        }
        for (TableInfo r : right) {
            if (left.contains(r)) continue;
            for (TableInfo l : left) {
                SqlJoinSmartCompletionProvider.processForeignKeys(project, sqlDialect, r, l, result, lOperand);
                SqlJoinSmartCompletionProvider.processForeignKeys(project, sqlDialect, l, r, result, lOperand);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 21: 
            case 28: 
            case 33: 
            case 34: 
            case 39: 
            case 44: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 18: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fk";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 19: 
            case 23: 
            case 27: 
            case 30: 
            case 36: 
            case 41: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlDialect";
                break;
            }
            case 20: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toColumn";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usingCandidates";
                break;
            }
            case 29: 
            case 35: 
            case 40: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstTable";
                break;
            }
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondTable";
                break;
            }
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnName";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pairedInfo";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedTable";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTablesForJoin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suggestJoinStuff";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectTablesForJoin";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cheapEquals";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectTables";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "suggestJoinConditions";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectUsingCandidatesAndGetStatement";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "suggestJoinUsing";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processForeignKeys";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addFkItem";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "foreignKeyStatements";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "foreignKeyStatement";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "appendTableReference";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "appendJoinPart";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "processTables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FuzzyKey
    implements DasForeignKey {
        @NotNull
        private final DasColumn column;
        @NotNull
        private final DasColumn refColumn;
        final int priority;

        private FuzzyKey(@NotNull DasColumn column, @NotNull DasColumn refColumn, int priority) {
            if (column == null) {
                FuzzyKey.$$$reportNull$$$0(0);
            }
            if (refColumn == null) {
                FuzzyKey.$$$reportNull$$$0(1);
            }
            this.column = column;
            this.refColumn = refColumn;
            this.priority = priority;
        }

        public String getRefTableName() {
            return this.getRefTable().getName();
        }

        public String getRefTableSchema() {
            return DasUtil.getSchema((DasObject)this.getRefTable());
        }

        public String getRefTableCatalog() {
            return DasUtil.getCatalog((DasObject)this.getRefTable());
        }

        @NotNull
        public DasTable getRefTable() {
            DasTable dasTable = Objects.requireNonNull(this.refColumn.getTable());
            if (dasTable == null) {
                FuzzyKey.$$$reportNull$$$0(2);
            }
            return dasTable;
        }

        @NotNull
        public MultiRef<? extends DasTypedObject> getRefColumns() {
            MultiRef multiRef = DasUtil.asRef(Collections.singleton(this.refColumn));
            if (multiRef == null) {
                FuzzyKey.$$$reportNull$$$0(3);
            }
            return multiRef;
        }

        public DasForeignKey.RuleAction getDeleteRule() {
            return null;
        }

        public DasForeignKey.RuleAction getUpdateRule() {
            return null;
        }

        public DasForeignKey.Deferrability getDeferrability() {
            return null;
        }

        @NotNull
        public MultiRef<? extends DasTypedObject> getColumnsRef() {
            MultiRef multiRef = DasUtil.asRef(Collections.singleton(this.column));
            if (multiRef == null) {
                FuzzyKey.$$$reportNull$$$0(4);
            }
            return multiRef;
        }

        @NotNull
        public DasTable getTable() {
            DasTable dasTable = Objects.requireNonNull(this.column.getTable());
            if (dasTable == null) {
                FuzzyKey.$$$reportNull$$$0(5);
            }
            return dasTable;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
            if (objectKind == null) {
                FuzzyKey.$$$reportNull$$$0(6);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refColumn";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$FuzzyKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$FuzzyKey";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefTable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefColumns";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnsRef";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTable";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TableInfo {
        final DasTable table;
        final ObjectName alias;
        final SqlExpression place;
        @NotNull
        private final String qualifiedName;
        @NotNull
        final Collection<FuzzyKey> fuzzyKeys;

        public TableInfo(@NotNull DasTable table, @Nullable ObjectName alias, @Nullable SqlExpression place) {
            if (table == null) {
                TableInfo.$$$reportNull$$$0(0);
            }
            this(table, alias, place, Collections.emptyList());
        }

        public TableInfo(@NotNull DasTable table, @Nullable ObjectName alias, @Nullable SqlExpression place, @NotNull Collection<FuzzyKey> fuzzyKeys) {
            if (table == null) {
                TableInfo.$$$reportNull$$$0(1);
            }
            if (fuzzyKeys == null) {
                TableInfo.$$$reportNull$$$0(2);
            }
            this.table = table;
            this.alias = alias;
            this.place = place;
            this.qualifiedName = QNameUtil.getQualifiedName((DasObject)table);
            this.fuzzyKeys = fuzzyKeys;
        }

        public int getPriority() {
            if (this.fuzzyKeys.isEmpty()) {
                return 90;
            }
            int max = 0;
            for (FuzzyKey key : this.fuzzyKeys) {
                if (key.priority <= max) continue;
                max = key.priority;
            }
            int diff = 100 - max;
            return 90 - diff;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableInfo info = (TableInfo)o;
            return this.qualifiedName.equals(info.qualifiedName);
        }

        public int hashCode() {
            return Objects.hash(this.qualifiedName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fuzzyKeys";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/completion/providers/SqlJoinSmartCompletionProvider$TableInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

