/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlHighlightUsagesFactory;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.slicer.SqlPsiUtilKt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlInlayParameterHintsProvider
implements InlayParameterHintsProvider {
    private static final Option COLUMN_NAMES_IN_INSERT_VALUES = new Option("sql.show.column.names.in.insert.values", SqlBundle.message("settings.inlay.in.insert.values", new Object[0]), false);
    private static final Option COLUMN_NAMES_IN_SELECT = new Option("sql.show.column.names.in.select", SqlBundle.message("settings.inlay.in.select.expressions", new Object[0]), false);
    private static final Option COLUMN_NAMES_FOR_ASTERISK = new Option("sql.show.column.names.for.asterisk", SqlBundle.message("settings.inlay.for.references", new Object[0]), false);

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlInlayParameterHintsProvider.$$$reportNull$$$0(0);
        }
        if (element2 instanceof SqlFunctionCallExpression) {
            List<InlayInfo> list = SqlInlayParameterHintsProvider.getCallHints((SqlFunctionCallExpression)element2);
            if (list == null) {
                SqlInlayParameterHintsProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        return SqlInlayParameterHintsProvider.getResultSetHints(element2);
    }

    private static List<InlayInfo> getCallHints(SqlFunctionCallExpression callExpression) {
        PsiElement target;
        SqlReferenceExpression calleeExpression = callExpression.getNameElement();
        PsiElement psiElement = target = calleeExpression != null ? calleeExpression.resolve() : null;
        if (!(target instanceof DasRoutine)) {
            return Collections.emptyList();
        }
        ArrayList<InlayInfo> objects2 = new ArrayList<InlayInfo>();
        SqlExpressionList expressionList = callExpression.getParameterList();
        if (expressionList == null) {
            return Collections.emptyList();
        }
        for (SqlExpression expression : expressionList.getExpressionList()) {
            DasArgument dasArgument;
            if (expression instanceof SqlNamedParameterValueExpression || (dasArgument = SqlPsiUtilKt.findParameterDefinition(expression, false)) == null) continue;
            objects2.add(new InlayInfo(dasArgument.getName(), expression.getTextRange().getStartOffset()));
        }
        return objects2;
    }

    @NotNull
    private static List<InlayInfo> getResultSetHints(@NotNull PsiElement element2) {
        List expressions2;
        if (element2 == null) {
            SqlInlayParameterHintsProvider.$$$reportNull$$$0(2);
        }
        if (element2 instanceof SqlExpressionList) {
            if (!COLUMN_NAMES_IN_INSERT_VALUES.get() || !(SqlImplUtil.sqlParent(element2) instanceof SqlValuesExpression)) {
                List<InlayInfo> list = Collections.emptyList();
                if (list == null) {
                    SqlInlayParameterHintsProvider.$$$reportNull$$$0(3);
                }
                return list;
            }
            expressions2 = ((SqlExpressionList)element2).getExpressionList();
        } else if (element2 instanceof SqlSelectClause) {
            if (!COLUMN_NAMES_IN_SELECT.get()) {
                List<InlayInfo> list = Collections.emptyList();
                if (list == null) {
                    SqlInlayParameterHintsProvider.$$$reportNull$$$0(4);
                }
                return list;
            }
            expressions2 = ((SqlSelectClause)element2).getExpressions();
        } else {
            List<InlayInfo> list = Collections.emptyList();
            if (list == null) {
                SqlInlayParameterHintsProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<InlayInfo> objects2 = new ArrayList<InlayInfo>();
        for (SqlExpression expression : expressions2) {
            IntRange indices;
            if (!SqlInlayParameterHintsProvider.shouldShowHintsForExpression((PsiElement)expression) || (indices = SqlImplUtil.getImmediateColumnSourceIndices((PsiElement)expression, (SqlElement)element2, false)) == null) continue;
            ArrayList names = new ArrayList(indices.getEndInclusive() - indices.getStart() + 1);
            SqlHighlightUsagesFactory.processColumnElements((PsiElement)expression, indices.getStart(), indices.getEndInclusive() + 1, (e, name) -> {
                if (name != null) {
                    names.add(name);
                }
            });
            if (names.isEmpty()) continue;
            objects2.add(new InlayInfo(StringUtil.join(names, (String)", "), expression.getTextRange().getStartOffset()));
        }
        ArrayList<InlayInfo> arrayList = objects2;
        if (arrayList == null) {
            SqlInlayParameterHintsProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static boolean shouldShowHintsForExpression(PsiElement element2) {
        if (SqlImplUtil.isAsteriskRef(element2)) {
            return COLUMN_NAMES_FOR_ASTERISK.get();
        }
        return element2 instanceof SqlLiteralExpression || element2 instanceof SqlUnaryExpression || element2 instanceof SqlBinaryExpression;
    }

    @Nullable
    public HintInfo getHintInfo(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlInlayParameterHintsProvider.$$$reportNull$$$0(7);
        }
        if (element2 instanceof SqlExpressionList && SqlImplUtil.sqlParent(element2) instanceof SqlValuesExpression) {
            return new HintInfo.OptionInfo(COLUMN_NAMES_IN_INSERT_VALUES);
        }
        if (element2 instanceof SqlSelectClause) {
            return new HintInfo.OptionInfo(COLUMN_NAMES_IN_SELECT);
        }
        if (SqlImplUtil.isAsteriskRef(element2)) {
            return new HintInfo.OptionInfo(COLUMN_NAMES_FOR_ASTERISK);
        }
        if (element2 instanceof SqlFunctionCallExpression) {
            PsiElement target;
            SqlReferenceExpression calleeExpression = ((SqlFunctionCallExpression)element2).getNameElement();
            PsiElement psiElement = target = calleeExpression != null ? calleeExpression.resolve() : null;
            if (!(target instanceof DasRoutine)) {
                return null;
            }
            DasRoutine routine = (DasRoutine)target;
            String fqName = QNameUtil.getQualifiedName((DasObject)routine);
            List parameterNames = JBIterable.from((Iterable)routine.getArguments()).filter(arg -> arg.getArgumentDirection().isIn() || arg.getArgumentDirection().isOut()).map(DasObject::getName).toList();
            return new HintInfo.MethodInfo(fqName, parameterNames);
        }
        return null;
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            SqlInlayParameterHintsProvider.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public List<Option> getSupportedOptions() {
        return new SmartList((Object[])new Option[]{COLUMN_NAMES_IN_INSERT_VALUES, COLUMN_NAMES_IN_SELECT, COLUMN_NAMES_FOR_ASTERISK});
    }

    public boolean isBlackListSupported() {
        return true;
    }

    public String getMainCheckboxText() {
        return SqlBundle.message("settings.inlay.show.column.names", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlInlayParameterHintsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlInlayParameterHintsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterHints";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultSetHints";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBlackList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParameterHints";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResultSetHints";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHintInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

