/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.run.actions.TransactionAction;
import com.intellij.database.run.ui.DescriptionPopup;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.DatabaseDriverGeneralPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class DatabaseDriverOptionsPanel {
    private final DatabaseDriverConfigurable myConfigurable;
    private JBScrollPane myRoot;
    private ComboBox<DatabaseDriver.SchemaControl> mySwitchControlBox;
    private EditorTextField myInitScript;
    private ComboBox<DBIntrospectionOptions.SourceLoading> mySourceLoading;
    private JBCheckBox myAutoSyncCheckBox;
    private ComboBox<Language> myDialect;
    private JBCheckBox myFormatSourcesOnSyncCheckBox;
    private JCheckBox mySendAppInfo;
    private EditorTextField myKeepAliveQuery;
    private JPanel myTxControlHolder;
    private JPanel myTxControlPanel;
    private ComboBox<Icon> myIcon;
    private JPanel myIconPanel;
    private final DescriptionPopup.TxPopup.TxSelector mySelector = new DescriptionPopup.TxPopup.TxSelectorImpl();

    public DatabaseDriverOptionsPanel(DatabaseDriverConfigurable configurable) {
        this.myConfigurable = configurable;
        this.$$$setupUI$$$();
        this.mySwitchControlBox.setModel((ComboBoxModel)new EnumComboBoxModel(DatabaseDriver.SchemaControl.class));
        this.mySwitchControlBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"Automatic", value2 -> StringUtil.capitalize((String)StringUtil.toLowerCase((String)value2.displayName()))));
        this.myDialect.setEditable(false);
        DbImplUtil.initLanguageComboBox(this.myDialect, true);
        this.myDialect.addActionListener(e -> this.resetSQLFieldsDialect(DbSqlUtil.getSqlDialect(configurable.getTempDriver())));
        new ExpandableEditorSupport(this.myInitScript);
        new ExpandableEditorSupport(this.myKeepAliveQuery);
        this.mySourceLoading.setModel((ComboBoxModel)new EnumComboBoxModel(DBIntrospectionOptions.SourceLoading.class));
        this.mySourceLoading.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"None", value2 -> value2 == DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES ? "All schemas" : (value2 == DBIntrospectionOptions.SourceLoading.USER_SOURCES ? "All excl. system schemas" : "None")));
        SortedComboBoxModel codeStyleNamesModel = new SortedComboBoxModel(String.CASE_INSENSITIVE_ORDER);
        List allSchemes = CodeStyleSchemesImpl.getSchemeManager().getAllSchemes();
        for (CodeStyleScheme scheme : allSchemes) {
            codeStyleNamesModel.add((Object)scheme.getName());
        }
        JComponent txComponent = DbUIUtil.createActionComponent((AnAction)new DatabaseDriverGeneralPanel.DriverTxModeAction(this.mySelector));
        this.myTxControlPanel.setLayout(new BorderLayout());
        this.myTxControlPanel.add((Component)txComponent, "Center");
        this.myTxControlHolder.setVisible(TransactionAction.isTransactionsSupported(DbImplUtil.getDbms(configurable.getDriver())));
        if (this.myConfigurable.getDriver().isPredefined()) {
            this.myIconPanel.setVisible(false);
        } else {
            LinkedHashMap<Icon, String> icons = new LinkedHashMap<Icon, String>();
            int genericCount = 1;
            icons.put(DatabaseIcons.UserDriver, "Generic " + genericCount++);
            JBIterable genericIcons = JBIterable.of((Object[])DatabaseIcons.class.getDeclaredFields()).filter(o -> o.getName().startsWith("Driver")).map(o -> (Icon)ReflectionUtil.getStaticFieldValue(DatabaseIcons.class, Icon.class, (String)o.getName()));
            for (Icon icon : genericIcons) {
                icons.putIfAbsent(icon, "Generic " + genericCount++);
            }
            for (Dbms dbms : JBIterable.from((Iterable)Dbms.allValues()).sort(Comparator.comparing(Dbms::getDisplayName))) {
                if (dbms == Dbms.UNKNOWN) continue;
                icons.putIfAbsent(dbms.getIcon(), dbms.getDisplayName());
            }
            this.myIcon.setModel((ComboBoxModel)new CollectionComboBoxModel(new ArrayList(icons.keySet())));
            this.myIcon.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value2, index2) -> {
                label.setIcon(value2);
                label.setText(StringUtil.notNullize((String)((String)icons.get(value2)), (String)"Generic"));
            }));
        }
        DatabaseDialogsHelper.setupEnclosingScrollPane((JScrollPane)this.myRoot);
    }

    public JComponent getComponent() {
        return this.myRoot;
    }

    private void createUIComponents() {
        this.myInitScript = new EditorTextField("", this.myConfigurable.getProject(), (FileType)SqlFileType.INSTANCE);
        this.myKeepAliveQuery = new EditorTextField("", this.myConfigurable.getProject(), (FileType)SqlFileType.INSTANCE);
    }

    public void saveData(@NotNull DatabaseDriverImpl driver) {
        Object dialect;
        if (driver == null) {
            DatabaseDriverOptionsPanel.$$$reportNull$$$0(0);
        }
        driver.setSqlDialect((dialect = this.myDialect.getSelectedItem()) instanceof Language ? ((Language)dialect).getID() : null);
        driver.setOption(DatabaseDriver.OPTION_AUTO_COMMIT, this.mySelector.isAuto());
        driver.setOption(DatabaseDriver.OPTION_AUTO_SYNC, this.myAutoSyncCheckBox.isSelected());
        driver.setOption(DatabaseDriver.OPTION_FORMAT_SOURCES_ON_SYNC, this.myFormatSourcesOnSyncCheckBox.isSelected());
        driver.setOption(DatabaseDriver.OPTION_SEND_APP_INFO, this.mySendAppInfo.isSelected());
        driver.setOption(DatabaseDriver.OPTION_SOURCE_LOADING, (DBIntrospectionOptions.SourceLoading)((Object)this.mySourceLoading.getSelectedItem()));
        driver.setOption(DatabaseDriver.OPTION_SCHEMA_CONTROL, (DatabaseDriver.SchemaControl)((Object)this.mySwitchControlBox.getSelectedItem()));
        driver.setInitScript(this.myInitScript.getText());
        driver.setKeepAliveQuery(this.myKeepAliveQuery.getText());
        if (this.myIconPanel.isVisible()) {
            driver.setIcon((Icon)this.myIcon.getSelectedItem());
        }
    }

    public void reset(@NotNull DatabaseDriverImpl driver) {
        if (driver == null) {
            DatabaseDriverOptionsPanel.$$$reportNull$$$0(1);
        }
        this.myDialect.setSelectedItem((Object)Language.findLanguageByID((String)driver.getSqlDialect()));
        this.mySelector.toggle(null, driver.getOption(DatabaseDriver.OPTION_AUTO_COMMIT));
        this.myAutoSyncCheckBox.setSelected(driver.getOption(DatabaseDriver.OPTION_AUTO_SYNC).booleanValue());
        this.myFormatSourcesOnSyncCheckBox.setSelected(driver.getOption(DatabaseDriver.OPTION_FORMAT_SOURCES_ON_SYNC).booleanValue());
        this.mySwitchControlBox.setSelectedItem((Object)driver.getOption(DatabaseDriver.OPTION_SCHEMA_CONTROL));
        this.mySourceLoading.setSelectedItem((Object)driver.getOption(DatabaseDriver.OPTION_SOURCE_LOADING));
        this.mySendAppInfo.setSelected(driver.getOption(DatabaseDriver.OPTION_SEND_APP_INFO));
        this.myInitScript.setText(driver.getInitScript());
        this.myKeepAliveQuery.setText(driver.getKeepAliveQuery());
        if (this.myIconPanel.isVisible()) {
            this.myIcon.setSelectedItem((Object)driver.getIcon(0));
        }
        this.resetSQLFieldsDialect(DbSqlUtil.getSqlDialect(driver));
    }

    void resetSQLFieldsDialect(@NotNull SqlLanguageDialect dialect) {
        if (dialect == null) {
            DatabaseDriverOptionsPanel.$$$reportNull$$$0(2);
        }
        DatabaseDialogsHelper.setTextFieldLanguage(this.myInitScript, dialect);
        DatabaseDialogsHelper.setTextFieldLanguage(this.myKeepAliveQuery, dialect);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        ComboBox comboBox;
        ComboBox comboBox2;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        ComboBox comboBox3;
        JPanel jPanel2;
        JPanel jPanel3;
        ComboBox comboBox4;
        JBScrollPane jBScrollPane;
        this.createUIComponents();
        this.myRoot = jBScrollPane = new JBScrollPane();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Connection", (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Switch schema:");
        jPanel5.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySwitchControlBox = comboBox4 = new ComboBox();
        jPanel5.add((Component)comboBox4, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Startup script:");
        jPanel5.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myInitScript;
        jPanel5.add((Component)editorTextField2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myTxControlHolder = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Transaction control:");
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTxControlPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Keep-alive query:");
        jPanel5.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField3 = this.myKeepAliveQuery;
        jPanel5.add((Component)editorTextField3, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Other", (int)0, (int)0, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Dialect:");
        jPanel6.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDialect = comboBox3 = new ComboBox();
        jPanel6.add((Component)comboBox3, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myFormatSourcesOnSyncCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Format synced sources");
        jPanel6.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 3, 8, 0, 2, 0, null, null, null));
        this.myIconPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Icon:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIcon = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Introspection", (int)0, (int)0, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Load sources for:");
        jPanel7.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceLoading = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel);
        jPanel7.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myAutoSyncCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Auto sync");
        jPanel7.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySendAppInfo = jCheckBox = new JCheckBox();
        jCheckBox.setText("Send application info");
        jPanel7.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        jLabel.setLabelFor((Component)comboBox4);
        jLabel2.setLabelFor((Component)editorTextField2);
        jLabel4.setLabelFor((Component)editorTextField3);
        jBLabel.setLabelFor((Component)comboBox3);
        jBLabel2.setLabelFor((Component)comboBox3);
        jBLabel3.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/view/ui/DatabaseDriverOptionsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "saveData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resetSQLFieldsDialect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

