/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class SqlDialects {
    private static final Logger LOG = Logger.getInstance(SqlDialects.class);

    private SqlDialects() {
        long t = System.currentTimeMillis();
        SqlDialects.initSqlDialects();
        LOG.info("SQL dialects initialized in " + StringUtil.formatDuration((long)(System.currentTimeMillis() - t)));
    }

    @NotNull
    public static SqlDialects getInstance() {
        SqlDialects sqlDialects = (SqlDialects)ApplicationManager.getApplication().getService(SqlDialects.class);
        if (sqlDialects == null) {
            SqlDialects.$$$reportNull$$$0(0);
        }
        return sqlDialects;
    }

    private static void initSqlDialects() {
        List extensions = SqlLanguageDialect.EP.allExtensions();
        if (extensions.isEmpty()) {
            LOG.error("No sql dialects found");
            return;
        }
        HashSet families = new HashSet();
        for (DbmsExtension.Bean bean : extensions) {
            try {
                bean.getInstance();
                ContainerUtil.addIfNotNull(families, (Object)bean.getDbms());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        if (!families.containsAll(Arrays.asList(Dbms.MYSQL, Dbms.ORACLE, Dbms.POSTGRES, Dbms.SQLITE, Dbms.UNKNOWN))) {
            LOG.error("Required SQL dialects not found among: " + families);
        }
    }

    @Nullable
    public static SqlLanguageDialect findDialectById(@NotNull String id) {
        if (id == null) {
            SqlDialects.$$$reportNull$$$0(1);
        }
        SqlDialects.ensureSqlDialectsLoaded();
        Language result = Language.findLanguageByID((String)id);
        return result instanceof SqlLanguageDialect ? (SqlLanguageDialect)result : null;
    }

    @NotNull
    public static List<SqlLanguageDialect> getSqlDialects() {
        List list = SqlDialects.getInstance().getSqlDialectsImpl().toList();
        if (list == null) {
            SqlDialects.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private JBIterable<SqlLanguageDialect> getSqlDialectsImpl() {
        JBIterable jBIterable = ((JBTreeTraverser)JBTreeTraverser.from(Language::getDialects).withRoot((Object)SqlLanguage.INSTANCE)).filter(SqlLanguageDialect.class);
        if (jBIterable == null) {
            SqlDialects.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NotNull
    public static List<SqlLanguageDialect> getTopLevelSqlDialects() {
        List list = SqlDialects.getInstance().getSqlDialectsImpl().filter(o -> !(o instanceof InjectableLanguage)).sort(Comparator.comparing(Language::getDisplayName)).toList();
        if (list == null) {
            SqlDialects.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static SqlLanguageDialect getGenericDialect() {
        SqlLanguageDialect sqlLanguageDialect = Objects.requireNonNull(SqlDialects.findDialectById("GenericSQL"));
        if (sqlLanguageDialect == null) {
            SqlDialects.$$$reportNull$$$0(5);
        }
        return sqlLanguageDialect;
    }

    public static boolean isGenericDialect(@NotNull SqlLanguageDialect dialect) {
        if (dialect == null) {
            SqlDialects.$$$reportNull$$$0(6);
        }
        return dialect.equals(SqlDialects.getGenericDialect());
    }

    public static void ensureSqlDialectsLoaded() {
        SqlDialects.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/SqlDialects";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/SqlDialects";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialects";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectsImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelSqlDialects";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findDialectById";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isGenericDialect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

