/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.UrlPropertiesPanel;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSequence;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.schemaEditor.DbObjectNameEditor;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilder;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbObjectEditorFactory {
    public static final DbObjectEditorFactory DEFAULT = new DbObjectEditorFactory();
    private static final Map<Class<?>, Converter<String, ?>> ourConverters;
    private static final Map<Class<? extends Collection>, Factory<? extends Collection<?>>> ourCollections;

    @NotNull
    public static DbObjectEditorFactory forDbms(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(0);
        }
        DbObjectEditorFactory dbObjectEditorFactory = ModelFacade.forDbms(dbms).getModelHelper().getObjectEditorFactory();
        if (dbObjectEditorFactory == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(1);
        }
        return dbObjectEditorFactory;
    }

    @NotNull
    public DbObjectEditor createObjectEditor(@NotNull Project project, @NotNull BasicMetaObject<?> object) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(2);
        }
        if (object == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(3);
        }
        DbObjectEditor dbObjectEditor = this.createObjectEditor(project, object, null);
        if (dbObjectEditor == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(4);
        }
        return dbObjectEditor;
    }

    @NotNull
    public DbObjectEditor createObjectEditor(@NotNull Project project, @NotNull BasicMetaObject<?> object, @Nullable List<BasicMetaProperty<?>> invalid) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(5);
        }
        if (object == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(6);
        }
        ArrayList properties = ContainerUtil.newArrayList((Object[])object.properties);
        this.reorderProperties(object, properties);
        ArrayList<DbObjectEditor> editors = new ArrayList<DbObjectEditor>(properties.size());
        this.createMultiPropEditors(project, editors, properties);
        for (BasicMetaProperty property : properties) {
            if (property.internal) continue;
            DbObjectEditor editor = this.createPropertyEditor(project, object, property);
            if (editor != null) {
                editors.add(editor);
                continue;
            }
            if (invalid == null) continue;
            invalid.add(property);
        }
        return new CompoundObjectEditor(editors);
    }

    @NotNull
    protected String getTitle(@NotNull BasicMetaProperty<?> prop) {
        if (prop == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(7);
        }
        return DbObjectEditorFactory.words(prop.name);
    }

    protected void reorderProperties(@NotNull BasicMetaObject<?> meta, @NotNull List<BasicMetaProperty<?>> properties) {
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(8);
        }
        if (properties == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(9);
        }
        DbObjectEditorFactory.moveTo(properties, 0, BasicModNamedElement.NAME, BasicModNamedElement.COMMENT, BasicModTypedElement.DATA_TYPE, BasicModSequence.SEQUENCE_IDENTITY);
    }

    public static <T> void moveTo(List<T> list, int idx, T ... values2) {
        for (T value2 : values2) {
            int newIdx = DbObjectEditorFactory.moveTo(list, idx, value2);
            if (newIdx == -1) continue;
            idx = newIdx + 1;
        }
    }

    public static <T> int moveTo(List<T> list, int idx, T value2) {
        int valIdx = list.indexOf(value2);
        if (valIdx == -1) {
            return -1;
        }
        if (valIdx == idx) {
            return idx;
        }
        if (valIdx < idx) {
            --idx;
        }
        list.add(idx, list.remove(valIdx));
        return idx;
    }

    private void createMultiPropEditors(@NotNull Project project, List<DbObjectEditor> editors, List<BasicMetaProperty<?>> properties) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(10);
        }
        if (properties.remove(BasicModNamedElement.NAME)) {
            properties.remove(BasicModNamedElement.NAME_QUOTED);
            properties.remove(BasicModNamedElement.NAME_SCRIPTED);
            properties.remove(BasicModNamedElement.NAME_SURROGATE);
            editors.add(new DbObjectNameEditor(project));
        }
    }

    private static NameValueType parseNvt(String s) {
        int valSep = s.indexOf(61);
        int valSepSafe = valSep == -1 ? s.length() : valSep;
        int typeSep = StringUtil.indexOf((CharSequence)s, (char)':', (int)0, (int)valSepSafe);
        return new NameValueType(s.substring(0, typeSep == -1 ? valSepSafe : typeSep), valSep == -1 ? "" : s.substring(valSep + 1), typeSep == -1 ? "" : s.substring(typeSep + 1, valSepSafe));
    }

    @NotNull
    private static String serializeNvt(NameValueType nvt) {
        String string = nvt.getName() + (StringUtil.isEmpty((String)nvt.getType()) ? "" : ":" + nvt.getType()) + "=" + nvt.getValue();
        if (string == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static NameValue parseNv(String s) {
        int valSep = s.indexOf(61);
        int valSepSafe = valSep == -1 ? s.length() : valSep;
        return new NameValue(s.substring(0, valSepSafe), valSep == -1 ? "" : s.substring(valSep + 1));
    }

    @NotNull
    private static String serializeNv(NameValue nvt) {
        String string = nvt.getName() + "=" + nvt.getValue();
        if (string == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static <T> void put(ContainerUtil.ImmutableMapBuilder<Class<?>, Converter<String, ?>> builder, Class<T> clazz, Function<T, String> from, Function<String, T> to) {
        builder.put(clazz, new Converter(from, to));
    }

    @Nullable
    public DbObjectEditor createPropertyEditor(Project project, BasicMetaObject<?> meta, BasicMetaProperty<?> property) {
        Converter<String, ?> converter = ourConverters.get(property.getValueClass());
        if (converter != null) {
            return new DbObjectTextPropEditor(property, this.getTitle(property), converter.from, converter.to);
        }
        BasicMetaProperty<Object> prop = property.tryCast(Boolean.class);
        if (prop != null) {
            return new DbObjectBoolPropEditor((BasicMetaProperty<Boolean>)prop, this.getTitle(property));
        }
        prop = property.tryCast(SequenceIdentity.class);
        if (prop != null) {
            return new DbSeqIdPropEditor((BasicMetaProperty<SequenceIdentity>)prop, this.getTitle(property));
        }
        prop = property.tryCast(Enum.class);
        if (prop != null) {
            return new DbObjectEnumPropEditor((BasicMetaProperty<Enum<?>>)prop, this.getTitle(property));
        }
        if (property.type instanceof BasicMetaType.CollectionMetaType) {
            return this.createPropertyEditor(project, meta, property, (BasicMetaType.CollectionMetaType)property.type);
        }
        return null;
    }

    @Nullable
    public DbObjectEditor createPropertyEditor(Project project, BasicMetaObject<?> meta, BasicMetaProperty<?> property, BasicMetaType.CollectionMetaType<?, ?> type) {
        Factory<? extends Collection<?>> fac = ourCollections.get(property.getValueClass());
        if (fac == null) {
            return null;
        }
        Converter<String, ?> converter = ourConverters.get(type.elementClass);
        if (converter != null) {
            return new DbObjectTextCollectionPropEditor(property, this.getTitle(property), converter.from, converter.to, fac);
        }
        if (Enum.class.isAssignableFrom(type.elementClass)) {
            return this.createEnumListEditor(property, type.elementClass, fac);
        }
        return null;
    }

    public <E extends Enum<E>, C extends Collection<E>> DbObjectEditor createEnumListEditor(BasicMetaProperty<C> property, Class<E> enumClass, Factory<C> fac) {
        return new DbObjectTextCollectionPropEditor(property, this.getTitle(property), Enum::name, n -> Enum.valueOf(enumClass, n), fac);
    }

    private static void setError(@NotNull JComponent comp, @Nullable String error2) {
        if (comp == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(13);
        }
        comp.putClientProperty("JComponent.outline", error2 == null ? null : "error");
        comp.setToolTipText(error2);
    }

    @NotNull
    private static String words(@NotNull String s) {
        if (s == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(14);
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char prev = i2 < 1 ? (char)'\u0000' : s.charAt(i2 - 1);
            char cur = s.charAt(i2);
            if (Character.isLowerCase(prev) && Character.isUpperCase(cur)) {
                sb.append(' ');
            }
            sb.append(cur);
        }
        String string = sb.toString();
        if (string == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(15);
        }
        return string;
    }

    static {
        ourCollections = ContainerUtil.immutableMapBuilder().put(List.class, ArrayList::new).put(Set.class, LinkedHashSet::new).build();
        ContainerUtil.ImmutableMapBuilder builder = ContainerUtil.immutableMapBuilder();
        DbObjectEditorFactory.put(builder, String.class, Functions.id(), Functions.id());
        DbObjectEditorFactory.put(builder, Byte.class, Object::toString, Byte::new);
        DbObjectEditorFactory.put(builder, Short.class, Object::toString, Short::new);
        DbObjectEditorFactory.put(builder, Integer.class, Object::toString, Integer::new);
        DbObjectEditorFactory.put(builder, Long.class, Object::toString, Long::new);
        DbObjectEditorFactory.put(builder, Float.class, Object::toString, Float::new);
        DbObjectEditorFactory.put(builder, Double.class, Object::toString, Double::new);
        DbObjectEditorFactory.put(builder, BigInteger.class, Object::toString, BigInteger::new);
        DbObjectEditorFactory.put(builder, DataType.class, dt -> dt.equals(DataType.UNKNOWN) ? "" : dt.getSpecification(), s -> StringUtil.isEmpty((String)s) ? DataType.UNKNOWN : DataTypeFactory.of(s));
        DbObjectEditorFactory.put(builder, NameValue.class, DbObjectEditorFactory::serializeNv, DbObjectEditorFactory::parseNv);
        DbObjectEditorFactory.put(builder, NameValueType.class, DbObjectEditorFactory::serializeNvt, DbObjectEditorFactory::parseNvt);
        ourConverters = builder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forDbms";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createObjectEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeNvt";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeNv";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "words";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forDbms";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createObjectEditor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reorderProperties";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createMultiPropEditors";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setError";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "words";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Converter<A, B> {
        public final Function<B, A> from;
        public final Function<A, B> to;

        private Converter(Function<B, A> from, Function<A, B> to) {
            this.from = from;
            this.to = to;
        }
    }

    public static abstract class DbObjectEditorBase
    extends DatabaseScriptDialog {
        private ScriptingTaskBuilder myBuilder;

        public DbObjectEditorBase(@NotNull Project project, @NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull String title) {
            if (project == null) {
                DbObjectEditorBase.$$$reportNull$$$0(0);
            }
            if (dataSource2 == null) {
                DbObjectEditorBase.$$$reportNull$$$0(1);
            }
            if (title == null) {
                DbObjectEditorBase.$$$reportNull$$$0(2);
            }
            super(project, dataSource2, searchPath, title);
        }

        protected abstract void reset();

        protected abstract void apply();

        @Override
        protected JComponent createCenterPanel() {
            this.myBuilder = this.createBuilder();
            JComponent editor = this.getObjectEditor().getComponent();
            this.reset();
            UserActivityWatcher watcher = new UserActivityWatcher();
            watcher.addUserActivityListener(this::generate, this.myDisposable);
            watcher.register((Component)editor);
            ApplicationManager.getApplication().invokeLater(this::generate, ModalityState.stateForComponent((Component)this.getRootPane()));
            return JBUI.Panels.simplePanel().addToTop((Component)editor).addToCenter((Component)this.myPreviewPanel);
        }

        protected abstract DbObjectEditor getObjectEditor();

        protected abstract ScriptingTaskBuilder createBuilder();

        @Override
        @NotNull
        protected List<AnAction> createPreviewActions() {
            List<AnAction> list = Collections.singletonList(DbObjectEditorBase.createSettingsPopupAction((Getter<ScriptingTask>)((Getter)() -> this.getTask()), (Consumer<ScriptingOptions>)((Consumer)o -> this.settingsChanged(this.appendCodeStyle((ScriptingOptions)o)))));
            if (list == null) {
                DbObjectEditorBase.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            DbObjectEditor e = (DbObjectEditor)((JBTreeTraverser)JBTreeTraverser.from(o -> o instanceof CompoundObjectEditor ? ((CompoundObjectEditor)o).getEditors() : Collections.emptyList()).withRoot((Object)this.getObjectEditor())).traverse(TreeTraversal.LEAVES_DFS).first();
            return e == null ? null : e.getComponent();
        }

        @Override
        protected ScriptingTask getTask() {
            this.apply();
            return this.myBuilder.build();
        }

        @Override
        protected void settingsChanged(ScriptingOptions options) {
            this.myBuilder.setOptions(options);
            this.generate();
        }

        private void generate() {
            ScriptingResult script = ScriptGenerators.INSTANCE.makeScript(this.myProject, this.getTask());
            this.updateText(script);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectEditorBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectEditorBase";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPreviewActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CompoundObjectEditor
    extends DbObjectEditor {
        private final List<DbObjectEditor> myEditors;
        private final JComponent myComponent;
        public static final int SMALL_WIDTH = 2;
        public static final int GRID_WIDTH = 6;

        public CompoundObjectEditor(@NotNull List<DbObjectEditor> editors) {
            if (editors == null) {
                CompoundObjectEditor.$$$reportNull$$$0(0);
            }
            this.myEditors = editors;
            List<Pair<Integer, Integer>> cells = this.getCells();
            Pair last = (Pair)ContainerUtil.getLastItem(cells);
            this.myComponent = new JPanel((LayoutManager)new GridLayoutManager(last == null ? 1 : (Integer)last.first + 1, 6));
            for (int i2 = 0; i2 < editors.size(); ++i2) {
                DbObjectEditor editor = editors.get(i2);
                String title = editor.getTitle();
                TypesRegistry.ParamEditor.FieldSize size = editor.getFieldSize();
                Pair<Integer, Integer> cell = cells.get(i2);
                if (title != null) {
                    JBLabel label = new JBLabel(title);
                    this.myComponent.add((Component)label, UrlPropertiesPanel.createLabelConstraints((Integer)cell.first, (Integer)cell.second, label.getPreferredSize().getWidth()));
                }
                int offset = title == null ? 0 : 1;
                this.myComponent.add((Component)editor.getComponent(), UrlPropertiesPanel.createConstraints((Integer)cell.first, (Integer)cell.second + offset, this.getWidth(size) - offset, 0, 1, -1, true));
            }
        }

        @NotNull
        public List<DbObjectEditor> getEditors() {
            List<DbObjectEditor> list = this.myEditors;
            if (list == null) {
                CompoundObjectEditor.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public List<Pair<Integer, Integer>> getCells() {
            ArrayList<Pair<Integer, Integer>> cells = new ArrayList<Pair<Integer, Integer>>();
            int row = 0;
            int col = 0;
            for (DbObjectEditor editor : this.myEditors) {
                TypesRegistry.ParamEditor.FieldSize s = editor.getFieldSize();
                int w = this.getWidth(s);
                if (col + w > 6) {
                    col = 0;
                    ++row;
                }
                cells.add((Pair<Integer, Integer>)Pair.create((Object)row, (Object)col));
                col += w;
            }
            ArrayList<Pair<Integer, Integer>> arrayList = cells;
            if (arrayList == null) {
                CompoundObjectEditor.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        protected int getWidth(TypesRegistry.ParamEditor.FieldSize s) {
            return s == TypesRegistry.ParamEditor.FieldSize.LARGE ? 6 : (s == TypesRegistry.ParamEditor.FieldSize.MEDIUM ? 4 : 2);
        }

        @Override
        public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
            if (e == null) {
                CompoundObjectEditor.$$$reportNull$$$0(3);
            }
            for (DbObjectEditor editor : this.myEditors) {
                editor.apply(edited, e);
            }
        }

        @Override
        public void reset(@NotNull BasicElement e) {
            if (e == null) {
                CompoundObjectEditor.$$$reportNull$$$0(4);
            }
            for (DbObjectEditor editor : this.myEditors) {
                editor.reset(e);
            }
        }

        @Override
        public void enable(@NotNull Function<BasicMetaProperty<?>, Boolean> enabled) {
            if (enabled == null) {
                CompoundObjectEditor.$$$reportNull$$$0(5);
            }
            for (DbObjectEditor editor : this.myEditors) {
                editor.enable(enabled);
            }
        }

        @Override
        public void initCompletion(@NotNull BasicModel model) {
            if (model == null) {
                CompoundObjectEditor.$$$reportNull$$$0(6);
            }
            for (DbObjectEditor editor : this.myEditors) {
                editor.initCompletion(model);
            }
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                CompoundObjectEditor.$$$reportNull$$$0(7);
            }
            return jComponent;
        }

        @Override
        @Nullable
        public String getTitle() {
            return null;
        }

        @Override
        @NotNull
        public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
            TypesRegistry.ParamEditor.FieldSize fieldSize = TypesRegistry.ParamEditor.FieldSize.LARGE;
            if (fieldSize == null) {
                CompoundObjectEditor.$$$reportNull$$$0(8);
            }
            return fieldSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$CompoundObjectEditor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enabled";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$CompoundObjectEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditors";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCells";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "enable";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "initCompletion";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbObjectEnumPropEditor
    extends DbObjectSinglePropEditor<Enum<?>> {
        private final ComboBox<Enum<?>> myBox;

        public DbObjectEnumPropEditor(@NotNull BasicMetaProperty<Enum<?>> property, @Nullable String title) {
            if (property == null) {
                DbObjectEnumPropEditor.$$$reportNull$$$0(0);
            }
            super(property, title);
            this.myBox = new ComboBox((Object[])property.getValueClass().getEnumConstants());
        }

        @Override
        public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
            if (e == null) {
                DbObjectEnumPropEditor.$$$reportNull$$$0(1);
            }
            this.myProperty.set(e, (Enum)this.myBox.getSelectedItem());
        }

        @Override
        public void reset(@NotNull BasicElement e) {
            if (e == null) {
                DbObjectEnumPropEditor.$$$reportNull$$$0(2);
            }
            this.myBox.setSelectedItem(this.myProperty.get(e));
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            ComboBox<Enum<?>> comboBox = this.myBox;
            if (comboBox == null) {
                DbObjectEnumPropEditor.$$$reportNull$$$0(3);
            }
            return comboBox;
        }

        @Override
        @NotNull
        public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
            TypesRegistry.ParamEditor.FieldSize fieldSize = TypesRegistry.ParamEditor.FieldSize.MEDIUM;
            if (fieldSize == null) {
                DbObjectEnumPropEditor.$$$reportNull$$$0(4);
            }
            return fieldSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectEnumPropEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectEnumPropEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbObjectBoolPropEditor
    extends DbObjectSinglePropEditor<Boolean> {
        private final JBCheckBox myBox;

        public DbObjectBoolPropEditor(@NotNull BasicMetaProperty<Boolean> property, @Nullable String title) {
            if (property == null) {
                DbObjectBoolPropEditor.$$$reportNull$$$0(0);
            }
            super(property, null);
            this.myBox = new JBCheckBox(title);
        }

        @Override
        public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
            if (e == null) {
                DbObjectBoolPropEditor.$$$reportNull$$$0(1);
            }
            this.myProperty.set(e, this.myBox.isSelected());
        }

        @Override
        public void reset(@NotNull BasicElement e) {
            if (e == null) {
                DbObjectBoolPropEditor.$$$reportNull$$$0(2);
            }
            this.myBox.setSelected(Boolean.TRUE.equals(this.myProperty.get(e)));
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JBCheckBox jBCheckBox = this.myBox;
            if (jBCheckBox == null) {
                DbObjectBoolPropEditor.$$$reportNull$$$0(3);
            }
            return jBCheckBox;
        }

        @Override
        @NotNull
        public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
            TypesRegistry.ParamEditor.FieldSize fieldSize = TypesRegistry.ParamEditor.FieldSize.SMALL;
            if (fieldSize == null) {
                DbObjectBoolPropEditor.$$$reportNull$$$0(4);
            }
            return fieldSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectBoolPropEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectBoolPropEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbObjectTextCollectionPropEditor<T, C extends Collection<T>>
    extends DbObjectSinglePropEditor<C> {
        private final Function<? super T, String> myFrom;
        private final Function<? super String, ? extends T> myTo;
        private final Factory<? extends C> myFac;
        private final JTextField myTextField;

        public DbObjectTextCollectionPropEditor(@NotNull BasicMetaProperty<C> property, @Nullable String title, @NotNull Function<? super T, String> from, @NotNull Function<? super String, ? extends T> to, @NotNull Factory<? extends C> fac) {
            if (property == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(1);
            }
            if (to == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(2);
            }
            if (fac == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(3);
            }
            super(property, title);
            this.myFrom = from;
            this.myTo = to;
            this.myFac = fac;
            this.myTextField = new JTextField();
        }

        @Override
        public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
            if (e == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(4);
            }
            try {
                this.myProperty.set(e, JBIterable.from((Iterable)StringUtil.split((String)this.myTextField.getText(), (String)",")).map(this.myTo).addAllTo((Collection)this.myFac.create()));
                DbObjectEditorFactory.setError(this.myTextField, null);
            }
            catch (Throwable th) {
                DbObjectEditorFactory.setError(this.myTextField, th.getMessage());
            }
        }

        @Override
        public void reset(@NotNull BasicElement e) {
            if (e == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(5);
            }
            this.myTextField.setText(StringUtil.join((Iterable)JBIterable.from((Iterable)((Iterable)this.myProperty.get(e))).map(this.myFrom), (String)","));
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JTextField jTextField = this.myTextField;
            if (jTextField == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(6);
            }
            return jTextField;
        }

        @Override
        @NotNull
        public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
            TypesRegistry.ParamEditor.FieldSize fieldSize = TypesRegistry.ParamEditor.FieldSize.LARGE;
            if (fieldSize == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(7);
            }
            return fieldSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fac";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectTextCollectionPropEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectTextCollectionPropEditor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbSeqIdPropEditor
    extends DbObjectSinglePropEditor<SequenceIdentity> {
        private final JComponent myPanel;
        private final JTextField myMin;
        private final JTextField myMax;
        private final JTextField myStep;

        protected DbSeqIdPropEditor(@NotNull BasicMetaProperty<SequenceIdentity> property, @Nullable String title) {
            if (property == null) {
                DbSeqIdPropEditor.$$$reportNull$$$0(0);
            }
            super(property, null);
            this.myPanel = new JPanel((LayoutManager)new GridLayoutManager(1, 6));
            this.myMin = this.addField("Min", 0);
            this.myMax = this.addField("Max", 2);
            this.myStep = this.addField("Step", 4);
        }

        private JTextField addField(String title, int base) {
            JBLabel lbl = new JBLabel(title);
            this.myPanel.add((Component)lbl, UrlPropertiesPanel.createLabelConstraints(0, base, lbl.getPreferredSize().width));
            JTextField field = new JTextField();
            this.myPanel.add((Component)field, UrlPropertiesPanel.createSimpleConstraints(0, base + 1, 1));
            return field;
        }

        @Override
        public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
            if (e == null) {
                DbSeqIdPropEditor.$$$reportNull$$$0(1);
            }
            BigInteger min = DbSeqIdPropEditor.getVal(this.myMin);
            BigInteger max = DbSeqIdPropEditor.getVal(this.myMax);
            BigInteger step = DbSeqIdPropEditor.getVal(this.myStep);
            SequenceIdentity prev = edited == null ? null : (SequenceIdentity)this.myProperty.get(edited);
            BigInteger next = prev == null ? null : prev.next;
            this.myProperty.set(e, SequenceIdentity.of(min, next, step, max));
        }

        @Nullable
        private static BigInteger getVal(JTextField field) {
            String text2 = field.getText();
            if (StringUtil.isEmpty((String)text2)) {
                return null;
            }
            try {
                BigInteger val = new BigInteger(text2);
                DbObjectEditorFactory.setError(field, null);
                return val;
            }
            catch (Throwable th) {
                DbObjectEditorFactory.setError(field, th.getMessage());
                return null;
            }
        }

        @Override
        public void reset(@NotNull BasicElement e) {
            SequenceIdentity se;
            if (e == null) {
                DbSeqIdPropEditor.$$$reportNull$$$0(2);
            }
            BigInteger min = (se = (SequenceIdentity)this.myProperty.get(e)) == null ? null : se.min;
            BigInteger max = se == null ? null : se.max;
            BigInteger increment = se == null ? null : se.increment;
            this.myMin.setText(min == null ? "" : min.toString());
            this.myMax.setText(max == null ? "" : max.toString());
            this.myStep.setText(increment == null ? "" : increment.toString());
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myPanel;
            if (jComponent == null) {
                DbSeqIdPropEditor.$$$reportNull$$$0(3);
            }
            return jComponent;
        }

        @Override
        @NotNull
        public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
            TypesRegistry.ParamEditor.FieldSize fieldSize = TypesRegistry.ParamEditor.FieldSize.LARGE;
            if (fieldSize == null) {
                DbSeqIdPropEditor.$$$reportNull$$$0(4);
            }
            return fieldSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbSeqIdPropEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbSeqIdPropEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbObjectReferencePropEditor
    extends DbObjectSinglePropEditor<String> {
        private final TextFieldWithCompletion myTextField;
        private final BasicMetaObject<?> myMeta;
        private JBIterable<BasicElement> myTraverser;

        public DbObjectReferencePropEditor(@NotNull Project project, @NotNull BasicMetaProperty<String> property, @Nullable String title, @NotNull BasicMetaObject<?> meta) {
            if (project == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(0);
            }
            if (property == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(1);
            }
            if (meta == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(2);
            }
            super(property, title);
            this.myTextField = new TextFieldWithCompletion(project, (TextCompletionProvider)new TextFieldCompletionProvider(){

                protected void addCompletionVariants(@NotNull String text2, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
                    if (text2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (prefix == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (result == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    this.addVariants(result);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "text";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "prefix";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "result";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectReferencePropEditor$1";
                    objectArray[2] = "addCompletionVariants";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, "", true, true, true);
            this.myMeta = meta;
        }

        private void addVariants(@NotNull CompletionResultSet result) {
            if (result == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(3);
            }
            if (this.myTraverser != null) {
                result.addAllElements((Iterable)this.myTraverser.filter(o -> result.getPrefixMatcher().prefixMatches(o.getName())).map(o -> LookupElementBuilder.create((String)o.getName()).withIcon(DbPresentation.getIcon(o)).withTypeText(DbPresentation.getPresentableName(o.getMetaObject()))));
            }
            result.stopHere();
        }

        @Override
        public void initCompletion(@Nullable BasicModel model) {
            if (model == null) {
                this.myTraverser = null;
                return;
            }
            HashSet metas = new HashSet();
            for (BasicMetaObject<?> t = this.myMeta; t != null; t = t.getParent()) {
                metas.add(t);
            }
            this.myTraverser = ((JBTreeTraverser)JBTreeTraverser.from(o -> JBIterable.from(o.getFamilies()).filter(f -> metas.contains(f.getMetaObject())).flatten((Function)Functions.id())).withRoot((Object)model.getRoot())).traverse().filter(o -> o.getMetaObject() == this.myMeta);
        }

        @Override
        public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
            if (e == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(4);
            }
            this.myProperty.set(e, this.myTextField.getText());
        }

        @Override
        public void reset(@NotNull BasicElement e) {
            if (e == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(5);
            }
            this.myTextField.setText((String)this.myProperty.get(e));
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            TextFieldWithCompletion textFieldWithCompletion = this.myTextField;
            if (textFieldWithCompletion == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(6);
            }
            return textFieldWithCompletion;
        }

        @Override
        @NotNull
        public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
            TypesRegistry.ParamEditor.FieldSize fieldSize = TypesRegistry.ParamEditor.FieldSize.LARGE;
            if (fieldSize == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(7);
            }
            return fieldSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectReferencePropEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectReferencePropEditor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addVariants";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbObjectTextPropEditor<T>
    extends DbObjectSinglePropEditor<T> {
        private final Function<? super T, String> myFrom;
        private final Function<? super String, ? extends T> myTo;
        private final JTextField myTextField;

        public DbObjectTextPropEditor(@NotNull BasicMetaProperty<T> property, @Nullable String title, @NotNull Function<? super T, String> from, @NotNull Function<? super String, ? extends T> to) {
            if (property == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(1);
            }
            if (to == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(2);
            }
            super(property, title);
            this.myFrom = from;
            this.myTo = to;
            this.myTextField = new JTextField();
        }

        @Override
        public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
            if (e == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(3);
            }
            try {
                this.myProperty.set(e, this.myTo.fun((Object)this.myTextField.getText()));
                DbObjectEditorFactory.setError(this.myTextField, null);
            }
            catch (Throwable th) {
                DbObjectEditorFactory.setError(this.myTextField, th.getMessage());
            }
        }

        @Override
        public void reset(@NotNull BasicElement e) {
            if (e == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(4);
            }
            this.myTextField.setText((String)this.myFrom.fun(this.myProperty.get(e)));
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JTextField jTextField = this.myTextField;
            if (jTextField == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(5);
            }
            return jTextField;
        }

        @Override
        @NotNull
        public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
            TypesRegistry.ParamEditor.FieldSize fieldSize = TypesRegistry.ParamEditor.FieldSize.LARGE;
            if (fieldSize == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(6);
            }
            return fieldSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectTextPropEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectTextPropEditor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class DbObjectSinglePropEditor<T>
    extends DbObjectEditor {
        protected final BasicMetaProperty<T> myProperty;
        private final String myTitle;

        protected DbObjectSinglePropEditor(@NotNull BasicMetaProperty<T> property, @Nullable String title) {
            if (property == null) {
                DbObjectSinglePropEditor.$$$reportNull$$$0(0);
            }
            this.myProperty = property;
            this.myTitle = title;
        }

        @Override
        public String getTitle() {
            return this.myTitle;
        }

        @Override
        public void enable(@NotNull Function<BasicMetaProperty<?>, Boolean> enabled) {
            if (enabled == null) {
                DbObjectSinglePropEditor.$$$reportNull$$$0(1);
            }
            boolean state = (Boolean)enabled.fun(this.myProperty);
            JComponent component = this.getComponent();
            component.setEnabled(state);
            component.setToolTipText(state ? "" : "Not supported");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enabled";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectSinglePropEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "enable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class DbObjectEditor {
        public abstract void apply(@Nullable BasicElement var1, @NotNull BasicModElement var2);

        public abstract void reset(@NotNull BasicElement var1);

        public abstract void enable(@NotNull Function<BasicMetaProperty<?>, Boolean> var1);

        public void initCompletion(@NotNull BasicModel model) {
            if (model == null) {
                DbObjectEditor.$$$reportNull$$$0(0);
            }
        }

        @Nullable
        public abstract String getTitle();

        @NotNull
        public abstract JComponent getComponent();

        @NotNull
        public abstract TypesRegistry.ParamEditor.FieldSize getFieldSize();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectEditor", "initCompletion"));
        }
    }
}

