/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.text;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RawIndexConverter;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractionConfigKt;
import com.intellij.database.extractors.TranspositionAwareExtractor;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.text.TextRawIndexConverter;
import com.intellij.database.run.ui.text.TextResultViewSearchSession;
import com.intellij.database.util.CharOut;
import com.intellij.find.FindModel;
import com.intellij.find.SearchSession;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextResultView
implements ResultView {
    private static final Logger LOG = Logger.getInstance(TextResultView.class);
    private final TableResultPanel myResultPanel;
    private final EditorEx myViewer;
    private final TextRawIndexConverter myRawIndexConverter;
    private final ThreadPoolExecutor myExecutor;
    private Future<?> myLastExtractorTask;
    private boolean myTransposed;

    public TextResultView(@NotNull TableResultPanel resultPanel) {
        if (resultPanel == null) {
            TextResultView.$$$reportNull$$$0(0);
        }
        this.myExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)this.getClass().getSimpleName());
        this.myLastExtractorTask = null;
        this.myResultPanel = resultPanel;
        this.myViewer = TextResultView.createEditor(DataGridUtil.getProject(this.myResultPanel), "textView");
        this.myViewer.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        this.myViewer.setColorsScheme(this.myViewer.createBoundColorSchemeDelegate((EditorColorsScheme)this.myResultPanel.getColorsScheme()));
        TextResultView.updateColorScheme(this.myViewer);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(EditorColorsManager.TOPIC, scheme -> {
            this.myResultPanel.getComponent().globalSchemeChange(scheme);
            this.myViewer.reinitSettings();
        });
        this.myRawIndexConverter = new TextRawIndexConverter();
        GridModel<DataConsumer.Row, DataConsumer.Column> model = this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        this.updateText(model.getRows());
    }

    private static void updateColorScheme(@NotNull EditorEx editor) {
        if (editor == null) {
            TextResultView.$$$reportNull$$$0(1);
        }
        Color backgroundColor = editor.getColorsScheme().getDefaultBackground();
        editor.setBackgroundColor(backgroundColor);
        editor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, backgroundColor);
    }

    @Override
    public void defaultBackgroundChanged() {
        TextResultView.updateColorScheme(this.myViewer);
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            TextResultView.$$$reportNull$$$0(2);
        }
        if (name == null) {
            TextResultView.$$$reportNull$$$0(3);
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name, (Language)PlainTextLanguage.INSTANCE, (CharSequence)"");
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
        document = document != null ? document : EditorFactory.getInstance().createDocument((CharSequence)"");
        EditorEx editor = (EditorEx)EditorFactory.getInstance().createViewer(document, project);
        editor.setEmbeddedIntoDialogWrapper(true);
        editor.getSettings().setAdditionalLinesCount(3);
        editor.getSettings().setAdditionalColumnsCount(3);
        editor.getSettings().setFoldingOutlineShown(true);
        editor.getSettings().setCaretRowShown(true);
        editor.setCaretEnabled(true);
        editor.setHorizontalScrollbarVisible(true);
        editor.setVerticalScrollbarVisible(true);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            TextResultView.$$$reportNull$$$0(4);
        }
        return editorEx;
    }

    @Override
    public void setTransposed(boolean transposed) {
        if (this.myTransposed == transposed) {
            return;
        }
        this.myTransposed = transposed;
        this.dataUpdated();
    }

    @Override
    public boolean isTransposed() {
        return this.myTransposed;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myViewer.getContentComponent();
        if (jComponent == null) {
            TextResultView.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @Override
    public void registerEscapeAction(@NotNull AbstractAction action2) {
        if (action2 == null) {
            TextResultView.$$$reportNull$$$0(6);
        }
        String actionId = "grid.escape";
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.myViewer.getContentComponent().getInputMap(0).put(keyStroke, actionId);
        this.myViewer.getContentComponent().getActionMap().put(actionId, action2);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myViewer.getComponent();
        if (jComponent == null) {
            TextResultView.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    @NotNull
    public EditorEx getViewer() {
        EditorEx editorEx = this.myViewer;
        if (editorEx == null) {
            TextResultView.$$$reportNull$$$0(8);
        }
        return editorEx;
    }

    @Override
    public void resetLayout() {
    }

    @Override
    public void setColumnEnabled(@NotNull ModelIndex<DataConsumer.Column> columnIdx, boolean state) {
        if (columnIdx == null) {
            TextResultView.$$$reportNull$$$0(9);
        }
    }

    @Override
    public void setRowEnabled(@NotNull ModelIndex<DataConsumer.Row> rowIdx, boolean state) {
        if (rowIdx == null) {
            TextResultView.$$$reportNull$$$0(10);
        }
    }

    @Override
    public void showFirstCell(int rowNumOnCurrentPage) {
    }

    @Override
    public void growSelection() {
    }

    @Override
    public void addSelectionChangedListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            TextResultView.$$$reportNull$$$0(11);
        }
    }

    @Override
    public void setCommonEditorValue(@Nullable Object object) {
    }

    @Override
    public void restoreColumnsOrder(Map<Integer, ModelIndex<DataConsumer.Column>> expectedToModel) {
    }

    @NotNull
    public GridColorsScheme getColorsScheme() {
        GridColorsScheme gridColorsScheme = this.myResultPanel.getColorsScheme();
        if (gridColorsScheme == null) {
            TextResultView.$$$reportNull$$$0(12);
        }
        return gridColorsScheme;
    }

    @Override
    public boolean isEditing() {
        return false;
    }

    @Override
    public boolean isMultiEditingAllowed() {
        return false;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getVisibleRows() {
        ModelIndexSet<DataConsumer.Row> modelIndexSet = ModelIndexSet.forRows(this.myResultPanel, new int[0]);
        if (modelIndexSet == null) {
            TextResultView.$$$reportNull$$$0(13);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getVisibleColumns() {
        ModelIndexSet<DataConsumer.Column> modelIndexSet = ModelIndexSet.forColumns(this.myResultPanel, new int[0]);
        if (modelIndexSet == null) {
            TextResultView.$$$reportNull$$$0(14);
        }
        return modelIndexSet;
    }

    @Override
    public int getViewColumnCount() {
        return 0;
    }

    @Override
    public int getViewRowCount() {
        return 0;
    }

    @Override
    public boolean stopEditing() {
        return false;
    }

    @Override
    public void cancelEditing() {
    }

    @Override
    public boolean isViewModified() {
        return false;
    }

    @Override
    public void contentLanguageUpdated(@NotNull ModelIndex<DataConsumer.Column> idx, @NotNull Language language) {
        if (idx == null) {
            TextResultView.$$$reportNull$$$0(15);
        }
        if (language == null) {
            TextResultView.$$$reportNull$$$0(16);
        }
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> getContextColumn() {
        ModelIndex<DataConsumer.Column> modelIndex = ModelIndex.forColumn(this.myResultPanel, -1);
        if (modelIndex == null) {
            TextResultView.$$$reportNull$$$0(17);
        }
        return modelIndex;
    }

    @Override
    public void updateSortKeysFromColumnAttributes() {
    }

    @Override
    public void orderingAndVisibilityChanged() {
    }

    @Override
    @NotNull
    public RawIndexConverter getRawIndexConverter() {
        TextRawIndexConverter textRawIndexConverter = this.myRawIndexConverter;
        if (textRawIndexConverter == null) {
            TextResultView.$$$reportNull$$$0(18);
        }
        return textRawIndexConverter;
    }

    @Override
    public void addMouseListener(final @NotNull MouseListener listener2) {
        if (listener2 == null) {
            TextResultView.$$$reportNull$$$0(19);
        }
        this.myViewer.addEditorMouseListener(new EditorMouseListener(){

            public void mousePressed(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                listener2.mousePressed(event.getMouseEvent());
            }

            public void mouseClicked(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                listener2.mouseClicked(event.getMouseEvent());
            }

            public void mouseReleased(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                listener2.mouseReleased(event.getMouseEvent());
            }

            public void mouseEntered(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                listener2.mouseEntered(event.getMouseEvent());
            }

            public void mouseExited(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(4);
                }
                listener2.mouseExited(event.getMouseEvent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/database/run/ui/text/TextResultView$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mousePressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseClicked";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseReleased";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseEntered";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseExited";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    @Nullable
    public SearchSession createSearchSession(@Nullable FindModel findModel) {
        FindModel newFindModel;
        FindModel findModel2 = newFindModel = findModel == null ? null : new FindModel();
        if (findModel != null) {
            newFindModel.copyFrom(findModel);
        }
        return findModel == null ? new TextResultViewSearchSession((Editor)this.myViewer, this.myResultPanel.getProject(), this.myResultPanel) : new TextResultViewSearchSession((Editor)this.myViewer, this.myResultPanel.getProject(), this.myResultPanel, newFindModel);
    }

    @Override
    public void columnsAdded(ModelIndexSet<DataConsumer.Column> columns) {
    }

    @Override
    public void columnsRemoved(ModelIndexSet<DataConsumer.Column> columns) {
    }

    @Override
    public void rowsAdded(ModelIndexSet<DataConsumer.Row> rows) {
        this.dataUpdated();
    }

    @Override
    public void rowsRemoved(ModelIndexSet<DataConsumer.Row> rows) {
        this.dataUpdated();
    }

    @Override
    public void cellsUpdated(ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> columns) {
        this.dataUpdated();
    }

    @Override
    public void extractorFactoryChanged() {
        this.dataUpdated();
    }

    private void dataUpdated() {
        GridModel<DataConsumer.Row, DataConsumer.Column> model = this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        this.updateText(ContainerUtil.copyList(model.getRows()));
    }

    private void updateText(@NotNull List<DataConsumer.Row> rows) {
        if (rows == null) {
            TextResultView.$$$reportNull$$$0(20);
        }
        Condition disposed = __ -> Disposer.isDisposed((Disposable)this);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (disposed.value(null)) {
                return;
            }
            DataExtractorFactory.Text extractorFactory = this.myResultPanel.getExtractorFactory();
            DataExtractor.Text extractor = extractorFactory.createExtractor(dataId -> dataId.equals(DatabaseDataKeys.DATA_GRID_KEY.getName()) ? this.myResultPanel : null);
            if (extractor == null) {
                LOG.error("Cannot create data extractor. DataExtractorFactory: " + extractorFactory.getName());
                TextResultView.updateEditorText(this.myViewer, DataGridUtil.getProject(this.myResultPanel), "", (Language)PlainTextLanguage.INSTANCE);
                return;
            }
            Language guessedLanguage = LanguageUtil.getFileTypeLanguage((FileType)FileTypeRegistry.getInstance().getFileTypeByExtension(extractor.getFileExtension()));
            Language language = (Language)ObjectUtils.notNull((Object)guessedLanguage, (Object)PlainTextLanguage.INSTANCE);
            GridModel<DataConsumer.Row, DataConsumer.Column> model = this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
            List<DataConsumer.Column> allColumns = model.getColumns();
            int[] cols = model.getColumnIndices().asArray();
            Dbms dbms = DataGridUtil.getDbms(this.myResultPanel);
            StringBuilder sb = new StringBuilder();
            CharOut out = CharOut.Util.newSink(sb);
            JBIterable iterable = JBIterable.from((Iterable)rows);
            if (this.myLastExtractorTask != null) {
                this.myLastExtractorTask.cancel(false);
            }
            PageSpec pageOfThisExtractor = this.getCurrentPage();
            this.myLastExtractorTask = this.myExecutor.submit(() -> {
                int chunkSize;
                DataExtractor.Extraction e = extractor.startExtraction(out, dbms, allColumns, ExtractionConfigKt.builder().setTransposed(this.myTransposed).build(), cols);
                int size = iterable.size();
                int showedRowsCount = 0;
                for (int i2 = 0; i2 < size; i2 += chunkSize) {
                    chunkSize = TextResultView.chunkSize(i2, extractor instanceof TranspositionAwareExtractor);
                    e.addData(iterable.skip(i2).take(chunkSize).toList());
                    showedRowsCount += chunkSize;
                    if (out.length() > (long)(FileUtilRt.LARGE_FOR_CONTENT_LOADING / 2)) break;
                }
                e.complete();
                String postfix = size > showedRowsCount ? "\nResult is too big. Only first " + showedRowsCount + " entries are shown" : "";
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!this.getCurrentPage().equals(pageOfThisExtractor)) {
                        return;
                    }
                    TextResultView.updateEditorText(this.myViewer, DataGridUtil.getProject(this.myResultPanel), sb.toString() + postfix, language);
                }, disposed);
            });
        }, disposed);
    }

    public static void updateEditorText(@NotNull EditorEx editor, @NotNull Project project, @NotNull String text2, @NotNull Language language) {
        if (editor == null) {
            TextResultView.$$$reportNull$$$0(21);
        }
        if (project == null) {
            TextResultView.$$$reportNull$$$0(22);
        }
        if (text2 == null) {
            TextResultView.$$$reportNull$$$0(23);
        }
        if (language == null) {
            TextResultView.$$$reportNull$$$0(24);
        }
        DocumentEx document = editor.getDocument();
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            document.replaceString(0, document.getTextLength(), (CharSequence)StringUtil.convertLineSeparators((String)text2));
            CaretModel caretModel = editor.getCaretModel();
            if (caretModel.getOffset() >= document.getTextLength()) {
                caretModel.moveToOffset(document.getTextLength());
            }
        });
        LightVirtualFile virtualFile = (LightVirtualFile)ObjectUtils.tryCast((Object)FileDocumentManager.getInstance().getFile((Document)document), LightVirtualFile.class);
        if (virtualFile == null) {
            return;
        }
        if (virtualFile.getLanguage() == language) {
            return;
        }
        virtualFile.setLanguage(language);
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)project, (VirtualFile)virtualFile);
        editor.setHighlighter(highlighter);
        FileContentUtil.reparseFiles((Project)project, Collections.singletonList(virtualFile), (boolean)false);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)document);
        if (psiFile != null) {
            DaemonCodeAnalyzer.getInstance((Project)project).setHighlightingEnabled(psiFile, !(language instanceof SqlLanguage));
        }
    }

    private static int chunkSize(int startIdx, boolean isTranspositionAware) {
        if (isTranspositionAware) {
            return 100;
        }
        if (startIdx < 20) {
            return 2;
        }
        if (startIdx < 100) {
            return 5;
        }
        return 20;
    }

    @NotNull
    private PageSpec getCurrentPage() {
        GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel = this.myResultPanel.getDataHookup().getPageModel();
        return new PageSpec(pageModel.getPageStart(), pageModel.getPageEnd());
    }

    @Override
    public void searchSessionUpdated() {
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor((Editor)this.myViewer);
        this.myExecutor.shutdown();
    }

    public void shutdownAndAwaitTermination() {
        this.myExecutor.shutdown();
        try {
            this.myExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Text result view termination interrupted", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/text/TextResultView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/text/TextResultView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleRows";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleColumns";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextColumn";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawIndexConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateColorScheme";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerEscapeAction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setColumnEnabled";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setRowEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionChangedListener";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "contentLanguageUpdated";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addMouseListener";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "updateEditorText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PageSpec {
        final int myPageStart;
        final int myPageEnd;

        PageSpec(int pageStart, int pageEnd) {
            this.myPageStart = pageStart;
            this.myPageEnd = pageEnd;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageSpec spec = (PageSpec)o;
            return this.myPageStart == spec.myPageStart && this.myPageEnd == spec.myPageEnd;
        }

        public int hashCode() {
            return Objects.hash(this.myPageStart, this.myPageEnd);
        }

        public String toString() {
            return "PageSpec{" + this.myPageStart + ", " + this.myPageEnd + '}';
        }
    }
}

