/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.grid.GridScrollPositionManager;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.ui.TableUtil;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class TableScrollPositionManager
implements GridScrollPositionManager {
    private final TableResultView myResultView;
    private final DataGrid myGrid;

    TableScrollPositionManager(@NotNull TableResultView resultView, @NotNull DataGrid grid) {
        if (resultView == null) {
            TableScrollPositionManager.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            TableScrollPositionManager.$$$reportNull$$$0(1);
        }
        this.myResultView = resultView;
        this.myGrid = grid;
        this.myResultView.putClientProperty("GridScrollPositionManager", this);
    }

    @Override
    public GridScrollPositionManager.GridScrollPosition store() {
        Rectangle visibleRect = this.myResultView.getVisibleRect();
        Point p2 = visibleRect.getLocation();
        ++p2.x;
        ++p2.y;
        int row = this.myResultView.rowAtPoint(p2);
        int column = this.myResultView.columnAtPoint(p2);
        int modelRow = this.myResultView.getRawIndexConverter().row2Model().fun(this.myResultView.isTransposed() ? column : row);
        int modelColumn = this.myResultView.getRawIndexConverter().column2Model().fun(this.myResultView.isTransposed() ? row : column);
        return new GridScrollPositionManager.GridScrollPosition(ModelIndex.forRow(this.myGrid, modelRow), ModelIndex.forColumn(this.myGrid, modelColumn));
    }

    @Override
    public void restore(@NotNull GridScrollPositionManager.GridScrollPosition position) {
        if (position == null) {
            TableScrollPositionManager.$$$reportNull$$$0(2);
        }
        int viewRow = this.myResultView.getRawIndexConverter().row2View().fun(position.myTopRowIdx.value);
        int viewColumn = this.myResultView.getRawIndexConverter().column2View().fun(position.myLeftColumnIdx.value);
        Rectangle targetRect = this.myResultView.getCellRect(this.myResultView.isTransposed() ? viewColumn : viewRow, this.myResultView.isTransposed() ? viewRow : viewColumn, true);
        Rectangle visibleRect = this.myResultView.getVisibleRect();
        targetRect.width = visibleRect.width;
        targetRect.height = visibleRect.height;
        this.myResultView.scrollRectToVisible(targetRect);
    }

    @Override
    public void scrollSelectionToVisible() {
        TableUtil.scrollSelectionToVisible((JTable)((Object)this.myResultView));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/table/TableScrollPositionManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "restore";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

