/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.util.containers.ContainerUtil;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeFormatter
implements Formatter {
    private final Formatter[] myFormatters;
    private final Formatter myBaseFormatter;

    public CompositeFormatter(@NotNull List<Formatter> formatters) {
        if (formatters == null) {
            CompositeFormatter.$$$reportNull$$$0(0);
        }
        this((Formatter[])ContainerUtil.toArray(formatters, Formatter[]::new));
    }

    public CompositeFormatter(Formatter ... formatters) {
        if (formatters == null) {
            CompositeFormatter.$$$reportNull$$$0(1);
        }
        if (formatters.length == 0) {
            throw new IllegalArgumentException("Formatters must contains at least one formatter");
        }
        this.myBaseFormatter = formatters[0];
        this.myFormatters = formatters;
    }

    @Override
    public Object parse(@NotNull String value2, @NotNull ParsePosition position) {
        if (value2 == null) {
            CompositeFormatter.$$$reportNull$$$0(2);
        }
        if (position == null) {
            CompositeFormatter.$$$reportNull$$$0(3);
        }
        ParsePosition internal = new ParsePosition(0);
        for (Formatter formatter : this.myFormatters) {
            internal.setIndex(0);
            internal.setErrorIndex(-1);
            Object result = formatter.parse(value2, internal);
            if (internal.getErrorIndex() != -1) continue;
            position.setIndex(internal.getIndex());
            return result;
        }
        position.setErrorIndex(internal.getErrorIndex());
        return null;
    }

    @Override
    public Object parse(@NotNull String value2) throws ParseException {
        if (value2 == null) {
            CompositeFormatter.$$$reportNull$$$0(4);
        }
        int errorOffset = 0;
        for (Formatter formatter : this.myFormatters) {
            try {
                return formatter.parse(value2);
            }
            catch (ParseException e) {
                errorOffset = e.getErrorOffset();
            }
        }
        throw new ParseException(value2, errorOffset);
    }

    @Override
    public String format(@NotNull Object value2) {
        if (value2 == null) {
            CompositeFormatter.$$$reportNull$$$0(5);
        }
        return this.myBaseFormatter.format(value2);
    }

    public String toString() {
        return this.myBaseFormatter.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatters";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/CompositeFormatter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "format";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

