/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.run.actions.ChoosePasteFormatAction;
import com.intellij.database.run.ui.grid.GridTransferableData;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridPasteProvider
implements PasteProvider {
    private final DataGrid myGrid;

    public GridPasteProvider(@NotNull DataGrid grid) {
        if (grid == null) {
            GridPasteProvider.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        GridTransferableData data;
        if (dataContext == null) {
            GridPasteProvider.$$$reportNull$$$0(1);
        }
        if ((data = GridPasteProvider.getTransferableData(DataGridUtil.getProject(this.myGrid))) == null) {
            return;
        }
        SelectionModel model = this.myGrid.getSelectionModel();
        ModelIndexSet rows = model.getSelectedRows();
        ModelIndexSet columns = model.getSelectedColumns();
        int minRow = DataGridUtil.min(rows.toView(this.myGrid));
        int minCol = DataGridUtil.min(columns.toView(this.myGrid));
        int rowOffset = minRow - data.getFirstRowIdx();
        int colOffset = minCol - data.getFirstColumnIdx();
        List<CellMutation.Builder> conversions = data.getConversions().stream().map(conversion -> conversion.copy().secondGrid(this.myGrid).secondSystem(DbImplUtil.getMaybeLocalDataSource((DasDataSource)DataGridUtil.getDatabaseSystem(this.myGrid))).secondDbms(DataGridUtil.getDbms(this.myGrid)).offset(rowOffset, colOffset).build()).filter(DataTypeConversion::isValid).map(DataTypeConversion::convert).collect(Collectors.toList());
        this.myGrid.getDataSupport().finishBuildingAndApply(conversions);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        CopyPasteManager manager;
        if (dataContext == null) {
            GridPasteProvider.$$$reportNull$$$0(2);
        }
        return (manager = CopyPasteManager.getInstance()).getContents(GridTransferableData.ourFlavor) instanceof GridTransferableData || manager.getContents(DataFlavor.stringFlavor) != null;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GridPasteProvider.$$$reportNull$$$0(3);
        }
        return this.myGrid.isReady() && this.myGrid.isEditable();
    }

    @Nullable
    private static GridTransferableData getTransferableData(@NotNull Project project) {
        Object data;
        if (project == null) {
            GridPasteProvider.$$$reportNull$$$0(4);
        }
        return (data = CopyPasteManager.getInstance().getContents(GridTransferableData.ourFlavor)) instanceof GridTransferableData ? (GridTransferableData)data : GridPasteProvider.createDataFromText(project);
    }

    @Nullable
    private static GridTransferableData createDataFromText(@NotNull Project project) {
        Object data;
        if (project == null) {
            GridPasteProvider.$$$reportNull$$$0(5);
        }
        if (!((data = CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)) instanceof String)) {
            return null;
        }
        String text2 = (String)data;
        List<DataTypeConversion.Builder> builders = GridPasteProvider.retrieveDataFromText(project, text2);
        return new GridTransferableData(builders, (Transferable)new TextTransferable(text2), 0, 0);
    }

    @NotNull
    private static List<DataTypeConversion.Builder> retrieveDataFromText(@NotNull Project project, @NotNull String text2) {
        if (project == null) {
            GridPasteProvider.$$$reportNull$$$0(6);
        }
        if (text2 == null) {
            GridPasteProvider.$$$reportNull$$$0(7);
        }
        ChoosePasteFormatAction.PasteType type = ChoosePasteFormatAction.PasteType.get();
        List<String[]> parsed = type.getParser().parse(project, text2);
        ArrayList<DataTypeConversion.Builder> conversions = new ArrayList<DataTypeConversion.Builder>();
        ArrayList<DataConsumer.Column> columns = new ArrayList<DataConsumer.Column>();
        for (int i2 = 0; i2 < parsed.size(); ++i2) {
            String[] record = parsed.get(i2);
            for (int j = 0; j < record.length; ++j) {
                String value2 = record[j];
                if (columns.size() <= j) {
                    columns.add(new DataConsumer.Column(j, "dummy", 12, "text", String.class.getName()));
                }
                DataConsumer.Column column = (DataConsumer.Column)columns.get(j);
                conversions.add(GridPasteProvider.createBuilder(i2, column, value2));
            }
        }
        ArrayList<DataTypeConversion.Builder> arrayList = conversions;
        if (arrayList == null) {
            GridPasteProvider.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static DataTypeConversion.Builder createBuilder(int row, @NotNull DataConsumer.Column column, Object value2) {
        if (column == null) {
            GridPasteProvider.$$$reportNull$$$0(9);
        }
        DataTypeConversion.Builder builder = new DataTypeConversion.Builder().firstColumn(column).firstRowIdx(row).firstColumnIdx(column.columnNum).firstDbms(Dbms.UNKNOWN).firstSystem(null).value(value2);
        if (builder == null) {
            GridPasteProvider.$$$reportNull$$$0(10);
        }
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridPasteProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridPasteProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveDataFromText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTransferableData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDataFromText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "retrieveDataFromText";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

