/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.diff.DbDiffElement;
import com.intellij.database.model.diff.DbDiffRoot;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.util.JdbcUtil;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffElement;
import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffModelHolder;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DbMigrationAction
extends IconWithTextAction
implements DirDiffModelHolder {
    private final Direction myDirection;
    private DirDiffModel myModel;

    public DbMigrationAction(Direction direction) {
        super(direction == Direction.FORWARD ? "Migrate &Left to Right" : "Migrate &Right to Left");
        this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
        this.getTemplatePresentation().setIcon(EmptyIcon.ICON_0);
        this.myDirection = direction;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DbMigrationAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(!this.myModel.getElements().isEmpty());
        JComponent component = (JComponent)e.getPresentation().getClientProperty(COMPONENT_KEY);
        if (component != null) {
            component.setToolTipText(e.getPresentation().getDescription());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ScriptingResult script;
        if (e == null) {
            DbMigrationAction.$$$reportNull$$$0(1);
        }
        DirDiffModel m = this.myModel;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        try {
            script = DbMigrationAction.createMigration(m, this.myDirection);
        }
        catch (UnsupportedOperationException uoe) {
            Component source = e.getInputEvent().getComponent();
            Messages.showErrorDialog((Component)source, (String)JdbcUtil.getMessage((Throwable)uoe), (String)"Migration Not Available");
            return;
        }
        DbDiffElement forDialect = (DbDiffElement)(this.myDirection == Direction.FORWARD ? m.getSourceDir() : m.getTargetDir());
        Language language = forDialect.getRoot().getLanguage();
        String sqlFileContent = script.getScriptText();
        final EditorFactory instance = Objects.requireNonNull(EditorFactory.getInstance());
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("migration.sql", language, (CharSequence)sqlFileContent);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        final Editor editor = instance.createViewer(document);
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)psiFile.getVirtualFile());
        ((EditorEx)editor).setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, editor.getColorsScheme()));
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        dialogBuilder.setCenterPanel(editor.getComponent());
        dialogBuilder.addCloseButton();
        DiffElement source = this.myDirection == Direction.FORWARD ? m.getSourceDir() : m.getTargetDir();
        DiffElement target = this.myDirection == Direction.FORWARD ? m.getTargetDir() : m.getSourceDir();
        dialogBuilder.setTitle("'" + source.getPresentablePath() + "' to '" + target.getPresentablePath() + "' Migration");
        dialogBuilder.showModal(false);
        dialogBuilder.addDisposable(new Disposable(){

            public void dispose() {
                instance.releaseEditor(editor);
            }
        });
    }

    private static BasicModel getModel(DirDiffModel model, boolean src, boolean isPrimary) {
        DbDiffRoot r = ((DbDiffElement)(src ? model.getSourceDir() : model.getTargetDir())).getRoot();
        if (isPrimary) {
            return r.getModel();
        }
        return (BasicModel)ObjectUtils.notNull((Object)r.getAltModel(), (Object)r.getModel());
    }

    private static BasicElement getElement(DirDiffElement d2, boolean src, boolean isPrimary) {
        DbDiffElement e = (DbDiffElement)(src ? d2.getSource() : d2.getTarget());
        if (e == null) {
            return null;
        }
        if (isPrimary || e.getRoot().getAltModel() == null) {
            return e.getValue();
        }
        return e.getAltElement();
    }

    public static ScriptingResult createMigration(DirDiffModel model, Direction direction) {
        List elements = model.getElements();
        boolean isFromSrc = direction == Direction.FORWARD;
        BasicModel src = DbMigrationAction.getModel(model, isFromSrc, true);
        BasicModel tgt = DbMigrationAction.getModel(model, !isFromSrc, false);
        ScriptingAlterTaskBuilder task = new ScriptingAlterTaskBuilder(src, tgt);
        for (DirDiffElement diff : elements) {
            if (diff.getOperation() == DirDiffOperation.NONE) continue;
            task.getCorrespondence().add(ElementDelta.create(DbMigrationAction.getElement(diff, isFromSrc, true), DbMigrationAction.getElement(diff, !isFromSrc, false)));
        }
        DbDiffRoot root2 = ((DbDiffElement)(isFromSrc ? model.getTargetDir() : model.getSourceDir())).getRoot();
        task.setOptions(root2.createOptions());
        return ScriptGenerators.INSTANCE.byModel(src).makeScript(root2.getProject(), task.build());
    }

    public void setModel(DirDiffModel model) {
        this.myModel = model;
        String source = this.myModel.getSourceDir().getPresentablePath();
        String target = this.myModel.getTargetDir().getPresentablePath();
        this.getTemplatePresentation().setDescription("Migrate '" + (this.myDirection == Direction.FORWARD ? source : target) + "' to '" + (this.myDirection == Direction.FORWARD ? target : source) + "' state");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/model/diff/DbMigrationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

