/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.DescriptionService$WhenMappings;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicDistTableColumn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicToggleable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.StringFun;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 a2\u00020\u0001:\u0002abB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u0018\u0010\u0018\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001aH\u0004J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0004J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\"H\u0004J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020$H\u0004J\u000e\u0010%\u001a\u00020\b2\u0006\u0010 \u001a\u00020&J\u0010\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020*H\u0004J\u0010\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010+\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020.H\u0014J\u000e\u0010/\u001a\u00020\b2\u0006\u0010,\u001a\u00020-J\u0018\u00100\u001a\u00020\b2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\fH\u0004J\u0018\u00104\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u000205H\u0004J\u001a\u00106\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u00107\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020:2\u0006\u00103\u001a\u00020\fH\u0004J\u0010\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020=H\u0014J \u0010;\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0004J\u0010\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020CH\u0004J\u0018\u0010A\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020CH\u0004J\u0010\u0010D\u001a\u00020\b2\u0006\u0010E\u001a\u00020FH\u0004J\u0018\u0010D\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020GH\u0004J\u0010\u0010H\u001a\u00020\b2\u0006\u0010I\u001a\u00020JH\u0004J \u0010H\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020K2\u0006\u0010?\u001a\u00020@H\u0004J\u0018\u0010L\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020MH\u0004J\u0010\u0010N\u001a\u00020\b2\u0006\u0010 \u001a\u00020OH\u0004J\u0010\u0010P\u001a\u00020\b2\u0006\u0010Q\u001a\u00020RH\u0014J\u0018\u0010P\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020RH\u0004J\u0018\u0010S\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020TH\u0004J\u0010\u0010U\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020VH\u0004J\u0010\u0010W\u001a\u00020\b2\u0006\u0010X\u001a\u00020YH\u0016J\u0018\u0010Z\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010[\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\b2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\b0]H\u0004J\u0018\u0010^\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010_\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020@2\u0006\u0010\u001e\u001a\u00020`2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006c"}, d2={"Lcom/intellij/database/model/DescriptionService;", "", "()V", "eoln", "", "getEoln", "()C", "indentStep", "", "getIndentStep", "()Ljava/lang/String;", "cascadeRuleIsMeaningful", "", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "e", "Lcom/intellij/database/model/basic/BasicElement;", "content", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeArgument", "a", "Lcom/intellij/database/model/basic/BasicArgument;", "describeBasicElement", "describeCheck", "check", "Lcom/intellij/database/model/basic/BasicCheck;", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "o", "describeColumn", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "Lcom/intellij/database/model/DasColumn;", "describeCustomType", "Lcom/intellij/database/model/DasUserDefinedType;", "describeDistColumn", "Lcom/intellij/database/model/basic/BasicDistTableColumn;", "describeForeignKey", "fk", "Lcom/intellij/database/model/basic/BasicForeignKey;", "Lcom/intellij/database/model/DasForeignKey;", "describeIndex", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "Lcom/intellij/database/model/DasIndex;", "describeIndexingItems", "describeKey", "key", "Lcom/intellij/database/model/basic/BasicKey;", "withSurrogates", "describeOperator", "Lcom/intellij/database/model/DasOperator;", "describePredicate", "predicate", "describeRoot", "root", "Lcom/intellij/database/model/basic/BasicRoot;", "describeRoutine", "r", "Lcom/intellij/database/model/basic/BasicRoutine;", "Lcom/intellij/database/model/DasRoutine;", "project", "Lcom/intellij/openapi/project/Project;", "describeSequence", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "describeSynonym", "synonym", "Lcom/intellij/database/model/basic/BasicSynonym;", "Lcom/intellij/database/model/DasSynonym;", "describeTable", "table", "Lcom/intellij/database/model/basic/BasicTable;", "Lcom/intellij/database/model/DasTable;", "describeTableKey", "Lcom/intellij/database/model/DasTableKey;", "describeTableOrViewColumn", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "describeTrigger", "trig", "Lcom/intellij/database/model/basic/BasicTrigger;", "describeTyped", "Lcom/intellij/database/model/DasTypedObject;", "describeTypedElement", "Lcom/intellij/database/model/basic/BasicTypedElement;", "describeView", "view", "Lcom/intellij/database/model/basic/BasicView;", "options", "presentIndexColumn", "descendants", "", "suffix", "updatePresentation", "Lcom/intellij/database/model/DasObject;", "Companion", "Context", "intellij.database.impl"})
public abstract class DescriptionService {
    @NotNull
    private final String indentStep = "    ";
    private final char eoln = (char)10;
    @JvmField
    @NotNull
    public static final DescriptionService DUMMY;
    public static final Companion Companion;

    @NotNull
    protected final String getIndentStep() {
        return this.indentStep;
    }

    protected final char getEoln() {
        return this.eoln;
    }

    @NotNull
    public String suffix(@NotNull BasicElement e, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return "";
    }

    @NotNull
    public String options(@NotNull BasicElement e, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (e.isAutoCreated() ? " [auto]" : "") + (e instanceof BasicSourceAware && ((BasicSourceAware)e).isWithDebugInfo() ? " [debug]" : "") + (e instanceof BasicToggleable && ((BasicToggleable)e).isDisabled() ? " [disabled]" : "") + (e instanceof BasicSourceAware && ((BasicSourceAware)e).isInvalid() ? " [invalid]" : "");
    }

    @NotNull
    public String content(@NotNull BasicElement e, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof BasicSequence ? this.describeSequence((BasicSequence)e) : (basicElement instanceof BasicTable ? this.describeTable((BasicTable)e) : (basicElement instanceof BasicView ? this.describeView((BasicView)e) : (basicElement instanceof BasicIndex ? this.describeIndex((BasicIndex)e) : (basicElement instanceof BasicKey ? this.describeKey((BasicKey)e, context.getWithSurrogates()) : (basicElement instanceof BasicForeignKey ? this.describeForeignKey((BasicForeignKey)e) : (basicElement instanceof BasicCheck ? this.describeCheck((BasicCheck)e) : (basicElement instanceof BasicTrigger ? this.describeTrigger((BasicTrigger)e) : (basicElement instanceof BasicRoutine ? this.describeRoutine((BasicRoutine)e) : (basicElement instanceof BasicDistTableColumn ? this.describeDistColumn((BasicDistTableColumn)e) : (basicElement instanceof BasicTableOrViewColumn ? this.describeTableOrViewColumn((BasicTableOrViewColumn)e) : (basicElement instanceof BasicLikeColumn ? this.describeColumn((BasicLikeColumn)e) : (basicElement instanceof BasicArgument ? this.describeArgument((BasicArgument)e) : (basicElement instanceof BasicTypedElement ? this.describeTypedElement((BasicTypedElement)e) : (basicElement instanceof BasicSynonym ? this.describeSynonym((BasicSynonym)e) : (basicElement instanceof BasicRoot ? this.describeRoot((BasicRoot)e, context.getWithSurrogates()) : this.describeBasicElement(e))))))))))))))));
    }

    @NotNull
    protected final String describeSequence(@NotNull BasicSequence sequence) {
        Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
        StringBuilder stringBuilder = new StringBuilder().append("sequence: ");
        Object object = sequence.getSequenceIdentity();
        if (object == null || (object = ((SequenceIdentity)object).getSpecification()) == null) {
            object = "???";
        }
        return stringBuilder.append(object).toString();
    }

    @NotNull
    protected final String describeTable(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        String res = "";
        if (table.isTemporary()) {
            res = res + "temporary ";
        }
        if (table.isSystem()) {
            res = res + "system ";
        }
        return res + "table";
    }

    @NotNull
    public String describeView(@NotNull BasicView view2) {
        Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view");
        return this.describeBasicElement(view2);
    }

    @NotNull
    public String describeIndex(@NotNull BasicIndex index2) {
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        String inner = this.describeIndexingItems(index2);
        String condition = index2.getCondition();
        String d2 = (index2.isUnique() ? "unique" : "index") + " (" + inner + ')';
        if (condition != null) {
            d2 = d2 + " when " + condition;
        }
        return d2;
    }

    @NotNull
    public final String describeIndexingItems(@NotNull BasicIndex index2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        List<String> list = index2.getColNames();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"index.colNames");
        List<String> names = list;
        Set<String> set = index2.getReverseColNames();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"index.reverseColNames");
        Set<String> ds = set;
        if (names.isEmpty()) {
            string = "???";
        } else {
            CharSequence charSequence = ", ";
            CharSequence charSequence2 = null;
            int n = 0;
            CharSequence charSequence3 = null;
            CharSequence charSequence4 = null;
            Function1 function1 = (Function1)new Function1<String, String>(this, ds){
                final /* synthetic */ DescriptionService this$0;
                final /* synthetic */ Set $ds;

                @NotNull
                public final String invoke(String it2) {
                    return this.this$0.presentIndexColumn(it2, this.$ds);
                }
                {
                    this.this$0 = descriptionService;
                    this.$ds = set;
                    super(1);
                }
            };
            string = CollectionsKt.joinToString$default((Iterable)names, (CharSequence)charSequence, charSequence4, charSequence3, (int)n, charSequence2, (Function1)function1, (int)30, null);
        }
        return string;
    }

    @NotNull
    protected final String presentIndexColumn(@Nullable String column, @NotNull Set<String> descendants) {
        int n;
        block8: {
            block7: {
                Intrinsics.checkParameterIsNotNull(descendants, (String)"descendants");
                if (column == null) break block7;
                CharSequence charSequence = column;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block8;
            }
            return "???";
        }
        String s = column;
        if (s.charAt(0) == '\u001b') {
            String string = s;
            n = 1;
            int n2 = s.length();
            StringBuilder stringBuilder = new StringBuilder().append("fun:");
            boolean bl = false;
            String string2 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string3 = string2;
            s = stringBuilder.append(string3).toString();
        }
        if (descendants.contains(column)) {
            s = s + " desc";
        } else {
            Collection collection = descendants;
            n = 0;
            if (!collection.isEmpty()) {
                s = s + " asc";
            }
        }
        return s;
    }

    @NotNull
    protected final String describeKey(@NotNull BasicKey key, boolean withSurrogates) {
        String string;
        boolean bl;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        List<String> list = key.getColNames();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"key.colNames");
        List<String> names = list;
        String k = key.isPrimary() ? "PK" : "AK";
        Collection collection = names;
        boolean bl2 = false;
        String inner = !collection.isEmpty() ? CollectionsKt.joinToString$default((Iterable)names, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : "???";
        BasicIndex index2 = key.getUnderlyingIndex();
        String name = index2 == null || index2 instanceof BasicNamedElement && !((BasicNamedElement)((Object)index2)).isNameSurrogate() || withSurrogates ? key.getUnderlyingIndexName() : index2.identity(false);
        String string3 = StringFun.notSame(key.getUnderlyingIndexName(), key.getName());
        if (string3 != null) {
            string2 = string3;
            bl = false;
            boolean bl3 = false;
            String it2 = string2;
            boolean bl4 = false;
            string = name;
        } else {
            string = null;
        }
        string2 = StringFun.decorate(string, " (underlying index ", ")");
        bl = false;
        String string4 = string2;
        if (string4 == null) {
            string4 = "";
        }
        String underlying = string4;
        return k + " (" + inner + ')' + underlying;
    }

    private final String describeForeignKey(BasicForeignKey fk) {
        String deferrable;
        String string;
        boolean toQualify;
        String domSchemaName = ModelFun.getSchemaName(fk);
        String refSchemaName = fk.getRefSchemaName();
        boolean bl = toQualify = refSchemaName != null && Intrinsics.areEqual((Object)refSchemaName, (Object)domSchemaName) ^ true;
        if (toQualify) {
            string = refSchemaName + "" + fk.getRefTableName();
        } else {
            string = fk.getRefTableName();
            if (string == null) {
                string = "???";
            }
        }
        String refTableScr = string;
        List<String> list = fk.getColNames();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"fk.colNames");
        List<String> names = list;
        Collection collection = names;
        boolean bl2 = false;
        String inner = !collection.isEmpty() ? CollectionsKt.joinToString$default((Iterable)names, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : "???";
        BasicKey basicKey = fk.getRefKey();
        String string2 = StringFun.decorate(basicKey != null ? basicKey.getNaturalName() : null, "[.", "]");
        boolean bl3 = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        String refKey = string3;
        List<String> list2 = fk.getRefColNames();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"fk.refColNames");
        List<String> refCols = list2;
        Collection collection2 = refCols;
        boolean bl4 = false;
        String refInner = !collection2.isEmpty() ? CollectionsKt.joinToString$default((Iterable)refCols, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : "???";
        CascadeRule cascadeRule = fk.getOnUpdate();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)cascadeRule), (String)"fk.onUpdate");
        String onUpdate = this.cascadeRuleIsMeaningful(cascadeRule, fk) ? " u:" + (Object)((Object)fk.getOnUpdate()) : "";
        CascadeRule cascadeRule2 = fk.getOnDelete();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)cascadeRule2), (String)"fk.onDelete");
        String onDelete = this.cascadeRuleIsMeaningful(cascadeRule2, fk) ? " d:" + (Object)((Object)fk.getOnDelete()) : "";
        String string4 = deferrable = fk.isDeferrable() ? " deferrable" : "";
        String deferred = fk.isInitiallyDeferred() && !fk.isDeferrable() ? " [deferred]" : (!fk.isInitiallyDeferred() && fk.isDeferrable() ? "[immediate]" : "");
        return "foreign key (" + inner + ") -> " + refTableScr + refKey + " (" + refInner + ')' + onUpdate + onDelete + deferrable + deferred;
    }

    private final boolean cascadeRuleIsMeaningful(CascadeRule rule, BasicElement e) {
        boolean bl;
        BasicModel basicModel = e.getModel();
        Dbms dbms = basicModel != null ? basicModel.getDbms() : null;
        boolean bl2 = false;
        boolean bl3 = false;
        Dbms it2 = dbms;
        boolean bl4 = false;
        boolean yesItIs = Intrinsics.areEqual((Object)it2, (Object)Dbms.POSTGRES) || Intrinsics.areEqual((Object)it2, (Object)Dbms.GREENPLUM) || Intrinsics.areEqual((Object)it2, (Object)Dbms.SQLITE);
        switch (DescriptionService$WhenMappings.$EnumSwitchMapping$0[rule.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = yesItIs;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    protected final String describeCheck(@NotNull BasicCheck check) {
        Intrinsics.checkParameterIsNotNull((Object)check, (String)"check");
        StringBuilder stringBuilder = new StringBuilder().append("check (");
        String string = check.getPredicate();
        if (string == null) {
            string = "???";
        }
        return stringBuilder.append((Object)string).append(")").toString();
    }

    @NotNull
    protected String describeTrigger(@NotNull BasicTrigger trig) {
        Intrinsics.checkParameterIsNotNull((Object)trig, (String)"trig");
        String string = trig.getKind().name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"trig.kind.name()");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String k = string4;
        String string5 = String.valueOf(trig.getTurn());
        boolean bl2 = false;
        String string6 = string5;
        if (string6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
        String wn = StringsKt.replace$default((String)string7, (char)'_', (char)' ', (boolean)false, (int)4, null);
        String wt = ModelFun.eventsPhrase(trig);
        String cond = trig.getCondition() == null ? "" : "c:" + trig.getCondition();
        String string8 = k + ' ' + wn + ' ' + wt + ' ' + cond;
        boolean bl3 = false;
        String string9 = string8;
        if (string9 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string9)).toString();
    }

    @NotNull
    protected String describeRoutine(@NotNull BasicRoutine r) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        switch (DescriptionService$WhenMappings.$EnumSwitchMapping$1[r.getRoutineKind().ordinal()]) {
            case 1: {
                string = "procedure";
                break;
            }
            case 2: {
                string = "function";
                break;
            }
            default: {
                string = "routine";
            }
        }
        return string;
    }

    @NotNull
    protected final String describeTableOrViewColumn(@NotNull BasicTableOrViewColumn column) {
        SequenceIdentity sequenceIdentity;
        BasicTableOrViewColumn basicTableOrViewColumn;
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        DataType dataType = column.getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
        String string = dataType.getSpecification();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"column.dataType.specification");
        String s = string;
        if (column.isComputed()) {
            s = "computed " + s;
        }
        if (column.isNotNull()) {
            s = s + " NN";
        }
        if (!((basicTableOrViewColumn = column) instanceof BasicTableColumn)) {
            basicTableOrViewColumn = null;
        }
        BasicTableColumn basicTableColumn = (BasicTableColumn)basicTableOrViewColumn;
        SequenceIdentity sequenceIdentity2 = sequenceIdentity = basicTableColumn != null ? basicTableColumn.getSequenceIdentity() : null;
        if (sequenceIdentity != null) {
            s = s + " identity " + sequenceIdentity;
        }
        if (column.getDefaultExpression() != null) {
            s = s + " default " + column.getDefaultExpression();
        }
        return s;
    }

    @NotNull
    protected final String describeColumn(@NotNull BasicLikeColumn column) {
        SequenceIdentity sequenceIdentity;
        BasicLikeColumn basicLikeColumn;
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        DataType dataType = column.getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
        String string = dataType.getSpecification();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"column.dataType.specification");
        String s = string;
        if (column.isNotNull()) {
            s = s + " NN";
        }
        if (!((basicLikeColumn = column) instanceof BasicTableColumn)) {
            basicLikeColumn = null;
        }
        BasicTableColumn basicTableColumn = (BasicTableColumn)basicLikeColumn;
        SequenceIdentity sequenceIdentity2 = sequenceIdentity = basicTableColumn != null ? basicTableColumn.getSequenceIdentity() : null;
        if (sequenceIdentity != null) {
            s = s + " identity " + sequenceIdentity;
        }
        if (column.getDefaultExpression() != null) {
            s = s + " default " + column.getDefaultExpression();
        }
        return s;
    }

    @NotNull
    protected final String describeArgument(@NotNull BasicArgument a) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        String string = a.getArgumentDirection().name();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String argWord = string3;
        String string4 = a.getDataType().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"a.dataType.toString()");
        String dataType = string4;
        String def = a.getDefaultExpression();
        String s = argWord + ' ' + dataType;
        if (def != null) {
            s = s + " default " + def;
        }
        return s;
    }

    @NotNull
    protected final String describeTypedElement(@NotNull BasicTypedElement e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        String string = e.getDataType().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.dataType.toString()");
        return string;
    }

    @NotNull
    protected final String describeSynonym(@NotNull BasicSynonym synonym) {
        Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
        BasicMajorObject targetObject = synonym.getTargetObject();
        if (targetObject != null) {
            return "synonym -> " + targetObject.getKind().code() + ' ' + targetObject.getName();
        }
        String schemaName = synonym.getTargetSchemaName() != null && Intrinsics.areEqual((Object)synonym.getTargetSchemaName(), (Object)synonym.getSchemaName()) ^ true ? synonym.getTargetSchemaName() : null;
        String string = synonym.getTargetObjectName();
        if (string == null) {
            string = "<unnamed-object>";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"synonym.targetObjectName ?: \"<unnamed-object>\"");
        String objectName = string;
        String x = schemaName != null ? schemaName + '.' + objectName : objectName;
        ObjectKind objectKind = synonym.getTargetObjectKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"synonym.targetObjectKind");
        ObjectKind kind = objectKind;
        return "synonym -> " + (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.NONE) ^ true ? kind.code() : "<unknown>") + ' ' + x;
    }

    @NotNull
    protected final String describeRoot(@NotNull BasicRoot root2, boolean withSurrogates) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        if (withSurrogates) {
            StringBuilder stringBuilder = new StringBuilder().append("root (server version: ").append(root2.getServerVersion()).append(", dbms: ");
            Dbms dbms = root2.getDbms();
            Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"root.dbms");
            string = stringBuilder.append(dbms.getName()).append(')').toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("root (dbms: ");
            Dbms dbms = root2.getDbms();
            Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"root.dbms");
            string = stringBuilder.append(dbms.getName()).append(')').toString();
        }
        return string;
    }

    @NotNull
    protected final String describeBasicElement(@NotNull BasicElement e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        String string = e.getKind().code();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.kind.code()");
        return string;
    }

    @NotNull
    public final String describeDistColumn(@NotNull BasicDistTableColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        String d2 = this.describeColumn(column);
        if (column.isDistKey()) {
            d2 = d2 + " distkey";
        }
        return d2;
    }

    public void updatePresentation(@NotNull Project project, @NotNull DasObject o, @NotNull PresentationData presentation) {
        block1: {
            DasObject dasObject;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block4: {
                                                block3: {
                                                    block2: {
                                                        block0: {
                                                            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                                                            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                                                            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
                                                            dasObject = o;
                                                            if (!(dasObject instanceof DasUserDefinedType)) break block0;
                                                            this.describeCustomType(presentation, (DasUserDefinedType)o);
                                                            break block1;
                                                        }
                                                        if (!(dasObject instanceof DasColumn)) break block2;
                                                        this.describeColumn(presentation, (DasColumn)o);
                                                        break block1;
                                                    }
                                                    if (!(dasObject instanceof DasTable)) break block3;
                                                    this.describeTable(presentation, (DasTable)o, project);
                                                    break block1;
                                                }
                                                if (!(dasObject instanceof DasRoutine)) break block4;
                                                this.describeRoutine(presentation, (DasRoutine)o, project);
                                                break block1;
                                            }
                                            if (!(dasObject instanceof DasTableKey)) break block5;
                                            this.describeTableKey(presentation, (DasTableKey)o);
                                            break block1;
                                        }
                                        if (!(dasObject instanceof DasForeignKey)) break block6;
                                        this.describeForeignKey(presentation, (DasForeignKey)o);
                                        break block1;
                                    }
                                    if (!(dasObject instanceof DasIndex)) break block7;
                                    this.describeIndex(presentation, (DasIndex)o);
                                    break block1;
                                }
                                if (!(dasObject instanceof DasSynonym)) break block8;
                                this.describeSynonym(presentation, (DasSynonym)o);
                                break block1;
                            }
                            if (!(dasObject instanceof DasTypedObject)) break block9;
                            this.describeTyped(presentation, (DasTypedObject)o);
                            break block1;
                        }
                        if (!(dasObject instanceof DasOperator)) break block10;
                        this.describeOperator(presentation, (DasOperator)o);
                        break block1;
                    }
                    if (!(dasObject instanceof BasicSequence)) break block11;
                    this.describeSequence(presentation, (BasicSequence)o);
                    break block1;
                }
                if (!(dasObject instanceof BasicTrigger)) break block12;
                this.describeTrigger(presentation, (BasicTrigger)o);
                break block1;
            }
            if (!(dasObject instanceof BasicCheck)) break block1;
            this.describeCheck(presentation, (BasicCheck)o);
        }
    }

    protected final void describeCheck(@NotNull PresentationData presentation, @NotNull BasicCheck o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        this.describePredicate(presentation, o.getPredicate());
    }

    private final void describePredicate(PresentationData presentation, String predicate) {
        if (predicate == null) {
            return;
        }
        String adjusted = StringsKt.startsWith$default((String)predicate, (String)"(", (boolean)false, (int)2, null) ? predicate : '(' + predicate + ')';
        String string = StringUtil.shortenTextWithEllipsis((String)adjusted, (int)20, (int)1, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.shortenTextWi\u2026is(adjusted, 20, 1, true)");
        String trimmed = string;
        presentation.addText(' ' + trimmed, DbNodeDescriptor.INFO_ATTRS);
    }

    protected final void describeTrigger(@NotNull PresentationData presentation, @NotNull BasicTrigger o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        TrigTurn turn = o.getTurn();
        if (turn != null) {
            List list;
            String string = StringUtil.toLowerCase((String)turn.toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.toLowerCase(turn.toString())");
            CharSequence charSequence = string;
            String string2 = "_";
            int n = 0;
            string2 = new Regex(string2);
            n = 0;
            boolean bl = false;
            List $this$dropLastWhile$iv = string2.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it2 = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence2 = it2;
                    boolean bl3 = false;
                    if (charSequence2.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String string3 = StringUtil.join((Iterable)((Iterable)JBIterable.of((Object[])Arrays.copyOf(stringArray, stringArray.length)).filter((Condition)describeTrigger.turnText.2.INSTANCE)), (String)" ");
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringUtil.join(\n       \u2026== \"row\") },\n        \" \")");
            String turnText2 = string3;
            presentation.addText(' ' + turnText2, DbNodeDescriptor.INFO_ATTRS);
        }
        Set<TrigEvent> set = o.getEvents();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"o.events");
        Set<TrigEvent> events = set;
        if (!events.isEmpty()) {
            String string = StringUtil.join((Iterable)((Iterable)JBIterable.from((Iterable)events).transform(new Function<E, T>(o){
                final /* synthetic */ BasicTrigger $o;

                public final String fun(TrigEvent e) {
                    List<String> list = this.$o.getColNames();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"o.colNames");
                    List<String> cols = list;
                    if (e == TrigEvent.UPDATE && !cols.isEmpty()) {
                        return "update of " + StringUtil.join((Collection)cols, (String)", ");
                    }
                    return StringUtil.toLowerCase((String)e.toString());
                }
                {
                    this.$o = basicTrigger;
                }
            })), (String)", ");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.join(\n       \u2026tring())\n        }, \", \")");
            String eventsText2 = string;
            presentation.addText(' ' + eventsText2, DbNodeDescriptor.INFO_ATTRS);
        }
        String condition = o.getCondition();
        this.describePredicate(presentation, condition);
        String suffix = DbImplUtil.getModelHelper(o).nodeTriggerSuffix(o);
        if (suffix != null) {
            presentation.addText(suffix, DbNodeDescriptor.INFO_ATTRS);
        }
    }

    protected final void describeOperator(@NotNull PresentationData presentation, @NotNull DasOperator o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        DasOperator.OperatorNotation operatorNotation = o.getOperatorNotation();
        Intrinsics.checkExpressionValueIsNotNull((Object)operatorNotation, (String)"o.operatorNotation");
        DasOperator.OperatorNotation notation = operatorNotation;
        StringBuilder res = new StringBuilder();
        List list = o.getArgumentTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"o.argumentTypes");
        List args = list;
        DataType dataType = o.getResultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"o.resultType");
        String string = dataType.getSpecification();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"o.resultType.specification");
        String resType = string;
        if (notation == DasOperator.OperatorNotation.INFIX) {
            res.append(StringUtil.join((Collection)args, (Function)describeOperator.1.INSTANCE, (String)(" " + o.getName() + " ")));
        } else {
            if (notation == DasOperator.OperatorNotation.PREFIX) {
                res.append(o.getName());
            }
            if (args.size() != 1) {
                res.append("(");
            }
            res.append(StringUtil.join((Collection)args, (Function)describeOperator.2.INSTANCE, (String)", "));
            if (args.size() != 1) {
                res.append(")");
            }
            if (notation == DasOperator.OperatorNotation.POSTFIX) {
                res.append(o.getName());
            }
        }
        presentation.addText("    " + res + " " + DbPresentation.arrow() + " " + resType, DbNodeDescriptor.INFO_ATTRS);
    }

    protected final void describeSequence(@NotNull PresentationData presentation, @NotNull BasicSequence o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        SequenceIdentity si = o.getSequenceIdentity();
        if (si != null) {
            String specification = si.getSpecification();
            presentation.addText(' ' + specification, DbNodeDescriptor.INFO_ATTRS);
        }
    }

    protected final void describeTyped(@NotNull PresentationData presentation, @NotNull DasTypedObject o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        DataType dataType = o.getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"o.dataType");
        String string = dataType.getSpecification();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"o.dataType.specification");
        String type = string;
        presentation.addText(' ' + type, DbNodeDescriptor.INFO_ATTRS);
    }

    protected final void describeSynonym(@NotNull PresentationData presentation, @NotNull DasSynonym o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        Iterable iterable = o.getTargetPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"o.targetPath");
        Iterable path = iterable;
        String string = StringUtil.join((Iterable)path, (String)".");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.join(path, \".\")");
        String pathString = string;
        CharSequence charSequence = pathString;
        boolean bl = false;
        if (charSequence.length() > 0) {
            String text2 = " " + DbPresentation.arrow() + " " + pathString;
            presentation.addText(text2, DbNodeDescriptor.INFO_ATTRS);
        }
    }

    protected void describeIndex(@NotNull PresentationData presentation, @NotNull DasIndex o) {
        String unique;
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        String string = unique = o.isUnique() ? " UNIQUE" : "";
        if (o instanceof BasicIndex) {
            String indexingItems = this.describeIndexingItems((BasicIndex)o);
            String columnsText = " (" + indexingItems + ')' + unique;
            presentation.addText(columnsText, DbNodeDescriptor.INFO_ATTRS);
            String condition = ((BasicIndex)o).getCondition();
            if (condition != null) {
                presentation.addText(" where " + condition, DbNodeDescriptor.INFO_ATTRS);
            }
        } else {
            String string2 = DbPresentation.multiRef((MultiRef<? extends DasTypedObject>)o.getColumnsRef());
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"multiRef(o.columnsRef)");
            String columns = string2;
            presentation.addText(' ' + columns + unique, DbNodeDescriptor.INFO_ATTRS);
        }
    }

    protected final void describeForeignKey(@NotNull PresentationData presentation, @NotNull DasForeignKey o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        String string = DbPresentation.multiRef((MultiRef<? extends DasTypedObject>)o.getColumnsRef());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"multiRef(o.columnsRef)");
        String referencingColumns = string;
        String refSchemaName = null;
        if (o instanceof BasicForeignKey && ((BasicForeignKey)o).isReferencingAnotherSchema()) {
            refSchemaName = ((BasicForeignKey)o).getRefSchemaName();
        }
        String arrowToReferenced = DbPresentation.arrowToColumns(refSchemaName, o.getRefTableName(), (MultiRef<? extends DasTypedObject>)o.getRefColumns());
        presentation.addText(' ' + referencingColumns + ' ' + arrowToReferenced, DbNodeDescriptor.INFO_ATTRS);
    }

    protected final void describeTableKey(@NotNull PresentationData presentation, @NotNull DasTableKey o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        presentation.addText(" " + DbPresentation.multiRef((MultiRef<? extends DasTypedObject>)o.getColumnsRef()), DbNodeDescriptor.INFO_ATTRS);
    }

    protected final void describeRoutine(@NotNull PresentationData presentation, @NotNull DasRoutine o, @NotNull Project project) {
        DdlBuilder builder;
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        StringBuilder sb = new StringBuilder();
        DbDataSource dataSource2 = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)o);
        DatabaseDialectEx databaseDialectEx = dataSource2 != null ? DbImplUtil.getDatabaseDialect((DbElement)dataSource2) : DatabaseDialects.getGenericDialect();
        Intrinsics.checkExpressionValueIsNotNull((Object)databaseDialectEx, (String)"if (dataSource != null) \u2026lects.getGenericDialect()");
        DatabaseDialectEx dialect = databaseDialectEx;
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((DbElement)dataSource2);
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlLanguageDialect, (String)"DbSqlUtil.getSqlDialect(dataSource)");
        SqlLanguageDialect sqlDialect = sqlLanguageDialect;
        DdlBuilder ddlBuilder = builder = new DdlBuilder(sb).applyCodeStyle(project, sqlDialect).withDialect(dialect);
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"builder");
        ddlBuilder.getDialect().sqlDefinePrototype(builder, o, false, true);
        presentation.addText(sb.toString(), DbNodeDescriptor.INFO_ATTRS);
        JBIterable jBIterable = o.getDasChildren(ObjectKind.COLUMN);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"o.getDasChildren(ObjectKind.COLUMN)");
        JBIterable columns = jBIterable;
        StringBuilder b2 = new StringBuilder();
        StringUtil.join((Iterable)((Iterable)columns), (Function)describeRoutine.1.INSTANCE, (String)", ", (StringBuilder)b2);
        CharSequence charSequence = b2;
        boolean bl = false;
        if (charSequence.length() > 0) {
            b2.insert(0, ": table (");
            b2.append(')');
            presentation.addText(b2.toString(), DbNodeDescriptor.INFO_ATTRS);
        }
    }

    protected final void describeTable(@NotNull PresentationData presentation, @NotNull DasTable o, @NotNull Project project) {
        String suffix;
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ObjectKind objectKind = o.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"o.kind");
        ObjectKind type = objectKind;
        if (!DbImplUtil.isDataTable(type)) {
            DbDataSource dataSource2 = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)o);
            ObjectKind objectKind2 = o.getKind();
            DbDataSource dbDataSource = dataSource2;
            if (dbDataSource == null || (dbDataSource = dbDataSource.getDbms()) == null) {
                dbDataSource = Dbms.UNKNOWN;
            }
            String string = DbPresentation.getPresentableName(objectKind2, (Dbms)dbDataSource);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getPresentableName(o.kin\u2026ce?.dbms ?: Dbms.UNKNOWN)");
            String typeName = string;
            presentation.addText(' ' + typeName, DbNodeDescriptor.INFO_ATTRS);
        }
        if (o instanceof BasicTable && (suffix = DbImplUtil.getModelHelper((BasicElement)o).nodeTableSuffix((BasicTable)o)) != null) {
            presentation.addText(suffix, DbNodeDescriptor.INFO_ATTRS);
        }
    }

    protected final void describeColumn(@NotNull PresentationData presentation, @NotNull DasColumn o) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        DataType dataType = o.getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"o.dataType");
        String string2 = dataType.getSpecification();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"o.dataType.specification");
        String d2 = string2;
        CharSequence charSequence = d2;
        boolean bl = false;
        if (charSequence.length() > 0) {
            presentation.addText(' ' + d2, DbNodeDescriptor.INFO_ATTRS);
        }
        if (DasUtil.isAutoGenerated((DasColumn)o)) {
            presentation.addText(" (auto increment)", DbNodeDescriptor.INFO_ATTRS);
        }
        if (o instanceof BasicDistTableColumn && ((BasicDistTableColumn)o).isDistKey()) {
            presentation.addText(" (in dist key)", DbNodeDescriptor.INFO_ATTRS);
        }
        if ((string = o.getDefault()) == null) {
            string = "";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"o.default ?: \"\"");
        String string3 = string;
        CharSequence charSequence2 = string3;
        boolean bl2 = false;
        if (charSequence2.length() > 0) {
            String string4 = StringUtil.shortenTextWithEllipsis((String)string3, (int)20, (int)1, (boolean)true);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringUtil.shortenTextWi\u2026sis(default, 20, 1, true)");
            String trimmed = string4;
            presentation.addText(" = " + trimmed, DbNodeDescriptor.INFO_ATTRS);
        }
    }

    protected final void describeCustomType(@NotNull PresentationData presentation, @NotNull DasUserDefinedType o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        String description = DbImplUtil.getCustomTypeShortDescription(o);
        if (description != null) {
            presentation.addText(' ' + description, DbNodeDescriptor.INFO_ATTRS);
        }
    }

    static {
        Companion = new Companion(null);
        DUMMY = new DescriptionService(){};
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/model/DescriptionService$Context;", "", "()V", "indent", "", "getIndent", "()Ljava/lang/String;", "setIndent", "(Ljava/lang/String;)V", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getOut", "()Ljava/lang/StringBuilder;", "setOut", "(Ljava/lang/StringBuilder;)V", "withSurrogates", "", "getWithSurrogates", "()Z", "setWithSurrogates", "(Z)V", "intellij.database.impl"})
    public static final class Context {
        private boolean withSurrogates;
        @NotNull
        public StringBuilder out;
        @NotNull
        private String indent = "";

        public final boolean getWithSurrogates() {
            return this.withSurrogates;
        }

        public final void setWithSurrogates(boolean bl) {
            this.withSurrogates = bl;
        }

        @NotNull
        public final StringBuilder getOut() {
            StringBuilder stringBuilder = this.out;
            if (stringBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"out");
            }
            return stringBuilder;
        }

        public final void setOut(@NotNull StringBuilder stringBuilder) {
            Intrinsics.checkParameterIsNotNull((Object)stringBuilder, (String)"<set-?>");
            this.out = stringBuilder;
        }

        @NotNull
        public final String getIndent() {
            return this.indent;
        }

        public final void setIndent(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.indent = string;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/model/DescriptionService$Companion;", "", "()V", "DUMMY", "Lcom/intellij/database/model/DescriptionService;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

