/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasTable;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlValuesExtractor
extends DefaultValuesExtractor {
    protected final DasTable myDatabaseTable;

    public SqlValuesExtractor(ObjectFormatter converter, DasTable databaseTable) {
        super(converter);
        this.myDatabaseTable = databaseTable;
    }

    @Override
    @NotNull
    public String getNullLiteral(DataConsumer.Row row, DataConsumer.Column column) {
        return "null";
    }

    @Override
    @NotNull
    public String getValueLiteral(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull Dbms dbms) {
        String oraTemporal;
        if (row == null) {
            SqlValuesExtractor.$$$reportNull$$$0(0);
        }
        if (column == null) {
            SqlValuesExtractor.$$$reportNull$$$0(1);
        }
        if (dbms == null) {
            SqlValuesExtractor.$$$reportNull$$$0(2);
        }
        if ((oraTemporal = this.getOracleDateTimestamp(row, column, dbms)) != null) {
            String string = oraTemporal;
            if (string == null) {
                SqlValuesExtractor.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = super.getValueLiteral(row, column, dbms);
        if (string == null) {
            SqlValuesExtractor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getStringValue(@NotNull Dbms dbms, @Nullable DataConsumer.Column column, @NotNull String value2) {
        if (dbms == null) {
            SqlValuesExtractor.$$$reportNull$$$0(5);
        }
        if (value2 == null) {
            SqlValuesExtractor.$$$reportNull$$$0(6);
        }
        String fixedValue = StringUtil.replace((String)value2, (String)"'", (String)"''");
        boolean isMysql = dbms.isMysql();
        boolean isClickHouse = dbms.isClickHouse();
        if ((isMysql || isClickHouse) && fixedValue.indexOf(92) >= 0) {
            fixedValue = StringUtil.replace((String)fixedValue, (String)"\\", (String)"\\\\");
        }
        String quoted = "'" + fixedValue + "'";
        quoted = dbms.isMicrosoft() ? "N" + quoted : quoted;
        String string = isMysql && column != null && ObjectFormatter.isBitString(column) ? "b" + quoted : quoted;
        if (string == null) {
            SqlValuesExtractor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        return "sql";
    }

    @Override
    public String getLineSeparator() {
        return "";
    }

    @Override
    public abstract SqlExtractionBase startExtraction(CharOut var1, Dbms var2, List<DataConsumer.Column> var3, @NotNull ExtractionConfig var4, int ... var5);

    @Nullable
    private String getOracleDateTimestamp(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull Dbms dbms) {
        int fractionalSeconds;
        String formattedValue;
        if (row == null) {
            SqlValuesExtractor.$$$reportNull$$$0(8);
        }
        if (column == null) {
            SqlValuesExtractor.$$$reportNull$$$0(9);
        }
        if (dbms == null) {
            SqlValuesExtractor.$$$reportNull$$$0(10);
        }
        if (!dbms.isOracle()) {
            return null;
        }
        Object value2 = column.getValue(row);
        if (!(value2 instanceof Timestamp)) {
            return null;
        }
        String function2 = "DATE".equals(column.typeName) ? "TO_DATE" : "TO_TIMESTAMP";
        Formatter format = this.myConverter.getTimestampFormat(column, dbms);
        try {
            formattedValue = format.format(value2);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        String pattern = format.toString();
        String oraPattern = StringUtil.replace((String)pattern, Arrays.asList("yyyy", "dd", "HH", "mm", "ss"), Arrays.asList("YYYY", "DD", "HH24", "MI", "SS"));
        int lastDotIdx = StringUtil.lastIndexOf((CharSequence)oraPattern, (char)'.', (int)0, (int)oraPattern.length());
        int n = fractionalSeconds = lastDotIdx != -1 ? oraPattern.length() - lastDotIdx - 1 : 0;
        if (fractionalSeconds > 0) {
            TextRange range = TextRange.create((int)lastDotIdx, (int)oraPattern.length());
            oraPattern = StringUtil.replaceSubstring((String)oraPattern, (TextRange)range, (String)(".FF" + fractionalSeconds));
        }
        return function2 + "('" + formattedValue + "', '" + oraPattern + "')";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/SqlValuesExtractor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/SqlValuesExtractor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueLiteral";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValueLiteral";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStringValue";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOracleDateTimestamp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class SqlExtractionBase
    extends DefaultValuesExtractor.DefaultExtraction {
        protected final DdlBuilder myDdlBuilder;

        public SqlExtractionBase(CharOut output, Dbms dbms, ExtractionConfig config, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            super(output, dbms, config, allColumns, selectedColumnIndices);
            this.myDdlBuilder = new DdlBuilder(this.myOutput).qualifyReferences(true).withDialect(DbImplUtil.getDatabaseDialect(dbms));
        }
    }
}

