/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.MutationData;
import gnu.trove.TIntHashSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutationsStorage
implements Iterable<Integer> {
    private static final double MULTIPLIER = 1.5;
    private final double myMultiplier;
    private final GridModel<DataConsumer.Row, DataConsumer.Column> myModel;
    private final TIntHashSet myModifiedRows;
    private MutationData[][] myValues;
    private int[] myModificationCount;
    private int myMaxRows;
    private int myRows;
    private int myMaxColumns;
    private int myColumns;

    public MutationsStorage(@NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model, int rows, int columns) {
        if (model == null) {
            MutationsStorage.$$$reportNull$$$0(0);
        }
        this(model, rows, columns, 1.5);
    }

    public MutationsStorage(@NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model, int rows, int columns, double multiplier) {
        if (model == null) {
            MutationsStorage.$$$reportNull$$$0(1);
        }
        this.myMultiplier = multiplier;
        this.myRows = rows;
        this.myColumns = columns;
        this.myMaxRows = this.getIncreasedValue(rows);
        this.myMaxColumns = this.getIncreasedValue(columns);
        this.myModel = model;
        this.myValues = new MutationData[this.myMaxRows][];
        this.myModificationCount = new int[this.myMaxRows];
        this.myModifiedRows = new TIntHashSet();
    }

    public void set(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, @Nullable CellMutation value2) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(2);
        }
        if (column == null) {
            MutationsStorage.$$$reportNull$$$0(3);
        }
        if (!this.isValid(row, column)) {
            return;
        }
        int rowIdx = row.asInteger();
        int colIdx = column.asInteger();
        if (rowIdx >= this.myMaxRows || colIdx >= this.myMaxColumns) {
            this.reallocate(Math.max(rowIdx, this.myMaxRows), Math.max(colIdx, this.myMaxColumns));
        }
        this.increase(rowIdx, colIdx);
        if (this.myValues[rowIdx] == null) {
            this.myValues[rowIdx] = new MutationData[this.myMaxColumns];
        }
        this.countModifications(value2, rowIdx, colIdx);
        this.myValues[rowIdx][colIdx] = value2 == null ? null : new MutationData(value2.getValue(), value2.getType());
    }

    public void shiftUp(@NotNull ModelIndex<DataConsumer.Row> row) {
        int[] oldModifiedRows;
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(4);
        }
        int idx = row.asInteger();
        System.arraycopy(this.myValues, idx + 1, this.myValues, idx, this.myRows - 1 - idx);
        System.arraycopy(this.myModificationCount, idx + 1, this.myModificationCount, idx, this.myRows - 1 - idx);
        this.myValues[this.myRows - 1] = null;
        this.myModificationCount[this.myRows - 1] = 0;
        this.myModifiedRows.remove(idx);
        TIntHashSet newModifiedRows = new TIntHashSet();
        for (int oldRowIdx : oldModifiedRows = this.myModifiedRows.toArray()) {
            if (oldRowIdx > idx) {
                newModifiedRows.add(oldRowIdx - 1);
                continue;
            }
            newModifiedRows.add(oldRowIdx);
        }
        this.myModifiedRows.clear();
        this.myModifiedRows.addAll(newModifiedRows.toArray());
    }

    public int rowCount() {
        return this.myRows;
    }

    public int columnCount() {
        return this.myColumns;
    }

    @NotNull
    public int[] getAffectedRows() {
        int[] nArray = this.myModifiedRows.toArray();
        if (nArray == null) {
            MutationsStorage.$$$reportNull$$$0(5);
        }
        return nArray;
    }

    public void delete(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            MutationsStorage.$$$reportNull$$$0(6);
        }
        this.delete(rows.asList());
    }

    public void delete(@NotNull List<ModelIndex<DataConsumer.Row>> rows) {
        if (rows == null) {
            MutationsStorage.$$$reportNull$$$0(7);
        }
        rows.forEach(this::delete);
    }

    public void delete(@NotNull ModelIndex<DataConsumer.Row> rowIdx) {
        if (rowIdx == null) {
            MutationsStorage.$$$reportNull$$$0(8);
        }
        if (!this.isValid(rowIdx)) {
            return;
        }
        int i2 = rowIdx.asInteger();
        if (i2 < this.myRows) {
            this.myValues[i2] = null;
            this.myModificationCount[i2] = 0;
        }
        this.myModifiedRows.remove(i2);
    }

    public boolean isModified(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(9);
        }
        return this.isValid(row) && this.isModified(row.asInteger());
    }

    @Nullable
    public MutationData get(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (row == null) {
            MutationsStorage.$$$reportNull$$$0(10);
        }
        if (column == null) {
            MutationsStorage.$$$reportNull$$$0(11);
        }
        int rowIdx = row.asInteger();
        int colIdx = column.asInteger();
        return !this.isValid(row, column) || rowIdx >= this.myRows || colIdx >= this.myColumns || this.myValues[rowIdx] == null ? null : this.myValues[rowIdx][colIdx];
    }

    public boolean isModified() {
        return !this.myModifiedRows.isEmpty();
    }

    public void clear() {
        this.myValues = new MutationData[this.myMaxRows][];
        this.myModificationCount = new int[this.myMaxRows];
        this.myModifiedRows.clear();
    }

    private boolean isValid(@Nullable ModelIndex<DataConsumer.Row> row) {
        return this.isValid(row, null);
    }

    private boolean isValid(@Nullable ModelIndex<DataConsumer.Row> row, @Nullable ModelIndex<DataConsumer.Column> column) {
        return !(row != null && !row.isValid(this.myModel) || column != null && !column.isValid(this.myModel));
    }

    private void increase(int rows, int columns) {
        this.myRows = rows >= this.myRows ? rows + 1 : this.myRows;
        this.myColumns = columns >= this.myColumns ? columns + 1 : this.myColumns;
    }

    private boolean isModified(int row) {
        return this.myModifiedRows.contains(row);
    }

    private void countModifications(@Nullable Object value2, int rowIdx, int colIdx) {
        int count2 = value2 != null && this.myValues[rowIdx][colIdx] == null ? 1 : (this.myValues[rowIdx][colIdx] != null && value2 == null ? -1 : 0);
        int n = rowIdx;
        this.myModificationCount[n] = this.myModificationCount[n] + count2;
        if (this.myModificationCount[rowIdx] > 0) {
            this.myModifiedRows.add(rowIdx);
            return;
        }
        this.myModifiedRows.remove(rowIdx);
    }

    private void reallocate(int rows, int columns) {
        this.myMaxRows = rows >= this.myMaxRows ? this.getIncreasedValue(rows) : this.myMaxRows;
        this.myMaxColumns = columns >= this.myMaxColumns ? this.getIncreasedValue(columns) : this.myMaxColumns;
        this.increase(rows, columns);
        this.myValues = MutationsStorage.copy(this.myValues, this.myMaxRows, this.myMaxColumns);
        int[] newModificationCount = new int[this.myMaxRows];
        System.arraycopy(this.myModificationCount, 0, newModificationCount, 0, this.myModificationCount.length);
        this.myModificationCount = newModificationCount;
    }

    @Override
    public Iterator<Integer> iterator() {
        return Arrays.stream(this.myModifiedRows.toArray()).iterator();
    }

    @NotNull
    private static MutationData[][] copy(@NotNull MutationData[][] from, int rows, int columns) {
        if (from == null) {
            MutationsStorage.$$$reportNull$$$0(12);
        }
        MutationData[][] newArray = new MutationData[rows][];
        for (int i2 = 0; i2 < from.length; ++i2) {
            if (from[i2] == null) continue;
            newArray[i2] = new MutationData[columns];
            System.arraycopy(from[i2], 0, newArray[i2], 0, from[i2].length);
        }
        if (newArray == null) {
            MutationsStorage.$$$reportNull$$$0(13);
        }
        return newArray;
    }

    private int getIncreasedValue(int value2) {
        return (int)Math.round((double)value2 * this.myMultiplier);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/MutationsStorage";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/MutationsStorage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedRows";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shiftUp";
                break;
            }
            case 5: 
            case 13: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

