/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.validation.NamedProgressive;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceProblem {
    private static final String ACTION_PREFIX = "action";
    private static final Pattern ACTION_PATTERN = Pattern.compile("action(\\d+)");
    private static final Pattern ACTION_PLACEHOLDER = Pattern.compile("\\$ACTION(\\d+)");
    private final Object myOwner;
    @Nullable
    private final Object myId;
    private final HyperText myText;
    private final NamedProgressive myFix;
    private final Level myLevel;

    public static void formatText(@NotNull StringBuilder builder, @NotNull List<Object> outActions, @NotNull String fmt, Object ... linkActions) {
        if (builder == null) {
            DataSourceProblem.$$$reportNull$$$0(0);
        }
        if (outActions == null) {
            DataSourceProblem.$$$reportNull$$$0(1);
        }
        if (fmt == null) {
            DataSourceProblem.$$$reportNull$$$0(2);
        }
        if (linkActions == null) {
            DataSourceProblem.$$$reportNull$$$0(3);
        }
        Matcher matcher = ACTION_PLACEHOLDER.matcher(fmt);
        int start2 = 0;
        while (start2 < fmt.length()) {
            if (matcher.find(start2)) {
                int acIdx = Integer.valueOf(matcher.group(1));
                if (acIdx < linkActions.length && linkActions[acIdx] != null) {
                    builder.append(fmt, start2, matcher.start());
                    builder.append(ACTION_PREFIX).append(outActions.size());
                    outActions.add(linkActions[acIdx]);
                } else {
                    builder.append(fmt, start2, matcher.end());
                }
                start2 = matcher.end();
                continue;
            }
            builder.append(fmt, start2, fmt.length());
            start2 = fmt.length();
        }
    }

    public static Object extractAction(@Nullable String host, @NotNull List<Object> actions) {
        if (actions == null) {
            DataSourceProblem.$$$reportNull$$$0(4);
        }
        if (host == null) {
            return null;
        }
        Matcher matcher = ACTION_PATTERN.matcher(host);
        if (!matcher.matches()) {
            return null;
        }
        int acIdx = Integer.valueOf(matcher.group(1));
        return acIdx < actions.size() ? actions.get(acIdx) : null;
    }

    public DataSourceProblem(@Nullable Object owner, @Nullable Object id, @NotNull Level level, @NotNull HyperText text2, @Nullable NamedProgressive quickFix) {
        if (level == null) {
            DataSourceProblem.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            DataSourceProblem.$$$reportNull$$$0(6);
        }
        this.myOwner = owner;
        this.myId = id;
        this.myLevel = level;
        this.myText = text2;
        this.myFix = quickFix;
    }

    @Nullable
    public Object getId() {
        return this.myId;
    }

    @Nullable
    public Object getOwner() {
        return this.myOwner;
    }

    @NotNull
    public HyperText getText() {
        HyperText hyperText = this.myText;
        if (hyperText == null) {
            DataSourceProblem.$$$reportNull$$$0(7);
        }
        return hyperText;
    }

    @Nullable
    public NamedProgressive getFix() {
        return this.myFix;
    }

    @NotNull
    public Level getLevel() {
        Level level = this.myLevel;
        if (level == null) {
            DataSourceProblem.$$$reportNull$$$0(8);
        }
        return level;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceProblem problem = (DataSourceProblem)o;
        if (this.myOwner != null ? !this.myOwner.equals(problem.myOwner) : problem.myOwner != null) {
            return false;
        }
        if (this.myId != null ? !this.myId.equals(problem.myId) : problem.myId != null) {
            return false;
        }
        return this.myText.equals(problem.myText);
    }

    public int hashCode() {
        int result = this.myOwner != null ? this.myOwner.hashCode() : 0;
        result = 31 * result + (this.myId != null ? this.myId.hashCode() : 0);
        result = 31 * result + this.myText.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outActions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fmt";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkActions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/validation/DataSourceProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/validation/DataSourceProblem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FocusDriverClass {
        public final DatabaseDriver driver;

        public FocusDriverClass(@NotNull DatabaseDriver driver) {
            if (driver == null) {
                FocusDriverClass.$$$reportNull$$$0(0);
            }
            this.driver = driver;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FocusDriverClass aClass = (FocusDriverClass)o;
            return this.driver.equals(aClass.driver);
        }

        public int hashCode() {
            return this.driver.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/validation/DataSourceProblem$FocusDriverClass", "<init>"));
        }
    }

    public static class NewUrlTemplate {
        public final DatabaseDriver driver;
        public final String template;

        public NewUrlTemplate(@NotNull DatabaseDriver driver, @NotNull String template) {
            if (driver == null) {
                NewUrlTemplate.$$$reportNull$$$0(0);
            }
            if (template == null) {
                NewUrlTemplate.$$$reportNull$$$0(1);
            }
            this.driver = driver;
            this.template = template;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NewUrlTemplate template1 = (NewUrlTemplate)o;
            if (!this.driver.equals(template1.driver)) {
                return false;
            }
            return this.template.equals(template1.template);
        }

        public int hashCode() {
            int result = this.driver.hashCode();
            result = 31 * result + this.template.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "driver";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "template";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/validation/DataSourceProblem$NewUrlTemplate";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Navigate {
        public final Object target;

        public Navigate(@NotNull Object target) {
            if (target == null) {
                Navigate.$$$reportNull$$$0(0);
            }
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.target.equals(((Navigate)o).target);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/dataSource/validation/DataSourceProblem$Navigate", "<init>"));
        }
    }

    public static class HyperText {
        private final String myDescription;
        private final String myShortDescription;
        private final String myTitle;
        private final Object[] myLinkActions;

        public HyperText(@NotNull String title, @NotNull String shortDescription, @NotNull String description, Object ... actions) {
            if (title == null) {
                HyperText.$$$reportNull$$$0(0);
            }
            if (shortDescription == null) {
                HyperText.$$$reportNull$$$0(1);
            }
            if (description == null) {
                HyperText.$$$reportNull$$$0(2);
            }
            if (actions == null) {
                HyperText.$$$reportNull$$$0(3);
            }
            this.myDescription = description;
            this.myShortDescription = shortDescription;
            this.myTitle = title;
            this.myLinkActions = actions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HyperText text2 = (HyperText)o;
            if (!this.myDescription.equals(text2.myDescription)) {
                return false;
            }
            if (!this.myShortDescription.equals(text2.myShortDescription)) {
                return false;
            }
            if (!this.myTitle.equals(text2.myTitle)) {
                return false;
            }
            return Arrays.equals(this.myLinkActions, text2.myLinkActions);
        }

        public int hashCode() {
            int result = this.myDescription.hashCode();
            result = 31 * result + this.myShortDescription.hashCode();
            result = 31 * result + this.myTitle.hashCode();
            result = 31 * result + Arrays.hashCode(this.myLinkActions);
            return result;
        }

        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                HyperText.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getShortDescription() {
            String string = this.myShortDescription;
            if (string == null) {
                HyperText.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getTitle() {
            String string = this.myTitle;
            if (string == null) {
                HyperText.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public Object[] getLinkActions() {
            if (this.myLinkActions == null) {
                HyperText.$$$reportNull$$$0(7);
            }
            return this.myLinkActions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shortDescription";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/validation/DataSourceProblem$HyperText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/validation/DataSourceProblem$HyperText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortDescription";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLinkActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Level {
        ERROR,
        WARNING,
        HINT;

    }
}

