/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SslConnectionInterceptor
implements DatabaseConnectionInterceptor,
ConsoleRunConfiguration.ParamProvider {
    @Override
    public @Nullable CompletionStage<@NotNull DatabaseConnectionInterceptor.ProtoConnection> intercept(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent) {
        DataSourceSslConfiguration ssl;
        if (proto == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(0);
        }
        if ((ssl = proto.getConnectionPoint().getDataSource().getSslCfg()) == null || !ssl.myEnabled) {
            return null;
        }
        JdbcSettings.SSL_MODE.put(proto.getExtraProperties(), (Object)ssl.myMode);
        return CompletableFuture.completedFuture(proto);
    }

    @Override
    public void populate(@NotNull ParametersList params, @NotNull LocalDataSource dataSource2) {
        DataSourceSslConfiguration ssl;
        if (params == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(1);
        }
        if (dataSource2 == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(2);
        }
        if ((ssl = dataSource2.getSslCfg()) != null && ssl.myEnabled) {
            SslConnectionInterceptor.addNotEmpty(params, ssl.myCaCertPath, "sslCaCertPath");
            SslConnectionInterceptor.addNotEmpty(params, ssl.myClientCertPath, "sslClientCertPath");
            SslConnectionInterceptor.addNotEmpty(params, ssl.myClientKeyPath, "sslClientKeyPath");
            if (Registry.is((String)"database.ssl.use.socket.factory", (boolean)false)) {
                SslConnectionInterceptor.addNotEmpty(params, "true", "sslUseFactory");
            }
        }
    }

    private static void addNotEmpty(@NotNull ParametersList props, @Nullable String value2, @NotNull String key) {
        if (props == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(3);
        }
        if (key == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(4);
        }
        if (!StringUtil.isEmptyOrSpaces((String)value2)) {
            props.addProperty(key, value2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/SslConnectionInterceptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "intercept";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "populate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addNotEmpty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

