/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModConstraint;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.JdbcParameterType;
import com.intellij.database.model.properties.JdbcProcedureType;
import com.intellij.database.model.properties.JdbcTableType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyDeserializer {
    private static final String TABLE_ELEMENT_NAME = "table";
    private static final String COLUMN_ELEMENT_NAME = "column";
    private static final String PROCEDURE_ELEMENT_NAME = "procedure";
    private static final String PROCEDURE_PROTO_ELEMENT_NAME = "prototype";
    private static final String ARGUMENT_ELEMENT_NAME = "parameter";
    private static final Pattern COLUMN_SPLITTER_PATTERN = Pattern.compile("\\s*,\\s*");

    @NotNull
    public static BasicModModel deserialize(@NotNull HierarchicalStreamReader reader, @NotNull ModelFactory modelFactory, @NotNull Dbms dbms) {
        if (reader == null) {
            LegacyDeserializer.$$$reportNull$$$0(0);
        }
        if (modelFactory == null) {
            LegacyDeserializer.$$$reportNull$$$0(1);
        }
        if (dbms == null) {
            LegacyDeserializer.$$$reportNull$$$0(2);
        }
        BasicModModel model = modelFactory.createModel(dbms);
        ((BaseModel)model).modify(model.getRoot(), BasicModRoot.class, true, r -> {
            boolean schemaDbMode = DbImplUtil.isSchemaDbMode(model, dbms);
            HashMap<BasicModForeignKey, List<String>> refCols = new HashMap<BasicModForeignKey, List<String>>();
            while (true) {
                String nodeName;
                if (TABLE_ELEMENT_NAME.equals(nodeName = reader.getNodeName())) {
                    LegacyDeserializer.deserializeTable(reader, model, schemaDbMode, refCols);
                } else if (PROCEDURE_ELEMENT_NAME.equals(nodeName)) {
                    LegacyDeserializer.deserializeProcedure(reader, model, schemaDbMode);
                } else if ("schema".equals(nodeName)) {
                    LegacyDeserializer.getOrCreateSchema(model, reader.getAttribute("catalog"), reader.getAttribute("name"), schemaDbMode);
                }
                reader.moveUp();
                if (!reader.hasMoreChildren()) break;
                reader.moveDown();
            }
            for (BasicModForeignKey fkey : ((JBTreeTraverser)model.traverser().expand(Conditions.alwaysTrue())).filter(BasicModForeignKey.class)) {
                List refColNames = (List)refCols.get(fkey);
                if (refColNames == null) continue;
                DbImplUtil.resolveKey(fkey, refColNames);
            }
        });
        BasicModModel basicModModel = model;
        if (basicModModel == null) {
            LegacyDeserializer.$$$reportNull$$$0(3);
        }
        return basicModModel;
    }

    @Nullable
    private static BasicModRoutine createRoutine(@NotNull ModFamily<?> targetFamily, String name, DasRoutine.Kind kind, String comment) {
        BasicModRoutine routine;
        if (targetFamily == null) {
            LegacyDeserializer.$$$reportNull$$$0(4);
        }
        if ((routine = (BasicModRoutine)ObjectUtils.tryCast(targetFamily.createNewOne(), BasicModRoutine.class)) == null) {
            return null;
        }
        routine.setName(name);
        routine.setComment(comment);
        routine.setRoutineKind(kind);
        return routine;
    }

    private static void deserializeArgument(HierarchicalStreamReader xmlReader, @NotNull BasicModRoutine routine, boolean ret, int idx) {
        if (routine == null) {
            LegacyDeserializer.$$$reportNull$$$0(5);
        }
        if (!ARGUMENT_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
            return;
        }
        ModFamily arguments = DbImplUtil.familyOf(routine, ObjectKind.ARGUMENT);
        if (arguments == null) {
            return;
        }
        BasicModArgument arg = (BasicModArgument)arguments.createNewOne();
        arg.setName(DbUtil.intern((String)xmlReader.getAttribute("name")));
        arg.setDataType(LegacyDeserializer.deserializeDataType(xmlReader));
        arg.setDefaultExpression(LegacyDeserializer.deserializeAttribute(xmlReader, "def"));
        arg.setComment(LegacyDeserializer.deserializeAttribute(xmlReader, "remarks"));
        ArgumentDirection direction = JdbcParameterType.findByID(StringUtil.parseInt((String)xmlReader.getAttribute("type"), (int)JdbcParameterType.IN.getID())).getArgumentDirection();
        if (ret) {
            direction = ArgumentDirection.RETURN;
        }
        arg.setArgumentDirection(direction);
        short pos = (short)StringUtil.parseInt((String)xmlReader.getAttribute("index"), (int)-1);
        arg.setPosition(pos);
    }

    @NotNull
    private static DataType deserializeDataType(HierarchicalStreamReader xmlReader) {
        int scale;
        int precision;
        String sqlType = DbUtil.intern((String)xmlReader.getAttribute("sqlType"));
        String lengthStr = xmlReader.getAttribute("length");
        if (lengthStr != null) {
            precision = StringUtil.parseInt((String)lengthStr, (int)-1);
            scale = StringUtil.parseInt((String)xmlReader.getAttribute("precision"), (int)-1);
        } else {
            precision = StringUtil.parseInt((String)xmlReader.getAttribute("precision"), (int)-1);
            scale = StringUtil.parseInt((String)xmlReader.getAttribute("scale"), (int)-1);
        }
        int jdbcType = StringUtil.parseInt((String)xmlReader.getAttribute("jdbcType"), (int)1111);
        DataType dataType = DataTypeFactory.of(null, DbUtil.intern((String)sqlType), precision, scale, (LengthUnit)(scale != 0 ? LengthUnit.DIGIT : null), null, false, false, jdbcType);
        if (dataType == null) {
            LegacyDeserializer.$$$reportNull$$$0(6);
        }
        return dataType;
    }

    private static BasicModRoutine deserializeProcedure(HierarchicalStreamReader xmlReader, @NotNull BasicModModel model, boolean schemaDbMode) {
        ModNamingFamily<?> pkgFamily;
        if (model == null) {
            LegacyDeserializer.$$$reportNull$$$0(7);
        }
        if (!PROCEDURE_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
            return null;
        }
        BasicModSchema schema = LegacyDeserializer.getOrCreateSchema(model, xmlReader.getAttribute("catalog"), xmlReader.getAttribute("schema"), schemaDbMode);
        String pkg = DbUtil.intern((String)xmlReader.getAttribute("package"), null);
        ModFamily targetFamily = null;
        if (!StringUtil.isEmpty((String)pkg) && (pkgFamily = LegacyDeserializer.namingFamily(schema, ObjectKind.PACKAGE)) != null) {
            Object pkgObj = pkgFamily.createOrGet(pkg);
            targetFamily = DbImplUtil.familyOf(pkgObj, ObjectKind.ROUTINE);
        }
        if (targetFamily == null) {
            targetFamily = DbImplUtil.familyOf(schema, ObjectKind.ROUTINE);
        }
        if (targetFamily == null) {
            return null;
        }
        String name = DbUtil.intern((String)xmlReader.getAttribute("name"));
        DasRoutine.Kind kind = JdbcProcedureType.findByID(StringUtil.parseInt((String)xmlReader.getAttribute("type"), (int)0)).getKind();
        String comment = LegacyDeserializer.deserializeAttribute(xmlReader, "remarks");
        BasicModRoutine routine = null;
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String nodeName = xmlReader.getNodeName();
            if (PROCEDURE_PROTO_ELEMENT_NAME.equals(nodeName) && (routine = LegacyDeserializer.createRoutine(targetFamily, name, kind, comment)) != null) {
                boolean hasReturn = "true".equals(xmlReader.getAttribute("return"));
                int idx = 0;
                while (xmlReader.hasMoreChildren()) {
                    xmlReader.moveDown();
                    if (ARGUMENT_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
                        LegacyDeserializer.deserializeArgument(xmlReader, routine, hasReturn, ++idx);
                        if (hasReturn) {
                            hasReturn = false;
                        }
                    }
                    xmlReader.moveUp();
                }
                ModFamily arguments = DbImplUtil.familyOf(routine, ObjectKind.ARGUMENT);
                if (arguments != null) {
                    arguments.sort();
                    for (BasicModArgument argument : JBIterable.from(arguments).filter(BasicModArgument.class)) {
                        argument.setPosition((short)0);
                    }
                }
            }
            xmlReader.moveUp();
        }
        if (routine == null) {
            routine = LegacyDeserializer.createRoutine(targetFamily, name, kind, comment);
        }
        return routine;
    }

    private static ModNamingFamily<?> namingFamily(BasicModElement e, ObjectKind kind) {
        return (ModNamingFamily)DbImplUtil.familyOf(e, kind);
    }

    @NotNull
    private static BasicModSchema getOrCreateSchema(@NotNull BasicModModel model, String cat, String schema, boolean schemaDbMode) {
        BasicModSchema res;
        ModNamingFamily<?> root2;
        if (model == null) {
            LegacyDeserializer.$$$reportNull$$$0(8);
        }
        if ((root2 = LegacyDeserializer.namingFamily((BasicModElement)((Object)model.getRoot()), ObjectKind.DATABASE)) != null) {
            BasicModMateDatabase modCat = (BasicModMateDatabase)root2.createOrGet(StringUtil.notNullize((String)DbUtil.intern((String)cat)));
            res = (BasicModSchema)modCat.getSchemas().createOrGet(StringUtil.notNullize((String)DbUtil.intern((String)schema)));
        } else {
            root2 = LegacyDeserializer.namingFamily((BasicModElement)((Object)model.getRoot()), ObjectKind.SCHEMA);
            if (root2 != null) {
                res = (BasicModSchema)root2.createOrGet(StringUtil.notNullize((String)DbUtil.intern((String)(schemaDbMode ? cat : schema))));
            } else {
                throw new AssertionError((Object)"Root has no database or schema family");
            }
        }
        BasicModSchema basicModSchema = res;
        if (basicModSchema == null) {
            LegacyDeserializer.$$$reportNull$$$0(9);
        }
        return basicModSchema;
    }

    private static void deserializeTable(HierarchicalStreamReader xmlReader, @NotNull BasicModModel model, boolean schemaDbMode, Map<BasicModForeignKey, List<String>> refCols) {
        BasicModTableOrView table;
        if (model == null) {
            LegacyDeserializer.$$$reportNull$$$0(10);
        }
        if (!TABLE_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
            return;
        }
        BasicModSchema schema = LegacyDeserializer.getOrCreateSchema(model, xmlReader.getAttribute("catalog"), xmlReader.getAttribute("schema"), schemaDbMode);
        String name = DbUtil.intern((String)xmlReader.getAttribute("name"));
        JdbcTableType tableType = JdbcTableType.findByName(xmlReader.getAttribute("type"));
        ModFamily tables = DbImplUtil.familyOf(schema, tableType.getKind());
        if (tables == null) {
            tables = DbImplUtil.familyOf(schema, ObjectKind.TABLE);
        }
        if (tables == null) {
            return;
        }
        Object object = tables.createNewOne();
        if (object instanceof BasicModNamedElement) {
            ((BasicModNamedElement)object).setName(name);
        }
        if ((table = (BasicModTableOrView)ObjectUtils.tryCast(object, BasicModTableOrView.class)) == null) {
            return;
        }
        table.setComment(LegacyDeserializer.deserializeAttribute(xmlReader, "remarks"));
        boolean count2 = false;
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String nodeName = xmlReader.getNodeName();
            if (COLUMN_ELEMENT_NAME.equals(nodeName)) {
                BasicModTableOrViewColumn column = LegacyDeserializer.deserializeColumn(xmlReader, table);
                if (column != null && Boolean.parseBoolean(xmlReader.getAttribute("autoIncrement")) && column instanceof BasicModTableColumn) {
                    BasicModTableColumn tColumn = (BasicModTableColumn)column;
                    tColumn.setSequenceIdentity(SequenceIdentity.UNKNOWN);
                }
            } else if ("primary-key".equals(nodeName)) {
                BasicModKey key = LegacyDeserializer.deserializeKey(xmlReader, table);
                if (key != null) {
                    key.setPrimary(true);
                }
            } else if ("foreign-key".equals(nodeName)) {
                LegacyDeserializer.deserializeFk(xmlReader, table, schemaDbMode, refCols);
            } else if ("index".equals(nodeName)) {
                LegacyDeserializer.deserializeIndex(xmlReader, table);
            }
            xmlReader.moveUp();
        }
    }

    @Nullable
    private static BasicModKey deserializeKey(HierarchicalStreamReader xmlReader, @NotNull BasicModTableOrView table) {
        ModFamily keys;
        if (table == null) {
            LegacyDeserializer.$$$reportNull$$$0(11);
        }
        if ((keys = DbImplUtil.familyOf(table, ObjectKind.KEY)) == null) {
            return null;
        }
        BasicModKey key = (BasicModKey)keys.createNewOne();
        key.setName(DbUtil.intern((String)xmlReader.getAttribute("name")));
        LegacyDeserializer.deserializeConstraint(xmlReader, key);
        return key;
    }

    @Nullable
    private static BasicModIndex deserializeIndex(HierarchicalStreamReader xmlReader, @NotNull BasicModTableOrView table) {
        ModFamily indices;
        if (table == null) {
            LegacyDeserializer.$$$reportNull$$$0(12);
        }
        if ((indices = DbImplUtil.familyOf(table, ObjectKind.INDEX)) == null) {
            return null;
        }
        BasicModIndex index2 = (BasicModIndex)indices.createNewOne();
        if (index2 instanceof BasicModNamedElement) {
            ((BasicModNamedElement)((Object)index2)).setName(DbUtil.intern((String)xmlReader.getAttribute("name")));
        }
        index2.setUnique(Boolean.valueOf(xmlReader.getAttribute("unique")));
        index2.setColNames(COLUMN_SPLITTER_PATTERN.split(StringUtil.notNullize((String)xmlReader.getAttribute("columns")), 0));
        return index2;
    }

    private static void deserializeConstraint(HierarchicalStreamReader xmlReader, @NotNull BasicModConstraint constraint) {
        if (constraint == null) {
            LegacyDeserializer.$$$reportNull$$$0(13);
        }
        constraint.setColNames(COLUMN_SPLITTER_PATTERN.split(StringUtil.notNullize((String)xmlReader.getAttribute("columns")), 0));
    }

    @Nullable
    private static BasicModForeignKey deserializeFk(HierarchicalStreamReader xmlReader, BasicModTableOrView table, boolean schemaDbMode, Map<BasicModForeignKey, List<String>> refCols) {
        ModFamily foreignKeys = DbImplUtil.familyOf(table, ObjectKind.FOREIGN_KEY);
        if (foreignKeys == null) {
            return null;
        }
        BasicModForeignKey fk = (BasicModForeignKey)foreignKeys.createNewOne();
        fk.setName(DbUtil.intern((String)xmlReader.getAttribute("name")));
        LegacyDeserializer.deserializeConstraint(xmlReader, fk);
        String tTab = DbUtil.intern((String)xmlReader.getAttribute("ref-table"));
        String tSchema = DbUtil.intern((String)xmlReader.getAttribute("ref-schema"));
        String tCat = DbUtil.intern((String)xmlReader.getAttribute("ref-catalog"));
        fk.setRefTableName(StringUtil.nullize((String)tTab));
        String refSchema = StringUtil.nullize((String)(schemaDbMode ? tCat : tSchema));
        if (!Comparing.equal((String)refSchema, (String)DasUtil.getName((DasObject)table.getParent()))) {
            fk.setRefSchemaName(refSchema);
        }
        List<String> refColNames = Arrays.asList(COLUMN_SPLITTER_PATTERN.split(StringUtil.notNullize((String)xmlReader.getAttribute("ref-columns")), 0));
        fk.setRefColNames(refColNames);
        refCols.put(fk, refColNames);
        int updateRuleOrd = StringUtil.parseInt((String)StringUtil.notNullize((String)xmlReader.getAttribute("update-rule")), (int)-1);
        fk.setOnUpdate(DbImplUtil.asCascadeRule(LegacyDeserializer.itemAt(updateRuleOrd, DasForeignKey.RuleAction.values())));
        int deleteRuleOrd = StringUtil.parseInt((String)StringUtil.notNullize((String)xmlReader.getAttribute("delete-rule")), (int)-1);
        fk.setOnDelete(DbImplUtil.asCascadeRule(LegacyDeserializer.itemAt(deleteRuleOrd, DasForeignKey.RuleAction.values())));
        DasForeignKey.Deferrability deferrability = LegacyDeserializer.itemAt(StringUtil.parseInt((String)StringUtil.notNullize((String)xmlReader.getAttribute("deferrability")), (int)-1), DasForeignKey.Deferrability.values());
        if (deferrability == null) {
            deferrability = DasForeignKey.Deferrability.NOT_DEFERRABLE;
        }
        fk.setDeferrable(deferrability != DasForeignKey.Deferrability.NOT_DEFERRABLE);
        fk.setInitiallyDeferred(deferrability == DasForeignKey.Deferrability.INITIALLY_DEFERRED);
        return fk;
    }

    @Nullable
    private static BasicModTableOrViewColumn deserializeColumn(HierarchicalStreamReader xmlReader, BasicModTableOrView table) {
        ModFamily columns = DbImplUtil.familyOf(table, ObjectKind.COLUMN);
        if (columns == null) {
            return null;
        }
        BasicModTableOrViewColumn column = (BasicModTableOrViewColumn)columns.createNewOne();
        column.setName(DbUtil.intern((String)xmlReader.getAttribute("name")));
        column.setDataType(LegacyDeserializer.deserializeDataType(xmlReader));
        column.setNotNull(!Boolean.parseBoolean(xmlReader.getAttribute("nullable")));
        column.setDefaultExpression(LegacyDeserializer.deserializeAttribute(xmlReader, "def"));
        column.setComment(LegacyDeserializer.deserializeAttribute(xmlReader, "remarks"));
        return column;
    }

    @Nullable
    static String deserializeAttribute(@NotNull HierarchicalStreamReader xmlReader, String name) {
        String value2;
        if (xmlReader == null) {
            LegacyDeserializer.$$$reportNull$$$0(14);
        }
        if ((value2 = xmlReader.getAttribute(name)) != null) {
            return DbUtil.intern((String)new String(Base64.getDecoder().decode(value2), StandardCharsets.UTF_8));
        }
        return null;
    }

    @Nullable
    private static <E> E itemAt(int ordinal, E[] values2) {
        return ordinal >= 0 && ordinal < values2.length ? (E)values2[ordinal] : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/LegacyDeserializer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFamily";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = TABLE_ELEMENT_NAME;
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/LegacyDeserializer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeDataType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSchema";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRoutine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserializeArgument";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserializeProcedure";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateSchema";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserializeTable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deserializeKey";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deserializeIndex";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deserializeConstraint";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deserializeAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

