/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.TooLongStatementException;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunSqlScriptAction {
    private static final int BATCH_MAX_SIZE = 1000;
    private static final int BATCH_MAX_LENGTH = 512000;

    @NotNull
    private static String getTaskName(@NotNull JBIterable<VirtualFile> files) {
        if (files == null) {
            RunSqlScriptAction.$$$reportNull$$$0(0);
        }
        String title = files.size() == 1 ? ((VirtualFile)files.iterator().next()).getName() : files.size() + " files";
        String string = String.format("Run '%s'... ", StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)title, (int)20)));
        if (string == null) {
            RunSqlScriptAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void perform(@NotNull Project project, @NotNull JBIterable<VirtualFile> files, @NotNull List<Pair<LocalDataSource, ObjectPath>> targets2) {
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(2);
        }
        if (files == null) {
            RunSqlScriptAction.$$$reportNull$$$0(3);
        }
        if (targets2 == null) {
            RunSqlScriptAction.$$$reportNull$$$0(4);
        }
        RunSqlScriptAction.perform(project, RunSqlScriptAction.getTaskName(files), files, targets2);
    }

    public static void perform(final @NotNull Project project, @NotNull String taskName, final @NotNull JBIterable<VirtualFile> files, final @NotNull List<Pair<LocalDataSource, ObjectPath>> targets2) {
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(5);
        }
        if (taskName == null) {
            RunSqlScriptAction.$$$reportNull$$$0(6);
        }
        if (files == null) {
            RunSqlScriptAction.$$$reportNull$$$0(7);
        }
        if (targets2 == null) {
            RunSqlScriptAction.$$$reportNull$$$0(8);
        }
        final Ref reporter = Ref.create(null);
        final AtomicReference<ProgressIndicator> indicatorRef = new AtomicReference<ProgressIndicator>();
        Runnable runnable = () -> {
            RunSqlScriptAction.prepare(project, files, targets2);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, taskName, true, null){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicatorRef.set(indicator);
                    RunSqlScriptAction.performImpl(project, (JBIterable<VirtualFile>)files, targets2, (DataAuditor.PrintingAdapter)reporter.get(), indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/console/RunSqlScriptAction$1", "run"));
                }
            });
        };
        ConsoleView consoleView = RunSqlScriptAction.addConsole(project, taskName, files, runnable, indicatorRef);
        reporter.set((Object)new DataAuditor.ConsoleLogger(consoleView));
        runnable.run();
    }

    public static void performImpl(@NotNull Project project, @NotNull JBIterable<VirtualFile> files, @NotNull List<Pair<LocalDataSource, ObjectPath>> targets2, @NotNull DataAuditor.PrintingAdapter reporter, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(9);
        }
        if (files == null) {
            RunSqlScriptAction.$$$reportNull$$$0(10);
        }
        if (targets2 == null) {
            RunSqlScriptAction.$$$reportNull$$$0(11);
        }
        if (reporter == null) {
            RunSqlScriptAction.$$$reportNull$$$0(12);
        }
        if (indicator == null) {
            RunSqlScriptAction.$$$reportNull$$$0(13);
        }
        indicator.setFraction(0.0);
        indicator.setIndeterminate(false);
        for (Pair<LocalDataSource, ObjectPath> target : targets2) {
            try {
                RunSqlScriptAction.performStepImpl(project, (LocalDataSource)target.first, (ObjectPath)target.second, files, targets2.size(), reporter, indicator);
            }
            catch (ProcessCanceledException pce) {
                indicator.checkCanceled();
            }
        }
    }

    private static void performStepImpl(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable ObjectPath destination, @NotNull JBIterable<VirtualFile> files, int progressMultiplier, @NotNull DataAuditor.PrintingAdapter reporter, @NotNull ProgressIndicator indicator) {
        VirtualFile single;
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(14);
        }
        if (dataSource2 == null) {
            RunSqlScriptAction.$$$reportNull$$$0(15);
        }
        if (files == null) {
            RunSqlScriptAction.$$$reportNull$$$0(16);
        }
        if (reporter == null) {
            RunSqlScriptAction.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            RunSqlScriptAction.$$$reportNull$$$0(18);
        }
        Language language = DbSqlUtil.getLanguage(dataSource2);
        if (destination == null && (single = (VirtualFile)files.single()) != null) {
            destination = ObjectPaths.of((DasObject)RunSqlScriptAction.getTargetElement(project, single));
        }
        Runner r = new Runner(project, dataSource2, destination, reporter);
        RunSqlScriptAction.reportAndLog(project, reporter, MessageType.INFO, "Connecting to " + dataSource2.getName() + "..." + (destination != null ? " (" + destination.getDisplayName() + ")" : ""));
        Ref doneAnything = Ref.create();
        r.withConnected(() -> {
            indicator.checkCanceled();
            indicator.setText(r.dataSource.getName());
            if (r.connection == null) {
                reporter.error("Unable to acquire connection", null);
                return;
            }
            long total = -1L;
            long chars = -1L;
            long executed = 0L;
            long failed = 0L;
            boolean aborted = false;
            long t0 = System.currentTimeMillis();
            for (VirtualFile file : files) {
                ScriptModel scriptModel;
                long t1;
                long[] counter;
                block10: {
                    RunSqlScriptAction.reportAndLog(project, reporter, MessageType.INFO, "Run " + file.getPresentableUrl());
                    counter = new long[]{0L, 0L, 0L};
                    t1 = System.currentTimeMillis();
                    PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)project).findFile(file));
                    if (psiFile == null) {
                        reporter.error("No PSI for file " + file.getName(), null);
                        continue;
                    }
                    scriptModel = (ScriptModel)ReadAction.compute(() -> SqlPsiFacade.getInstance((Project)project).createScriptModel(file, language));
                    try {
                        RunSqlScriptAction.runScript(r, scriptModel, reporter, indicator, counter, progressMultiplier * files.size(), (Ref<Boolean>)doneAnything);
                        if (total < 0L) {
                            total = counter[0];
                        }
                        if (chars >= 0L) break block10;
                        chars = counter[2];
                    }
                    catch (ProcessCanceledException e) {
                        try {
                            aborted = true;
                        }
                        catch (Throwable throwable) {
                            Disposer.dispose((Disposable)scriptModel);
                            executed += counter[0];
                            failed += counter[1];
                            if (files.size() > 1) {
                                long t2 = System.currentTimeMillis() - t1;
                                MessageType messageType = counter[1] > 0L ? MessageType.ERROR : (aborted ? MessageType.WARNING : MessageType.INFO);
                                RunSqlScriptAction.reportAndLog(project, reporter, messageType, dataSource2.getName() + ": " + counter[0] + (total < 0L ? "" : " of " + total) + " statements executed" + (counter[1] > 0L ? ", " + counter[1] + " failed" : "") + " in " + StringUtil.formatDuration((long)t2) + (aborted ? " (aborted!)" : ""));
                            }
                            throw throwable;
                        }
                        Disposer.dispose((Disposable)scriptModel);
                        executed += counter[0];
                        failed += counter[1];
                        if (files.size() <= 1) break;
                        long t2 = System.currentTimeMillis() - t1;
                        MessageType messageType = counter[1] > 0L ? MessageType.ERROR : (aborted ? MessageType.WARNING : MessageType.INFO);
                        RunSqlScriptAction.reportAndLog(project, reporter, messageType, dataSource2.getName() + ": " + counter[0] + (total < 0L ? "" : " of " + total) + " statements executed" + (counter[1] > 0L ? ", " + counter[1] + " failed" : "") + " in " + StringUtil.formatDuration((long)t2) + (aborted ? " (aborted!)" : ""));
                        break;
                    }
                }
                Disposer.dispose((Disposable)scriptModel);
                executed += counter[0];
                failed += counter[1];
                if (files.size() <= 1) continue;
                long t2 = System.currentTimeMillis() - t1;
                MessageType messageType = counter[1] > 0L ? MessageType.ERROR : (aborted ? MessageType.WARNING : MessageType.INFO);
                RunSqlScriptAction.reportAndLog(project, reporter, messageType, dataSource2.getName() + ": " + counter[0] + (total < 0L ? "" : " of " + total) + " statements executed" + (counter[1] > 0L ? ", " + counter[1] + " failed" : "") + " in " + StringUtil.formatDuration((long)t2) + (aborted ? " (aborted!)" : ""));
            }
            if (Boolean.TRUE.equals(doneAnything.get())) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> DataSourceUiUtil.performAutoSyncTask(DataSourceUiUtil.getConnectionContext(project, dataSource2, r.destination)));
            }
            long t3 = System.currentTimeMillis() - t0;
            MessageType messageType = failed > 0L ? MessageType.ERROR : (aborted ? MessageType.WARNING : MessageType.INFO);
            RunSqlScriptAction.reportAndLog(project, reporter, messageType, "Summary: " + executed + (total < 0L ? "" : " of " + total * (long)files.size()) + " statements executed" + (failed > 0L ? ", " + failed + " failed" : "") + " in " + StringUtil.formatDuration((long)t3) + (chars < 0L ? "" : " (" + chars + " symbols in file)") + (aborted ? " (aborted!)" : ""));
        });
    }

    public static void prepare(@NotNull Project project, @NotNull JBIterable<VirtualFile> files, @NotNull List<Pair<LocalDataSource, ObjectPath>> targets2) {
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(19);
        }
        if (files == null) {
            RunSqlScriptAction.$$$reportNull$$$0(20);
        }
        if (targets2 == null) {
            RunSqlScriptAction.$$$reportNull$$$0(21);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])((VirtualFile[])files.toArray((Object[])VirtualFile.EMPTY_ARRAY)));
        RunSqlScriptAction.patchDialects(project, files, targets2);
    }

    public static void patchDialects(@NotNull Project project, @NotNull JBIterable<VirtualFile> files, @NotNull List<Pair<LocalDataSource, ObjectPath>> targets2) {
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(22);
        }
        if (files == null) {
            RunSqlScriptAction.$$$reportNull$$$0(23);
        }
        if (targets2 == null) {
            RunSqlScriptAction.$$$reportNull$$$0(24);
        }
        SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
        LinkedHashSet preferredDialects = ContainerUtil.newLinkedHashSet((Iterable)JBIterable.from(targets2).transform(t -> DbSqlUtil.getSqlDialect((LocalDataSource)t.first)));
        SqlLanguageDialect genericDialect = SqlDialects.getGenericDialect();
        preferredDialects.remove(genericDialect);
        SqlLanguageDialect preferredDialect = (SqlLanguageDialect)ContainerUtil.getFirstItem((Collection)preferredDialects);
        if (preferredDialect == null) {
            return;
        }
        List remapDialect = files.filter(file -> !preferredDialects.contains(LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file))).toList();
        if (!remapDialect.isEmpty()) {
            WriteAction.run(() -> {
                for (VirtualFile file : remapDialect) {
                    sqlPsiFacade.setDialectMapping(file, preferredDialect);
                }
            });
        }
    }

    @Nullable
    public static Pair<LocalDataSource, ObjectPath> makeTargetPair(@NotNull LocalDataSource source, @NotNull Object object) {
        if (source == null) {
            RunSqlScriptAction.$$$reportNull$$$0(25);
        }
        if (object == null) {
            RunSqlScriptAction.$$$reportNull$$$0(26);
        }
        return object == source ? Pair.create((Object)source, null) : (object instanceof DasObject ? Pair.create((Object)source, (Object)ObjectPaths.of((DasObject)object)) : null);
    }

    @Nullable
    private static DbElement getTargetElement(@NotNull Project project, VirtualFile file) {
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(27);
        }
        return DbImplUtil.findElement(project, file);
    }

    private static void reportAndLog(@NotNull Project project, @NotNull DataAuditor.PrintingAdapter logger, @NotNull MessageType messageType, @NotNull String message2) {
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(28);
        }
        if (logger == null) {
            RunSqlScriptAction.$$$reportNull$$$0(29);
        }
        if (messageType == null) {
            RunSqlScriptAction.$$$reportNull$$$0(30);
        }
        if (message2 == null) {
            RunSqlScriptAction.$$$reportNull$$$0(31);
        }
        DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(message2, messageType).notify(project);
        ConsoleViewContentType contentType = messageType == MessageType.ERROR ? ConsoleViewContentType.ERROR_OUTPUT : (messageType == MessageType.WARNING ? ConsoleViewContentType.LOG_WARNING_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT);
        logger.println(message2, contentType);
    }

    @NotNull
    private static ConsoleView addConsole(@NotNull Project project, @NotNull String taskName, @NotNull JBIterable<VirtualFile> files, @NotNull Runnable rerunRunnable, @NotNull AtomicReference<ProgressIndicator> indicatorRef) {
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(32);
        }
        if (taskName == null) {
            RunSqlScriptAction.$$$reportNull$$$0(33);
        }
        if (files == null) {
            RunSqlScriptAction.$$$reportNull$$$0(34);
        }
        if (rerunRunnable == null) {
            RunSqlScriptAction.$$$reportNull$$$0(35);
        }
        if (indicatorRef == null) {
            RunSqlScriptAction.$$$reportNull$$$0(36);
        }
        ConsoleView consoleView = DbUIUtil.addConsole(project, taskName, () -> {
            for (VirtualFile file : files) {
                if (file.isValid()) continue;
                return false;
            }
            return true;
        }, rerunRunnable, indicatorRef);
        if (consoleView == null) {
            RunSqlScriptAction.$$$reportNull$$$0(37);
        }
        return consoleView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runStatements(Project project, LocalDataSource dataSource2, ObjectPath destination, ScriptModel<?> scriptModel, DataAuditor.PrintingAdapter reporter) {
        EmptyProgressIndicator progress = new EmptyProgressIndicator();
        long[] counter = new long[3];
        try {
            Runner r = new Runner(project, dataSource2, destination, reporter);
            r.withConnected(() -> RunSqlScriptAction.lambda$runStatements$9((ProgressIndicator)progress, r, reporter, scriptModel, counter));
        }
        finally {
            Disposer.dispose(scriptModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runScript(Runner r, ScriptModel<?> scriptModel, DataAuditor.PrintingAdapter reporter, ProgressIndicator progress, long[] counter, int progressMultiplier, Ref<Boolean> doneAnything) {
        try {
            VirtualFile virtualFile = scriptModel.getVirtualFile();
            long fileSize = virtualFile.getLength();
            float averageBytesPerChar = virtualFile.getCharset().newEncoder().averageBytesPerChar();
            counter[2] = 0L;
            boolean inBatch = false;
            NotNullLazyValue dmlSet = NotNullLazyValue.createValue(() -> TokenSet.create((IElementType[])new IElementType[]{SqlTokenRegistry.findCompositeType((String)"SQL_INSERT_STATEMENT"), SqlTokenRegistry.findCompositeType((String)"SQL_UPDATE_STATEMENT"), SqlTokenRegistry.findCompositeType((String)"SQL_DELETE_STATEMENT")}));
            Condition notDml = o -> !((TokenSet)dmlSet.getValue()).contains(o.type());
            for (JBIterable itGroup : scriptModel.statements().split(JBIterable.Split.GROUP, notDml)) {
                if (doneAnything != null) {
                    doneAnything.set((Object)true);
                }
                double fraction = -1.0;
                if (inBatch) {
                    reporter.print("");
                }
                inBatch = false;
                for (ScriptModel.StatementIt it2 : itGroup) {
                    progress.checkCanceled();
                    String sql = it2.text();
                    if (!inBatch) {
                        reporter.println(StringUtil.first((String)sql, (int)240, (boolean)true), ConsoleViewContentType.USER_INPUT);
                        progress.setText2(StringUtil.first((String)sql, (int)120, (boolean)true));
                    }
                    counter[0] = counter[0] + 1L;
                    counter[2] = counter[2] + (long)sql.length();
                    long curOffset = it2.rangeOffset() + (long)it2.range().getEndOffset();
                    fraction = (float)curOffset * averageBytesPerChar / (float)fileSize / (float)progressMultiplier;
                    if (!r.batchUpdatesSupported || notDml.value((Object)it2)) {
                        r.runSingle(sql);
                        progress.setFraction(fraction);
                    } else {
                        if (r.batchCount % 10L == 1L) {
                            reporter.rawPrint(".", ConsoleViewContentType.USER_INPUT);
                        }
                        inBatch = true;
                        r.addBatch(sql);
                        if (r.batchCount >= 1000L || r.batchLength >= 512000L) {
                            reporter.print("");
                            r.runBatch();
                            progress.setFraction(fraction);
                        }
                    }
                    counter[1] = counter[1] + r.getAndResetFailCount();
                }
                if (inBatch) {
                    reporter.print("");
                    r.runBatch();
                    progress.setFraction(fraction);
                }
                counter[1] = counter[1] + r.getAndResetFailCount();
            }
        }
        catch (TooLongStatementException e) {
            reporter.error(e.getMessage() + ". Increasing memory via -Xmx may help. Aborting.", null);
        }
        finally {
            counter[1] = counter[1] + r.getAndResetFailCount();
        }
    }

    private static /* synthetic */ void lambda$runStatements$9(ProgressIndicator progress, Runner r, DataAuditor.PrintingAdapter reporter, ScriptModel scriptModel, long[] counter) {
        progress.checkCanceled();
        progress.setText(r.dataSource.getName());
        if (r.connection == null) {
            reporter.error("Unable to acquire connection", null);
            return;
        }
        RunSqlScriptAction.runScript(r, scriptModel, reporter, progress, counter, 1, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/RunSqlScriptAction";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 14: 
            case 19: 
            case 22: 
            case 27: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 6: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunRunnable";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicatorRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/RunSqlScriptAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskName";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "addConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTaskName";
                break;
            }
            case 1: 
            case 37: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performImpl";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "performStepImpl";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "patchDialects";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "makeTargetPair";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTargetElement";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "reportAndLog";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addConsole";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Runner {
        final Project project;
        final LocalDataSource dataSource;
        final ObjectPath destination;
        final DataAuditor.PrintingAdapter reporter;
        boolean batchUpdatesSupported;
        DatabaseConnection connection;
        ReusableSmartStatement<String> statement;
        long failCount;
        long batchCount;
        long batchLength;

        Runner(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable ObjectPath destination, DataAuditor.PrintingAdapter reporter) {
            if (project == null) {
                Runner.$$$reportNull$$$0(0);
            }
            if (dataSource2 == null) {
                Runner.$$$reportNull$$$0(1);
            }
            this.project = project;
            this.dataSource = dataSource2;
            this.destination = destination;
            this.reporter = reporter;
        }

        long getAndResetFailCount() {
            long result = this.failCount;
            this.failCount = 0L;
            return result;
        }

        void prepare() {
            if (this.connection == null) {
                return;
            }
            try {
                if (!this.dataSource.getDbms().isTransactSql()) {
                    RemoteDatabaseMetaData metaData = this.connection.getRemoteMetaData();
                    boolean bl = this.batchUpdatesSupported = metaData != null && metaData.supportsBatchUpdates();
                    if (this.batchUpdatesSupported) {
                        this.reporter.print("Using batch mode (1000 insert/update/delete statements max)");
                    }
                }
            }
            catch (Exception ex) {
                this.reporter.error(JdbcEngine.getErrorMessage(ex, this.dataSource), null);
            }
            if (this.destination != null) {
                DatabaseEditorHelper.setCurrentSchemaSafe(DbImplUtil.getDatabaseDialect(this.dataSource), this.destination, this.connection);
            }
        }

        public void withConnected(@NotNull Runnable r) {
            if (r == null) {
                Runner.$$$reportNull$$$0(2);
            }
            ErrorHandler handler = new ErrorHandler();
            try {
                DatabaseSessionManager.facade(this.project, this.dataSource, null, SearchPath.of((ObjectPath)this.destination), handler, DGDepartment.DATA_IMPORT).runSync(SessionsUtil.consumer(connection2 -> {
                    try {
                        this.connection = connection2;
                        this.statement = SmartStatements.poweredBy(connection2).simple(Configuration.getDefault()).reuse();
                        this.prepare();
                        r.run();
                    }
                    finally {
                        this.connection = null;
                        if (this.statement != null) {
                            this.statement.close();
                        }
                    }
                }));
            }
            catch (ProcessCanceledException e) {
                if (handler.hasErrors()) {
                    this.reporter.error(handler.getSummary(), null);
                }
                throw e;
            }
            catch (Exception e) {
                this.reporter.error(null, e);
            }
        }

        public void runSingle(String sql) {
            try {
                long updateTotal = -1L;
                long timestamp = System.currentTimeMillis();
                try (ClosableResultsProducer producer = this.statement.noisy().execute(sql, StandardExecutionMode.GENERIC);){
                    String executionTime = StringUtil.formatDuration((long)(System.currentTimeMillis() - timestamp));
                    while (producer.advance()) {
                        int count2 = producer.processCurrent(StandardResultsProcessors.updateCount(-1));
                        if (count2 < 0) continue;
                        if (updateTotal < 0L) {
                            updateTotal = 0L;
                        }
                        updateTotal += (long)count2;
                    }
                    if (updateTotal >= 0L) {
                        this.reporter.print(updateTotal + " row(s) affected in " + executionTime);
                    } else {
                        this.reporter.print("completed in " + executionTime);
                    }
                }
            }
            catch (Exception ex) {
                ++this.failCount;
                if (DbImplUtil.isRemoteProcessDown(ex)) {
                    this.reporter.error("Connection is closed", null);
                    throw new ProcessCanceledException();
                }
                this.reporter.error(JdbcEngine.getErrorMessage(ex, this.dataSource), null);
            }
        }

        public void addBatch(String sql) {
            if (!this.batchUpdatesSupported) {
                this.runSingle(sql);
                return;
            }
            try {
                this.statement.addBatch(sql);
                ++this.batchCount;
                this.batchLength += (long)sql.length();
            }
            catch (SQLException e) {
                this.batchUpdatesSupported = false;
                if (this.batchCount > 0L) {
                    this.runBatch();
                }
                this.runSingle(sql);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runBatch() {
            if (!this.batchUpdatesSupported) {
                return;
            }
            if (this.batchCount == 0L) {
                return;
            }
            try {
                long updateCount2 = 0L;
                long timestamp = System.currentTimeMillis();
                try (ClosableResultsProducer producer = this.statement.noisy().executeBatch();){
                    while (producer.advance()) {
                        int count2 = producer.processCurrent(StandardResultsProcessors.UPDATE_COUNT);
                        if (count2 >= 0) {
                            updateCount2 += (long)count2;
                            continue;
                        }
                        if (count2 != -3) continue;
                        ++this.failCount;
                    }
                }
                String executionTime = StringUtil.formatDuration((long)(System.currentTimeMillis() - timestamp));
                if (updateCount2 == 0L) {
                    this.reporter.print("completed in " + executionTime);
                } else {
                    this.reporter.print(updateCount2 + " row(s) affected in " + executionTime);
                }
            }
            catch (Exception ex) {
                this.reporter.error(JdbcEngine.getErrorMessage(ex, this.dataSource), null);
                this.failCount += this.batchCount;
            }
            finally {
                this.batchCount = 0L;
                this.batchLength = 0L;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/RunSqlScriptAction$Runner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withConnected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

