/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.icons.AllIcons;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import icons.DatabaseIcons;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseRunners {
    private DatabaseRunners() {
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner createSessionRunner(@NotNull DatabaseSession session2, @NotNull Runnable runnable, boolean qualify) {
        if (session2 == null) {
            DatabaseRunners.$$$reportNull$$$0(0);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(1);
        }
        String title = qualify ? SessionsUtil.qualifiedName(session2) : session2.getTitle();
        String dsId = ((LocalDataSource)session2.getTarget()).getUniqueId();
        return DatabaseRunners.createRunner(title, dsId, session2.getProject(), DatabaseSession.getIcon(session2.isConnected()), runnable);
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner createConsoleRunner(@NotNull JdbcConsole console, @NotNull Runnable runnable) {
        if (console == null) {
            DatabaseRunners.$$$reportNull$$$0(2);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(3);
        }
        return DatabaseRunners.createRunner(console.getDisplayName(), ((LocalDataSource)console.getTarget()).getUniqueId(), console.getProject(), ((LocalDataSource)console.getTarget()).getIcon(), runnable);
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner createDataSourceRunner(@NotNull DbDataSource dataSource2, @NotNull Runnable runnable) {
        if (dataSource2 == null) {
            DatabaseRunners.$$$reportNull$$$0(4);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(5);
        }
        return new MyRunner(dataSource2.getName(), false, false, dataSource2.getIcon(), DatabaseRunners.getRunnerColor(dataSource2), runnable);
    }

    public static PersistenceConsoleProvider.Runner createDataSourceRunner(final @NotNull DbDataSource dataSource2, final @NotNull String title, final @NotNull Consumer<? super DatabaseSession> consumer2) {
        if (dataSource2 == null) {
            DatabaseRunners.$$$reportNull$$$0(6);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(7);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(8);
        }
        final Project project = dataSource2.getProject();
        return new MyRunner(dataSource2.getName(), false, false, dataSource2.getIcon(), DatabaseRunners.getRunnerColor(dataSource2), EmptyRunnable.getInstance()){

            @NotNull
            public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                VirtualFile consoleDir = DatabaseEditorHelper.getConsoleRootDir((DasDataSource)dataSource2);
                PersistenceConsoleProvider.Runner newRunner = DatabaseRunners.newSessionRunner((Consumer<? super DatabaseSession>)consumer2, title, project, dataSource2, consoleDir == null);
                List<DatabaseSession> sessions = DatabaseSessionManager.getSessions(project, DbImplUtil.getLocalDataSource((DasDataSource)dataSource2));
                JBIterable perSession = JBIterable.from(sessions).map(s -> DatabaseRunners.createSessionRunner(s, () -> consumer2.consume(s), false));
                List list = (List)JBIterable.of((Object)newRunner).append((Iterable)perSession).addAllTo(new ArrayList());
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseRunners$1", "getSubRunners"));
            }
        };
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner createDataSourceConsolesRunner(final @NotNull DbDataSource dataSource2, final @NotNull Consumer<? super VirtualFile> consumer2) {
        if (dataSource2 == null) {
            DatabaseRunners.$$$reportNull$$$0(9);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(10);
        }
        final Project project = dataSource2.getProject();
        return new MyRunner(dataSource2.getName(), false, false, dataSource2.getIcon(0), DatabaseRunners.getRunnerColor(dataSource2), EmptyRunnable.getInstance()){

            @NotNull
            public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                VirtualFile consoleDir = DatabaseEditorHelper.getConsoleRootDir((DasDataSource)dataSource2);
                Icon icon = dataSource2.getIcon(0);
                Color color = DatabaseRunners.getRunnerColor(dataSource2);
                Icon newIcon = LayeredIcon.create((Icon)DatabaseIcons.ConsoleRun, (Icon)AllIcons.Actions.New);
                PersistenceConsoleProvider.Runner newRunner = DatabaseRunners.newPriorityRunner(PriorityAction.Priority.HIGH, DatabaseBundle.message((String)"console.new.console", (Object[])new Object[0]), false, consoleDir == null, newIcon, color, () -> consumer2.consume((Object)DatabaseEditorHelper.createNewConsoleVirtualFile((DasDataSource)dataSource2)));
                if (consoleDir == null) {
                    List<PersistenceConsoleProvider.Runner> list = Collections.singletonList(newRunner);
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                VirtualFile defaultConsoleFile = DatabaseEditorHelper.findExistingConsoleVirtualFile((DasDataSource)dataSource2);
                Map allRunningFiles = JBIterable.from(JdbcConsole.getActiveConsoles(project)).toReverseMap(o -> o.getVirtualFile());
                PersistenceConsoleProvider.Runner defRunner = DatabaseRunners.newPriorityRunner(PriorityAction.Priority.HIGH, "console (Default)", allRunningFiles.containsKey(defaultConsoleFile), true, icon, color, () -> consumer2.consume(ObjectUtils.notNull((Object)defaultConsoleFile, () -> Objects.requireNonNull(DatabaseEditorHelper.getConsoleVirtualFile((DasDataSource)dataSource2)))));
                DbConsoleRootType rootType = DbConsoleRootType.getInstance();
                JBIterable perFile = FileUtil.fileTraverser((File)VfsUtilCore.virtualToIoFile((VirtualFile)consoleDir)).traverse(TreeTraversal.LEAVES_BFS).take(100).filterMap(file -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file)).filter(file -> !file.equals(defaultConsoleFile)).filter(file -> !allRunningFiles.containsKey(file)).map(file -> new MyRunner(StringUtil.trimEnd((String)Objects.requireNonNull(rootType.substituteName(project, (VirtualFile)file)), (String)(" [" + dataSource2.getName() + "]")), false, false, icon, color, () -> consumer2.consume(file)));
                PersistenceConsoleProvider.Runner dir = DatabaseRunners.newPriorityRunner(PriorityAction.Priority.LOW, DatabaseBundle.message((String)"jump.to.console.files", (Object[])new Object[0]), false, false, null, color, () -> {
                    PsiManager psiManager = PsiManager.getInstance((Project)project);
                    PsiDirectory psiDirectory = psiManager.findDirectory(consoleDir);
                    if (psiDirectory != null) {
                        psiDirectory.navigate(true);
                    }
                });
                List list = (List)JBIterable.of((Object[])new PersistenceConsoleProvider.Runner[]{defRunner, newRunner}).append((Iterable)perFile).append((Object)dir).addAllTo(new ArrayList());
                if (list == null) {
                    2.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseRunners$2", "getSubRunners"));
            }
        };
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> createRunners(@Nullable JdbcConsoleProvider.Info info, boolean ignoreForced) {
        if (info == null || info.model.statements().isEmpty()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                DatabaseRunners.$$$reportNull$$$0(11);
            }
            return list;
        }
        Project project = info.originalFile.getProject();
        JBIterable<DbDataSource> dataSources2 = DbImplUtil.getDataSourcesForExec(info.file, ignoreForced, false);
        if (dataSources2.isEmpty()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                DatabaseRunners.$$$reportNull$$$0(12);
            }
            return list;
        }
        HashSet<String> allowedIds = new HashSet<String>();
        for (DbDataSource source : dataSources2) {
            allowedIds.add(source.getUniqueId());
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        for (DatabaseSession session3 : DatabaseSessionManager.getSessions(project)) {
            if (!allowedIds.contains(((LocalDataSource)session3.getTarget()).getUniqueId())) continue;
            result.add(DatabaseRunners.createSessionRunner(session3, () -> DatabaseRunners.runInner(session3, info), allowedIds.size() > 1));
        }
        for (DbDataSource dataSource2 : dataSources2) {
            if (!DbImplUtil.canConnectTo((DbElement)dataSource2)) continue;
            result.add(DatabaseRunners.createDataSourceRunner(dataSource2, DatabaseSession.getTitle(project, info.originalFile.getVirtualFile()), (Consumer<? super DatabaseSession>)((Consumer)session2 -> DatabaseRunners.runInner(session2, info))));
        }
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            DatabaseRunners.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> getRunners(@NotNull JBIterable<DbDataSource> dataSources2, @NotNull Project project, @Nullable DatabaseSession current, @NotNull String title, @NotNull Consumer<? super DatabaseSession> consumer2) {
        if (dataSources2 == null) {
            DatabaseRunners.$$$reportNull$$$0(14);
        }
        if (project == null) {
            DatabaseRunners.$$$reportNull$$$0(15);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(16);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(17);
        }
        return DatabaseRunners.getRunners(dataSources2, project, current, title, consumer2, true);
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> getRunners(@NotNull JBIterable<DbDataSource> dataSources2, @NotNull Project project, @Nullable DatabaseSession current, @NotNull String title, @NotNull Consumer<? super DatabaseSession> consumer2, boolean allowDetach) {
        if (dataSources2 == null) {
            DatabaseRunners.$$$reportNull$$$0(18);
        }
        if (project == null) {
            DatabaseRunners.$$$reportNull$$$0(19);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(20);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(21);
        }
        Set allowedIds = dataSources2.map(o -> o.getUniqueId()).toSet();
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        if (allowDetach && current != null) {
            result.add(DatabaseRunners.newPriorityRunner(PriorityAction.Priority.HIGH, DatabaseBundle.message((String)"detach.session", (Object[])new Object[0]), false, false, AllIcons.Actions.Cancel, null, () -> consumer2.consume(null)));
        }
        for (DatabaseSession session2 : DatabaseSessionManager.getSessions(project)) {
            if (session2 == current || !allowedIds.contains(((LocalDataSource)session2.getTarget()).getUniqueId())) continue;
            result.add(DatabaseRunners.createSessionRunner(session2, () -> consumer2.consume((Object)session2), allowedIds.size() > 1));
        }
        for (DbDataSource dataSource2 : dataSources2) {
            result.add(DatabaseRunners.createDataSourceRunner(dataSource2, title, consumer2));
        }
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            DatabaseRunners.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @Nullable
    private static Color getRunnerColor(@NotNull DbDataSource o) {
        if (o == null) {
            DatabaseRunners.$$$reportNull$$$0(23);
        }
        DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(o.getProject()).getState();
        boolean useColors = state.useColors && state.inDatabaseView;
        return useColors ? DatabaseColorManager.getColor((DbElement)o) : null;
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner newSessionRunner(@NotNull Consumer<? super DatabaseSession> consumer2, @NotNull String title, @NotNull Project project, @NotNull DbDataSource dataSource2, boolean hasDefault) {
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(24);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(25);
        }
        if (project == null) {
            DatabaseRunners.$$$reportNull$$$0(26);
        }
        if (dataSource2 == null) {
            DatabaseRunners.$$$reportNull$$$0(27);
        }
        Icon icon = LayeredIcon.create((Icon)DatabaseSession.getIcon(false), (Icon)AllIcons.Actions.New);
        Color color = DatabaseRunners.getRunnerColor(dataSource2);
        Runnable runnable = () -> {
            LocalDataSource localDataSource = DbImplUtil.getLocalDataSource((DasDataSource)dataSource2);
            DatabaseSession session2 = DatabaseSessionManager.openSession(project, localDataSource, title);
            consumer2.consume((Object)session2);
        };
        return DatabaseRunners.newPriorityRunner(PriorityAction.Priority.HIGH, DatabaseBundle.message((String)"new.session", (Object[])new Object[0]), false, hasDefault, icon, color, runnable);
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner newPriorityRunner(@NotNull PriorityAction.Priority priority, @NotNull String displayName, boolean running, boolean defaultSubRunner, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable) {
        if (priority == null) {
            DatabaseRunners.$$$reportNull$$$0(28);
        }
        if (displayName == null) {
            DatabaseRunners.$$$reportNull$$$0(29);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(30);
        }
        return new PriorityRunner(displayName, running, defaultSubRunner, icon, color, runnable, priority);
    }

    private static void runInner(@NotNull DatabaseSession session2, @NotNull JdbcConsoleProvider.Info info) {
        JdbcConsole console;
        PsiFile topPsi;
        VirtualFile virtualFile;
        if (session2 == null) {
            DatabaseRunners.$$$reportNull$$$0(31);
        }
        if (info == null) {
            DatabaseRunners.$$$reportNull$$$0(32);
        }
        if (!session2.isValid()) {
            return;
        }
        if (info.editor instanceof EditorWindow && !((EditorWindow)info.editor).isValid()) {
            return;
        }
        if (info.editor != null && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)(topPsi = InjectedLanguageManager.getInstance((Project)info.originalFile.getProject()).getTopLevelFile((PsiElement)info.originalFile)))) != null && (console = JdbcConsoleProvider.attachConsole(session2.getProject(), session2, virtualFile)) != null) {
            JdbcConsoleProvider.doRunQueryInConsole(console, info);
        }
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner createRunner(@NotNull String title, @NotNull String dataSourceId, @NotNull Project project, @NotNull Icon icon, @NotNull Runnable runnable) {
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(33);
        }
        if (dataSourceId == null) {
            DatabaseRunners.$$$reportNull$$$0(34);
        }
        if (project == null) {
            DatabaseRunners.$$$reportNull$$$0(35);
        }
        if (icon == null) {
            DatabaseRunners.$$$reportNull$$$0(36);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(37);
        }
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)project);
        DbDataSource dataSource2 = Objects.requireNonNull(dbPsiFacade.findDataSource(dataSourceId));
        return new MyRunner(title, true, false, icon, DatabaseRunners.getRunnerColor(dataSource2), runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 7: 
            case 16: 
            case 20: 
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: 
            case 10: 
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/DatabaseRunners";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 15: 
            case 19: 
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/DatabaseRunners";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunners";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSessionRunner";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleRunner";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceRunner";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceConsolesRunner";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 22: {
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerColor";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "newSessionRunner";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "newPriorityRunner";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "runInner";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createRunner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class PriorityRunner
    extends MyRunner
    implements PriorityAction {
        private final PriorityAction.Priority myPriority;

        PriorityRunner(@NotNull String displayName, boolean running, boolean defaultSubRunner, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable, @NotNull PriorityAction.Priority priority) {
            if (displayName == null) {
                PriorityRunner.$$$reportNull$$$0(0);
            }
            if (runnable == null) {
                PriorityRunner.$$$reportNull$$$0(1);
            }
            if (priority == null) {
                PriorityRunner.$$$reportNull$$$0(2);
            }
            super(displayName, running, defaultSubRunner, icon, color, runnable);
            this.myPriority = priority;
        }

        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = this.myPriority;
            if (priority == null) {
                PriorityRunner.$$$reportNull$$$0(3);
            }
            return priority;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "priority";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseRunners$PriorityRunner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseRunners$PriorityRunner";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class MyRunner
    extends PersistenceConsoleProvider.Runner {
        final String displayName;
        final boolean running;
        final boolean defaultSubRunner;
        final Icon icon;
        final Color color;
        final Runnable runnable;

        MyRunner(@NotNull String displayName, boolean running, boolean defaultSubRunner, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable) {
            if (displayName == null) {
                MyRunner.$$$reportNull$$$0(0);
            }
            if (runnable == null) {
                MyRunner.$$$reportNull$$$0(1);
            }
            this.displayName = displayName;
            this.running = running;
            this.defaultSubRunner = defaultSubRunner;
            this.icon = icon;
            this.color = color;
            this.runnable = runnable;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon() {
            return this.icon;
        }

        @Nullable
        public Color getColor() {
            return this.color;
        }

        public boolean isAlreadyRunning() {
            return this.running;
        }

        public boolean isDefaultSubRunner() {
            return this.defaultSubRunner;
        }

        public void run() {
            this.runnable.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "displayName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runnable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/DatabaseRunners$MyRunner";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

