/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.dump.pg;

import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.SimpleCliDialogValidator;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.cli.argument.CommonPgArguments;
import com.intellij.database.cli.argument.CommonPgCliArguments;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgDialogValidator
extends SimpleCliDialogValidator {
    private static final String INVALID_FILE = "Path must point on file";
    private static final String DATA_ONLY = "Options -c/--clean and -a/--data-only cannot be used together";
    private static final String IF_EXISTS = "Option --if-exists requires option -c/--clean";

    public PgDialogValidator() {
        super(CommonPgArguments.FILE, CommonPgArguments.PASSWORD);
    }

    protected PgDialogValidator(@NotNull String[] fileArgs) {
        if (fileArgs == null) {
            PgDialogValidator.$$$reportNull$$$0(0);
        }
        super(fileArgs, CommonPgArguments.PASSWORD);
    }

    @Override
    @Nullable
    public ValidationInfo createInfo(@NotNull CliModel model) {
        ValidationInfo info;
        if (model == null) {
            PgDialogValidator.$$$reportNull$$$0(1);
        }
        return (info = super.createInfo(model)) == null ? this.createInfoInternal(model) : info;
    }

    @Nullable
    private ValidationInfo createInfoInternal(@NotNull CliModel model) {
        if (model == null) {
            PgDialogValidator.$$$reportNull$$$0(2);
        }
        CliArgument argument = this.getFormatArgument(model.getCliComponents());
        CliComponent pathComponent = this.getPathComponent(model.getCliComponents());
        if (this.checkFileError(pathComponent, argument)) {
            return new ValidationInfo(INVALID_FILE, Objects.requireNonNull(pathComponent).getComponent());
        }
        if (this.checkDirError(pathComponent, argument)) {
            return new ValidationInfo(this.getInvalidDirectoryError(), Objects.requireNonNull(pathComponent).getComponent());
        }
        CliContextDescriptor cd = model.getContext();
        return PgDialogValidator.checkDataOnly(cd) ? new ValidationInfo(DATA_ONLY, model.getCommandComponent()) : (PgDialogValidator.checkIfExists(cd) ? new ValidationInfo(IF_EXISTS, model.getCommandComponent()) : null);
    }

    @NotNull
    protected abstract String getInvalidDirectoryError();

    @NotNull
    protected List<CliArgument> getFileArgs() {
        List<CliArgument> list = Arrays.asList(CommonPgCliArguments.F_CUSTOM, CommonPgCliArguments.F_TAR);
        if (list == null) {
            PgDialogValidator.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected boolean isDirectoryWrong(@NotNull File file) {
        if (file == null) {
            PgDialogValidator.$$$reportNull$$$0(4);
        }
        return file.isFile();
    }

    @NotNull
    protected abstract StringCliArgument getPathArgument();

    private boolean checkDirError(@Nullable CliComponent component, @Nullable CliArgument argument) {
        String text2 = PgDialogValidator.getText(component);
        if (text2 == null) {
            return false;
        }
        File file = new File(text2);
        return this.isDirectoryWrong(file) && argument == CommonPgCliArguments.F_DIRECTORY;
    }

    @Nullable
    private CliArgument getFormatArgument(@NotNull List<CliComponent> components) {
        Condition condition;
        CliComponent component2;
        if (components == null) {
            PgDialogValidator.$$$reportNull$$$0(5);
        }
        return (component2 = (CliComponent)ContainerUtil.find(components, (Condition)(condition = component -> ContainerUtil.containsIdentity(this.getFileArgs(), (Object)component.getArgument()) || component.getArgument() == CommonPgCliArguments.F_DIRECTORY))) == null ? null : component2.getArgument();
    }

    @Nullable
    private CliComponent getPathComponent(List<CliComponent> components) {
        return (CliComponent)ContainerUtil.find(components, component -> component.getArgument() == this.getPathArgument());
    }

    private boolean checkFileError(@Nullable CliComponent component, @Nullable CliArgument argument) {
        String text2 = PgDialogValidator.getText(component);
        if (text2 == null) {
            return false;
        }
        File file = new File(text2);
        return file.isDirectory() && ContainerUtil.containsIdentity(this.getFileArgs(), (Object)argument);
    }

    @Nullable
    private static String getText(@Nullable CliComponent component) {
        if (component == null) {
            return null;
        }
        JComponent swingComponent = component.getComponent();
        if (!(swingComponent instanceof TextFieldWithBrowseButton)) {
            return null;
        }
        return ((TextFieldWithBrowseButton)swingComponent).getText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkDataOnly(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            PgDialogValidator.$$$reportNull$$$0(6);
        }
        if (ContainerUtil.find((Object[])CommonPgArguments.DATA_ONLY, cd::contains) == null) return false;
        if (ContainerUtil.find((Object[])CommonPgArguments.CLEAN_DATABASE, cd::contains) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkIfExists(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            PgDialogValidator.$$$reportNull$$$0(7);
        }
        if (!cd.contains("--if-exists")) return false;
        if (ContainerUtil.find((Object[])CommonPgArguments.CLEAN_DATABASE, cd::contains) != null) return false;
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileArgs";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/dump/pg/PgDialogValidator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/dump/pg/PgDialogValidator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createInfoInternal";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryWrong";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFormatArgument";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkDataOnly";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkIfExists";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

