/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliComponent;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public interface CliPanelDecorator {
    public JComponent decorate(@NotNull HideableTitledPanel var1, @NotNull JComponent var2, @NotNull List<CliComponent> var3);

    public static class DefaultCliPanelDecorator
    implements CliPanelDecorator {
        private static final String EXEC_PATH = "Path to %s: ";
        private static final int WIDTH = 2;
        private static final int GAP = 6;
        private final String myName;

        public DefaultCliPanelDecorator(@NotNull String name) {
            if (name == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @Override
        public JComponent decorate(@NotNull HideableTitledPanel titledPanel, @NotNull JComponent pathComponent, @NotNull List<CliComponent> components) {
            if (titledPanel == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(1);
            }
            if (pathComponent == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(2);
            }
            if (components == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(3);
            }
            JComponent hideable = this.getHideablePanel(pathComponent, components);
            JComponent visible = DefaultCliPanelDecorator.getAlwaysVisiblePanel(components);
            titledPanel.setContentComponent(hideable);
            JPanel panel2 = new JPanel((LayoutManager)new VerticalLayout(6));
            panel2.add((Component)titledPanel);
            panel2.add(visible);
            return panel2;
        }

        @NotNull
        private JComponent getHideablePanel(@NotNull JComponent pathComponent, @NotNull List<CliComponent> components) {
            if (pathComponent == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(4);
            }
            if (components == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(5);
            }
            JPanel panel2 = new JPanel(new GridBagLayout());
            JBLabel pathLabel = new JBLabel(String.format(EXEC_PATH, this.myName));
            GridBagConstraints gbc = DefaultCliPanelDecorator.createConstraints();
            DefaultCliPanelDecorator.add(panel2, (JComponent)pathLabel, gbc);
            DefaultCliPanelDecorator.span(gbc);
            DefaultCliPanelDecorator.add(panel2, pathComponent, gbc);
            DefaultCliPanelDecorator.addComponents(panel2, gbc, ContainerUtil.filter(components, CliComponent::isHideable));
            JPanel jPanel = panel2;
            if (jPanel == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(6);
            }
            return jPanel;
        }

        @NotNull
        private static JComponent getAlwaysVisiblePanel(@NotNull List<CliComponent> components) {
            if (components == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(7);
            }
            JPanel panel2 = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = DefaultCliPanelDecorator.createConstraints();
            DefaultCliPanelDecorator.addComponents(panel2, gbc, ContainerUtil.filter(components, (Condition)Conditions.not(CliComponent::isHideable)));
            JPanel jPanel = panel2;
            if (jPanel == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(8);
            }
            return jPanel;
        }

        private static void addComponents(@NotNull JPanel panel2, @NotNull GridBagConstraints gbc, @NotNull List<CliComponent> components) {
            if (panel2 == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(9);
            }
            if (gbc == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(10);
            }
            if (components == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(11);
            }
            for (CliComponent component : components) {
                DefaultCliPanelDecorator.addComponent(panel2, component, gbc);
            }
        }

        private static GridBagConstraints createConstraints() {
            GridBagConstraints gbc = new GridBagConstraints();
            DefaultCliPanelDecorator.reset(gbc);
            return gbc;
        }

        private static void reset(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(12);
            }
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            DefaultCliPanelDecorator.noSpan(gbc);
        }

        private static void addComponent(@NotNull JPanel panel2, @NotNull CliComponent component, @NotNull GridBagConstraints gbc) {
            if (panel2 == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(13);
            }
            if (component == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(14);
            }
            if (gbc == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(15);
            }
            if (component.getLabel() == null) {
                DefaultCliPanelDecorator.addSimple(panel2, component, gbc);
                return;
            }
            DefaultCliPanelDecorator.addLabeled(panel2, component, gbc);
        }

        private static void addSimple(@NotNull JPanel panel2, @NotNull CliComponent component, @NotNull GridBagConstraints gbc) {
            if (panel2 == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(16);
            }
            if (component == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(17);
            }
            if (gbc == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(18);
            }
            DefaultCliPanelDecorator.noSpan(gbc);
            DefaultCliPanelDecorator.add(panel2, component.getComponent(), gbc);
            DefaultCliPanelDecorator.addDescription(panel2, component, gbc);
        }

        private static void addLabeled(@NotNull JPanel panel2, @NotNull CliComponent component, @NotNull GridBagConstraints gbc) {
            if (panel2 == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(19);
            }
            if (component == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(20);
            }
            if (gbc == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(21);
            }
            DefaultCliPanelDecorator.noSpan(gbc);
            DefaultCliPanelDecorator.nextLine(gbc);
            DefaultCliPanelDecorator.add(panel2, (JComponent)new JBLabel(component.getLabel() + ": "), gbc);
            DefaultCliPanelDecorator.span(gbc);
            DefaultCliPanelDecorator.add(panel2, component.getComponent(), gbc);
            DefaultCliPanelDecorator.addDescription(panel2, component, gbc);
        }

        private static void addDescription(@NotNull JPanel panel2, @NotNull CliComponent component, @NotNull GridBagConstraints gbc) {
            if (panel2 == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(22);
            }
            if (component == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(23);
            }
            if (gbc == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(24);
            }
            if (component.getDescription() == null) {
                return;
            }
            DefaultCliPanelDecorator.nextCell(gbc);
            DefaultCliPanelDecorator.add(panel2, ComponentPanelBuilder.createCommentComponent((String)component.getDescription(), (boolean)true, (int)100), gbc);
        }

        private static void nextLine(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(25);
            }
            gbc.gridx = 0;
            ++gbc.gridy;
        }

        private static void noSpan(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(26);
            }
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
        }

        private static void span(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(27);
            }
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
        }

        private static void nextCell(@NotNull GridBagConstraints gbc) {
            if (gbc == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(28);
            }
            if (gbc.gridx == 1) {
                DefaultCliPanelDecorator.nextLine(gbc);
                return;
            }
            ++gbc.gridx;
        }

        private static void add(@NotNull JPanel panel2, @NotNull JComponent component, @NotNull GridBagConstraints gbc) {
            if (panel2 == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(29);
            }
            if (component == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(30);
            }
            if (gbc == null) {
                DefaultCliPanelDecorator.$$$reportNull$$$0(31);
            }
            panel2.add((Component)component, gbc);
            DefaultCliPanelDecorator.nextCell(gbc);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "titledPanel";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathComponent";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator";
                    break;
                }
                case 9: 
                case 13: 
                case 16: 
                case 19: 
                case 22: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 10: 
                case 12: 
                case 15: 
                case 18: 
                case 21: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gbc";
                    break;
                }
                case 14: 
                case 17: 
                case 20: 
                case 23: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliPanelDecorator$DefaultCliPanelDecorator";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHideablePanel";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlwaysVisiblePanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "decorate";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getHideablePanel";
                    break;
                }
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getAlwaysVisiblePanel";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addComponents";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "addComponent";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "addSimple";
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "addLabeled";
                    break;
                }
                case 22: 
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "addDescription";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "nextLine";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "noSpan";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "span";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "nextCell";
                    break;
                }
                case 29: 
                case 30: 
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

