/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.actions.handlers;

import com.intellij.openapi.project.Project;
import com.jetbrains.intellij.datalore.DataloreBundle;
import com.jetbrains.intellij.datalore.api.DataloreController;
import com.jetbrains.intellij.datalore.models.DataloreSyncWorkbookContext;
import com.jetbrains.intellij.datalore.models.WorkbookInfo;
import com.jetbrains.intellij.datalore.services.AuthService;
import com.jetbrains.intellij.datalore.services.SyncService;
import com.jetbrains.intellij.datalore.services.WorkbookService;
import com.jetbrains.intellij.datalore.util.NotificationUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/intellij/datalore/actions/handlers/SyncChangesActionHandler;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "mySyncService", "Lcom/jetbrains/intellij/datalore/services/SyncService;", "syncWorkbooks", "", "datalore-intellij-plugin"})
public final class SyncChangesActionHandler {
    private final SyncService mySyncService;
    private final Project myProject;

    public final void syncWorkbooks() {
        Collection<WorkbookInfo> createdWorkbooks = WorkbookService.Companion.getInstance(this.myProject).getCreatedWorkbooks();
        int successSyncCount = 0;
        String token = AuthService.Companion.getInstance().getToken();
        if (token == null) {
            NotificationUtil.INSTANCE.fireErrorNotification(this.myProject, "You are not logged in");
            return;
        }
        for (WorkbookInfo info : createdWorkbooks) {
            boolean committed = this.mySyncService.commitChanges(info);
            if (!committed) {
                NotificationUtil.INSTANCE.fireErrorNotification(this.myProject, "Error while committing changes for " + info.getName());
                continue;
            }
            try {
                String changes;
                if (this.mySyncService.getChanges(info) == null) {
                    continue;
                }
                CharSequence charSequence = changes;
                boolean bl = false;
                if (charSequence.length() == 0) continue;
                DataloreController.INSTANCE.callSyncWorkbook(DataloreSyncWorkbookContext.Companion.create(info.getSyncId(), changes), token);
                this.mySyncService.updateCommitHash(info);
                ++successSyncCount;
            }
            catch (RuntimeException e) {
                NotificationUtil.INSTANCE.fireErrorNotification(this.myProject, DataloreBundle.INSTANCE.message("datalore.sync_workbook.error_prefix", new Object[0]));
            }
        }
        switch (successSyncCount) {
            case 0: {
                NotificationUtil.INSTANCE.fireWarningNotification(this.myProject, DataloreBundle.INSTANCE.message("datalore.sync_workbook.notification.no_workbooks_synced", new Object[0]));
                break;
            }
            default: {
                NotificationUtil.INSTANCE.fireOkNotification(this.myProject, DataloreBundle.INSTANCE.message("datalore.sync_workbook.notification.ok", successSyncCount, createdWorkbooks.size()));
            }
        }
    }

    public SyncChangesActionHandler(@NotNull Project myProject) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.mySyncService = SyncService.Companion.getInstance(this.myProject);
    }
}

