/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigHelper;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;

public class PerforceP4ConfigVirtualFileListener
implements VirtualFileListener {
    private final PerforceConnectionManagerI myConnectionManager;
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(PerforceP4ConfigVirtualFileListener.class);

    public PerforceP4ConfigVirtualFileListener(PerforceConnectionManagerI connectionManager, Project project) {
        this.myConnectionManager = connectionManager;
        this.myProject = project;
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(0);
        }
        this.processFileEvent((VirtualFileEvent)event);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(1);
        }
        this.processFileEvent(event);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(2);
        }
        this.processFileEvent(event);
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(3);
        }
        this.processFileEvent(event);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(4);
        }
        this.processFileEvent((VirtualFileEvent)event);
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(5);
        }
        this.processFileEvent((VirtualFileEvent)event);
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(6);
        }
        this.processFileEvent(event);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(7);
        }
        this.processFileEvent(event);
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(8);
        }
        this.processFileEvent((VirtualFileEvent)event);
    }

    private boolean isConfigFileName(@NotNull String fileName) {
        PerforceMultipleConnections multipleConnections;
        if (fileName == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(9);
        }
        if ((multipleConnections = this.myConnectionManager.getMultipleConnectionObject()) != null) {
            for (P4ConnectionParameters parameters : multipleConnections.getParametersMap().values()) {
                if (!Comparing.equal((String)parameters.getConfigFileName(), (String)fileName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIgnoredFileName(@NotNull String fileName) {
        if (fileName == null) {
            PerforceP4ConfigVirtualFileListener.$$$reportNull$$$0(10);
        }
        if (fileName.equals(P4ConfigHelper.getP4IgnoreFileName())) {
            return true;
        }
        PerforceMultipleConnections multipleConnections = this.myConnectionManager.getMultipleConnectionObject();
        if (multipleConnections != null) {
            for (P4ConnectionParameters parameters : multipleConnections.getParametersMap().values()) {
                if (!Comparing.equal((String)parameters.getIgnoreFileName(), (String)fileName)) continue;
                return true;
            }
        }
        return false;
    }

    private void processFileEvent(VirtualFileEvent event) {
        String fileName = event.getFileName();
        if (this.isIgnoredFileName(fileName)) {
            LOG.debug("received virtual file event on p4ignore file");
            PerforceVcs.getInstance(this.myProject).getOnlineChangeProvider().discardCache();
        }
        if (this.isConfigFileName(fileName)) {
            LOG.debug("received virtual file event on p4config file");
            this.myConnectionManager.updateConnections();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/perforce/perforce/connections/PerforceP4ConfigVirtualFileListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "contentsChanged";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCreated";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDeleted";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMoved";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "beforePropertyChange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeContentsChange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileDeletion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileMovement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigFileName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredFileName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

