/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.html.HtmlLikeFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.inspections.quickfixes.AddJSPropertyQuickFix;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.Angular2LangUtil;
import org.angular2.lang.selector.Angular2DirectiveSimpleSelector;
import org.jetbrains.annotations.NotNull;

public class AngularInvalidSelectorInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AngularInvalidSelectorInspection.$$$reportNull$$$0(0);
        }
        if (holder.getFile() instanceof HtmlLikeFile) {
            return new XmlElementVisitor(){

                public void visitXmlAttribute(XmlAttribute attribute) {
                    XmlAttributeValue value;
                    if (attribute.getName().equals("select") && attribute.getParent().getName().equals("ng-content") && (value = attribute.getValueElement()) != null) {
                        try {
                            Angular2DirectiveSimpleSelector.parse(value.getValue());
                        }
                        catch (Angular2DirectiveSimpleSelector.ParseException e) {
                            holder.registerProblem((PsiElement)value, e.getErrorRange().shiftRight(value.getText().indexOf(value.getValue())), e.getMessage(), new LocalQuickFix[0]);
                        }
                    }
                }
            };
        }
        if (DialectDetector.isTypeScript((PsiElement)holder.getFile()) && Angular2LangUtil.isAngular2Context((PsiElement)holder.getFile())) {
            return new JSElementVisitor(){

                public void visitES6Decorator(ES6Decorator decorator) {
                    if (Angular2DecoratorUtil.isAngularEntityDecorator(decorator, "Component", "Directive")) {
                        JSObjectLiteralExpression initializer = Angular2DecoratorUtil.getObjectLiteralInitializer(decorator);
                        if (initializer == null) {
                            return;
                        }
                        JSProperty selector = initializer.findProperty("selector");
                        if (selector == null) {
                            if ("Directive".equals(decorator.getDecoratorName())) {
                                holder.registerProblem((PsiElement)initializer, Angular2Bundle.message("angular.inspection.decorator.directive-missing-selector-property", new Object[0]), new LocalQuickFix[]{new AddJSPropertyQuickFix(initializer, "selector", "", 0, false)});
                            }
                        } else {
                            String text = Angular2DecoratorUtil.getExpressionStringValue(selector.getValue());
                            if (text != null) {
                                try {
                                    Angular2DirectiveSimpleSelector.parse(text);
                                }
                                catch (Angular2DirectiveSimpleSelector.ParseException e) {
                                    holder.registerProblem((PsiElement)selector.getValue(), e.getErrorRange().shiftRight(1), e.getMessage(), new LocalQuickFix[0]);
                                }
                            }
                        }
                    }
                }
            };
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            AngularInvalidSelectorInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/inspections/AngularInvalidSelectorInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/inspections/AngularInvalidSelectorInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

