/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.actions;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlDocumentationProvider;
import com.intellij.sql.psi.impl.SqlCreateTypeStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class OraNavigationHelper {
    public static OraNavigationHelper getInstance() {
        return (OraNavigationHelper)ApplicationManager.getApplication().getService(OraNavigationHelper.class);
    }

    @Nullable
    public Pair<String, JBIterable<? extends PsiObject>> findSuperDefinitions(@NotNull PsiObject def, boolean checkOnly) {
        if (def == null) {
            OraNavigationHelper.$$$reportNull$$$0(0);
        }
        if (def.getKind() == ObjectKind.BODY) {
            return Pair.create((Object)"Go to specification", checkOnly ? JBIterable.empty() : OraNavigationHelper.findBodySpecifications(def));
        }
        if (OraNavigationHelper.isBodyRoutine(def)) {
            JBIterable<? extends PsiObject> specifications = OraNavigationHelper.findRoutineSpecifications(def);
            if (checkOnly && specifications.isEmpty()) {
                return null;
            }
            return Pair.create((Object)"Go to specification", checkOnly ? JBIterable.empty() : specifications);
        }
        if (def.getKind() == ObjectKind.OBJECT_TYPE) {
            if (checkOnly && !OraNavigationHelper.hasSuperTypes(def)) {
                return null;
            }
            return Pair.create((Object)"Go to super type", checkOnly ? JBIterable.empty() : OraNavigationHelper.findSuperTypes(def));
        }
        return null;
    }

    @Nullable
    public Pair<String, JBIterable<? extends PsiObject>> findDefinitions(@NotNull PsiObject def, boolean checkOnly) {
        ObjectKind pKind;
        ObjectKind kind;
        if (def == null) {
            OraNavigationHelper.$$$reportNull$$$0(1);
        }
        if ((kind = def.getKind()) == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE) {
            return Pair.create((Object)"Go to body", checkOnly ? JBIterable.empty() : OraNavigationHelper.findBodies(def));
        }
        DasObject parent = def.getDasParent();
        ObjectKind objectKind = pKind = parent == null ? null : parent.getKind();
        if (kind == ObjectKind.ROUTINE && (pKind == ObjectKind.PACKAGE || pKind == ObjectKind.OBJECT_TYPE)) {
            return Pair.create((Object)"Go to routine definition", checkOnly ? JBIterable.empty() : OraNavigationHelper.findBodyRoutines(def));
        }
        return null;
    }

    @NotNull
    private static JBIterable<? extends PsiObject> findBodies(@NotNull PsiObject element) {
        JBIterable bodies;
        if (element == null) {
            OraNavigationHelper.$$$reportNull$$$0(2);
        }
        if ((bodies = element.getDasChildren(ObjectKind.BODY).filter(PsiObject.class)).isEmpty()) {
            bodies = SqlDocumentationProvider.findRelatedDbElements((PsiElement)element, (boolean)true).flatten(e -> e.getDasChildren(ObjectKind.BODY).filter(PsiObject.class));
        }
        JBIterable jBIterable = bodies;
        if (jBIterable == null) {
            OraNavigationHelper.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    private static JBIterable<? extends PsiObject> findBodyRoutines(@NotNull PsiObject element) {
        PsiObject parent;
        ObjectKind kind;
        if (element == null) {
            OraNavigationHelper.$$$reportNull$$$0(4);
        }
        ObjectKind objectKind = kind = (parent = (PsiObject)ObjectUtils.tryCast((Object)element.getDasParent(), PsiObject.class)) == null ? null : parent.getKind();
        if (kind != ObjectKind.OBJECT_TYPE && kind != ObjectKind.PACKAGE) {
            return JBIterable.empty();
        }
        return OraNavigationHelper.findBodies(parent).flatten(b -> {
            DbElement db = (DbElement)ObjectUtils.tryCast((Object)b, DbElement.class);
            if (db == null) {
                return b.getDasChildren(ObjectKind.ROUTINE).filter(DbSqlUtil.byName((DasObject)element, null, (CasingProvider)DbImplUtil.getCasingProvider((DasObject)element))).filter(PsiObject.class);
            }
            VirtualFile file = DatabaseTargetElementEvaluator.getContainingFile((DbElement)db, (boolean)false);
            if (file == null) {
                return JBIterable.empty();
            }
            return JBIterable.of((Object)DatabaseTargetElementEvaluator.calcTarget((Project)db.getProject(), (VirtualFile)file, (DasObject)element));
        });
    }

    public static boolean isBodyRoutine(@NotNull PsiObject def) {
        if (def == null) {
            OraNavigationHelper.$$$reportNull$$$0(5);
        }
        if (def.getKind() != ObjectKind.ROUTINE) {
            return false;
        }
        DasObject parent = def.getDasParent();
        return parent != null && parent.getKind() == ObjectKind.BODY;
    }

    @NotNull
    public static JBIterable<? extends PsiObject> findBodySpecifications(@NotNull PsiObject body2) {
        PsiObject parent;
        JBIterable pkgs;
        if (body2 == null) {
            OraNavigationHelper.$$$reportNull$$$0(6);
        }
        if ((pkgs = SqlImplUtil.unwrapFake((PsiObject)(parent = (PsiObject)ObjectUtils.tryCast((Object)body2.getDasParent(), PsiObject.class)))).isEmpty()) {
            pkgs = SqlDocumentationProvider.findRelatedDbElements((PsiElement)body2, (boolean)true).map(DbElement::getParent);
        }
        JBIterable jBIterable = pkgs;
        if (jBIterable == null) {
            OraNavigationHelper.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<? extends PsiObject> findRoutineSpecifications(@NotNull PsiObject routine) {
        PsiObject body2;
        if (routine == null) {
            OraNavigationHelper.$$$reportNull$$$0(8);
        }
        if ((body2 = (PsiObject)ObjectUtils.tryCast((Object)routine.getDasParent(), PsiObject.class)) == null || body2.getKind() != ObjectKind.BODY) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                OraNavigationHelper.$$$reportNull$$$0(9);
            }
            return jBIterable;
        }
        Condition condition = DbSqlUtil.byName((DasObject)routine, null, (CasingProvider)DbImplUtil.getCasingProvider((DasObject)routine));
        JBIterable jBIterable = OraNavigationHelper.findBodySpecifications(body2).flatten(b -> b.getDasChildren(ObjectKind.ROUTINE).filter(condition)).filter(PsiObject.class);
        if (jBIterable == null) {
            OraNavigationHelper.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    public static boolean hasSuperTypes(@NotNull PsiObject type) {
        if (type == null) {
            OraNavigationHelper.$$$reportNull$$$0(11);
        }
        if (type instanceof SqlCreateTypeStatementImpl) {
            return ((SqlCreateTypeStatementImpl)type).getSuperTypeRef() != null;
        }
        if (type instanceof DasUserDefinedType) {
            return ((DasUserDefinedType)type).getSuperType() != null;
        }
        return false;
    }

    @NotNull
    public static JBIterable<? extends PsiObject> findSuperTypes(@NotNull PsiObject type) {
        DasUserDefinedType tp;
        PsiObject st;
        if (type == null) {
            OraNavigationHelper.$$$reportNull$$$0(12);
        }
        if ((st = (PsiObject)ObjectUtils.tryCast((Object)((tp = (DasUserDefinedType)ObjectUtils.tryCast((Object)type, DasUserDefinedType.class)) == null ? null : tp.getSuperType()), PsiObject.class)) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                OraNavigationHelper.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }
        JBIterable supers = SqlImplUtil.unwrapFake((PsiObject)st);
        if (supers.isEmpty()) {
            supers = SqlDocumentationProvider.findRelatedDbElements((PsiElement)st, (boolean)true);
        }
        JBIterable jBIterable = supers;
        if (jBIterable == null) {
            OraNavigationHelper.$$$reportNull$$$0(14);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/actions/OraNavigationHelper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/actions/OraNavigationHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findBodies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findBodySpecifications";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findRoutineSpecifications";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSuperDefinitions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findDefinitions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findBodies";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findBodyRoutines";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBodyRoutine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBodySpecifications";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findRoutineSpecifications";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasSuperTypes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findSuperTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

