/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql.dataFlow;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlFlowGraphBuilder;
import com.intellij.sql.dataFlow.instructions.SqlLabel;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.mssql.MsElementTypes;
import com.intellij.sql.dialects.mssql.psi.MssqlAlterProcedureStatementImpl;
import com.intellij.sql.dialects.mssql.psi.MssqlTryCatchStatement;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlRaiseStatement;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlVisitor;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/dialects/mssql/dataFlow/MsDFABuildingVisitor;", "Lcom/intellij/sql/dataFlow/DFABuildingVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;)V", "visitSqlAlterStatement", "", "o", "Lcom/intellij/sql/psi/SqlAlterStatement;", "visitSqlBlockStatement", "Lcom/intellij/sql/psi/SqlBlockStatement;", "visitSqlRaiseStatement", "Lcom/intellij/sql/psi/SqlRaiseStatement;", "intellij.database.dialects.mssql"})
public final class MsDFABuildingVisitor
extends DFABuildingVisitor {
    public void visitSqlAlterStatement(@NotNull SqlAlterStatement o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        if (o instanceof MssqlAlterProcedureStatementImpl) {
            this.visitSqlRoutineDefinition((SqlRoutineDefinition)o);
        } else {
            super.visitSqlAlterStatement(o);
        }
    }

    public void visitSqlBlockStatement(@NotNull SqlBlockStatement o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        if (o instanceof MssqlTryCatchStatement) {
            SqlFlowGraphBuilder sqlFlowGraphBuilder = this.getBuilder();
            if (sqlFlowGraphBuilder == null) {
                Intrinsics.throwNpe();
            }
            sqlFlowGraphBuilder.mark((SqlElement)o);
            SqlFlowGraphBuilder sqlFlowGraphBuilder2 = this.getBuilder();
            if (sqlFlowGraphBuilder2 == null) {
                Intrinsics.throwNpe();
            }
            SqlLabel tryStart = sqlFlowGraphBuilder2.newLabel("TRY BLOCK");
            SqlFlowGraphBuilder sqlFlowGraphBuilder3 = this.getBuilder();
            if (sqlFlowGraphBuilder3 == null) {
                Intrinsics.throwNpe();
            }
            SqlLabel catchStart = sqlFlowGraphBuilder3.newLabel("CATCH BLOCK");
            SqlFlowGraphBuilder sqlFlowGraphBuilder4 = this.getBuilder();
            if (sqlFlowGraphBuilder4 == null) {
                Intrinsics.throwNpe();
            }
            SqlLabel tryEnd = sqlFlowGraphBuilder4.newLabel("TRY END");
            SqlFlowGraphBuilder sqlFlowGraphBuilder5 = this.getBuilder();
            if (sqlFlowGraphBuilder5 == null) {
                Intrinsics.throwNpe();
            }
            sqlFlowGraphBuilder5.genNondeterministicJump(CollectionsKt.listOf((Object[])new SqlLabel[]{tryStart, catchStart}));
            SqlFlowGraphBuilder sqlFlowGraphBuilder6 = this.getBuilder();
            if (sqlFlowGraphBuilder6 == null) {
                Intrinsics.throwNpe();
            }
            sqlFlowGraphBuilder6.bindLabelToNext(tryStart);
            SqlFlowGraphBuilder sqlFlowGraphBuilder7 = this.getBuilder();
            if (sqlFlowGraphBuilder7 == null) {
                Intrinsics.throwNpe();
            }
            sqlFlowGraphBuilder7.enterBlock((SqlElement)o);
            for (PsiElement it : ((MssqlTryCatchStatement)o).getBlockElements()) {
                if (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it), (Object)MsElementTypes.Misc.MSSQL_CATCH_CLAUSE)) continue;
                PsiElement psiElement = it;
                if (!(psiElement instanceof SqlElement)) {
                    psiElement = null;
                }
                SqlElement sqlElement = (SqlElement)psiElement;
                if (sqlElement == null) continue;
                sqlElement.accept((SqlVisitor)this);
            }
            SqlFlowGraphBuilder sqlFlowGraphBuilder8 = this.getBuilder();
            if (sqlFlowGraphBuilder8 == null) {
                Intrinsics.throwNpe();
            }
            sqlFlowGraphBuilder8.genJump(tryEnd);
            SqlFlowGraphBuilder sqlFlowGraphBuilder9 = this.getBuilder();
            if (sqlFlowGraphBuilder9 == null) {
                Intrinsics.throwNpe();
            }
            sqlFlowGraphBuilder9.exitBlock((SqlElement)o);
            SqlFlowGraphBuilder sqlFlowGraphBuilder10 = this.getBuilder();
            if (sqlFlowGraphBuilder10 == null) {
                Intrinsics.throwNpe();
            }
            sqlFlowGraphBuilder10.bindLabelToNext(catchStart);
            SqlBlockStatement sqlBlockStatement = ((MssqlTryCatchStatement)o).getCatchBlock();
            if (sqlBlockStatement != null) {
                sqlBlockStatement.accept((SqlVisitor)this);
            }
            SqlFlowGraphBuilder sqlFlowGraphBuilder11 = this.getBuilder();
            if (sqlFlowGraphBuilder11 == null) {
                Intrinsics.throwNpe();
            }
            sqlFlowGraphBuilder11.bindLabelToNext(tryEnd);
        } else {
            super.visitSqlBlockStatement(o);
        }
    }

    public void visitSqlRaiseStatement(@NotNull SqlRaiseStatement o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        if (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)o.getFirstChild()), (Object)SqlCommonKeywords.SQL_RAISERROR)) {
            int severity;
            SqlExpression[] arguments = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)o), SqlExpression.class);
            Object object = arguments;
            if (object == null || (object = (SqlExpression[])ArraysKt.getOrNull((Object[])object, (int)1)) == null || (object = object.getText()) == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
                return;
            }
            int n = severity = ((Integer)object).intValue();
            if (0 <= n && 10 >= n) {
                return;
            }
        }
        SqlFlowGraphBuilder sqlFlowGraphBuilder = this.getBuilder();
        if (sqlFlowGraphBuilder == null) {
            Intrinsics.throwNpe();
        }
        sqlFlowGraphBuilder.mark((SqlElement)o);
        SqlFlowGraphBuilder sqlFlowGraphBuilder2 = this.getBuilder();
        if (sqlFlowGraphBuilder2 == null) {
            Intrinsics.throwNpe();
        }
        sqlFlowGraphBuilder2.genThrow((SqlStatement)o);
    }

    public MsDFABuildingVisitor(@NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkParameterIsNotNull((Object)dialect, (String)"dialect");
        super(dialect);
    }
}

