/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.model;

import com.intellij.database.dialects.sqlite.model.SqliteLikeTable;
import com.intellij.database.dialects.sqlite.model.SqliteSchema;
import com.intellij.database.dialects.sqlite.model.SqliteVirtualTableColumn;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SqliteVirtualTable
extends SqliteLikeTable {
    public static final BasicMetaProperty<String> MODULE = BasicMetaProperty.create((String)"Module", (BasicMetaType)BasicMetaType.Types.STRING, null, SqliteVirtualTable.class, (boolean)false);
    public static final BasicMetaProperty<List<String>> ARGUMENTS = BasicMetaProperty.create((String)"Arguments", (BasicMetaType)BasicMetaType.Types.LIST_OF_STRING, Collections.emptyList(), SqliteVirtualTable.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> TEMPORARY = BasicMetaProperty.create((String)"Temporary", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, SqliteVirtualTable.class, (boolean)false);

    @Nullable
    default public SqliteSchema getSchema() {
        return this.getParent();
    }

    @Nullable
    public SqliteSchema getParent();

    default public @Nullable NamingFamily<@NotNull ? extends SqliteVirtualTable> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModPositioningNamingFamily<@NotNull ? extends SqliteVirtualTableColumn> getColumns();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.COLUMN);
        if (list == null) {
            SqliteVirtualTable.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModPositioningNamingFamily<? extends SqliteVirtualTableColumn>> list = Collections.singletonList(this.getColumns());
        if (list == null) {
            SqliteVirtualTable.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public String getModule();

    @NotNull
    public List<String> getArguments();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean temporary;
        List<String> arguments;
        String module;
        boolean outdated;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        if (consumer == null) {
            SqliteVirtualTable.$$$reportNull$$$0(2);
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if ((module = this.getModule()) != null) {
            consumer.accept("Module", (Object)PropertyConverter.export((String)module));
        }
        if (!(arguments = this.getArguments()).isEmpty()) {
            consumer.accept("Arguments", (Object)PropertyConverter.exportListOfString(arguments));
        }
        if (temporary = this.isTemporary()) {
            consumer.accept("Temporary", (Object)PropertyConverter.export((boolean)temporary));
        }
    }

    public void setModule(@Nullable String var1);

    public void setArguments(@NotNull List<String> var1);

    default public void setArguments(String ... arguments) {
        this.setArguments(Arrays.asList(arguments));
    }

    public void setTemporary(boolean var1);

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            SqliteVirtualTable.$$$reportNull$$$0(3);
        }
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String outdated = _properties.get("Outdated");
        String module = _properties.get("Module");
        String arguments = _properties.get("Arguments");
        String temporary = _properties.get("Temporary");
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setModule(module != null ? PropertyConverter.importString((String)module) : null);
        this.setArguments(arguments != null ? PropertyConverter.importListOfString((String)arguments) : Collections.emptyList());
        this.setTemporary(temporary != null ? PropertyConverter.importBoolean((String)temporary) : false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/sqlite/model/SqliteVirtualTable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/sqlite/model/SqliteVirtualTable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

