/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.testing.utplsql;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dialects.base.DataSourceRunConfigurationOptions;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlCoverageEngine;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlCoverageRunner;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlCoverageSuite;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlRunConfiguration;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlRunConfigurationOptions;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.Function;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlCoverageRunner;", "Lcom/intellij/coverage/CoverageRunner;", "()V", "acceptsCoverageEngine", "", "engine", "Lcom/intellij/coverage/CoverageEngine;", "extractFilePath", "", "objName", "suite", "Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlCoverageSuite;", "getDataFileExtension", "getId", "getPresentableName", "loadCoverageData", "Lcom/intellij/rt/coverage/data/ProjectData;", "sessionDataFile", "Ljava/io/File;", "baseCoverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "loadData", "json", "Lorg/codehaus/jettison/json/JSONObject;", "intellij.database.dialects.oracle"})
public final class UtPlSqlCoverageRunner
extends CoverageRunner {
    @NotNull
    public String getPresentableName() {
        return "utPLSQL";
    }

    @NotNull
    public String getDataFileExtension() {
        return "json";
    }

    @NotNull
    public String getId() {
        return "utPlSqlCoverageRunner";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        return engine instanceof UtPlSqlCoverageEngine;
    }

    @Nullable
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        Intrinsics.checkParameterIsNotNull((Object)sessionDataFile, (String)"sessionDataFile");
        CoverageSuite coverageSuite = baseCoverageSuite;
        if (!(coverageSuite instanceof UtPlSqlCoverageSuite)) {
            coverageSuite = null;
        }
        UtPlSqlCoverageSuite utPlSqlCoverageSuite = (UtPlSqlCoverageSuite)coverageSuite;
        if (utPlSqlCoverageSuite == null) {
            return null;
        }
        UtPlSqlCoverageSuite suite = utPlSqlCoverageSuite;
        JSONObject json = new JSONObject(new JSONTokener(FileUtil.loadFile((File)sessionDataFile)));
        return this.loadData(json, suite);
    }

    /*
     * WARNING - void declaration
     */
    private final ProjectData loadData(JSONObject json, UtPlSqlCoverageSuite suite) {
        ProjectData res2 = new ProjectData();
        JSONArray files = json.getJSONArray("source_files");
        res2.getClasses();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)files.length());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            LineData[] lineDataArray;
            void $this$toTypedArray$iv;
            int element$iv;
            int idx = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            JSONObject file = files.getJSONObject(idx);
            JSONArray coverage = file.getJSONArray("coverage");
            ArrayList<LineData> lines = new ArrayList<LineData>();
            Iterable $this$forEach$iv2 = (Iterable)RangesKt.until((int)0, (int)coverage.length());
            boolean $i$f$forEach2 = false;
            Object object = $this$forEach$iv2.iterator();
            while (object.hasNext()) {
                int element$iv2;
                int ln = element$iv2 = ((IntIterator)object).nextInt();
                boolean bl2 = false;
                int ht = coverage.optInt(ln, -1);
                if (ht < 0) continue;
                LineData lineData = new LineData(ln + 1, null);
                ArrayList<LineData> arrayList = lines;
                boolean bl3 = false;
                boolean bl4 = false;
                LineData $this$apply = lineData;
                boolean bl5 = false;
                $this$apply.setHits(ht);
                LineData lineData2 = lineData;
                arrayList.add(lineData2);
            }
            String string = file.getString("name");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.getString(\"name\")");
            String name2 = this.extractFilePath(string, suite);
            ClassData classData = res2.getOrCreateClassData(name2);
            object = lines;
            ClassData classData2 = classData;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new LineData[0]) == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            classData2.setLines(lineDataArray);
        }
        return res2;
    }

    private final String extractFilePath(String objName, UtPlSqlCoverageSuite suite) {
        Object object = suite.getConfiguration();
        if (object == null || (object = (UtPlSqlRunConfigurationOptions)((Object)object.getState())) == null || (object = ((DataSourceRunConfigurationOptions)((Object)object)).getDataSourceId()) == null) {
            return null;
        }
        UtPlSqlRunConfiguration dsId = object;
        DbDataSource dbDataSource = DbPsiFacade.getInstance((Project)suite.getProject()).findDataSource((String)((Object)dsId));
        if (dbDataSource == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)dbDataSource, (String)"DbPsiFacade.getInstance(\u2026urce(dsId) ?: return null");
        DbDataSource dataSource = dbDataSource;
        BasicSourceAware obj2 = (BasicSourceAware)QNameUtil.findByQName((DasModel)dataSource.getModel(), (String)objName, (Function)extractFilePath.obj.1.INSTANCE).filterMap((Function)extractFilePath.obj.2.INSTANCE).filter(BasicSourceAware.class).first();
        Project project = suite.getProject();
        LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DasDataSource)dataSource));
        if (localDataSource == null) {
            Intrinsics.throwNpe();
        }
        return DbSrcUtils.getPath((Project)project, (LocalDataSource)localDataSource, (DasObject)((DasObject)obj2), (CasingProvider)((CasingProvider)dataSource.getModel()), (DbSrcFileSystem.ItemType)DbSrcFileSystem.ItemType.SRC);
    }
}

