/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraTableTrigger
extends OraTrigger {
    public static final BasicMetaProperty<String> CONDITION = BasicMetaProperty.create((String)"Condition", (BasicMetaType)BasicMetaType.Types.STRING, null, OraTableTrigger.class, (boolean)false);

    @Nullable
    default public OraTable getTable() {
        return this.getParent();
    }

    @Nullable
    public OraTable getParent();

    @Nullable
    default public OraTable getMajorObject() {
        return this.getTable();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraTableTrigger> getParentFamily() {
        return null;
    }

    @Nullable
    public OraSchema getSchema();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            OraTableTrigger.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            OraTableTrigger.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SourceError> getErrors();

    @Override
    @NotNull
    public Set<Long> getDependsOnIds();

    @Override
    @NotNull
    public Set<TrigEvent> getEvents();

    @Override
    @NotNull
    public List<String> getColNames();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        String condition;
        List<String> colNames;
        TrigTurn turn;
        Set<TrigEvent> events;
        Date modifiedTimestamp;
        Date createdTimestamp;
        Set<Long> dependsOnIds;
        boolean withDebugInfo;
        boolean obfuscated;
        boolean invalid;
        List<SourceError> errors;
        int sourceTextLength;
        boolean outdated;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer == null) {
            OraTableTrigger.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", (Object)PropertyConverter.export((long)objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if ((sourceTextLength = this.getSourceTextLength()) != 0) {
            consumer.accept("SourceTextLength", (Object)PropertyConverter.export((int)sourceTextLength));
        }
        if (!(errors = this.getErrors()).isEmpty()) {
            consumer.accept("Errors", (Object)PropertyConverter.exportListOfSourceError(errors));
        }
        if (invalid = this.isInvalid()) {
            consumer.accept("Invalid", (Object)PropertyConverter.export((boolean)invalid));
        }
        if (obfuscated = this.isObfuscated()) {
            consumer.accept("Obfuscated", (Object)PropertyConverter.export((boolean)obfuscated));
        }
        if (withDebugInfo = this.isWithDebugInfo()) {
            consumer.accept("WithDebugInfo", (Object)PropertyConverter.export((boolean)withDebugInfo));
        }
        if (!(dependsOnIds = this.getDependsOnIds()).isEmpty()) {
            consumer.accept("DependsOnIds", (Object)PropertyConverter.exportSetOfLong(dependsOnIds));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", (Object)PropertyConverter.export((Date)createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", (Object)PropertyConverter.export((Date)modifiedTimestamp));
        }
        if (!(events = this.getEvents()).isEmpty()) {
            consumer.accept("Events", (Object)PropertyConverter.exportSetOfTrigEvent(events));
        }
        if ((turn = this.getTurn()) != null) {
            consumer.accept("Turn", (Object)PropertyConverter.export((Enum)turn));
        }
        if (!(colNames = this.getColNames()).isEmpty()) {
            consumer.accept("ColNames", (Object)PropertyConverter.exportListOfString(colNames));
        }
        if ((condition = this.getCondition()) != null) {
            consumer.accept("Condition", (Object)PropertyConverter.export((String)condition));
        }
    }

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setDependsOnIds(@NotNull Set<Long> var1);

    @Override
    public void setEvents(@NotNull Set<TrigEvent> var1);

    @Override
    public void setColNames(@NotNull List<String> var1);

    @Override
    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            OraTableTrigger.$$$reportNull$$$0(3);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String outdated = _properties.get("Outdated");
        String sourceTextLength = _properties.get("SourceTextLength");
        String errors = _properties.get("Errors");
        String invalid = _properties.get("Invalid");
        String obfuscated = _properties.get("Obfuscated");
        String withDebugInfo = _properties.get("WithDebugInfo");
        String dependsOnIds = _properties.get("DependsOnIds");
        String createdTimestamp = _properties.get("CreatedTimestamp");
        String modifiedTimestamp = _properties.get("ModifiedTimestamp");
        String events = _properties.get("Events");
        String turn = _properties.get("Turn");
        String colNames = _properties.get("ColNames");
        String condition = _properties.get("Condition");
        this.setObjectId(objectId != null ? PropertyConverter.importLong((String)objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setSourceTextLength(sourceTextLength != null ? PropertyConverter.importInt((String)sourceTextLength) : 0);
        this.setErrors(errors != null ? PropertyConverter.importListOfSourceError((String)errors) : Collections.emptyList());
        this.setInvalid(invalid != null ? PropertyConverter.importBoolean((String)invalid) : false);
        this.setObfuscated(obfuscated != null ? PropertyConverter.importBoolean((String)obfuscated) : false);
        this.setWithDebugInfo(withDebugInfo != null ? PropertyConverter.importBoolean((String)withDebugInfo) : false);
        this.setDependsOnIds(dependsOnIds != null ? PropertyConverter.importSetOfLong((String)dependsOnIds) : Collections.emptySet());
        this.setCreatedTimestamp(createdTimestamp != null ? PropertyConverter.importDate((String)createdTimestamp) : null);
        this.setModifiedTimestamp(modifiedTimestamp != null ? PropertyConverter.importDate((String)modifiedTimestamp) : null);
        this.setEvents(events != null ? PropertyConverter.importSetOfTrigEvent((String)events) : Collections.emptySet());
        this.setTurn(turn != null ? PropertyConverter.importTrigTurn((String)turn) : null);
        this.setColNames(colNames != null ? PropertyConverter.importListOfString((String)colNames) : Collections.emptyList());
        this.setCondition(condition != null ? PropertyConverter.importString((String)condition) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/model/OraTableTrigger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/model/OraTableTrigger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

