/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.introspector;

import com.intellij.database.dialects.base.introspector.BaseIntroQueries;
import com.intellij.database.dialects.h2.model.H2Schema;
import com.intellij.database.dialects.h2.model.H2Table;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.util.Version;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00123456789:;<=>?@ABCDB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\fJ*\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\fJ*\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\fJ*\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\fJ*\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00040\fJ*\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00040\fJ*\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00040\fJ\"\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00040\fJ*\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00040\fJ*\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00040\fJ*\u0010 \u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00040\fJ*\u0010\"\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00040\fJ*\u0010$\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00040\fJ*\u0010&\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00040\fJ\"\u0010(\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00040\fJ\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020.0+2\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010/\u001a\b\u0012\u0004\u0012\u0002000+2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u00101\u001a\b\u0012\u0004\u0012\u0002020+2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006E"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries;", "Lcom/intellij/database/dialects/base/introspector/BaseIntroQueries;", "()V", "processColumns", "", "serverVersion", "Lcom/intellij/database/util/Version;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "Lcom/intellij/database/dialects/h2/model/H2Schema;", "action", "Lkotlin/Function1;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ColumnInfo;", "processConstants", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ConstantInfo;", "processConstraints", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ConstraintInfo;", "processDomains", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$DomainInfo;", "processForeignKeyColumns", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ForeignKeyColumnInfo;", "processForeignKeys", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ForeignKeyInfo;", "processIndexColumns", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$IndexColumnInfo;", "processRoles", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoleInfo;", "processRoutineArguments", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineArgumentInfo;", "processRoutines", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineInfo;", "processSequences", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SequenceInfo;", "processSynonyms", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SynonymInfo;", "processTables", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TableInfo;", "processTriggers", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TriggerInfo;", "processUsers", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$UserInfo;", "retrieveCollations", "", "", "retrieveDatabases", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$DbInfo;", "retrieveIndexes", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$IndexInfo;", "retrieveSchemas", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SchemaInfo;", "ColumnInfo", "ConstantInfo", "ConstraintInfo", "DbInfo", "DomainInfo", "ForeignKeyColumnInfo", "ForeignKeyInfo", "IndexColumnInfo", "IndexInfo", "RoleInfo", "RoutineArgumentInfo", "RoutineInfo", "SchemaInfo", "SequenceInfo", "SynonymInfo", "TableInfo", "TriggerInfo", "UserInfo", "intellij.database.dialects.h2"})
public final class H2IntroQueries
extends BaseIntroQueries {
    public static final H2IntroQueries INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DbInfo> retrieveDatabases(@NotNull DBTransaction transaction) {
        void $this$retrieveList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String query$iv = "select catalog_name from information_schema.catalogs";
        Object[] parameters$iv = null;
        boolean $i$f$retrieveList = false;
        return BaseIntroQueries.access$retrieveList((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveList$iv, DbInfo.class, query$iv, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void processUsers(@NotNull DBTransaction transaction, @NotNull Function1<? super UserInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select id, name, admin = 'true' as is_admin, remarks from information_schema.users where trim(name) != ''";
        Object[] parameters$iv = null;
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, UserInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processRoles(@NotNull DBTransaction transaction, @NotNull Function1<? super RoleInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select id, name, remarks from information_schema.roles";
        Object[] parameters$iv = null;
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, RoleInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> retrieveCollations(@NotNull DBTransaction transaction) {
        void $this$retrieveList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String query$iv = "select name from information_schema.collations where name != ''";
        Object[] parameters$iv = null;
        boolean $i$f$retrieveList = false;
        return BaseIntroQueries.access$retrieveList((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveList$iv, String.class, query$iv, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SchemaInfo> retrieveSchemas(@NotNull DBTransaction transaction) {
        void $this$retrieveList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String query$iv = "\n      select\n        schema_name,\n        is_default,\n        remarks\n      from information_schema.schemata\n    ";
        Object[] parameters$iv = null;
        boolean $i$f$retrieveList = false;
        return BaseIntroQueries.access$retrieveList((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveList$iv, SchemaInfo.class, query$iv, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void processTables(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super TableInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "\n        select\n          id,  \n          table_name,\n          table_type = 'VIEW' as is_view,\n          storage_type in ('LOCAL TEMPORARY', 'GLOBAL TEMPORARY') as is_temp,\n          sql,\n          remarks\n        from information_schema.tables\n        where table_schema = ?\n      ";
        Object[] parameters$iv = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, TableInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processColumns(@NotNull Version serverVersion, @NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super ColumnInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)serverVersion, (String)"serverVersion");
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "\n        select\n          table_name,\n          column_name,\n          ordinal_position,\n          type_name,\n          numeric_precision,\n          numeric_scale,\n          column_default,\n          is_nullable = 'YES' as is_nullable,\n          sequence_name,\n          check_constraint,\n          " + (serverVersion.isOrGreater(new int[]{1, 4, 197}) ? "column_type" : "null as column_type") + ",\n          remarks\n        from information_schema.columns\n        where table_schema = ?\n        order by table_name, ordinal_position\n      ";
        Object[] parameters$iv = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ColumnInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IndexInfo> retrieveIndexes(@NotNull DBTransaction transaction, @NotNull H2Schema schema) {
        void query$iv;
        void $this$retrieveList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "\n      select \n          id, \n          table_name,\n          index_name,\n          non_unique,\n          is_generated,\n          sql,\n          remarks \n      from information_schema.indexes \n      where table_schema = ?\n      order by table_name\n    ";
        Object[] parameters$iv = new String[]{schema.getName()};
        boolean $i$f$retrieveList = false;
        return BaseIntroQueries.access$retrieveList((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveList$iv, IndexInfo.class, (String)query$iv, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void processIndexColumns(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super IndexColumnInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "\n        select \n            id, \n            column_name,\n            asc_or_desc = 'D' as is_desc\n        from information_schema.indexes \n        where table_schema = ?\n        order by id, ordinal_position\n      ";
        Object[] parameters$iv = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, IndexColumnInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processConstraints(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super ConstraintInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "\n        select \n            table_name,\n            constraint_name,\n            constraint_type,\n            check_expression,\n            column_list,\n            remarks\n        from information_schema.constraints \n        where table_schema = ?\n        order by table_name\n      ";
        Object[] parameters$iv = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ConstraintInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processForeignKeys(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super ForeignKeyInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "\n        select \n            fktable_name,\n            fk_name,\n            pk_name,\n            pktable_schema,\n            pktable_name,\n            update_rule,\n            delete_rule\n        from information_schema.cross_references \n        where fktable_schema = ? and ordinal_position = 1\n      ";
        Object[] parameters$iv = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ForeignKeyInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processForeignKeyColumns(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super ForeignKeyColumnInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "\n        select \n            fktable_name,\n            fk_name,\n            pkcolumn_name            \n        from information_schema.cross_references \n        where fktable_schema = ?\n        order by ordinal_position\n      ";
        Object[] parameters$iv = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ForeignKeyColumnInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processTriggers(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super TriggerInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "\n        select \n            id, \n            trigger_schema,\n            trigger_name,\n            table_name,\n            sql,\n            remarks \n        from information_schema.triggers \n        where table_schema = ?\n        order by table_name\n      ";
        Object[] parameters$iv = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, TriggerInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processSequences(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super SequenceInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "\n        select \n            id, \n            sequence_name,\n            current_value,\n            increment,\n            is_generated,\n            cache,\n            min_value,\n            max_value,\n            is_cycle,\n            remarks\n        from information_schema.sequences \n        where sequence_schema = ?\n      ";
        Object[] parameters$iv = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, SequenceInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processDomains(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super DomainInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "\n        select \n            id, \n            domain_name,\n            sql,\n            remarks\n        from information_schema.domains \n        where domain_schema = ?\n      ";
        Object[] parameters$iv = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, DomainInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processRoutines(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super RoutineInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "\n        select \n            alias_name,\n            column_count,\n            java_class,\n            java_method,\n            source,\n            data_type != 0 as is_func,\n            remarks\n        from information_schema.function_aliases \n        where alias_schema = ?\n      ";
        Object[] parameters$iv = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, RoutineInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processRoutineArguments(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super RoutineArgumentInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "\n        select \n            alias_name,\n            column_count,\n            column_name,\n            pos,\n            type_name,\n            precision,\n            scale,\n            column_type\n        from information_schema.function_columns \n        where alias_schema = ?\n        order by alias_name, column_count, pos\n      ";
        Object[] parameters$iv = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, RoutineArgumentInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processConstants(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super ConstantInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "\n        select \n            id,\n            constant_name,\n            data_type,\n            sql,\n            remarks\n        from information_schema.constants \n        where constant_schema = ?\n      ";
        Object[] parameters$iv = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ConstantInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processSynonyms(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super SynonymInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "\n        select \n            id,\n            synonym_name,\n            synonym_for_schema,\n            synonym_for,\n            remarks\n        from information_schema.synonyms \n        where synonym_schema = ?\n      ";
        Object[] parameters$iv = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, SynonymInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    private H2IntroQueries() {
    }

    static {
        H2IntroQueries h2IntroQueries;
        INSTANCE = h2IntroQueries = new H2IntroQueries();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$DbInfo;", "", "()V", "catalog_name", "", "intellij.database.dialects.h2"})
    public static final class DbInfo {
        @JvmField
        @Nullable
        public String catalog_name;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$UserInfo;", "", "()V", "id", "", "is_admin", "", "name", "", "remarks", "intellij.database.dialects.h2"})
    public static final class UserInfo {
        @JvmField
        public long id = Long.MIN_VALUE;
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        public boolean is_admin;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoleInfo;", "", "()V", "id", "", "name", "", "remarks", "intellij.database.dialects.h2"})
    public static final class RoleInfo {
        @JvmField
        public long id = Long.MIN_VALUE;
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SchemaInfo;", "", "()V", "is_default", "", "remarks", "", "schema_name", "intellij.database.dialects.h2"})
    public static final class SchemaInfo {
        @JvmField
        @NotNull
        public String schema_name = "";
        @JvmField
        public boolean is_default;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TableInfo;", "", "()V", "id", "", "is_temp", "", "is_view", "remarks", "", "sql", "table_name", "intellij.database.dialects.h2"})
    public static final class TableInfo {
        @JvmField
        public long id = Long.MIN_VALUE;
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        public boolean is_view;
        @JvmField
        public boolean is_temp;
        @JvmField
        @Nullable
        public String sql;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ColumnInfo;", "", "()V", "check_constraint", "", "column_default", "column_name", "column_type", "is_nullable", "", "numeric_precision", "", "numeric_scale", "ordinal_position", "", "remarks", "sequence_name", "table_name", "type_name", "intellij.database.dialects.h2"})
    public static final class ColumnInfo {
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @NotNull
        public String column_name = "";
        @JvmField
        public short ordinal_position;
        @JvmField
        @Nullable
        public String type_name;
        @JvmField
        public int numeric_precision;
        @JvmField
        public int numeric_scale;
        @JvmField
        public boolean is_nullable = true;
        @JvmField
        @Nullable
        public String column_default;
        @JvmField
        @Nullable
        public String sequence_name;
        @JvmField
        @Nullable
        public String check_constraint;
        @JvmField
        @Nullable
        public String column_type;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0011j\b\u0012\u0004\u0012\u00020\u0005`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$IndexInfo;", "", "()V", "columnNames", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getColumnNames", "()Ljava/util/ArrayList;", "id", "", "index_name", "is_generated", "", "non_unique", "remarks", "reverseColumnNames", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getReverseColumnNames", "()Ljava/util/LinkedHashSet;", "sql", "table", "Lcom/intellij/database/dialects/h2/model/H2Table;", "getTable", "()Lcom/intellij/database/dialects/h2/model/H2Table;", "setTable", "(Lcom/intellij/database/dialects/h2/model/H2Table;)V", "table_name", "intellij.database.dialects.h2"})
    public static final class IndexInfo {
        @JvmField
        public long id = Long.MIN_VALUE;
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @NotNull
        public String index_name = "";
        @JvmField
        public boolean non_unique;
        @JvmField
        public boolean is_generated;
        @JvmField
        @Nullable
        public String sql;
        @JvmField
        @Nullable
        public String remarks;
        @Nullable
        private H2Table table;
        @NotNull
        private final ArrayList<String> columnNames = new ArrayList();
        @NotNull
        private final LinkedHashSet<String> reverseColumnNames = new LinkedHashSet();

        @Nullable
        public final H2Table getTable() {
            return this.table;
        }

        public final void setTable(@Nullable H2Table h2Table) {
            this.table = h2Table;
        }

        @NotNull
        public final ArrayList<String> getColumnNames() {
            return this.columnNames;
        }

        @NotNull
        public final LinkedHashSet<String> getReverseColumnNames() {
            return this.reverseColumnNames;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$IndexColumnInfo;", "", "()V", "column_name", "", "id", "", "is_desc", "", "intellij.database.dialects.h2"})
    public static final class IndexColumnInfo {
        @JvmField
        public long id = Long.MIN_VALUE;
        @JvmField
        @NotNull
        public String column_name = "";
        @JvmField
        public boolean is_desc;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ConstraintInfo;", "", "()V", "check_expression", "", "column_list", "constraint_name", "constraint_type", "remarks", "table_name", "intellij.database.dialects.h2"})
    public static final class ConstraintInfo {
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @NotNull
        public String constraint_name = "";
        @JvmField
        @NotNull
        public String constraint_type = "";
        @JvmField
        @Nullable
        public String check_expression;
        @JvmField
        @Nullable
        public String column_list;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ForeignKeyInfo;", "", "()V", "delete_rule", "", "fk_name", "", "fktable_name", "pk_name", "pktable_name", "pktable_schema", "update_rule", "intellij.database.dialects.h2"})
    public static final class ForeignKeyInfo {
        @JvmField
        @NotNull
        public String fktable_name = "";
        @JvmField
        @NotNull
        public String fk_name = "";
        @JvmField
        @NotNull
        public String pk_name = "";
        @JvmField
        @NotNull
        public String pktable_schema = "";
        @JvmField
        @NotNull
        public String pktable_name = "";
        @JvmField
        public int update_rule;
        @JvmField
        public int delete_rule;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ForeignKeyColumnInfo;", "", "()V", "fk_name", "", "fktable_name", "pkcolumn_name", "intellij.database.dialects.h2"})
    public static final class ForeignKeyColumnInfo {
        @JvmField
        @NotNull
        public String fktable_name = "";
        @JvmField
        @NotNull
        public String fk_name = "";
        @JvmField
        @NotNull
        public String pkcolumn_name = "";
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TriggerInfo;", "", "()V", "id", "", "remarks", "", "sql", "table_name", "trigger_name", "trigger_schema", "intellij.database.dialects.h2"})
    public static final class TriggerInfo {
        @JvmField
        public long id = Long.MIN_VALUE;
        @JvmField
        @NotNull
        public String trigger_schema = "";
        @JvmField
        @NotNull
        public String trigger_name = "";
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @Nullable
        public String sql;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SequenceInfo;", "", "()V", "cache", "", "current_value", "id", "increment", "is_cycle", "", "is_generated", "max_value", "min_value", "remarks", "", "sequence_name", "intellij.database.dialects.h2"})
    public static final class SequenceInfo {
        @JvmField
        public long id = Long.MIN_VALUE;
        @JvmField
        @NotNull
        public String sequence_name = "";
        @JvmField
        public long current_value;
        @JvmField
        public long increment;
        @JvmField
        public long min_value;
        @JvmField
        public long max_value;
        @JvmField
        public boolean is_generated;
        @JvmField
        public long cache;
        @JvmField
        public boolean is_cycle;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$DomainInfo;", "", "()V", "domain_name", "", "id", "", "remarks", "sql", "intellij.database.dialects.h2"})
    public static final class DomainInfo {
        @JvmField
        public long id = Long.MIN_VALUE;
        @JvmField
        @NotNull
        public String domain_name = "";
        @JvmField
        @Nullable
        public String sql;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineInfo;", "", "()V", "alias_name", "", "column_count", "", "is_func", "", "java_class", "java_method", "remarks", "source", "intellij.database.dialects.h2"})
    public static final class RoutineInfo {
        @JvmField
        @NotNull
        public String alias_name = "";
        @JvmField
        public int column_count;
        @JvmField
        @Nullable
        public String java_class;
        @JvmField
        @Nullable
        public String java_method;
        @JvmField
        @Nullable
        public String source;
        @JvmField
        public boolean is_func;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineArgumentInfo;", "", "()V", "alias_name", "", "column_count", "", "column_name", "column_type", "pos", "", "precision", "scale", "type_name", "intellij.database.dialects.h2"})
    public static final class RoutineArgumentInfo {
        @JvmField
        @NotNull
        public String alias_name = "";
        @JvmField
        public int column_count;
        @JvmField
        @NotNull
        public String column_name = "";
        @JvmField
        public short pos;
        @JvmField
        @NotNull
        public String type_name = "";
        @JvmField
        public int precision;
        @JvmField
        public int scale;
        @JvmField
        public int column_type;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ConstantInfo;", "", "()V", "constant_name", "", "data_type", "", "id", "", "remarks", "sql", "intellij.database.dialects.h2"})
    public static final class ConstantInfo {
        @JvmField
        public long id = Long.MIN_VALUE;
        @JvmField
        @NotNull
        public String constant_name = "";
        @JvmField
        public int data_type;
        @JvmField
        @Nullable
        public String sql;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SynonymInfo;", "", "()V", "id", "", "remarks", "", "synonym_for", "synonym_for_schema", "synonym_name", "intellij.database.dialects.h2"})
    public static final class SynonymInfo {
        @JvmField
        public long id = Long.MIN_VALUE;
        @JvmField
        @NotNull
        public String synonym_name = "";
        @JvmField
        @NotNull
        public String synonym_for_schema = "";
        @JvmField
        @NotNull
        public String synonym_for = "";
        @JvmField
        @Nullable
        public String remarks;
    }
}

