/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.model;

import com.intellij.database.dialects.db2.model.Db2Check;
import com.intellij.database.dialects.db2.model.Db2ForeignKey;
import com.intellij.database.dialects.db2.model.Db2Index;
import com.intellij.database.dialects.db2.model.Db2Key;
import com.intellij.database.dialects.db2.model.Db2Schema;
import com.intellij.database.dialects.db2.model.Db2TableColumn;
import com.intellij.database.dialects.db2.model.Db2Trigger;
import com.intellij.database.dialects.db2.model.Db2TriggerTarget;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.Db2PartitionMode;
import com.intellij.database.model.properties.Db2TableClustering;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Db2Table
extends BasicModTable,
Db2TriggerTarget {
    public static final BasicMetaProperty<Boolean> TEMPORARY = BasicMetaProperty.create((String)"Temporary", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, Db2Table.class, (boolean)false);
    public static final BasicMetaProperty<Db2PartitionMode> PARTITION_MODE = BasicMetaProperty.create((String)"PartitionMode", (BasicMetaType)BasicMetaType.Types.DB2_PARTITION_MODE, null, Db2Table.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> COLUMN_ORGANIZED = BasicMetaProperty.create((String)"ColumnOrganized", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, Db2Table.class, (boolean)false);
    public static final BasicMetaProperty<Db2TableClustering> CLUSTERING = BasicMetaProperty.create((String)"Clustering", (BasicMetaType)BasicMetaType.Types.DB2_TABLE_CLUSTERING, null, Db2Table.class, (boolean)false);
    public static final BasicMetaProperty<List<String>> CLUSTERING_INDEX_NAMES = BasicMetaProperty.create((String)"ClusteringIndexNames", (BasicMetaType)BasicMetaType.Types.LIST_OF_STRING, Collections.emptyList(), Db2Table.class, (boolean)false);
    public static final BasicMetaProperty<Integer> PAGE_FREE_PERCENTAGE = BasicMetaProperty.create((String)"PageFreePercentage", (BasicMetaType)BasicMetaType.Types.INT, (Object)0, Db2Table.class, (boolean)false);
    public static final BasicMetaProperty<String> RCT_CHECK_NAME = BasicMetaProperty.create((String)"RCTCheckName", (BasicMetaType)BasicMetaType.Types.STRING, null, Db2Table.class, (boolean)false);

    @Nullable
    default public Db2Schema getSchema() {
        return this.getParent();
    }

    @Nullable
    public Db2Schema getParent();

    default public @Nullable NamingFamily<@NotNull ? extends Db2Table> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends Db2Trigger> getTriggers();

    @NotNull
    public @NotNull ModPositioningNamingFamily<@NotNull ? extends Db2TableColumn> getColumns();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends Db2Index> getIndices();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends Db2Key> getKeys();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends Db2ForeignKey> getForeignKeys();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends Db2Check> getChecks();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.TRIGGER, ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK);
        if (list == null) {
            Db2Table.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getTriggers(), this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks());
        if (list == null) {
            Db2Table.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public Db2PartitionMode getPartitionMode();

    public boolean isColumnOrganized();

    @Nullable
    public Db2TableClustering getClustering();

    @NotNull
    public List<String> getClusteringIndexNames();

    public int getPageFreePercentage();

    @Nullable
    public String getRCTCheckName();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        String rCTCheckName;
        int pageFreePercentage;
        List<String> clusteringIndexNames;
        Db2TableClustering clustering;
        boolean columnOrganized;
        Db2PartitionMode partitionMode;
        boolean temporary;
        boolean system;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        if (consumer == null) {
            Db2Table.$$$reportNull$$$0(2);
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", (Object)PropertyConverter.export((String)comment));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if (system = this.isSystem()) {
            consumer.accept("System", (Object)PropertyConverter.export((boolean)system));
        }
        if (temporary = this.isTemporary()) {
            consumer.accept("Temporary", (Object)PropertyConverter.export((boolean)temporary));
        }
        if ((partitionMode = this.getPartitionMode()) != null) {
            consumer.accept("PartitionMode", (Object)PropertyConverter.export((Enum)partitionMode));
        }
        if (columnOrganized = this.isColumnOrganized()) {
            consumer.accept("ColumnOrganized", (Object)PropertyConverter.export((boolean)columnOrganized));
        }
        if ((clustering = this.getClustering()) != null) {
            consumer.accept("Clustering", (Object)PropertyConverter.export((Enum)clustering));
        }
        if (!(clusteringIndexNames = this.getClusteringIndexNames()).isEmpty()) {
            consumer.accept("ClusteringIndexNames", (Object)PropertyConverter.exportListOfString(clusteringIndexNames));
        }
        if ((pageFreePercentage = this.getPageFreePercentage()) != 0) {
            consumer.accept("PageFreePercentage", (Object)PropertyConverter.export((int)pageFreePercentage));
        }
        if ((rCTCheckName = this.getRCTCheckName()) != null) {
            consumer.accept("RCTCheckName", (Object)PropertyConverter.export((String)rCTCheckName));
        }
    }

    public void setTemporary(boolean var1);

    public void setPartitionMode(@Nullable Db2PartitionMode var1);

    public void setColumnOrganized(boolean var1);

    public void setClustering(@Nullable Db2TableClustering var1);

    public void setClusteringIndexNames(@NotNull List<String> var1);

    default public void setClusteringIndexNames(String ... clusteringIndexNames) {
        this.setClusteringIndexNames(Arrays.asList(clusteringIndexNames));
    }

    public void setPageFreePercentage(int var1);

    public void setRCTCheckName(@Nullable String var1);

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            Db2Table.$$$reportNull$$$0(3);
        }
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String system = _properties.get("System");
        String temporary = _properties.get("Temporary");
        String partitionMode = _properties.get("PartitionMode");
        String columnOrganized = _properties.get("ColumnOrganized");
        String clustering = _properties.get("Clustering");
        String clusteringIndexNames = _properties.get("ClusteringIndexNames");
        String pageFreePercentage = _properties.get("PageFreePercentage");
        String rCTCheckName = _properties.get("RCTCheckName");
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString((String)comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setSystem(system != null ? PropertyConverter.importBoolean((String)system) : false);
        this.setTemporary(temporary != null ? PropertyConverter.importBoolean((String)temporary) : false);
        this.setPartitionMode(partitionMode != null ? PropertyConverter.importDb2PartitionMode((String)partitionMode) : null);
        this.setColumnOrganized(columnOrganized != null ? PropertyConverter.importBoolean((String)columnOrganized) : false);
        this.setClustering(clustering != null ? PropertyConverter.importDb2TableClustering((String)clustering) : null);
        this.setClusteringIndexNames(clusteringIndexNames != null ? PropertyConverter.importListOfString((String)clusteringIndexNames) : Collections.emptyList());
        this.setPageFreePercentage(pageFreePercentage != null ? PropertyConverter.importInt((String)pageFreePercentage) : 0);
        this.setRCTCheckName(rCTCheckName != null ? PropertyConverter.importString((String)rCTCheckName) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/db2/model/Db2Table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/db2/model/Db2Table";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

