/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.progress;

import com.intellij.docker.agent.progress.DockerProgressDetailsFormat;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.TtySink;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/agent/progress/DockerResponseItemTtyHandler;", "", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "(Lcom/intellij/docker/agent/progress/TtySink;)V", "currentStreams", "", "", "", "progressFormat", "Lcom/intellij/docker/agent/progress/DockerProgressDetailsFormat;", "displayItem", "", "item", "Lcom/intellij/docker/agent/progress/DockerResponseItem;", "handleItem", "Companion", "intellij.clouds.docker.agent.rt"})
public final class DockerResponseItemTtyHandler {
    private final Map<String, Integer> currentStreams;
    private final DockerProgressDetailsFormat progressFormat;
    private final TtySink ttySink;
    @NotNull
    private static final SimpleDateFormat TIME_FORMAT;
    public static final Companion Companion;

    public final void handleItem(@NotNull DockerResponseItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        int jump = 0;
        String id = item.getId();
        if (id == null || item.getProgress() == null && item.getProgressMessage() == null) {
            this.currentStreams.clear();
        } else {
            Integer n;
            Map<String, Integer> $this$getOrPut$iv = this.currentStreams;
            boolean $i$f$getOrPut = false;
            Integer value$iv = $this$getOrPut$iv.get(id);
            if (value$iv == null) {
                boolean bl = false;
                this.ttySink.invoke("\r\n");
                Integer answer$iv = this.currentStreams.size();
                $this$getOrPut$iv.put(id, answer$iv);
                n = answer$iv;
            } else {
                n = value$iv;
            }
            int itemIdx = ((Number)n).intValue();
            jump = this.currentStreams.size() - itemIdx;
            this.ttySink.ttyCursorUp(jump);
        }
        this.displayItem(item);
        if (id != null) {
            this.ttySink.ttyCursorDown(jump);
        }
    }

    private final void displayItem(DockerResponseItem item) {
        block25: {
            String endLine;
            block27: {
                String string;
                String safeStatus;
                block31: {
                    DockerResponseItem.ErrorDetail error;
                    block30: {
                        boolean bl;
                        block29: {
                            String string2;
                            block28: {
                                block26: {
                                    boolean bl2;
                                    block24: {
                                        Object object;
                                        block23: {
                                            block22: {
                                                String it;
                                                boolean bl3;
                                                String time;
                                                DockerResponseItem.ErrorDetail errorDetail = item.getError();
                                                if (errorDetail != null) {
                                                    if (401 == errorDetail.getCode()) {
                                                        this.ttySink.invoke("authentication is required");
                                                        return;
                                                    }
                                                }
                                                endLine = "";
                                                String string3 = item.getStream();
                                                if (string3 == null) {
                                                    string3 = "";
                                                }
                                                CharSequence charSequence = string3;
                                                boolean bl4 = false;
                                                if (charSequence.length() == 0 && item.getProgress() != null) {
                                                    this.ttySink.ttyClearLine();
                                                    endLine = "\r";
                                                }
                                                if (item.getTime() != 0L) {
                                                    time = TIME_FORMAT.format(new Date(item.getTime()));
                                                    this.ttySink.invoke(time + ' ');
                                                }
                                                String string4 = item.getId();
                                                if (string4 != null) {
                                                    time = string4;
                                                    bl4 = false;
                                                    bl3 = false;
                                                    it = time;
                                                    boolean bl5 = false;
                                                    this.ttySink.invoke(it + ": ");
                                                }
                                                String string5 = item.getFrom();
                                                if (string5 != null) {
                                                    time = string5;
                                                    bl4 = false;
                                                    bl3 = false;
                                                    it = time;
                                                    boolean bl6 = false;
                                                    this.ttySink.invoke("(from " + it + ") ");
                                                }
                                                if ((object = item.getProgress()) == null) break block22;
                                                DockerResponseItem.ProgressDetail progressDetail = object;
                                                bl3 = false;
                                                boolean it22 = false;
                                                DockerResponseItem.ProgressDetail it3 = progressDetail;
                                                bl2 = false;
                                                object = this.progressFormat.toTtyString(it3);
                                                if (object != null) break block23;
                                            }
                                            object = item.getProgressMessage();
                                        }
                                        Object progress = object;
                                        if (progress == null) break block24;
                                        this.ttySink.invoke(item.getStatus() + ' ' + (String)progress + endLine);
                                        break block25;
                                    }
                                    if (item.getStream() == null) break block26;
                                    String string6 = item.getStream();
                                    if (string6 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    CharSequence charSequence = string6;
                                    String it22 = "(?<=[^\r])\n";
                                    boolean bl7 = false;
                                    it22 = new Regex(it22);
                                    String string7 = "\r\n";
                                    bl2 = false;
                                    charSequence = it22.replace(charSequence, string7);
                                    boolean it22 = false;
                                    boolean bl8 = false;
                                    CharSequence it = charSequence;
                                    boolean bl9 = false;
                                    CharSequence fixedStream = StringsKt.startsWith$default((CharSequence)it, (char)'\n', (boolean)false, (int)2, null) ? "\r" + (String)it : it;
                                    this.ttySink.invoke((String)fixedStream + endLine);
                                    break block25;
                                }
                                if (item.getError() == null) break block27;
                                DockerResponseItem.ErrorDetail errorDetail = item.getError();
                                if (errorDetail == null) {
                                    Intrinsics.throwNpe();
                                }
                                error = errorDetail;
                                string2 = item.getStatus();
                                if (string2 == null) break block28;
                                String it22 = string2;
                                boolean bl10 = false;
                                bl = false;
                                String it = it22;
                                boolean bl11 = false;
                                CharSequence charSequence = it;
                                boolean bl12 = false;
                                string2 = !StringsKt.isBlank((CharSequence)charSequence) ? it22 : null;
                                if (string2 != null) break block29;
                            }
                            string2 = safeStatus = "Error response from daemon:";
                        }
                        if ((string = error.getMessage()) == null) break block30;
                        String string8 = string;
                        bl = false;
                        boolean bl13 = false;
                        String it = string8;
                        boolean bl14 = false;
                        CharSequence charSequence = it;
                        boolean bl15 = false;
                        string = !StringsKt.isBlank((CharSequence)charSequence) ? string8 : null;
                        if (string != null) break block31;
                    }
                    string = "Error code " + error.getCode();
                }
                String errorMessage = string;
                this.ttySink.invoke(safeStatus + ' ' + errorMessage + "\r\n");
                break block25;
            }
            endLine = "\r";
            StringBuilder stringBuilder = new StringBuilder();
            String string = item.getStatus();
            if (string == null) {
                string = "";
            }
            this.ttySink.invoke(stringBuilder.append(string).append(endLine).append('\n').toString());
        }
    }

    public DockerResponseItemTtyHandler(@NotNull TtySink ttySink) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)ttySink, (String)"ttySink");
        this.ttySink = ttySink;
        DockerResponseItemTtyHandler dockerResponseItemTtyHandler = this;
        boolean bl = false;
        dockerResponseItemTtyHandler.currentStreams = map = (Map)new LinkedHashMap();
        this.progressFormat = new DockerProgressDetailsFormat();
    }

    static {
        Companion = new Companion(null);
        TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/agent/progress/DockerResponseItemTtyHandler$Companion;", "", "()V", "TIME_FORMAT", "Ljava/text/SimpleDateFormat;", "getTIME_FORMAT", "()Ljava/text/SimpleDateFormat;", "intellij.clouds.docker.agent.rt"})
    public static final class Companion {
        @NotNull
        public final SimpleDateFormat getTIME_FORMAT() {
            return TIME_FORMAT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

