/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.actions.ruleset.StyleCreatorWithFileChooser;
import com.intellij.psi.css.index.CssSupportedFileTypesProvider;
import com.intellij.psi.css.util.CssFileTypeUtil;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewFileStyleCreator
extends StyleCreatorWithFileChooser {
    public NewFileStyleCreator(@NotNull PsiFile contextFile) {
        if (contextFile == null) {
            NewFileStyleCreator.$$$reportNull$$$0(0);
        }
        super(CssBundle.message((String)"css.inspections.create.style.new.file", (Object[])new Object[0]), contextFile);
    }

    @Override
    @Nullable
    protected StylesheetFile chooseFile() {
        Project project = this.myContextFile.getProject();
        CssFileSaverDescriptor fileSaverDescriptor = new CssFileSaverDescriptor();
        fileSaverDescriptor.setRoots(ProjectRootManager.getInstance((Project)project).getContentRoots());
        fileSaverDescriptor.withTreeRootVisible(true);
        VirtualFileWrapper wrapper = FileChooserFactory.getInstance().createSaveFileDialog((FileSaverDescriptor)fileSaverDescriptor, project).save(null, null);
        if (wrapper != null) {
            VirtualFile virtualFile = wrapper.getVirtualFile();
            if (virtualFile == null) {
                File parentFile = wrapper.getFile().getParentFile();
                VirtualFile parentVFile = LocalFileSystem.getInstance().findFileByIoFile(parentFile);
                if (parentVFile != null) {
                    try {
                        virtualFile = (VirtualFile)WriteAction.compute(() -> parentVFile.createChildData((Object)this, wrapper.getFile().getName()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (virtualFile != null) {
                return (StylesheetFile)ObjectUtils.tryCast((Object)PsiManager.getInstance((Project)project).findFile(virtualFile), StylesheetFile.class);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/psi/css/actions/ruleset/NewFileStyleCreator", "<init>"));
    }

    private static class CssFileSaverDescriptor
    extends FileSaverDescriptor {
        CssFileSaverDescriptor() {
            super(CssBundle.message((String)"css.inspections.create.style.new.file.title", (Object[])new Object[0]), CssBundle.message((String)"css.inspections.create.style.new.file.text", (Object[])new Object[0]), CssFileTypeUtil.getAllCssExtensions());
        }

        public boolean isFileVisible(@NotNull VirtualFile file, boolean showHiddenFiles) {
            if (file == null) {
                CssFileSaverDescriptor.$$$reportNull$$$0(0);
            }
            return super.isFileVisible(file, showHiddenFiles) || CssSupportedFileTypesProvider.isSupportedFileType(file.getFileType());
        }

        public boolean isFileSelectable(@NotNull VirtualFile file) {
            if (file == null) {
                CssFileSaverDescriptor.$$$reportNull$$$0(1);
            }
            return super.isFileSelectable(file) && CssSupportedFileTypesProvider.isSupportedFileType(file.getFileType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "file";
            objectArray2[1] = "com/intellij/psi/css/actions/ruleset/NewFileStyleCreator$CssFileSaverDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFileVisible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFileSelectable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

