/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project.roots;

import com.intellij.ProjectTopics;
import com.intellij.lang.puppet.project.PuppetProjectListener;
import com.intellij.lang.puppet.project.PuppetProjectManager;
import com.intellij.lang.puppet.project.roots.PuppetDirectoryInfo;
import com.intellij.lang.puppet.project.roots.PuppetRootIndex;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PuppetDirectoryIndex {
    private static final Logger LOG = Logger.getInstance(PuppetDirectoryIndex.class);
    private final Project myProject;
    private final MessageBusConnection myConnection;
    private volatile boolean myDisposed;
    private volatile PuppetRootIndex myRootIndex;

    public PuppetDirectoryIndex(Project project) {
        this.myProject = project;
        this.myConnection = project.getMessageBus().connect();
        this.subscribeToFileChanges();
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                PuppetDirectoryIndex.this.myDisposed = true;
                PuppetDirectoryIndex.this.myRootIndex = null;
            }
        });
    }

    protected void subscribeToFileChanges() {
        this.myConnection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                PuppetDirectoryIndex.this.myRootIndex = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/puppet/project/roots/PuppetDirectoryIndex$2", "fileTypesChanged"));
            }
        });
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                PuppetDirectoryIndex.this.myRootIndex = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/puppet/project/roots/PuppetDirectoryIndex$3", "rootsChanged"));
            }
        });
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                PuppetRootIndex rootIndex;
                if (events == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((rootIndex = PuppetDirectoryIndex.this.myRootIndex) != null && rootIndex.resetOnEvents(events)) {
                    PuppetDirectoryIndex.this.myRootIndex = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/puppet/project/roots/PuppetDirectoryIndex$4", "after"));
            }
        });
        this.myConnection.subscribe(PuppetProjectManager.PUPPET_PROJECT_TOPIC, (Object)new PuppetProjectListener(){

            @Override
            public void projectUpdated() {
                PuppetDirectoryIndex.this.myRootIndex = null;
            }
        });
    }

    protected void dispatchPendingEvents() {
        this.myConnection.deliverImmediately();
    }

    @NotNull
    private PuppetRootIndex getRootIndex() {
        PuppetRootIndex rootIndex = this.myRootIndex;
        if (rootIndex == null) {
            this.myRootIndex = rootIndex = new PuppetRootIndex(this.myProject);
        }
        PuppetRootIndex puppetRootIndex = rootIndex;
        if (puppetRootIndex == null) {
            PuppetDirectoryIndex.$$$reportNull$$$0(0);
        }
        return puppetRootIndex;
    }

    @NotNull
    public PuppetDirectoryInfo getInfoForFile(@NotNull VirtualFile file) {
        if (file == null) {
            PuppetDirectoryIndex.$$$reportNull$$$0(1);
        }
        this.checkAvailability();
        this.dispatchPendingEvents();
        if (!(file instanceof NewVirtualFile)) {
            PuppetDirectoryInfo puppetDirectoryInfo = PuppetDirectoryInfo.UNAVAILABLE;
            if (puppetDirectoryInfo == null) {
                PuppetDirectoryIndex.$$$reportNull$$$0(2);
            }
            return puppetDirectoryInfo;
        }
        PuppetDirectoryInfo puppetDirectoryInfo = this.getRootIndex().getInfoForFile(file);
        if (puppetDirectoryInfo == null) {
            PuppetDirectoryIndex.$$$reportNull$$$0(3);
        }
        return puppetDirectoryInfo;
    }

    private void checkAvailability() {
        if (this.myDisposed) {
            ProgressManager.checkCanceled();
            LOG.error("Directory index is already disposed for " + this.myProject);
        }
    }

    public static PuppetDirectoryIndex getInstance(Project project) {
        assert (!project.isDefault()) : "Must not call PuppetDirectoryIndex for default project";
        return (PuppetDirectoryIndex)ServiceManager.getService((Project)project, PuppetDirectoryIndex.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/project/roots/PuppetDirectoryIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/project/roots/PuppetDirectoryIndex";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

