/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.annotation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.PuppetLanguage;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.psi.PuppetDefaultWrapper;
import com.intellij.lang.puppet.psi.mixins.PuppetResourceInstanceDeclarationMixin;
import com.intellij.lang.puppet.util.PuppetConfigurationUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PuppetAnnotator
implements Annotator,
PuppetTokenTypes {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            PuppetAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PuppetAnnotator.$$$reportNull$$$0(1);
        }
        if (PuppetConfigurationUtil.getPuppetVersion(element) == PuppetLanguage.Version.PUPPET_3) {
            PuppetAnnotator.annotatePuppet3(element, holder);
        } else {
            PuppetAnnotator.annotatePuppet4(element, holder);
        }
    }

    private static void annotatePuppet3(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        block7: {
            List<PsiElement> list;
            block5: {
                CharSequence text;
                block6: {
                    if (element == null) {
                        PuppetAnnotator.$$$reportNull$$$0(2);
                    }
                    if (holder == null) {
                        PuppetAnnotator.$$$reportNull$$$0(3);
                    }
                    if (PsiUtilCore.getElementType((PsiElement)element) != SINGLE_QUOTED_STRING) break block5;
                    assert (element instanceof LeafPsiElement);
                    text = ((LeafPsiElement)element).getChars();
                    if (StringUtil.endsWithChar((CharSequence)text, (char)'\'')) break block6;
                    PuppetAnnotator.errorClosingQuoteExpected(holder);
                    break block7;
                }
                if (!StringUtil.endsWith((CharSequence)text, (CharSequence)"\\'")) break block7;
                TextRange range = element.getTextRange();
                holder.newAnnotation(HighlightSeverity.ERROR, PuppetBundle.message("puppet.v3.closing.quote.escaped", new Object[0])).range(TextRange.from((int)(range.getEndOffset() - 2), (int)1)).create();
                break block7;
            }
            if (element instanceof PuppetResourceInstanceDeclarationMixin && (list = ((PuppetResourceInstanceDeclarationMixin)element).getNameIdentifiersList()) != null) {
                for (PsiElement psiElement : list) {
                    if (!(psiElement instanceof PuppetDefaultWrapper)) continue;
                    holder.newAnnotation(HighlightSeverity.ERROR, PuppetBundle.message("puppet.v3.per.epxression.default", new Object[0])).create();
                }
            }
        }
    }

    private static void annotatePuppet4(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            PuppetAnnotator.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            PuppetAnnotator.$$$reportNull$$$0(5);
        }
        if (PsiUtilCore.getElementType((PsiElement)element) == SINGLE_QUOTED_STRING) {
            assert (element instanceof LeafPsiElement);
            if (PuppetAnnotator.isPuppet4SingleQuotedStringUnclosed(((LeafPsiElement)element).getChars())) {
                PuppetAnnotator.errorClosingQuoteExpected(holder);
            }
        }
    }

    private static boolean isPuppet4SingleQuotedStringUnclosed(CharSequence text) {
        if (!StringUtil.endsWithChar((CharSequence)text, (char)'\'')) {
            return true;
        }
        int backSlashes = 0;
        for (int currentIndex = text.length() - 2; currentIndex >= 0 && text.charAt(currentIndex) == '\\'; --currentIndex) {
            ++backSlashes;
        }
        return backSlashes % 2 != 0;
    }

    private static void errorClosingQuoteExpected(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            PuppetAnnotator.$$$reportNull$$$0(6);
        }
        holder.newAnnotation(HighlightSeverity.ERROR, PuppetBundle.message("puppet.unclosed.string", new Object[0])).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/ide/annotation/PuppetAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotatePuppet3";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "annotatePuppet4";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "errorClosingQuoteExpected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

